/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Field;
import gnu.bytecode.Label;
import gnu.bytecode.Method;
import gnu.bytecode.ObjectType;
import gnu.bytecode.PrimType;
import gnu.bytecode.SwitchState;
import gnu.bytecode.Type;
import gnu.bytecode.Variable;
import gnu.expr.ApplyExp;
import gnu.expr.CheckedTarget;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.IgnoreTarget;
import gnu.expr.Initializer;
import gnu.expr.Keyword;
import gnu.expr.ModuleExp;
import gnu.expr.ObjectExp;
import gnu.expr.ProcInitializer;
import gnu.expr.QuoteExp;
import gnu.expr.ScopeExp;
import gnu.expr.Special;
import gnu.expr.StackTarget;
import gnu.expr.Target;
import gnu.lists.LList;
import gnu.mapping.OutPort;
import gnu.mapping.Procedure;
import gnu.mapping.Values;
import java.util.Vector;

public class LambdaExp
extends ScopeExp {
    public String name;
    public Expression body;
    public int min_args;
    public int max_args;
    Vector applyMethods = new Vector();
    Variable argsArray;
    private Declaration firstArgsArrayArg;
    public Keyword[] keywords;
    public Expression[] defaultArgs;
    static int counter;
    int id = ++counter;
    Declaration capturedVars;
    Variable heapFrame;
    LambdaExp heapFrameLambda;
    public LambdaExp firstChild;
    public LambdaExp nextSibling;
    static final ApplyExp unknownContinuation;
    ApplyExp returnContinuation;
    Declaration nameDecl;
    public Field closureEnvField;
    public Field staticLinkField;
    Variable closureEnv;
    static final int INLINE_ONLY = 1;
    static final int CAN_READ = 2;
    static final int CAN_CALL = 4;
    static final int IMPORTS_LEX_VARS = 8;
    static final int NEEDS_STATIC_LINK = 16;
    static final int CANNOT_INLINE = 32;
    static final int CLASS_METHOD = 64;
    static final int METHODS_COMPILED = 128;
    static final int NO_FIELD = 256;
    static final int DEFAULT_CAPTURES_ARG = 512;
    public static final int SEQUENCE_RESULT = 1024;
    protected static final int NEXT_AVAIL_FLAG = 2048;
    public static String fileFunctionName;
    ClassType type = Compilation.typeProcedure;
    int selectorValue;
    Method[] primMethods;
    Variable thisVariable;
    static Method setNameMethod;
    static Method searchForKeywordMethod3;
    static Method searchForKeywordMethod4;
    Initializer initChain;
    Procedure thisValue;
    Object[] properties;

    public final boolean getInlineOnly() {
        return (this.flags & 1) != 0;
    }

    public final void setInlineOnly(boolean bl) {
        this.setFlag(bl, 1);
    }

    public final boolean getNeedsClosureEnv() {
        return (this.flags & 0x18) != 0;
    }

    public final boolean getNeedsStaticLink() {
        return (this.flags & 0x10) != 0;
    }

    public final void setNeedsStaticLink(boolean bl) {
        this.flags = bl ? (this.flags |= 0x10) : (this.flags &= 0xFFFFFFEF);
    }

    public final boolean getImportsLexVars() {
        return (this.flags & 8) != 0;
    }

    public final void setImportsLexVars(boolean bl) {
        this.flags = bl ? (this.flags |= 8) : (this.flags &= 0xFFFFFFF7);
    }

    public final void setImportsLexVars() {
        int n = this.flags;
        this.flags |= 8;
        if ((n & 8) == 0 && this.nameDecl != null) {
            this.setCallersNeedStaticLink();
        }
    }

    public final void setNeedsStaticLink() {
        int n = this.flags;
        this.flags |= 0x10;
        if ((n & 0x10) == 0 && this.nameDecl != null) {
            this.setCallersNeedStaticLink();
        }
    }

    void setCallersNeedStaticLink() {
        LambdaExp lambdaExp = this.outerLambda();
        ApplyExp applyExp = this.nameDecl.firstCall;
        while (applyExp != null) {
            LambdaExp lambdaExp2 = applyExp.context;
            while (lambdaExp2 != lambdaExp) {
                lambdaExp2.setNeedsStaticLink();
                lambdaExp2 = lambdaExp2.outerLambda();
            }
            applyExp = applyExp.nextCall;
        }
    }

    public final boolean getCanRead() {
        return (this.flags & 2) != 0;
    }

    public final void setCanRead(boolean bl) {
        this.flags = bl ? (this.flags |= 2) : (this.flags &= 0xFFFFFFFD);
    }

    public final boolean getCanCall() {
        return (this.flags & 4) != 0;
    }

    public final void setCanCall(boolean bl) {
        this.flags = bl ? (this.flags |= 4) : (this.flags &= 0xFFFFFFFB);
    }

    public final boolean isClassMethod() {
        return (this.flags & 0x40) != 0;
    }

    public final void setClassMethod(boolean bl) {
        this.flags = bl ? (this.flags |= 0x40) : (this.flags &= 0xFFFFFFBF);
    }

    public final boolean isModuleBody() {
        return this instanceof ModuleExp;
    }

    public final boolean isClassGenerated() {
        return !this.getInlineOnly() && (this.isHandlingTailCalls() || this.isModuleBody() || this instanceof ObjectExp);
    }

    public final boolean isHandlingTailCalls() {
        return this.isModuleBody() && !((ModuleExp)this).isStatic() || Compilation.usingTailCalls && !this.isModuleBody() && !this.isClassMethod();
    }

    public final boolean variable_args() {
        return this.max_args < 0;
    }

    public ClassType getCompiledClassType(Compilation compilation) {
        if (this.type == Compilation.typeProcedure) {
            throw new Error("internal error: getCompiledClassType");
        }
        return this.type;
    }

    public Type getType() {
        return this.type;
    }

    public int incomingArgs() {
        return this.min_args == this.max_args && this.max_args <= 4 && this.max_args > 0 ? this.max_args : 1;
    }

    int getSelectorValue(Compilation compilation) {
        if (this.selectorValue == 0) {
            this.selectorValue = ++compilation.maxSelectorValue;
        }
        return this.selectorValue;
    }

    public final Method getMethod(int n) {
        if (this.primMethods == null || this.max_args >= 0 && n > this.max_args) {
            return null;
        }
        int n2 = n - this.min_args;
        if (n2 < 0) {
            return null;
        }
        int n3 = this.primMethods.length;
        return this.primMethods[n2 < n3 ? n2 : n3 - 1];
    }

    public final Method getMainMethod() {
        Method[] methodArray = this.primMethods;
        return methodArray == null ? null : methodArray[methodArray.length - 1];
    }

    public final Type restArgType() {
        if (this.min_args == this.max_args) {
            return null;
        }
        if (this.primMethods == null) {
            throw new Error("internal error - restArgType");
        }
        Method[] methodArray = this.primMethods;
        if (this.max_args >= 0 && methodArray.length > this.max_args - this.min_args) {
            return null;
        }
        Type[] typeArray = methodArray[methodArray.length - 1].getParameterTypes();
        return typeArray[typeArray.length - 1];
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public String getJavaName() {
        return this.name == null ? "lambda" : Compilation.mangleName(this.name);
    }

    public LambdaExp outerLambda() {
        return this.outer == null ? null : this.outer.currentLambda();
    }

    public LambdaExp outerLambdaNotInline() {
        ScopeExp scopeExp = this;
        while ((scopeExp = scopeExp.outer) != null) {
            ScopeExp scopeExp2;
            if (!(scopeExp instanceof LambdaExp) || ((LambdaExp)(scopeExp2 = scopeExp)).getInlineOnly()) continue;
            return scopeExp2;
        }
        return null;
    }

    public LambdaExp getCaller() {
        return this.returnContinuation.context;
    }

    public Variable declareThis(ClassType classType) {
        if (this.thisVariable == null) {
            this.thisVariable = new Variable("this");
            this.scope.addVariableAfter(null, this.thisVariable);
            this.thisVariable.setParameter(true);
            this.thisVariable.setArtificial(true);
        }
        if (this.thisVariable.getType() == null) {
            this.thisVariable.setType(classType);
        }
        return this.thisVariable;
    }

    public Variable declareClosureEnv() {
        if (this.closureEnv == null && this.getNeedsClosureEnv()) {
            Variable variable;
            LambdaExp lambdaExp = this.outerLambda();
            if (lambdaExp instanceof ObjectExp) {
                lambdaExp = lambdaExp.outerLambda();
            }
            Variable variable2 = variable = lambdaExp.heapFrame != null ? lambdaExp.heapFrame : lambdaExp.closureEnv;
            if (lambdaExp.heapFrameLambda == this || this.isClassMethod()) {
                this.closureEnv = this.declareThis(this.type);
            } else if (lambdaExp.heapFrame == null && !lambdaExp.getNeedsStaticLink() && !(lambdaExp instanceof ModuleExp)) {
                this.closureEnv = null;
            } else if (!this.isClassGenerated() && !this.getInlineOnly()) {
                Method method = this.getMainMethod();
                if (!method.getStaticFlag()) {
                    this.closureEnv = this.declareThis(method.getDeclaringClass());
                } else {
                    Type type = method.getParameterTypes()[0];
                    this.closureEnv = new Variable("closureEnv", type);
                    this.scope.addVariableAfter(null, this.closureEnv);
                    this.closureEnv.setArtificial(true);
                    this.closureEnv.setParameter(true);
                }
            } else {
                LambdaExp lambdaExp2;
                LambdaExp lambdaExp3 = lambdaExp2 = this.getInlineOnly() ? this.getCaller() : null;
                if (lambdaExp == lambdaExp2) {
                    this.closureEnv = variable;
                } else if (lambdaExp2 != null && lambdaExp == lambdaExp2.outerLambdaNotInline()) {
                    this.closureEnv = lambdaExp2.closureEnv;
                } else {
                    this.closureEnv = new Variable("closureEnv", variable.getType());
                    this.scope.addVariable(this.closureEnv);
                    this.closureEnv.setArtificial(true);
                }
            }
        }
        return this.closureEnv;
    }

    public LambdaExp() {
    }

    public LambdaExp(int n) {
        this.min_args = n;
        this.max_args = n;
    }

    public LambdaExp(Expression expression) {
        this.body = expression;
    }

    public void loadHeapFrame(Compilation compilation) {
        CodeAttr codeAttr = compilation.getCode();
        LambdaExp lambdaExp = compilation.curLambda;
        while (lambdaExp != this && lambdaExp.getInlineOnly()) {
            lambdaExp = lambdaExp.returnContinuation.context;
        }
        if (this == lambdaExp) {
            if (this.heapFrame == null) {
                codeAttr.emitPushThis();
            } else {
                codeAttr.emitLoad(this.heapFrame);
            }
        } else {
            codeAttr.emitLoad(lambdaExp.closureEnv);
            LambdaExp lambdaExp2 = lambdaExp.outerLambda();
            while (lambdaExp2 != this) {
                if (lambdaExp2.staticLinkField != null) {
                    codeAttr.emitGetField(lambdaExp2.staticLinkField);
                }
                lambdaExp2 = lambdaExp2.outerLambda();
            }
        }
    }

    Declaration getArg(int n) {
        Declaration declaration = this.firstDecl();
        while (true) {
            if (declaration == null) {
                throw new Error("internal error - getArg");
            }
            if (n == 0) {
                return declaration;
            }
            --n;
            declaration = declaration.nextDecl();
        }
    }

    public ClassType compile(Compilation compilation) {
        ClassType classType = compilation.curClass;
        Method method = compilation.method;
        Variable variable = compilation.callStackContext;
        try {
            ClassType classType2 = compilation.addClass(this);
            Object var7_6 = null;
            compilation.curClass = classType;
            compilation.method = method;
            compilation.callStackContext = variable;
            return classType2;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            compilation.curClass = classType;
            compilation.method = method;
            compilation.callStackContext = variable;
            throw throwable;
        }
    }

    public ClassType compileAlloc(Compilation compilation) {
        ClassType classType = this.compile(compilation);
        CodeAttr codeAttr = compilation.getCode();
        codeAttr.emitNew(classType);
        codeAttr.emitDup(classType);
        codeAttr.emitInvokeSpecial(classType.constructor);
        if (this.closureEnvField != null) {
            codeAttr.emitDup(classType);
            LambdaExp lambdaExp = this.outerLambda();
            Variable variable = !Compilation.usingTailCalls ? LambdaExp.getHeapLambda((ScopeExp)lambdaExp).heapFrame : (lambdaExp.heapFrame != null ? lambdaExp.heapFrame : lambdaExp.closureEnv);
            codeAttr.emitLoad(variable);
            codeAttr.emitPutField(this.closureEnvField);
        }
        if (this.name != null && !(this instanceof ObjectExp)) {
            if (setNameMethod == null) {
                setNameMethod = Compilation.typeProcedure.getDeclaredMethod("setName", 1);
            }
            codeAttr.emitDup(classType);
            codeAttr.emitPushString(this.name);
            codeAttr.emitInvokeVirtual(setNameMethod);
        }
        return classType;
    }

    public void compileEnd(Compilation compilation) {
        CodeAttr codeAttr = compilation.getCode();
        if (!this.getInlineOnly() || Compilation.usingTailCalls) {
            if (compilation.method.reachableHere() && (!Compilation.usingTailCalls || this.isModuleBody() || this.isClassMethod() || this.isHandlingTailCalls())) {
                codeAttr.emitReturn();
            }
            codeAttr.popScope();
        }
        if (!Compilation.fewerClasses) {
            codeAttr.popScope();
        }
        if (this.applyMethods != null && this.applyMethods.size() > 0) {
            Method method = compilation.method;
            ClassType classType = compilation.curClass;
            compilation.curClass = this.getHeapFrameType();
            compilation.generateApplyMethods(this);
            compilation.method = method;
            compilation.curClass = classType;
        }
        if (this.heapFrame != null && !Compilation.usingTailCalls) {
            compilation.generateConstructor(this);
        }
    }

    Field allocFieldFor(Compilation compilation) {
        if (this.nameDecl != null && this.nameDecl.field != null) {
            return this.nameDecl.field;
        }
        String string = this.getName();
        String string2 = string == null ? "lambda" : Compilation.mangleName(string);
        int n = 16;
        if (this.nameDecl != null && this.nameDecl.context instanceof ModuleExp) {
            if (this.nameDecl.getFlag(2048)) {
                n |= 8;
                if (!((ModuleExp)this.nameDecl.context).isStatic()) {
                    n &= 0xFFFFFFEF;
                }
            }
            if (!this.nameDecl.isPrivate()) {
                n |= 1;
            }
        } else {
            string2 = string2 + "$Fn" + ++compilation.localFieldIndex;
            if (!this.getNeedsClosureEnv()) {
                n = (n | 8) & 0xFFFFFFEF;
            }
        }
        ClassType classType = Compilation.getMethodProcType(compilation.mainClass);
        ClassType classType2 = LambdaExp.getHeapLambda(this.outer).getHeapFrameType();
        Field field = classType2.addField(string2, classType, n);
        if (this.nameDecl != null) {
            this.nameDecl.field = field;
        }
        return field;
    }

    public Field compileSetField(Compilation compilation) {
        this.compileAsMethod(compilation);
        LambdaExp.getHeapLambda((ScopeExp)this.outer).applyMethods.addElement(this);
        return new ProcInitializer((LambdaExp)this, (Compilation)compilation).field;
    }

    public void compile(Compilation compilation, Target target) {
        Type type;
        if (target instanceof IgnoreTarget) {
            if (this.getInlineOnly()) {
                return;
            }
            if (Compilation.usingTailCalls) {
                return;
            }
        }
        CodeAttr codeAttr = compilation.getCode();
        if (Compilation.fewerClasses && !this.getImportsLexVars()) {
            ClassType classType;
            Label label = new Label(codeAttr);
            LambdaExp lambdaExp = compilation.curLambda;
            compilation.curLambda = this;
            this.type = lambdaExp.type;
            SwitchState switchState = compilation.fswitch;
            int n = compilation.fswitch.getMaxValue() + 1;
            codeAttr.emitGoto(label);
            Type[] typeArray = codeAttr.saveStackTypeState(true);
            switchState.addCase(n, codeAttr);
            this.allocParameters(compilation);
            this.enterFunction(compilation);
            this.body.compileWithPosition(compilation, Target.returnObject);
            this.compileEnd(compilation);
            compilation.curLambda = lambdaExp;
            label.define(codeAttr);
            codeAttr.restoreStackTypeState(typeArray);
            type = classType = compilation.curClass;
            codeAttr.emitNew(classType);
            codeAttr.emitDup(classType);
            codeAttr.emitPushInt(n);
            codeAttr.emitPutField(Compilation.saved_pcCallFrameField);
            if (this.isHandlingTailCalls()) {
                if (this.name != null) {
                    codeAttr.emitDup(classType);
                    codeAttr.emitPushString(this.name);
                    codeAttr.emitInvokeVirtual(Compilation.setNameMethod);
                }
                codeAttr.emitDup(classType);
                codeAttr.emitPushInt(this.min_args | this.max_args << 12);
                codeAttr.emitPutField(Compilation.numArgsCallFrameField);
                codeAttr.emitDup(classType);
                codeAttr.emitPushThis();
                codeAttr.emitPutField(Compilation.callerCallFrameField);
            }
        } else {
            LambdaExp lambdaExp = this.outerLambda();
            if (!this.isClassGenerated()) {
                type = Compilation.typeModuleMethod;
                if ((this.flags & 0x100) != 0) {
                    this.compileAsMethod(compilation);
                    ProcInitializer.emitLoadModuleMethod(this, compilation);
                } else {
                    Field field = this.compileSetField(compilation);
                    if (field.getStaticFlag()) {
                        codeAttr.emitGetStatic(field);
                    } else if (Compilation.usingTailCalls) {
                        codeAttr.emitPushThis();
                        codeAttr.emitGetField(field);
                    } else {
                        LambdaExp lambdaExp2 = compilation.curLambda;
                        Variable variable = lambdaExp2.heapFrame != null ? lambdaExp2.heapFrame : lambdaExp2.closureEnv;
                        codeAttr.emitLoad(variable);
                        codeAttr.emitGetField(field);
                    }
                }
            } else if (Compilation.usingTailCalls && lambdaExp != null && lambdaExp.heapFrameLambda == this) {
                codeAttr.emitLoad(lambdaExp.heapFrame);
                type = lambdaExp.heapFrame.getType();
            } else {
                type = this.compileAlloc(compilation);
            }
        }
        target.compileFromStack(compilation, type);
    }

    public ClassType getHeapFrameType() {
        if (this instanceof ModuleExp || this instanceof ObjectExp) {
            return (ClassType)this.getType();
        }
        return (ClassType)this.heapFrame.getType();
    }

    public static LambdaExp getHeapLambda(ScopeExp scopeExp) {
        ScopeExp scopeExp2 = scopeExp;
        while (scopeExp2 != null) {
            if (scopeExp2 instanceof ModuleExp || scopeExp2 instanceof ObjectExp || scopeExp2 instanceof LambdaExp && ((LambdaExp)scopeExp2).heapFrame != null) {
                return (LambdaExp)scopeExp2;
            }
            scopeExp2 = scopeExp2.outer;
        }
        return null;
    }

    void addMethodFor(Compilation compilation, ObjectType objectType) {
        ModuleExp moduleExp;
        LambdaExp lambdaExp = LambdaExp.getHeapLambda(this.outer);
        ClassType classType = lambdaExp.getHeapFrameType();
        String string = this.getName();
        StringBuffer stringBuffer = new StringBuffer(60);
        LambdaExp lambdaExp2 = this.outerLambda();
        if (!lambdaExp2.isModuleBody() && !(lambdaExp2 instanceof ObjectExp) || string == null) {
            stringBuffer.append("lambda");
            stringBuffer.append(++compilation.method_counter);
        }
        if (string != null) {
            stringBuffer.append(Compilation.mangleName(string));
        }
        if (this.getFlag(1024)) {
            stringBuffer.append("$C");
        }
        int n = this.keywords == null ? 0 : this.keywords.length;
        int n2 = this.defaultArgs == null ? 0 : this.defaultArgs.length - n;
        int n3 = (this.flags & 0x200) != 0 || Compilation.usingTailCalls ? 0 : n2;
        boolean bl = this.max_args < 0 || this.min_args + n3 < this.max_args;
        this.primMethods = new Method[n3 + 1];
        boolean bl2 = this.isClassMethod() || this.thisVariable != null || objectType == classType ? false : (this.nameDecl == null ? true : (this.nameDecl.getFlag(4096) ? false : (this.nameDecl.getFlag(2048) ? true : (this.nameDecl.context instanceof ModuleExp ? (moduleExp = (ModuleExp)this.nameDecl.context).getSuperType() == null && moduleExp.getInterfaces() == null : true))));
        int n4 = (bl2 ? 8 : 0) + (this.nameDecl != null && !this.nameDecl.isPrivate() ? 1 : 0);
        if (!bl2) {
            this.closureEnv = this.declareThis(classType);
        }
        PrimType primType = this.getFlag(1024) || Compilation.usingTailCalls && !this.isClassMethod() ? Type.void_type : this.body.getType();
        int n5 = objectType != null && objectType != classType ? 1 : 0;
        int n6 = 0;
        while (n6 <= n3) {
            int n7;
            int n8 = n7 = this.min_args + n6;
            if (n6 == n3 && bl) {
                ++n8;
            }
            Type[] typeArray = new Type[n5 + n8];
            if (n5 > 0) {
                typeArray[0] = objectType;
            }
            Declaration declaration = this.firstDecl();
            int n9 = 0;
            while (n9 < n7) {
                typeArray[n5 + n9++] = declaration.getType();
                declaration = declaration.nextDecl();
            }
            if (n7 < n8) {
                stringBuffer.append("$V");
                string = stringBuffer.toString();
                Type type = declaration.getType();
                String string2 = type.getName();
                if (n > 0 || n3 < n2 || !"gnu.kawa.util.LList".equals(string2) && !"java.lang.Object[]".equals(string2)) {
                    type = Compilation.objArrayType;
                    this.argsArray = new Variable("argsArray", Compilation.objArrayType);
                }
                this.firstArgsArrayArg = declaration;
                typeArray[typeArray.length - 1] = type;
            }
            boolean bl3 = lambdaExp2 instanceof ObjectExp || lambdaExp2 instanceof ModuleExp && ((ModuleExp)lambdaExp2).getFlag(16384);
            string = stringBuffer.toString();
            if (!bl3) {
                int n10 = 0;
                int n11 = stringBuffer.length();
                block2: while (true) {
                    ClassType classType2 = classType;
                    while (classType2 != null) {
                        if (classType2.getDeclaredMethod(string, typeArray) != null) {
                            stringBuffer.setLength(n11);
                            stringBuffer.append('$');
                            stringBuffer.append(++n10);
                            string = stringBuffer.toString();
                            continue block2;
                        }
                        classType2 = classType2.getSuperclass();
                    }
                    break;
                }
            }
            this.primMethods[n6] = classType.addMethod(string, typeArray, primType, n4);
            ++n6;
        }
    }

    public void allocChildClasses(Compilation compilation) {
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        if (this instanceof ModuleExp) {
            ((ModuleExp)this).allocFields(compilation);
        } else {
            object5 = this.getMainMethod();
            object4 = this.firstDecl();
            if (this.isHandlingTailCalls()) {
                this.firstArgsArrayArg = object4;
                if (!Compilation.usingTailCalls) {
                    this.scope.addVariable(null, Compilation.typeCallContext, "$ctx");
                }
            }
            while (true) {
                if (object4 == this.firstArgsArrayArg && this.argsArray != null) {
                    this.scope.addVariable(this.argsArray);
                    this.argsArray.setParameter(true);
                    this.argsArray.setArtificial(true);
                }
                if (object4 == null) break;
                object3 = ((Declaration)object4).var;
                if (((Declaration)object4).isSimple() && !((Declaration)object4).isIndirectBinding()) {
                    object3 = ((Declaration)object4).allocateVariable(null);
                } else {
                    object2 = Compilation.mangleName(((Declaration)object4).getName()).intern();
                    ((Declaration)object4).var = this.scope.addVariable(null, ((Declaration)object4).getType(), (String)object2);
                    object3 = ((Declaration)object4).var;
                    ((Variable)object3).setArtificial(true);
                    ((Variable)object3).setParameter(true);
                }
                object4 = ((Declaration)object4).nextDecl();
            }
        }
        this.declareClosureEnv();
        if (Compilation.usingTailCalls) {
            object5 = this.firstChild;
            while (object5 != null) {
                if (!((LambdaExp)object5).getInlineOnly() && ((LambdaExp)object5).isClassGenerated()) {
                    compilation.allocClass((LambdaExp)object5);
                }
                object5 = ((LambdaExp)object5).nextSibling;
            }
        }
        this.allocFrame(compilation);
        if (Compilation.usingTailCalls && this.getNeedsClosureEnv() && this.isClassGenerated()) {
            object4 = this.outerLambda();
            object3 = ((LambdaExp)object4).heapFrameLambda;
            if (!(object4 instanceof ObjectExp) && object3 != this) {
                if (object3 != null) {
                    object2 = ((LambdaExp)object3).getCompiledClassType(compilation);
                    this.closureEnvField = compilation.curClass.addField("closureEnv", (Type)object2);
                } else if (((LambdaExp)object4).getNeedsStaticLink() && !Compilation.usingCPStyle()) {
                    this.closureEnvField = compilation.curClass.addField("closureEnv", ((LambdaExp)object4).closureEnv.getType());
                }
            }
        }
        object4 = this.firstChild;
        while (object4 != null) {
            if (((LambdaExp)object4).isClassGenerated()) {
                if (((LambdaExp)object4).min_args != ((LambdaExp)object4).max_args || ((LambdaExp)object4).min_args > 4 || ((LambdaExp)object4).isHandlingTailCalls()) {
                    ((LambdaExp)object4).argsArray = new Variable("argsArray", Compilation.objArrayType);
                    ((LambdaExp)object4).firstArgsArrayArg = ((ScopeExp)object4).firstDecl();
                }
            } else if (!((LambdaExp)object4).getInlineOnly()) {
                if (!((LambdaExp)object4).getNeedsClosureEnv()) {
                    object2 = null;
                } else if (this instanceof ObjectExp) {
                    object2 = this.getCompiledClassType(compilation);
                } else if ("$finit$".equals(this.getName())) {
                    object2 = this.outerLambda().getCompiledClassType(compilation);
                } else {
                    LambdaExp lambdaExp = this;
                    while (lambdaExp.heapFrame == null) {
                        lambdaExp = lambdaExp.outerLambda();
                    }
                    object2 = (ClassType)lambdaExp.heapFrame.getType();
                }
                ((LambdaExp)object4).addMethodFor(compilation, (ObjectType)object2);
            }
            object4 = ((LambdaExp)object4).nextSibling;
        }
    }

    public void allocFrame(Compilation compilation) {
        if (this.heapFrame != null) {
            ClassType classType;
            if (this instanceof ModuleExp || this instanceof ObjectExp) {
                classType = this.getCompiledClassType(compilation);
            } else if (Compilation.usingTailCalls && this.heapFrameLambda != null) {
                classType = this.heapFrameLambda.getCompiledClassType(compilation);
            } else {
                classType = new ClassType(compilation.generateClassName("frame"));
                if (Compilation.usingTailCalls) {
                    classType.setSuper(Type.pointer_type);
                } else {
                    classType.setSuper(Compilation.typeModuleBody);
                }
                compilation.addClass(classType);
            }
            this.heapFrame.setType(classType);
            if (!Compilation.usingTailCalls) {
                this.type = classType;
            }
        }
    }

    void allocParameters(Compilation compilation) {
        CodeAttr codeAttr = compilation.getCode();
        int n = 0;
        int n2 = 0;
        codeAttr.locals.enterScope(this.scope);
        if (this.argsArray != null && this.isHandlingTailCalls()) {
            codeAttr.emitLoad(compilation.callStackContext);
            codeAttr.emitGetField(Compilation.argsCallContextField);
            codeAttr.emitStore(this.argsArray);
        }
        Declaration declaration = this.firstDecl();
        while (declaration != null) {
            Variable variable = declaration.var;
            if (this.argsArray != null && this.min_args == this.max_args && this.primMethods == null && !this.isHandlingTailCalls()) {
                codeAttr.emitLoad(this.argsArray);
                codeAttr.emitPushInt(n2);
                codeAttr.emitArrayLoad(Type.pointer_type);
                declaration.getType().emitCoerceFromObject(codeAttr);
                codeAttr.emitStore(declaration.getVariable());
            }
            ++n2;
            ++n;
            declaration = declaration.nextDecl();
        }
        if (this.heapFrame != null) {
            this.heapFrame.allocateLocal(codeAttr);
        }
    }

    void enterFunction(Compilation compilation) {
        int n;
        int n2;
        Object object2;
        CodeAttr codeAttr = compilation.getCode();
        this.scope.setStartPC(codeAttr.getPC());
        if (this.closureEnv != null && !this.closureEnv.isParameter() && !Compilation.usingCPStyle()) {
            if (this.getInlineOnly()) {
                this.outerLambda().loadHeapFrame(compilation);
            } else {
                codeAttr.emitPushThis();
                object2 = this.closureEnvField;
                if (object2 == null) {
                    object2 = this.outerLambda().closureEnvField;
                }
                codeAttr.emitGetField((Field)object2);
            }
            codeAttr.emitStore(this.closureEnv);
        }
        if (this.heapFrame != null && !Compilation.usingCPStyle()) {
            Object object3;
            object2 = (ClassType)this.heapFrame.getType();
            Declaration declaration = this.capturedVars;
            while (declaration != null) {
                if (declaration.field == null) {
                    Object object4;
                    object3 = Compilation.mangleName(declaration.getName());
                    String string = object3;
                    n2 = 0;
                    while ((object4 = ((ClassType)object2).getField(string)) != null) {
                        string = (String)object3 + '_' + ++n2;
                    }
                    object4 = declaration.getType();
                    declaration.field = ((ClassType)object2).addField(string, declaration.getType());
                }
                declaration = declaration.nextCapturedVar;
            }
            if (this.closureEnv != null && this.heapFrame != null) {
                this.staticLinkField = ((ClassType)object2).addField("staticLink", this.closureEnv.getType());
            }
            if (!(this instanceof ModuleExp) && !(this instanceof ObjectExp)) {
                if (this.heapFrameLambda != null) {
                    this.heapFrameLambda.compileAlloc(compilation);
                } else {
                    codeAttr.emitNew((ClassType)object2);
                    codeAttr.emitDup((Type)object2);
                    object3 = compilation.getConstructor(this);
                    codeAttr.emitInvokeSpecial((Method)object3);
                }
                if (this.staticLinkField != null) {
                    codeAttr.emitDup(this.heapFrame.getType());
                    codeAttr.emitLoad(this.closureEnv);
                    codeAttr.emitPutField(this.staticLinkField);
                }
                codeAttr.emitStore(this.heapFrame);
            }
        }
        object2 = this.argsArray;
        if (this.min_args == this.max_args && !Compilation.fewerClasses && this.primMethods == null && !this.isHandlingTailCalls()) {
            object2 = null;
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        n2 = this.keywords == null ? 0 : this.keywords.length;
        int n6 = n = this.defaultArgs == null ? 0 : this.defaultArgs.length - n2;
        if (this instanceof ModuleExp) {
            return;
        }
        int n7 = -1;
        int n8 = 0;
        Method method = this.getMainMethod();
        Declaration declaration = this.firstDecl();
        while (declaration != null) {
            if (declaration == this.firstArgsArrayArg && object2 != null) {
                if (this.primMethods != null) {
                    n7 = n3;
                    n8 = n7 - this.min_args;
                } else {
                    n7 = 0;
                    n8 = 0;
                }
            }
            if (n7 >= 0 || !declaration.isSimple() || declaration.isIndirectBinding()) {
                ClassType classType;
                Type type = declaration.getType();
                Type type2 = classType = method == null || n7 >= 0 ? Type.pointer_type : method.getParameterTypes()[n3];
                if (!declaration.isSimple()) {
                    declaration.loadOwningObject(compilation);
                }
                if (n7 < 0) {
                    codeAttr.emitLoad(declaration.getVariable());
                } else if (n3 < this.min_args) {
                    codeAttr.emitLoad((Variable)object2);
                    codeAttr.emitPushInt(n3);
                    codeAttr.emitArrayLoad(Type.pointer_type);
                } else if (n3 < this.min_args + n) {
                    codeAttr.emitPushInt(n3 - n7);
                    codeAttr.emitLoad((Variable)object2);
                    codeAttr.emitArrayLength();
                    codeAttr.emitIfIntLt();
                    codeAttr.emitLoad((Variable)object2);
                    codeAttr.emitPushInt(n3 - n7);
                    codeAttr.emitArrayLoad(Type.pointer_type);
                    codeAttr.emitElse();
                    this.defaultArgs[n8 + n4++].compile(compilation, type);
                    codeAttr.emitFi();
                } else if (this.max_args < 0 && n3 == this.min_args + n) {
                    codeAttr.emitLoad((Variable)object2);
                    codeAttr.emitPushInt(n3 - n7);
                    codeAttr.emitInvokeStatic(Compilation.makeListMethod);
                    classType = Compilation.scmListType;
                } else {
                    Type[] typeArray;
                    codeAttr.emitLoad((Variable)object2);
                    codeAttr.emitPushInt(this.min_args + n - n7);
                    compilation.compileConstant(this.keywords[n5++]);
                    Expression expression = this.defaultArgs[n8 + n4++];
                    if (expression instanceof QuoteExp) {
                        if (searchForKeywordMethod4 == null) {
                            typeArray = new Type[]{Compilation.objArrayType, Type.int_type, Type.pointer_type, Type.pointer_type};
                            searchForKeywordMethod4 = Compilation.scmKeywordType.addMethod("searchForKeyword", typeArray, Type.pointer_type, 9);
                        }
                        expression.compile(compilation, type);
                        codeAttr.emitInvokeStatic(searchForKeywordMethod4);
                    } else {
                        if (searchForKeywordMethod3 == null) {
                            typeArray = new Type[]{Compilation.objArrayType, Type.int_type, Type.pointer_type};
                            searchForKeywordMethod3 = Compilation.scmKeywordType.addMethod("searchForKeyword", typeArray, Type.pointer_type, 9);
                        }
                        codeAttr.emitInvokeStatic(searchForKeywordMethod3);
                        codeAttr.emitDup(1);
                        compilation.compileConstant(Special.dfault);
                        codeAttr.emitIfEq();
                        codeAttr.emitPop(1);
                        expression.compile(compilation, type);
                        codeAttr.emitFi();
                    }
                }
                if (type != classType) {
                    CheckedTarget.emitCheckedCoerce(compilation, this, n3, type);
                }
                if (declaration.isIndirectBinding()) {
                    declaration.pushIndirectBinding(compilation);
                }
                if (declaration.isSimple()) {
                    codeAttr.emitStore(declaration.getVariable());
                } else {
                    codeAttr.emitPutField(declaration.field);
                }
            }
            ++n3;
            declaration = declaration.nextDecl();
        }
    }

    void compileChildMethods(Compilation compilation) {
        LambdaExp lambdaExp = this.firstChild;
        while (lambdaExp != null) {
            if (!(lambdaExp.getCanRead() || lambdaExp.getInlineOnly() || lambdaExp.isHandlingTailCalls())) {
                lambdaExp.compileAsMethod(compilation);
            }
            lambdaExp = lambdaExp.nextSibling;
        }
    }

    void compileAsMethod(Compilation compilation) {
        int n;
        if ((this.flags & 0x80) != 0) {
            return;
        }
        this.flags |= 0x80;
        Method method = compilation.method;
        LambdaExp lambdaExp = compilation.curLambda;
        Variable variable = compilation.callStackContext;
        compilation.curLambda = this;
        Method method2 = this.primMethods[0];
        boolean bl = method2.getStaticFlag();
        Type type = method2.getReturnType();
        Target target = Compilation.usingTailCalls ? Target.returnObject : Target.returnValue(type);
        int n2 = this.primMethods.length - 1;
        Type type2 = this.restArgType();
        int[] nArray = null;
        if (n2 > 0) {
            nArray = new int[this.min_args + n2];
            n = 0;
            Declaration declaration = this.firstDecl();
            while (n < this.min_args + n2) {
                nArray[n++] = declaration.flags;
                declaration = declaration.nextDecl();
            }
        }
        n = 0;
        while (n <= n2) {
            compilation.method = this.primMethods[n];
            if (n < n2) {
                Object object2;
                compilation.method.init_param_slots();
                CodeAttr codeAttr = compilation.getCode();
                int n3 = n + 1;
                while (n3 < n2 && this.defaultArgs[n3] instanceof QuoteExp) {
                    ++n3;
                }
                boolean bl2 = !bl;
                boolean bl3 = n3 == n2 && type2 != null;
                Variable variable2 = codeAttr.getArg(0);
                if (!bl) {
                    codeAttr.emitPushThis();
                    if (this.getNeedsClosureEnv()) {
                        this.closureEnv = variable2;
                    }
                    variable2 = codeAttr.getArg(1);
                }
                Declaration declaration = this.firstDecl();
                int n4 = 0;
                while (n4 < this.min_args + n) {
                    declaration.flags |= 0x40;
                    declaration.var = variable2;
                    codeAttr.emitLoad(variable2);
                    variable2 = variable2.nextVar();
                    ++n4;
                    declaration = declaration.nextDecl();
                }
                int n5 = n;
                while (n5 < n3) {
                    object2 = StackTarget.getInstance(declaration.getType());
                    this.defaultArgs[n5].compile(compilation, (Target)object2);
                    ++n5;
                    declaration = declaration.nextDecl();
                }
                if (bl3) {
                    String string = type2.getName();
                    if ("gnu.kawa.util.LList".equals(string)) {
                        object2 = new QuoteExp(LList.Empty);
                    } else if ("java.lang.Object[]".equals(string)) {
                        object2 = new QuoteExp(Values.noArgs);
                    } else {
                        throw new Error("unimplemented #!rest type");
                    }
                    ((Expression)object2).compile(compilation, type2);
                }
                if (bl) {
                    codeAttr.emitInvokeStatic(this.primMethods[n3]);
                } else {
                    codeAttr.emitInvokeVirtual(this.primMethods[n3]);
                }
                codeAttr.emitReturn();
                this.closureEnv = null;
            } else {
                if (nArray != null) {
                    int n6 = 0;
                    Declaration declaration = this.firstDecl();
                    while (n6 < this.min_args + n2) {
                        declaration.flags = nArray[n6++];
                        declaration.var = null;
                        declaration = declaration.nextDecl();
                    }
                }
                compilation.method.initCode();
                this.allocChildClasses(compilation);
                this.allocParameters(compilation);
                this.enterFunction(compilation);
                this.body.compileWithPosition(compilation, target);
                this.compileEnd(compilation);
            }
            ++n;
        }
        this.compileChildMethods(compilation);
        compilation.method = method;
        compilation.curLambda = lambdaExp;
        compilation.callStackContext = variable;
    }

    protected Expression walk(ExpWalker expWalker) {
        return expWalker.walkLambdaExp(this);
    }

    protected void walkChildren(ExpWalker expWalker) {
        LambdaExp lambdaExp = expWalker.currentLambda;
        expWalker.currentLambda = this;
        try {
            Object[] objectArray;
            expWalker.walkDefaultArgs(this);
            if (expWalker.exitValue == null && this.body != null) {
                this.body = this.body.walk(expWalker);
            }
            if ((objectArray = this.properties) != null) {
                int n = objectArray.length;
                int n2 = 1;
                while (n2 < n) {
                    Object object2 = objectArray[n2];
                    if (object2 instanceof Expression) {
                        objectArray[n2] = ((Expression)objectArray[n2]).walk(expWalker);
                    }
                    n2 += 2;
                }
            }
            Object var8_7 = null;
            expWalker.currentLambda = lambdaExp;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            expWalker.currentLambda = lambdaExp;
            throw throwable;
        }
    }

    public void print(OutPort outPort) {
        outPort.startLogicalBlock("(Lambda/", ")", 2);
        if (this.name != null) {
            outPort.print(this.name);
            outPort.print('/');
        }
        outPort.print(this.id);
        outPort.print("/ (");
        Special special = null;
        int n = 0;
        int n2 = 0;
        int n3 = this.keywords == null ? 0 : this.keywords.length;
        int n4 = this.defaultArgs == null ? 0 : this.defaultArgs.length - n3;
        Declaration declaration = this.firstDecl();
        while (declaration != null) {
            Special special2 = n < this.min_args ? null : (n < this.min_args + n4 ? Special.optional : (this.max_args < 0 && n == this.min_args + n4 ? Special.rest : Special.key));
            if (n > 0) {
                outPort.print(' ');
            }
            if (special2 != special) {
                outPort.print(special2);
                outPort.print(' ');
            }
            Expression expression = null;
            if (special2 == Special.optional || special2 == Special.key) {
                expression = this.defaultArgs[n2++];
            }
            if (expression != null) {
                outPort.print('(');
            }
            outPort.print(declaration.getName());
            if (expression != null && expression != QuoteExp.falseExp) {
                outPort.print(' ');
                expression.print(outPort);
                outPort.print(')');
            }
            ++n;
            special = special2;
            declaration = declaration.nextDecl();
        }
        outPort.print(')');
        outPort.writeSpaceLinear();
        if (this.body == null) {
            outPort.print("<null body>");
        } else {
            this.body.print(outPort);
        }
        outPort.endLogicalBlock(")");
    }

    public String toString() {
        String string = "LambdaExp/" + this.name + '/' + this.id + '/';
        int n = this.getLine();
        if (n <= 0 && this.body != null) {
            n = this.body.getLine();
        }
        if (n > 0) {
            string = string + "l:" + n;
        }
        return string;
    }

    public Object getProperty(Object object2, Object object3) {
        if (this.properties != null) {
            int n = this.properties.length;
            while ((n -= 2) >= 0) {
                if (this.properties[n] != object2) continue;
                return this.properties[n + 1];
            }
        }
        return object3;
    }

    public synchronized void setProperty(Object object2, Object object3) {
        this.properties = Procedure.setProperty(this.properties, object2, object3);
    }

    static {
        unknownContinuation = new ApplyExp((Expression)null, null);
        fileFunctionName = "atFileLevel";
        setNameMethod = null;
    }
}

