/*
 * Decompiled with CFR 0.152.
 */
package gnu.jemacs.buffer;

import gnu.jemacs.buffer.Buffer;
import gnu.jemacs.buffer.Command;
import gnu.jemacs.buffer.FinalAction;
import gnu.jemacs.buffer.IgnoreAction;
import gnu.jemacs.buffer.InsertAction;
import gnu.jemacs.buffer.TooLongAction;
import gnu.jemacs.lang.ELisp;
import gnu.lists.FString;
import gnu.lists.LList;
import gnu.lists.Pair;
import gnu.lists.Sequence;
import gnu.mapping.Binding;
import gnu.mapping.Procedure;
import gnu.math.IntNum;
import gnu.text.Char;
import java.util.Enumeration;
import javax.swing.Action;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;

public class BufferKeymap
implements Keymap {
    Buffer buffer;
    public static KeyStroke metaKey = KeyStroke.getKeyStroke('\u001b');
    static Keymap defaultKeymap = JTextComponent.getKeymap("default");
    public static Keymap globalKeymap = JTextComponent.addKeymap("global", defaultKeymap);
    public static Keymap metaKeymap = JTextComponent.addKeymap("ESC-map", null);
    static Action metaAction = new Command(metaKeymap, metaKey);
    static InsertAction defaultInsertAction = new InsertAction(null);
    static final int CTRL_MASK = 2;
    static final int SHIFT_MASK = 1;
    static final int META_MASK = 8;
    static final int ALT_MASK = 4;
    Keymap localKeymap;
    static int counter;
    Keymap[] activeKeymaps;
    int activeLength;
    KeyStroke[] pendingKeys = null;
    int pendingLength = 0;
    int eliminated = 0;
    Keymap resolveParent;

    public void pushPrefix(KeyStroke keyStroke) {
        if (this.pendingKeys == null) {
            this.pendingKeys = new KeyStroke[10];
        }
        this.pendingKeys[this.pendingLength++] = keyStroke;
    }

    public static Keymap makeEmptyKeymap(String string) {
        if (string == null) {
            string = "keymap-" + ++counter;
        }
        return JTextComponent.addKeymap(string, null);
    }

    public BufferKeymap(Buffer buffer) {
        this.buffer = buffer;
        this.activeKeymaps = new Keymap[6];
        this.activeLength = 1;
        this.activeKeymaps[0] = globalKeymap;
    }

    public Keymap getLocalKeymap() {
        return this.localKeymap;
    }

    public void setLocalKeymap(Keymap keymap2) {
        if (this.localKeymap != null) {
            this.activeKeymaps[this.activeLength - 2] = this.activeKeymaps[this.activeLength - 1];
            --this.activeLength;
            this.localKeymap = null;
        }
        if (keymap2 != null) {
            this.activeKeymaps[this.activeLength] = this.activeKeymaps[this.activeLength - 1];
            this.activeKeymaps[this.activeLength - 1] = keymap2;
            ++this.activeLength;
            this.localKeymap = keymap2;
        }
    }

    public void addActionForKeyStroke(KeyStroke keyStroke, Action action) {
        this.activeKeymaps[0].addActionForKeyStroke(keyStroke, action);
    }

    public static Object lookupKey(Keymap keymap2, Sequence sequence, boolean bl) {
        int n = sequence.size();
        KeyStroke[] keyStrokeArray = new KeyStroke[n];
        Enumeration enumeration = sequence.elements();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            keyStrokeArray[n2] = BufferKeymap.asKeyStroke(enumeration.nextElement());
            ++n2;
        }
        Action action = BufferKeymap.lookupKey(keymap2, keyStrokeArray, n, null, bl);
        return BufferKeymap.asNonAction(action);
    }

    public static Object asNonAction(Action action) {
        if (action instanceof Command) {
            return ((Command)action).getCommand();
        }
        if (action instanceof FinalAction) {
            return ((FinalAction)action).action;
        }
        if (action instanceof TooLongAction) {
            return IntNum.make(((TooLongAction)action).getMaxValid());
        }
        return action;
    }

    public static Action asAction(Object object2) {
        return BufferKeymap.asAction(object2, null);
    }

    public static Action asAction(Object object2, KeyStroke keyStroke) {
        if (object2 instanceof Procedure) {
            return new Command((Procedure)object2, keyStroke);
        }
        if (object2 instanceof String || object2 instanceof Binding) {
            return new Command(object2, object2.toString(), keyStroke);
        }
        if (object2 instanceof Keymap) {
            return new Command((Keymap)object2, keyStroke);
        }
        return (Action)object2;
    }

    public static boolean ignorable(KeyStroke keyStroke) {
        if (keyStroke.isOnKeyRelease()) {
            return true;
        }
        int n = keyStroke.getModifiers();
        int n2 = keyStroke.getKeyCode();
        if (n2 == 0) {
            char c = keyStroke.getKeyChar();
            return c < ' ' && c != '\n' && c != '\t' || c > '\u007f';
        }
        return true;
    }

    public static String toString(KeyStroke keyStroke) {
        int n;
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('[');
        char c = keyStroke.getKeyChar();
        if (c != '\u0000') {
            stringBuffer.append("char:'");
            ELisp.readableChar(c, stringBuffer, true);
            stringBuffer.append("'");
        }
        if ((n2 = keyStroke.getKeyCode()) != 0) {
            stringBuffer.append("code:");
            stringBuffer.append(n2);
        }
        if ((n = keyStroke.getModifiers()) != 0) {
            stringBuffer.append(" mods:");
            stringBuffer.append(n);
        }
        if (keyStroke.isOnKeyRelease()) {
            stringBuffer.append(" release");
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public static Action lookupKey(Keymap keymap2, KeyStroke[] keyStrokeArray, int n, KeyStroke keyStroke, boolean bl) {
        int n2 = n + (keyStroke != null ? 1 : 0);
        boolean bl2 = false;
        if (n2 == 0) {
            throw new Error("no keys");
        }
        int n3 = 0;
        while (true) {
            Object object2;
            Action action;
            Action action2;
            KeyStroke keyStroke2;
            KeyStroke keyStroke3 = keyStroke2 = n3 == n ? keyStroke : keyStrokeArray[n3];
            if (bl2) {
                keyStroke2 = KeyStroke.getKeyStroke(keyStroke2.getKeyCode(), 8);
            }
            if ((action2 = keymap2.getAction(keyStroke2)) == null && (keyStroke2.getModifiers() & 8) != 0 && (action = keymap2.getAction(metaKey)) instanceof Command && ((Command)action).getCommand() instanceof Keymap) {
                object2 = (Keymap)((Command)action).getCommand();
                action = keymap2.getAction(metaKey);
                action2 = object2.getAction(BufferKeymap.stripMeta(keyStroke2));
            }
            ++n3;
            if (action2 == null) {
                if (BufferKeymap.ignorable(keyStroke)) {
                    return IgnoreAction.getInstance();
                }
                return keymap2.getDefaultAction();
            }
            if (n3 == n2) {
                return action2;
            }
            object2 = action2 instanceof Command ? ((Command)action2).getCommand() : null;
            if (object2 instanceof String || object2 instanceof Binding) {
                object2 = Command.resolveSymbol(object2);
            }
            if (!(object2 instanceof Keymap)) break;
            keymap2 = (Keymap)object2;
        }
        return null;
    }

    public Action getAction(KeyStroke keyStroke) {
        int n = 0;
        while (n < this.activeLength) {
            Keymap keymap2 = this.activeKeymaps[n];
            Action action = BufferKeymap.lookupKey(keymap2, this.pendingKeys, this.pendingLength, keyStroke, n < this.activeLength - 1);
            if (action != null) {
                return action;
            }
            ++n;
        }
        return BufferKeymap.ignorable(keyStroke) ? null : new TooLongAction(this.pendingLength);
    }

    public Action[] getBoundActions() {
        return this.activeKeymaps[0].getBoundActions();
    }

    public KeyStroke[] getBoundKeyStrokes() {
        return this.activeKeymaps[0].getBoundKeyStrokes();
    }

    public Action getDefaultAction() {
        return null;
    }

    public KeyStroke[] getKeyStrokesForAction(Action action) {
        return this.activeKeymaps[0].getKeyStrokesForAction(action);
    }

    public String getName() {
        return this.activeKeymaps[0].getName();
    }

    public Keymap getResolveParent() {
        return this.resolveParent;
    }

    public boolean isLocallyDefined(KeyStroke keyStroke) {
        return this.activeKeymaps[0].isLocallyDefined(keyStroke);
    }

    public void removeBindings() {
        this.activeKeymaps[0].removeBindings();
    }

    public void removeKeyStrokeBinding(KeyStroke keyStroke) {
        this.activeKeymaps[0].removeKeyStrokeBinding(keyStroke);
    }

    public void setDefaultAction(Action action) {
        this.activeKeymaps[0].setDefaultAction(action);
    }

    public void setResolveParent(Keymap keymap2) {
        this.resolveParent = keymap2;
    }

    public static KeyStroke asKeyStroke(char c, int n) {
        char c2 = c;
        if (c < ' ') {
            n |= 2;
            c = (char)(c == '\u0000' ? 32 : (char)(64 + (c & 0x1F)));
        }
        if (n != 0) {
            return KeyStroke.getKeyStroke((int)c, n);
        }
        return KeyStroke.getKeyStroke(c);
    }

    public static KeyStroke asKeyStroke(Object object2) {
        Object object3;
        int n = 0;
        while (object2 instanceof Pair) {
            object3 = (Pair)object2;
            if (((Pair)object3).cdr == LList.Empty) {
                object2 = ((Pair)object3).car;
                continue;
            }
            Object object4 = ((Pair)object3).car;
            if (object4 instanceof Binding) {
                object4 = object4.toString();
            }
            if (object4 == "control") {
                n |= 2;
            }
            if (object4 == "meta") {
                n |= 8;
            }
            if (object4 == "shift") {
                n |= 1;
            }
            if (object4 == "alt") {
                n |= 4;
            }
            object2 = ((Pair)object3).cdr;
        }
        if (object2 instanceof Char) {
            return BufferKeymap.asKeyStroke(((Char)object2).charValue(), n);
        }
        if (object2 instanceof IntNum) {
            return BufferKeymap.asKeyStroke((char)((IntNum)object2).intValue(), n);
        }
        if (object2 instanceof String || object2 instanceof Binding) {
            object3 = object2.toString();
            if (((String)object3).length() == 1) {
                char c = ((String)object3).charAt(0);
                if (n == 0) {
                    return KeyStroke.getKeyStroke(c);
                }
                c = Character.toUpperCase(c);
                return KeyStroke.getKeyStroke((int)c, n);
            }
            if (object3 == "backspace") {
                return KeyStroke.getKeyStroke(8, n);
            }
            if (object3 == "prior") {
                return KeyStroke.getKeyStroke(33, n);
            }
            if (object3 == "next") {
                return KeyStroke.getKeyStroke(34, n);
            }
            if (object3 == "return") {
                object3 = "enter";
            }
            return KeyStroke.getKeyStroke(((String)object3).toUpperCase());
        }
        return (KeyStroke)object2;
    }

    public static Keymap definePrefix(Keymap keymap2, KeyStroke keyStroke) {
        Action action = keymap2.getAction(keyStroke);
        if (action == null) {
            Keymap keymap3 = BufferKeymap.makeEmptyKeymap(null);
            keymap2.addActionForKeyStroke(keyStroke, new Command(keymap3, keyStroke));
            return keymap3;
        }
        if (action instanceof Command) {
            Object object2;
            Object object3 = ((Command)action).getCommand();
            if (object3 instanceof Keymap) {
                return (Keymap)object3;
            }
            if (object3 instanceof String && (object2 = Command.resolveSymbol(object3)) instanceof Keymap) {
                return (Keymap)object2;
            }
            throw new Error("keymap entry " + object3 + " for key " + keyStroke + " is not a prefix");
        }
        throw new Error("prefix command cannot override exiting action: " + ((Command)action).getCommand());
    }

    public static KeyStroke stripMeta(KeyStroke keyStroke) {
        int n = keyStroke.getModifiers();
        if ((n & 8) == 0) {
            return keyStroke;
        }
        int n2 = keyStroke.getKeyCode();
        boolean bl = keyStroke.isOnKeyRelease();
        if (((n &= 0xFFFFFFF7) & 0xFFFFFFFE) != 0 || bl || n2 > 127 || n2 < 32) {
            return KeyStroke.getKeyStroke(n2, n, bl);
        }
        if (n2 >= 65 && n2 <= 90 && n != 1) {
            n2 = n2 + 97 - 65;
        }
        return KeyStroke.getKeyStroke((char)n2);
    }

    public static void defineKey(Keymap keymap2, Object object2, Object object3) {
        if (object2 instanceof Sequence && !(object2 instanceof LList)) {
            Sequence sequence = (Sequence)object2;
            boolean bl = object2 instanceof FString;
            int n = sequence.size();
            Object var6_9 = null;
            int n2 = 0;
            while (n2 < n) {
                char c;
                Object object4 = sequence.get(n2);
                boolean bl2 = false;
                ++n2;
                if (bl && (c = ((Char)object4).charValue()) > '\u007f' && c <= '\u00ff') {
                    bl2 = true;
                    c = (char)(c - 128);
                    object4 = KeyStroke.getKeyStroke(c);
                }
                if (object4 instanceof Pair && ((Pair)object4).car == "meta") {
                    bl2 = true;
                    object4 = ((Pair)object4).cdr;
                }
                if (bl2) {
                    keymap2 = BufferKeymap.definePrefix(keymap2, metaKey);
                }
                if (n2 < n) {
                    keymap2 = BufferKeymap.definePrefix(keymap2, BufferKeymap.asKeyStroke(object4));
                    continue;
                }
                BufferKeymap.defineKey(keymap2, object4, object3);
            }
        } else {
            KeyStroke keyStroke;
            boolean bl = false;
            if (object2 instanceof Pair && ((Pair)object2).car == "meta") {
                bl = true;
                object2 = ((Pair)object2).cdr;
            }
            if (((keyStroke = BufferKeymap.asKeyStroke(object2)).getModifiers() & 8) != 0) {
                keyStroke = BufferKeymap.stripMeta(keyStroke);
                bl = true;
            }
            if (bl) {
                keymap2 = BufferKeymap.definePrefix(keymap2, metaKey);
            }
            Action action = BufferKeymap.asAction(object3, keyStroke);
            keymap2.addActionForKeyStroke(keyStroke, action);
        }
    }

    static {
        globalKeymap.setDefaultAction(defaultInsertAction);
        globalKeymap.addActionForKeyStroke(metaKey, metaAction);
    }
}

