/*
 * Decompiled with CFR 0.152.
 */
package gnu.lists;

import gnu.lists.AbstractSequence;
import gnu.lists.SeqPosition;

public class TreePosition
extends SeqPosition
implements Cloneable {
    AbstractSequence[] sstack;
    int[] istack;
    Object[] xstack;
    int depth;

    public TreePosition() {
        this.depth = -1;
    }

    public TreePosition(Object object2) {
        this.xpos = object2;
        this.depth = -1;
    }

    public TreePosition(AbstractSequence abstractSequence, int n) {
        abstractSequence.makePosition(n, false, this, 0);
    }

    public TreePosition(TreePosition treePosition) {
        this.set(treePosition);
    }

    public Object clone() {
        return new TreePosition(this);
    }

    public void set(TreePosition treePosition) {
        AbstractSequence abstractSequence;
        int n;
        this.clear();
        this.depth = n = treePosition.depth;
        if (n < 0) {
            this.xpos = treePosition.xpos;
            return;
        }
        if (this.sstack == null || this.sstack.length <= n) {
            this.sstack = new AbstractSequence[n + 10];
        }
        if (this.istack == null || this.istack.length <= n) {
            this.istack = new int[n + 10];
        }
        if (this.xstack == null || this.xstack.length <= n) {
            this.xstack = new Object[n + 10];
        }
        int n2 = 0;
        while (n2 < this.depth) {
            abstractSequence = treePosition.sstack[n2];
            abstractSequence.copyPosition(treePosition.istack[n2], treePosition.xstack[n2], this, this.depth - n2);
            ++n2;
        }
        abstractSequence = treePosition.sequence;
        abstractSequence.copyPosition(treePosition.ipos, treePosition.xpos, this, 0);
    }

    public int getDepth() {
        return this.depth + 1;
    }

    public AbstractSequence getRoot() {
        return this.depth == 0 ? this.sequence : this.sstack[0];
    }

    public Object getNext() {
        return this.sequence == null ? this.xpos : this.sequence.getNext(this.ipos, this.xpos);
    }

    public void push(AbstractSequence abstractSequence, int n, Object object2) {
        if (this.depth >= 0) {
            if (this.depth == 0) {
                this.istack = new int[8];
                this.xstack = new Object[8];
                this.sstack = new AbstractSequence[8];
            } else if (this.depth >= this.istack.length) {
                int n2 = 2 * this.depth;
                int[] nArray = new int[n2];
                Object[] objectArray = new Object[n2];
                AbstractSequence[] abstractSequenceArray = new AbstractSequence[n2];
                System.arraycopy(this.istack, 0, nArray, 0, this.depth);
                System.arraycopy(this.xstack, 0, objectArray, 0, this.depth);
                System.arraycopy(this.sstack, 0, abstractSequenceArray, 0, this.depth);
                this.istack = nArray;
                this.xstack = objectArray;
                this.sstack = abstractSequenceArray;
            }
            this.sstack[this.depth] = this.sequence;
            this.istack[this.depth] = this.ipos;
            this.xstack[this.depth] = this.xpos;
        }
        ++this.depth;
        this.sequence = abstractSequence;
        this.ipos = n;
        this.xpos = object2;
    }

    public void pop() {
        this.sequence.releasePosition(this.ipos, this.xpos);
        this.popNoRelease();
    }

    public void popNoRelease() {
        if (--this.depth < 0) {
            this.xpos = this.sequence;
            this.sequence = null;
        } else {
            this.sequence = this.sstack[this.depth];
            this.ipos = this.istack[this.depth];
            this.xpos = this.xstack[this.depth];
        }
    }

    public final boolean gotoParent() {
        return this.sequence == null ? false : this.sequence.gotoParent(this);
    }

    public boolean gotoChildrenStart() {
        if (this.sequence == null) {
            if (!(this.xpos instanceof AbstractSequence)) {
                return false;
            }
            this.depth = 0;
            this.sequence = (AbstractSequence)this.xpos;
            this.sequence.makeStartPosition(this, 0);
        } else if (!this.sequence.gotoChildrenStart(this)) {
            return false;
        }
        return true;
    }

    public boolean gotoAttributesStart() {
        if (this.sequence == null) {
            if (this.xpos instanceof AbstractSequence) {
                // empty if block
            }
            return false;
        }
        return this.sequence.gotoAttributesStart(this);
    }

    public Object getAncestor(int n) {
        if (n == 0) {
            return this.sequence.getNext(this.ipos, this.xpos);
        }
        int n2 = this.depth - n;
        if (n2 <= 0) {
            return this.getRoot();
        }
        return this.sstack[n2].getNext(this.istack[n2], this.xstack[n2]);
    }

    public void finalize() {
        this.clear();
    }

    public void clear() {
        while (this.sequence != null) {
            this.sequence.releasePosition(this.ipos, this.xpos);
            this.pop();
        }
        this.xpos = null;
    }

    public int getPositionInt(int n) {
        return n == 0 ? this.ipos : this.istack[this.depth - n];
    }

    public Object getPositionPtr(int n) {
        return n == 0 ? this.xpos : this.xstack[this.depth - n];
    }

    public void setPosition(int n, int n2, Object object2) {
        if (n == 0) {
            this.ipos = n2;
            this.xpos = object2;
        } else {
            this.istack[this.depth - n] = n2;
            this.xstack[this.depth - n] = object2;
        }
    }

    public void setSequence(int n, AbstractSequence abstractSequence) {
        if (n == 0) {
            this.sequence = abstractSequence;
        } else {
            this.sstack[this.depth - n] = abstractSequence;
        }
    }

    public int countPositions() {
        return this.depth + 1;
    }

    public void dump() {
        System.err.println("TreePosition dump depth:" + this.depth);
        if (this.depth < 0) {
            System.err.println("#- xpos:" + this.getPositionPtr(0));
        }
        int n = 0;
        while (n <= this.depth) {
            AbstractSequence abstractSequence = n == 0 ? this.sequence : this.sstack[this.depth - n];
            System.err.print("#" + n + " seq:" + abstractSequence);
            System.err.println(" ipos:" + this.getPositionInt(n) + " xpos:" + this.getPositionPtr(n));
            ++n;
        }
    }
}

