/*
 * Decompiled with CFR 0.152.
 */
package gnu.mapping;

import gnu.mapping.ConstantConstraint;
import gnu.mapping.Constraint;
import gnu.mapping.Environment;
import gnu.mapping.Location;
import gnu.mapping.Procedure;
import gnu.mapping.SFormat;
import gnu.mapping.TrivialConstraint;
import gnu.mapping.UnboundSymbol;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.io.PrintWriter;

public class Binding
extends Location
implements Externalizable {
    Object value;
    Constraint constraint;
    public static final String UNBOUND = new String("(unbound)");
    static final String FUNCTION = new String("(function).");
    public static final Binding hashDELETED = new Binding(new String("<Deleted>"));

    public final Object get() {
        return this.constraint.get(this);
    }

    public Procedure getProcedure() {
        try {
            return this.constraint.getProcedure(this);
        }
        catch (UnboundSymbol unboundSymbol) {
            Object object2 = this.getFunctionValue(UNBOUND);
            if (object2 != UNBOUND) {
                return (Procedure)object2;
            }
            throw unboundSymbol;
        }
    }

    public final void defineValue(Object object2) {
        Environment environment = this.constraint.getEnvironment(this);
        if (environment.locked) {
            this.set(object2);
        } else {
            this.constraint = TrivialConstraint.getInstance(this);
            this.value = object2;
        }
    }

    public final void defineConstant(Object object2) {
        Environment environment = this.constraint.getEnvironment(this);
        if (environment.locked) {
            this.set(object2);
        } else {
            this.constraint = ConstantConstraint.getInstance(environment);
            this.value = object2;
        }
    }

    public final void set(Object object2) {
        this.constraint.set(this, object2);
    }

    public final Constraint getConstraint() {
        return this.constraint;
    }

    public final void setConstraint(Constraint constraint) {
        this.constraint = constraint;
    }

    public boolean isBound() {
        return this.constraint.isBound(this);
    }

    public Binding() {
    }

    public Binding(String string) {
        this.setName(string);
    }

    public static Binding make(Object object2, String string) {
        Binding binding = new Binding(string);
        binding.value = object2;
        binding.constraint = TrivialConstraint.getInstance((Environment)null);
        return binding;
    }

    public static Binding make(String string, Environment environment) {
        if (environment == null) {
            return new Binding(string);
        }
        return environment.getBinding(string);
    }

    public void print(PrintWriter printWriter) {
        printWriter.print("#<binding ");
        String string = this.getName();
        if (string != null) {
            printWriter.print(string);
        }
        if (this.isBound()) {
            printWriter.print(" -> ");
            SFormat.print(this.get(), printWriter);
        } else {
            printWriter.print("(unbound)");
        }
        printWriter.print('>');
    }

    public final Object getKey() {
        return this.getName();
    }

    public final Object getValue() {
        return this.constraint.get(this);
    }

    public final Object setValue(Object object2) {
        Object object3 = this.constraint.get(this);
        this.constraint.set(this, object2);
        return object3;
    }

    public boolean equals(Object object2) {
        return this == object2;
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    public static int hashSearch(Binding[] bindingArray, int n, int n2, String string, int n3) {
        int n4 = n3 & n2;
        Binding binding = bindingArray[n4];
        if (binding == null || binding.getName() == string) {
            return n4;
        }
        int n5 = -1;
        int n6 = ((n3 >> n ^ n4) << 1) + 1;
        do {
            if (binding == hashDELETED && n5 < 0) {
                n5 = n4;
            }
            if ((binding = bindingArray[n4 = n4 + n6 & n2]) != null) continue;
            return n5 < 0 ? n4 : n5;
        } while (binding.getName() != string);
        return n4;
    }

    public static int hashSearch(Binding[] bindingArray, int n, String string) {
        return Binding.hashSearch(bindingArray, n, (1 << n) - 1, string, System.identityHashCode(string));
    }

    public static Binding hashGet(Binding[] bindingArray, int n, String string) {
        int n2 = Binding.hashSearch(bindingArray, n, (1 << n) - 1, string, System.identityHashCode(string));
        Binding binding = bindingArray[n2];
        if (binding == null || binding == hashDELETED) {
            return null;
        }
        return binding;
    }

    public static Binding hashSet(Binding[] bindingArray, int n, Binding binding) {
        String string = binding.getName();
        int n2 = Binding.hashSearch(bindingArray, n, (1 << n) - 1, string, System.identityHashCode(string));
        Binding binding2 = bindingArray[n2];
        bindingArray[n2] = binding;
        return binding2 == hashDELETED ? null : binding2;
    }

    public static Binding hashDelete(Binding[] bindingArray, int n, String string) {
        int n2 = Binding.hashSearch(bindingArray, n, (1 << n) - 1, string, System.identityHashCode(string));
        Binding binding = bindingArray[n2];
        bindingArray[n2] = hashDELETED;
        return binding == hashDELETED ? null : binding;
    }

    public static int hashInsertAll(Binding[] bindingArray, int n, Binding[] bindingArray2, int n2) {
        int n3 = 0;
        int n4 = 1 << n2;
        int n5 = 1 << n;
        int n6 = (1 << n) - 1;
        int n7 = n4;
        while (--n7 >= 0) {
            Binding binding = bindingArray2[n7];
            if (binding == null || binding == hashDELETED) continue;
            String string = binding.getName();
            int n8 = Binding.hashSearch(bindingArray, n, n6, string, System.identityHashCode(string));
            Binding binding2 = bindingArray[n8];
            if (binding2 != null && binding2 != hashDELETED) {
                ++n3;
            }
            bindingArray[n8] = binding;
        }
        return n3;
    }

    public final Object getFunctionValue() {
        Object object2 = this.constraint.getFunctionValue(this);
        if (object2 == UNBOUND) {
            throw new UnboundSymbol(this.getName());
        }
        return object2;
    }

    public final Object getFunctionValue(Object object2) {
        Object object3 = this.constraint.getFunctionValue(this);
        return object3 == UNBOUND ? object2 : object3;
    }

    public boolean hasFunctionValue() {
        Object object2 = this.constraint.getFunctionValue(this);
        return object2 != UNBOUND;
    }

    public void setFunctionValue(Object object2) {
        this.constraint.setFunctionValue(this, object2);
    }

    public void removeFunctionValue() {
        this.constraint.setFunctionValue(this, UNBOUND);
    }

    public final Environment getEnvironment() {
        return this.constraint.getEnvironment(this);
    }

    public String toString() {
        return this.getName();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.getName());
        objectOutput.writeObject(this.getEnvironment());
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        String string = (String)objectInput.readObject();
        Environment environment = (Environment)objectInput.readObject();
        if (environment != null) {
            this.constraint = environment.unboundConstraint;
        }
        this.setName(string);
    }

    public Object readResolve() throws ObjectStreamException {
        if (this.constraint == null) {
            return this;
        }
        Environment environment = this.constraint.getEnvironment(this);
        if (environment == null) {
            return this;
        }
        return Binding.make(environment, this.getName());
    }
}

