/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.ArrayType;
import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Method;
import gnu.bytecode.ObjectType;
import gnu.bytecode.PrimType;
import gnu.bytecode.Type;
import gnu.expr.Compilation;
import gnu.expr.Interpreter;
import gnu.expr.Literal;
import gnu.expr.StackTarget;
import gnu.lists.FString;
import gnu.mapping.Values;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectOutput;
import java.lang.reflect.Array;

public class LitTable
implements ObjectOutput {
    Compilation comp;
    Object[] valueStack = new Object[20];
    Type[] typeStack = new Type[20];
    int stackPointer;

    public LitTable(Compilation compilation) {
        this.comp = compilation;
    }

    public void emit() throws IOException {
        Literal literal = this.comp.literalsChain;
        while (literal != null) {
            this.writeObject(literal.value);
            literal = literal.next;
        }
        Literal literal2 = this.comp.literalsChain;
        while (literal2 != null) {
            this.emit(literal2, true);
            literal2 = literal2.next;
        }
        this.comp.literalTable = null;
        this.comp.literalsCount = 0;
    }

    void push(Object object2, Type type) {
        if (this.stackPointer >= this.valueStack.length) {
            Object[] objectArray = new Object[2 * this.valueStack.length];
            Type[] typeArray = new Type[2 * this.typeStack.length];
            System.arraycopy(this.valueStack, 0, objectArray, 0, this.stackPointer);
            System.arraycopy(this.typeStack, 0, typeArray, 0, this.stackPointer);
            this.valueStack = objectArray;
            this.typeStack = typeArray;
        }
        this.valueStack[this.stackPointer] = object2;
        this.typeStack[this.stackPointer] = type;
        ++this.stackPointer;
    }

    void error(String string) {
        throw new Error(string);
    }

    public void flush() {
    }

    public void close() {
    }

    public void write(int n) throws IOException {
        this.error("cannot handle call to write(int) when externalizing literal");
    }

    public void writeBytes(String string) throws IOException {
        this.error("cannot handle call to writeBytes(String) when externalizing literal");
    }

    public void write(byte[] byArray) throws IOException {
        this.error("cannot handle call to write(byte[]) when externalizing literal");
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.error("cannot handle call to write(byte[],int,int) when externalizing literal");
    }

    public void writeBoolean(boolean bl) {
        this.push(new Boolean(bl), Type.boolean_type);
    }

    public void writeChar(int n) {
        this.push(new Character((char)n), Type.char_type);
    }

    public void writeByte(int n) {
        this.push(new Byte((byte)n), Type.byte_type);
    }

    public void writeShort(int n) {
        this.push(new Short((short)n), Type.short_type);
    }

    public void writeInt(int n) {
        this.push(new Integer(n), Type.int_type);
    }

    public void writeLong(long l) {
        this.push(new Long(l), Type.long_type);
    }

    public void writeFloat(float f) {
        this.push(new Float(f), Type.float_type);
    }

    public void writeDouble(double d) {
        this.push(new Double(d), Type.double_type);
    }

    public void writeUTF(String string) {
        this.push(string, Type.string_type);
    }

    public void writeChars(String string) {
        this.push(string, Type.string_type);
    }

    public void writeObject(Object object2) throws IOException {
        Literal literal = this.comp.findLiteral(object2);
        if ((literal.flags & 3) != 0) {
            if (literal.field == null && !(object2 instanceof String)) {
                literal.assign(this.comp);
            }
            if ((literal.flags & 2) == 0) {
                literal.flags |= 4;
            }
        } else {
            literal.flags |= 1;
            int n = this.stackPointer;
            if (object2 instanceof FString && ((FString)object2).size() < 65535) {
                this.push(object2.toString(), Type.string_type);
            } else if (object2 instanceof Externalizable) {
                ((Externalizable)object2).writeExternal(this);
            } else if (object2 instanceof Object[]) {
                Object[] objectArray = (Object[])object2;
                int n2 = 0;
                while (n2 < objectArray.length) {
                    this.writeObject(objectArray[n2]);
                    ++n2;
                }
            } else if (object2 != null && !(object2 instanceof String) && !(literal.type instanceof ArrayType)) {
                this.error(object2.getClass().getName() + " does not implement Externalizable");
            }
            int n3 = this.stackPointer - n;
            if (n3 == 0) {
                literal.argValues = Values.noArgs;
                literal.argTypes = Type.typeArray0;
            } else {
                literal.argValues = new Object[n3];
                literal.argTypes = new Type[n3];
                System.arraycopy(this.valueStack, n, literal.argValues, 0, n3);
                System.arraycopy(this.typeStack, n, literal.argTypes, 0, n3);
                this.stackPointer = n;
            }
            literal.flags |= 2;
        }
        this.push(literal, literal.type);
    }

    Method getMethod(ClassType classType, String string, Literal literal, boolean bl) {
        Type[] typeArray = literal.argTypes;
        Method method = classType.getDeclaredMethods();
        int n = typeArray.length;
        Method method2 = null;
        long l = 0L;
        boolean bl2 = false;
        Type[] typeArray2 = null;
        while (method != null) {
            boolean bl3;
            if (string.equals(method.getName()) && bl == (bl3 = method.getStaticFlag())) {
                long l2 = 0L;
                Type[] typeArray3 = method.getParameterTypes();
                int n2 = 0;
                int n3 = 0;
                block1: while (true) {
                    int n4;
                    if (n2 == n && n3 == typeArray3.length) {
                        if (method2 == null || l != 0L && l2 == 0L) {
                            method2 = method;
                            typeArray2 = typeArray3;
                            l = l2;
                            break;
                        }
                        if (l2 != 0L) break;
                        boolean bl4 = false;
                        boolean bl5 = false;
                        n4 = n;
                        while (--n4 >= 0) {
                            int n5 = typeArray2[n4].compare(typeArray3[n4]);
                            if (n5 != 1) {
                                bl5 = true;
                                if (bl4) break;
                            }
                            if (n5 == -1) continue;
                            bl4 = true;
                            if (bl5) break;
                        }
                        if (bl4) {
                            method2 = method;
                            typeArray2 = typeArray3;
                        }
                        bl2 = bl4 && bl5;
                        break;
                    }
                    if (n2 == n || n3 == typeArray3.length) break;
                    Type type = typeArray[n2];
                    Type type2 = typeArray3[n3];
                    if (!type.isSubtype(type2)) {
                        if (!(type2 instanceof ArrayType) || n3 >= 64 || type != Type.int_type && type != Type.short_type) break;
                        n4 = ((Number)literal.argValues[n2]).intValue();
                        if (n4 < 0 && classType.getName().equals("gnu.math.IntNum")) {
                            n4 -= Integer.MIN_VALUE;
                        }
                        Type type3 = ((ArrayType)type2).getComponentType();
                        if (n4 < 0 || n2 + n4 >= n) break;
                        int n6 = n4;
                        while (--n6 >= 0) {
                            Type type4 = typeArray[n2 + n6 + 1];
                            if (type3 instanceof PrimType ? type3.getSignature() != type4.getSignature() : !type4.isSubtype(type3)) break block1;
                        }
                        n2 += n4;
                        l2 |= (long)(1 << n3);
                    }
                    ++n2;
                    ++n3;
                }
            }
            method = method.getNext();
        }
        if (bl2) {
            return null;
        }
        if (l != 0L) {
            Object[] objectArray = new Object[typeArray2.length];
            Type[] typeArray4 = new Type[typeArray2.length];
            int n7 = 0;
            int n8 = 0;
            while (n7 != n) {
                Type type = typeArray[n7];
                void var18_23 = typeArray2[n8];
                if ((l & (long)(1 << n8)) == 0L) {
                    objectArray[n8] = literal.argValues[n7];
                    typeArray4[n8] = literal.argTypes[n7];
                } else {
                    int n9 = ((Number)literal.argValues[n7]).intValue();
                    boolean bl6 = classType.getName().equals("gnu.math.IntNum");
                    if (bl6) {
                        n9 -= Integer.MIN_VALUE;
                    }
                    Type type5 = ((ArrayType)var18_23).getComponentType();
                    typeArray4[n8] = var18_23;
                    objectArray[n8] = Array.newInstance(type5.getReflectClass(), n9);
                    Object[] objectArray2 = literal.argValues;
                    if (bl6) {
                        int[] nArray = (int[])objectArray[n8];
                        int n10 = n9;
                        while (n10 > 0) {
                            nArray[n9 - n10] = (Integer)objectArray2[n7 + n10];
                            --n10;
                        }
                    } else {
                        int n11 = n9;
                        while (--n11 >= 0) {
                            Array.set(objectArray[n8], n11, objectArray2[n7 + 1 + n11]);
                        }
                    }
                    Literal literal2 = new Literal(objectArray[n8], (Type)var18_23);
                    if (type5 instanceof ObjectType) {
                        literal2.argValues = (Object[])objectArray[n8];
                    }
                    objectArray[n8] = literal2;
                    n7 += n9;
                }
                ++n7;
                ++n8;
            }
            literal.argValues = objectArray;
            literal.argTypes = typeArray4;
        }
        return method2;
    }

    void putArgs(Literal literal, CodeAttr codeAttr) {
        Type[] typeArray = literal.argTypes;
        int n = typeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object2 = literal.argValues[n2];
            if (object2 instanceof Literal) {
                this.emit((Literal)object2, false);
            } else {
                this.comp.compileConstant(object2, new StackTarget(typeArray[n2]));
            }
            ++n2;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    void emitPrimArray(Object object2, ArrayType arrayType, CodeAttr codeAttr) {
        Type type = arrayType.getComponentType();
        int n = Array.getLength(object2);
        codeAttr.emitPushInt(n);
        codeAttr.emitNewArray(type);
        char c = type.getSignature().charAt(0);
        int n2 = 0;
        while (n2 < n) {
            block17: {
                long l = 0L;
                float f = 0.0f;
                double d = 0.0;
                switch (c) {
                    case 'J': {
                        l = ((long[])object2)[n2];
                        if (l != 0L) break;
                        break block17;
                    }
                    case 'I': {
                        l = ((int[])object2)[n2];
                        if (l != 0L) break;
                        break block17;
                    }
                    case 'S': {
                        l = ((short[])object2)[n2];
                        if (l != 0L) break;
                        break block17;
                    }
                    case 'C': {
                        l = ((char[])object2)[n2];
                        if (l != 0L) break;
                        break block17;
                    }
                    case 'B': {
                        l = ((byte[])object2)[n2];
                        if (l != 0L) break;
                        break block17;
                    }
                    case 'Z': {
                        long l2 = l = ((boolean[])object2)[n2] ? 1L : 0L;
                        if (l != 0L) break;
                        break block17;
                    }
                    case 'F': {
                        f = ((float[])object2)[n2];
                        if ((double)f != 0.0) break;
                        break block17;
                    }
                    case 'D': {
                        d = ((double[])object2)[n2];
                        if (d == 0.0) break block17;
                    }
                }
                codeAttr.emitDup(arrayType);
                codeAttr.emitPushInt(n2);
                switch (c) {
                    case 'B': 
                    case 'C': 
                    case 'I': 
                    case 'S': 
                    case 'Z': {
                        codeAttr.emitPushInt((int)l);
                        break;
                    }
                    case 'J': {
                        codeAttr.emitPushLong(l);
                        break;
                    }
                    case 'F': {
                        codeAttr.emitPushFloat(f);
                        break;
                    }
                    case 'D': {
                        codeAttr.emitPushDouble(d);
                        break;
                    }
                }
                codeAttr.emitArrayStore(type);
            }
            ++n2;
        }
    }

    void emit(Literal literal, boolean bl) {
        CodeAttr codeAttr = this.comp.getCode();
        if (literal.value == null) {
            if (!bl) {
                codeAttr.emitPushNull();
            }
        } else if (literal.value instanceof String) {
            if (!bl) {
                codeAttr.emitPushString(literal.value.toString());
            }
        } else if ((literal.flags & 8) != 0) {
            if (!bl) {
                codeAttr.emitGetStatic(literal.field);
            }
        } else if (literal.value instanceof Object[]) {
            int n = literal.argValues.length;
            Type type = ((ArrayType)literal.type).getComponentType();
            codeAttr.emitPushInt(n);
            codeAttr.emitNewArray(type);
            if (literal.field != null) {
                if (!bl) {
                    codeAttr.emitDup(literal.type);
                }
                codeAttr.emitPutStatic(literal.field);
            }
            literal.flags |= 8;
            int n2 = 0;
            while (n2 < n) {
                Literal literal2 = (Literal)literal.argValues[n2];
                if (literal2.value != null) {
                    codeAttr.emitDup(type);
                    codeAttr.emitPushInt(n2);
                    this.emit(literal2, false);
                    codeAttr.emitArrayStore(type);
                }
                ++n2;
            }
        } else if (literal.type instanceof ArrayType) {
            this.emitPrimArray(literal.value, (ArrayType)literal.type, codeAttr);
            if (literal.field != null) {
                if (!bl) {
                    codeAttr.emitDup(literal.type);
                }
                codeAttr.emitPutStatic(literal.field);
            }
            literal.flags |= 8;
        } else {
            Method method;
            Interpreter interpreter = this.comp.getInterpreter();
            ClassType classType = (ClassType)literal.type;
            boolean bl2 = (literal.flags & 4) != 0;
            Method method2 = null;
            boolean bl3 = false;
            if (!bl2) {
                method2 = this.getMethod(classType, "make", literal, true);
                if (method2 != null) {
                    bl3 = true;
                } else if (literal.argTypes.length > 0) {
                    method2 = this.getMethod(classType, "<init>", literal, false);
                }
                if (method2 == null) {
                    bl2 = true;
                }
            }
            if (bl2) {
                method2 = this.getMethod(classType, "set", literal, false);
            }
            if (method2 == null && literal.argTypes.length > 0) {
                this.error("no method to construct " + literal.type);
            }
            if (bl3) {
                this.putArgs(literal, codeAttr);
                codeAttr.emitInvokeStatic(method2);
            } else if (bl2) {
                codeAttr.emitNew(classType);
                codeAttr.emitDup(classType);
                method = classType.getDeclaredMethod("<init>", 0);
                codeAttr.emitInvokeSpecial(method);
            } else {
                codeAttr.emitNew(classType);
                codeAttr.emitDup(classType);
                this.putArgs(literal, codeAttr);
                codeAttr.emitInvokeSpecial(method2);
            }
            Method method3 = method = bl3 ? null : classType.getDeclaredMethod("readResolve", 0);
            if (method != null) {
                codeAttr.emitInvokeVirtual(method);
                classType.emitCoerceFromObject(codeAttr);
            }
            if (literal.field != null) {
                if (!bl || bl2 && method2 != null) {
                    codeAttr.emitDup(classType);
                }
                codeAttr.emitPutStatic(literal.field);
            }
            literal.flags |= 8;
            if (bl2 && method2 != null) {
                if (!bl) {
                    codeAttr.emitDup(classType);
                }
                this.putArgs(literal, codeAttr);
                codeAttr.emitInvokeVirtual(method2);
            }
        }
    }
}

