/*
 * Decompiled with CFR 0.152.
 */
package gnu.lists;

import gnu.lists.CharSequence;
import gnu.lists.Consumer;
import gnu.lists.FString;
import gnu.lists.StableVector;
import java.io.IOException;
import java.io.Writer;

public class CharBuffer
extends StableVector
implements CharSequence {
    private FString string;

    public CharBuffer(FString fString) {
        super(fString);
        this.string = fString;
    }

    public CharBuffer(int n) {
        this(new FString(n));
    }

    public int length() {
        return this.size();
    }

    public char charAt(int n) {
        if (n >= this.gapStart) {
            n += this.gapEnd - this.gapStart;
        }
        return this.string.charAt(n);
    }

    public void getChars(int n, int n2, char[] cArray, int n3) {
        int n4;
        int n5;
        char[] cArray2 = this.string.data;
        if (n < this.gapStart && (n5 = (n2 < this.gapStart ? n2 : this.gapStart) - n) > 0) {
            System.arraycopy(cArray2, n, cArray, n3, n5);
            n += n5;
            n3 += n5;
        }
        if ((n5 = (n2 += (n4 = this.gapEnd - this.gapStart)) - (n += n4)) > 0) {
            System.arraycopy(cArray2, n, cArray, n3, n5);
        }
    }

    public void setCharAt(int n, char c) {
        if (n >= this.gapStart) {
            n += this.gapEnd - this.gapStart;
        }
        this.string.setCharAt(n, c);
    }

    public void fill(int n, int n2, char c) {
        char[] cArray = this.string.data;
        int n3 = n;
        int n4 = this.gapStart < n2 ? this.gapStart : n2;
        while (n3 < n4) {
            cArray[n3] = c;
            ++n3;
        }
        int n5 = this.gapEnd - this.gapStart;
        n3 = n4 + n5;
        n4 += n2;
        while (n3 < n4) {
            cArray[n3] = c;
            ++n3;
        }
    }

    public final void fill(char c) {
        char[] cArray = this.string.data;
        int n = cArray.length;
        while (--n >= this.gapEnd) {
            cArray[n] = c;
        }
        int n2 = this.gapStart;
        while (--n2 >= 0) {
            cArray[n2] = c;
        }
    }

    public char[] getArray() {
        return (char[])this.base.getBuffer();
    }

    public void delete(int n, int n2) {
        int n3 = this.createPosition(n, false);
        this.remove(n3, null, n2);
        this.releasePosition(n3, null);
    }

    public void insert(int n, String string, boolean bl) {
        int n2 = string.length();
        this.gapReserve(n, n2);
        string.getChars(0, n2, this.string.data, n);
        this.gapStart += n2;
    }

    public void consume(int n, int n2, Consumer consumer) {
        char[] cArray = this.string.data;
        if (n < this.gapStart) {
            int n3 = this.gapStart - n;
            if (n3 > n2) {
                n3 = n2;
            }
            consumer.write(cArray, n, n3);
            n += (n2 -= n3);
        }
        if (n2 > 0) {
            consumer.write(cArray, n += this.gapEnd - this.gapStart, n2);
        }
    }

    public void writeTo(int n, int n2, Writer writer) throws IOException {
        char[] cArray = this.string.data;
        if (n < this.gapStart) {
            int n3 = this.gapStart - n;
            if (n3 > n2) {
                n3 = n2;
            }
            writer.write(cArray, n, n3);
            n += (n2 -= n3);
        }
        if (n2 > 0) {
            writer.write(cArray, n += this.gapEnd - this.gapStart, n2);
        }
    }

    public void writeTo(Writer writer) throws IOException {
        char[] cArray = this.string.data;
        writer.write(cArray, 0, this.gapStart);
        writer.write(cArray, this.gapEnd, cArray.length - this.gapEnd);
    }
}

