/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml;

import gnu.lists.Convert;
import gnu.lists.PositionConsumer;
import gnu.lists.TreeList;
import gnu.lists.TreePosition;
import gnu.lists.TreePositionList;
import gnu.xml.ParsedXMLToConsumer;
import gnu.xml.XMLParser;
import gnu.xml.XMLPrinter;
import gnu.xml.XPathConstants;
import gnu.xml.XPathContext;
import gnu.xml.XPathFunction;
import gnu.xml.XPathParser;
import java.io.PrintWriter;
import java.net.URL;

public class XPath
implements XPathConstants {
    String srcPath;
    short[] code;
    short codeLen;
    Object[] values;
    short valLen;

    public static String stringValue(double d) {
        long l = (long)d;
        if ((double)l == d) {
            return Long.toString(l);
        }
        return Double.toString(d);
    }

    public static String stringValue(Object object2) {
        if (object2 instanceof Number) {
            return XPath.stringValue(((Number)object2).doubleValue());
        }
        return object2.toString();
    }

    public static double numberValue(Object object2) {
        if (object2 instanceof Number) {
            return ((Number)object2).doubleValue();
        }
        return Convert.parseDouble(XPath.stringValue(object2));
    }

    public static boolean booleanValue(Object object2) {
        if (object2 instanceof Boolean) {
            return (Boolean)object2;
        }
        if (object2 instanceof Number) {
            return ((Number)object2).doubleValue() != 0.0;
        }
        return object2.toString().length() > 0;
    }

    void result(XPathContext xPathContext, Object object2, int n) {
        if (object2 instanceof Boolean) {
            XPath.result(xPathContext, (Boolean)object2, n);
        } else if (object2 instanceof Number) {
            this.result(xPathContext, ((Number)object2).doubleValue(), n);
        } else if (object2 instanceof String) {
            XPath.result(xPathContext, (String)object2, n);
        } else if (n == 0) {
            xPathContext.objResult = object2;
            xPathContext.resultType = 0;
        } else {
            throw new Error("unhandled result code");
        }
    }

    void result(XPathContext xPathContext, double d, int n) {
        if (n == 3) {
            xPathContext.boolResult = d != 0.0;
            xPathContext.resultType = 3;
        } else if (n == 4) {
            xPathContext.boolResult = d == (double)this.getContextPosition(xPathContext);
            xPathContext.resultType = 3;
        } else if (n == 1) {
            xPathContext.objResult = XPath.stringValue(d);
            xPathContext.resultType = 1;
        } else if (n == 5 || n == 0) {
            xPathContext.numResult = d;
            xPathContext.resultType = 5;
        } else {
            throw new Error("unhandled result code");
        }
    }

    static void result(XPathContext xPathContext, String string, int n) {
        if (n == 0 || n == 1) {
            xPathContext.objResult = string;
            xPathContext.resultType = 1;
        } else if (n == 3 || n == 4) {
            xPathContext.boolResult = string.length() > 0;
            xPathContext.resultType = 3;
        } else if (n == 5) {
            xPathContext.numResult = Convert.parseDouble(string);
            xPathContext.resultType = 5;
        } else {
            throw new Error("unhandled result code");
        }
    }

    static void result(XPathContext xPathContext, TreePositionList treePositionList, int n) {
        if (n == 0 || n == 2) {
            xPathContext.objResult = treePositionList;
            xPathContext.resultType = 2;
        } else if (n == 3 || n == 4) {
            xPathContext.boolResult = !treePositionList.isEmpty();
            xPathContext.resultType = 3;
        } else if (n == 1) {
            xPathContext.objResult = XPath.stringValue(treePositionList);
            xPathContext.resultType = 1;
        } else {
            throw new Error("unhandled result code");
        }
    }

    static void result(XPathContext xPathContext, boolean bl, int n) {
        if (n == 3 || n == 0 || n == 4) {
            xPathContext.boolResult = bl;
            xPathContext.resultType = 3;
        } else if (n == 5) {
            xPathContext.numResult = bl ? 1.0 : 0.0;
            xPathContext.resultType = 5;
        } else if (n == 1) {
            xPathContext.objResult = bl ? "true" : "false";
            xPathContext.resultType = 1;
        } else {
            throw new Error("unknown result code");
        }
    }

    public Object eval(XPathContext xPathContext) {
        return this.eval(xPathContext, this.codeLen - 1);
    }

    public Object eval(XPathContext xPathContext, int n) {
        this.eval(xPathContext, n, 0);
        switch (xPathContext.resultType) {
            case 0: 
            case 1: 
            case 2: {
                return xPathContext.objResult;
            }
            case 3: {
                return xPathContext.boolResult ? Boolean.TRUE : Boolean.FALSE;
            }
            case 5: {
                return new Double(xPathContext.numResult);
            }
        }
        throw new Error("unknown result Type");
    }

    public void error(String string) {
        throw new Error(string);
    }

    public void checkArgs(Object object2, int n, int n2) {
        if (n != n2) {
            this.error(object2.toString() + ": wrong number of arguments (" + n + ", should be " + n2 + ')');
        }
    }

    public void checkArgs(Object object2, int n, int n2, int n3) {
        if (n < n2) {
            this.error(object2.toString() + ": too few arguments (" + n + ", should be at least " + n2 + ')');
        } else if (n > n3 && n3 >= 0) {
            this.error(object2.toString() + ": too many arguments (" + n + ", should be at most " + n3 + ')');
        }
    }

    public void call(XPathContext xPathContext, Object object2, Object[] objectArray, int n) {
        this.error("unknown function: " + object2);
    }

    int getContextPosition(XPathContext xPathContext) {
        return xPathContext.getCurrentPosition();
    }

    int getContextSize(XPathContext xPathContext) {
        return xPathContext.predPc > xPathContext.stepPc ? (int)(this.getPositionAndLast(xPathContext) >> 32) : xPathContext.getCurrentSize();
    }

    private long getPositionAndLast(XPathContext xPathContext) {
        throw new Error("not implemented");
    }

    public void evalCall(XPathContext xPathContext, Object object2, int n, int n2, int n3) {
        if (object2 instanceof XPathFunction) {
            ((XPathFunction)object2).apply(xPathContext, n, this, n2, n3);
            return;
        }
        if (object2 == "count") {
            this.checkArgs(object2, n, 1);
            n2 -= this.code[n2];
            int n4 = xPathContext.consumeKind;
            int n5 = xPathContext.consumeCount;
            try {
                xPathContext.consumeKind = 1;
                xPathContext.consumeCount = 0;
                this.evalToNodes(xPathContext, n2 + this.code[n2], xPathContext);
                xPathContext.resultType = 5;
                xPathContext.numResult = xPathContext.consumeCount;
                Object var9_16 = null;
                xPathContext.consumeKind = n4;
                xPathContext.consumeCount = n5;
            }
            catch (Throwable throwable) {
                Object var9_17 = null;
                xPathContext.consumeKind = n4;
                xPathContext.consumeCount = n5;
                throw throwable;
            }
            return;
        }
        if (object2 == "not") {
            this.checkArgs(object2, n, 1);
            n2 -= this.code[n2];
            n2 += this.code[n2];
            XPath.result(xPathContext, !this.evalToBoolean(xPathContext, n2), n3);
            return;
        }
        if (object2 == "boolean") {
            this.checkArgs(object2, n, 1);
            n2 -= this.code[n2];
            n2 += this.code[n2];
            XPath.result(xPathContext, this.evalToBoolean(xPathContext, n2), n3);
            return;
        }
        if (object2 == "number") {
            this.checkArgs(object2, n, 1);
            n2 -= this.code[n2];
            n2 += this.code[n2];
            this.result(xPathContext, this.evalToNumber(xPathContext, n2), n3);
            return;
        }
        if (object2 == "position") {
            this.checkArgs(object2, n, 0);
            this.result(xPathContext, this.getContextPosition(xPathContext), n3);
            return;
        }
        if (object2 == "last") {
            this.checkArgs(object2, n, 0);
            this.result(xPathContext, this.getContextSize(xPathContext), n3);
            return;
        }
        if (object2 == "string") {
            this.checkArgs(object2, n, 1);
            n2 -= this.code[n2];
            n2 += this.code[n2];
            XPath.result(xPathContext, this.evalToString(xPathContext, n2), n3);
            return;
        }
        if (object2 == "true") {
            this.checkArgs(object2, n, 0);
            XPath.result(xPathContext, true, n3);
            return;
        }
        if (object2 == "false") {
            this.checkArgs(object2, n, 0);
            XPath.result(xPathContext, false, n3);
            return;
        }
        if (object2 == "starts-with") {
            this.checkArgs(object2, n, 2);
            n2 -= this.code[n2];
            n2 += this.code[n2];
            String string = this.evalToString(xPathContext, n2);
            short s = this.code[++n2];
            String string2 = this.evalToString(xPathContext, n2 += s);
            XPath.result(xPathContext, string.startsWith(string2), n3);
            return;
        }
        if (object2 == "ends-with") {
            this.checkArgs(object2, n, 2);
            n2 -= this.code[n2];
            n2 += this.code[n2];
            String string = this.evalToString(xPathContext, n2);
            short s = this.code[++n2];
            String string3 = this.evalToString(xPathContext, n2 += s);
            XPath.result(xPathContext, string.endsWith(string3), n3);
            return;
        }
        if (object2 == "substring") {
            this.checkArgs(object2, n, 2);
            n2 -= this.code[n2];
            n2 += this.code[n2];
            String string = this.evalToString(xPathContext, n2);
            short s = this.code[++n2];
            int n6 = (int)this.evalToNumber(xPathContext, n2 += s);
            String string4 = string.substring(n6);
            XPath.result(xPathContext, string4, n3);
            return;
        }
        Object[] objectArray = new Object[n];
        n2 -= this.code[n2];
        int n7 = 0;
        while (n7 < n) {
            n2 += this.code[n2];
            objectArray[n7] = this.eval(xPathContext, n2);
            ++n2;
            ++n7;
        }
        this.call(xPathContext, object2, objectArray, n3);
    }

    public static boolean compare(Object object2, Object object3, int n) {
        if (n <= 129) {
            if (object2 instanceof Boolean || object3 instanceof Boolean) {
                boolean bl;
                boolean bl2 = XPath.booleanValue(object2);
                return bl2 == (bl = XPath.booleanValue(object3)) == (n == 128);
            }
            if (object2 instanceof Number || object3 instanceof Number) {
                double d;
                double d2 = XPath.numberValue(object2);
                return d2 == (d = XPath.numberValue(object3)) == (n == 128);
            }
            String string = XPath.stringValue(object2);
            String string2 = XPath.stringValue(object3);
            return string.equals(string2) == (n == 128);
        }
        double d = XPath.numberValue(object2);
        double d3 = XPath.numberValue(object3);
        switch (n) {
            case 132: {
                return d < d3;
            }
            case 134: {
                return d <= d3;
            }
            case 133: {
                return d > d3;
            }
            case 135: {
                return d >= d3;
            }
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public void eval(XPathContext var1_1, int var2_2, int var3_3) {
        var4_4 = this.code[var2_2];
        switch (var4_4) {
            case 120: 
            case 124: {
                var9_5 = this.code[--var2_2];
                var10_8 = (var2_2 -= 2) - var9_5;
                var11_11 = this.evalToBoolean(var1_1, var10_8);
                XPath.result(var1_1, var4_4 == 120 == var11_11 ? var11_11 : this.evalToBoolean(var1_1, var2_2), var3_3);
                break;
            }
            case 128: 
            case 129: 
            case 132: 
            case 133: 
            case 134: 
            case 135: {
                var9_6 = this.code[--var2_2];
                var10_9 = (var2_2 -= 2) - var9_6;
                var12_12 = this.eval(var1_1, var10_9);
                var13_13 = this.eval(var1_1, var2_2);
                XPath.result(var1_1, XPath.compare(var12_12, var13_13, var4_4), var3_3);
                break;
            }
            case 136: 
            case 137: 
            case 140: 
            case 141: 
            case 142: {
                var9_7 = this.code[--var2_2];
                var10_10 = (var2_2 -= 2) - var9_7;
                var5_14 = this.evalToNumber(var1_1, var10_10);
                var7_15 = this.evalToNumber(var1_1, var2_2);
                switch (var4_4) {
                    case 136: {
                        var5_14 += var7_15;
                        break;
                    }
                    case 137: {
                        var5_14 -= var7_15;
                        break;
                    }
                    case 140: {
                        var5_14 *= var7_15;
                        break;
                    }
                    case 141: {
                        var5_14 /= var7_15;
                        break;
                    }
                    case 142: {
                        var5_14 %= var7_15;
                    }
                }
                this.result(var1_1, var5_14, var3_3);
                break;
            }
            case 117: {
                XPath.result(var1_1, (String)this.values[this.code[var2_2 - 1]], var3_3);
                break;
            }
            case 113: {
                this.result(var1_1, this.code[var2_2 - 1], var3_3);
                break;
            }
            case 114: {
                var14_16 = 0L;
                --var2_2;
                var16_17 = 4;
                while (--var16_17 >= 0) {
                    var14_16 = var14_16 << 16 * var16_17 | (long)(this.code[var2_2 - var16_17] & 65535);
                }
                this.result(var1_1, Double.longBitsToDouble(var14_16), var3_3);
                break;
            }
            case 116: {
                var17_18 = this.values[this.code[var2_2 - 1]];
                var1_1.getVariableReference(var17_18, var3_3);
                break;
            }
            case 115: {
                var18_19 = this.values[this.code[--var2_2]];
                var19_20 = this.code[--var2_2];
                this.evalCall(var1_1, var18_19, var19_20, --var2_2, var3_3);
                break;
            }
            case 86: 
            case 87: 
            case 118: {
                if (var3_3 != 3 && var3_3 != 4) ** GOTO lbl94
                var20_21 = var1_1.consumeKind;
                var21_23 = var1_1.consumeCount;
                try {
                    var1_1.consumeKind = 2;
                    var1_1.consumeCount = 0;
                    if (var4_4 != 118) ** GOTO lbl79
                    var22_24 = this.code[var2_2 - 1];
                    var23_25 = 0;
                    while (var23_25 < var22_24) {
                        v0 = var24_26 = var23_25 + 1 == var22_24 ? var2_2 - 2 - var22_24 : this.code[var2_2 - var22_24 + var23_25] + var2_2 - 1;
                        if (this.evalToNodes(var1_1, var24_26, var1_1)) {
                            ++var23_25;
                            continue;
                        }
                        ** GOTO lbl81
                    }
                    ** GOTO lbl81
lbl79:
                    // 1 sources

                    this.evalToNodes(var1_1, var2_2, var1_1);
lbl81:
                    // 3 sources

                    var1_1.resultType = 3;
                    var1_1.boolResult = var1_1.consumeCount > 0;
                    var26_27 = null;
                    var1_1.consumeKind = var20_21;
                    var1_1.consumeCount = var21_23;
                    break;
                }
                catch (Throwable var25_29) {
                    var26_28 = null;
                    var1_1.consumeKind = var20_21;
                    var1_1.consumeCount = var21_23;
                    throw var25_29;
                }
lbl94:
                // 1 sources

                var20_22 = new TreePositionList();
                this.evalToNodes(var1_1, var2_2, var20_22);
                XPath.result(var1_1, var20_22, var3_3);
                break;
            }
            default: {
                throw new Error("unhandled opcode");
            }
        }
    }

    public boolean evalToNodes(XPathContext xPathContext, PositionConsumer positionConsumer) {
        xPathContext.stepPc = 0;
        xPathContext.predPc = 0;
        return this.evalToNodes(xPathContext, this.codeLen - 1, positionConsumer);
    }

    public boolean evalToNodes(XPathContext xPathContext, int n, PositionConsumer positionConsumer) {
        short s = this.code[n];
        int n2 = n--;
        switch (s) {
            case 86: {
                short s2 = this.code[n];
                return this.evalPath(xPathContext, this.code[n -= s2] + n2, n, positionConsumer);
            }
            case 118: {
                short s3 = this.code[n - 1];
                int[] nArray = new int[s3];
                return this.evalUnionStep(xPathContext, nArray, 0, n, positionConsumer);
            }
        }
        throw new Error("unimplemented");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean evalPath(XPathContext xPathContext, int n, int n2, PositionConsumer positionConsumer) {
        TreePosition treePosition = xPathContext.position;
        block17: while (n != n2) {
            short s = this.code[n];
            if (s >= 100 && s < 113) {
                xPathContext.stepPc = n;
            }
            xPathContext.predPc = n++;
            switch (s) {
                case 103: {
                    if (!treePosition.gotoChildrenStart()) return true;
                    try {
                        while (true) {
                            if (!treePosition.hasNext()) break;
                            if (!this.evalPath(xPathContext, n, n2, positionConsumer)) {
                                boolean bl = false;
                                Object var12_16 = null;
                                treePosition.gotoParent();
                                return bl;
                            }
                            treePosition.gotoNext();
                        }
                        Object var12_17 = null;
                        treePosition.gotoParent();
                        return true;
                    }
                    catch (Throwable throwable) {
                        Object var12_18 = null;
                        treePosition.gotoParent();
                        throw throwable;
                    }
                }
                case 105: {
                    if (!this.evalPath(xPathContext, n, n2, positionConsumer)) {
                        return false;
                    }
                    if (!treePosition.gotoChildrenStart()) return true;
                    try {
                        while (true) {
                            if (!treePosition.hasNext()) break;
                            if (!this.evalPath(xPathContext, n - 1, n2, positionConsumer)) {
                                boolean bl = false;
                                Object var14_22 = null;
                                treePosition.gotoParent();
                                return bl;
                            }
                            treePosition.gotoNext();
                        }
                        Object var14_23 = null;
                        treePosition.gotoParent();
                        return true;
                    }
                    catch (Throwable throwable) {
                        Object var14_24 = null;
                        treePosition.gotoParent();
                        throw throwable;
                    }
                }
                case 104: {
                    if (!treePosition.gotoChildrenStart()) return true;
                    try {
                        while (true) {
                            if (!treePosition.hasNext()) break;
                            if (!this.evalPath(xPathContext, n, n2, positionConsumer) || !this.evalPath(xPathContext, n - 1, n2, positionConsumer)) {
                                boolean bl = false;
                                Object var16_25 = null;
                                treePosition.gotoParent();
                                return bl;
                            }
                            treePosition.gotoNext();
                        }
                        Object var16_26 = null;
                        treePosition.gotoParent();
                        return true;
                    }
                    catch (Throwable throwable) {
                        Object var16_27 = null;
                        treePosition.gotoParent();
                        throw throwable;
                    }
                }
                case 95: {
                    Object object2 = this.values[this.code[n]];
                    if (!object2.equals(treePosition.getNextTypeName())) {
                        return true;
                    }
                    ++n;
                    continue block17;
                }
                case 112: {
                    if (this.code[n] == 91) {
                        return true;
                    }
                }
                case 90: 
                case 96: {
                    continue block17;
                }
                case 98: {
                    Object var18_21;
                    boolean bl;
                    int n3 = n - 1;
                    short s2 = this.code[n++];
                    if (xPathContext.predPc < n3) {
                        xPathContext.setCounter(s2, 0);
                    }
                    xPathContext.predPc = n3;
                    xPathContext.incrementCounter(s2);
                    short s3 = this.code[n++];
                    n += s3;
                    int n4 = xPathContext.currentPosition;
                    try {
                        xPathContext.currentPosition = xPathContext.counters[s2];
                        bl = this.evalToPredicate(xPathContext, n - 1);
                        var18_21 = null;
                        xPathContext.currentPosition = n4;
                    }
                    catch (Throwable throwable) {
                        var18_21 = null;
                        xPathContext.currentPosition = n4;
                        throw throwable;
                    }
                    if (!bl) return true;
                    continue block17;
                }
            }
            if (s < 0) continue;
            this.error("unknown upcode " + s);
        }
        return positionConsumer.consume(xPathContext.position);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean evalUnionStep(XPathContext xPathContext, int[] nArray, int n, int n2, PositionConsumer positionConsumer) {
        TreePosition treePosition = xPathContext.position;
        if (!treePosition.gotoChildrenStart()) return true;
        try {
            while (true) {
                if (!treePosition.hasNext()) {
                    break;
                }
                if (!this.evalUnionStepChild(xPathContext, nArray, n, n2, positionConsumer)) {
                    boolean bl = false;
                    Object var9_8 = null;
                    treePosition.gotoParent();
                    return bl;
                }
                treePosition.gotoNext();
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            treePosition.gotoParent();
            throw throwable;
        }
        Object var9_9 = null;
        treePosition.gotoParent();
        return true;
    }

    public boolean evalUnionStepChild(XPathContext xPathContext, int[] nArray, int n, int n2, PositionConsumer positionConsumer) {
        int n3;
        boolean bl = false;
        boolean bl2 = false;
        int n4 = xPathContext.stepPc;
        int n5 = xPathContext.predPc;
        int n6 = this.code[n2 - 1];
        int n7 = 0;
        while (n7 < n6) {
            n3 = n7 + 1 == n6 ? n2 - 2 - n6 : n2 + this.code[n2 - n6 + n7] - 1;
            short s = this.code[n3 - 1];
            if (n < s) {
                int n8;
                int n9 = this.code[n3 - 1 - s + n] + n3;
                int n10 = n3 - 1 - s;
                int n11 = n8 = n + 1 == s ? n10 : n3 + this.code[n3 - s + n];
                if (nArray[n7] == n) {
                    xPathContext.stepPc = n9;
                    xPathContext.predPc = n9;
                    if ((n9 = this.matchSingleStep(xPathContext, n9, n8)) > 0) {
                        int n12 = n7;
                        nArray[n12] = nArray[n12] + 1;
                        if (n9 == n10) {
                            bl = true;
                        } else {
                            bl2 = true;
                        }
                    }
                }
            }
            ++n7;
        }
        xPathContext.stepPc = n4;
        xPathContext.predPc = n5;
        if (bl && !positionConsumer.consume(xPathContext.getPosition())) {
            return false;
        }
        if (bl2 && !this.evalUnionStep(xPathContext, nArray, n + 1, n2, positionConsumer)) {
            return false;
        }
        n3 = 0;
        while (n3 < n6) {
            if (nArray[n3] > n) {
                nArray[n3] = n;
            }
            ++n3;
        }
        return true;
    }

    public final double evalToNumber(XPathContext xPathContext, int n) {
        this.eval(xPathContext, n, 5);
        return xPathContext.numResult;
    }

    public final boolean evalToBoolean(XPathContext xPathContext, int n) {
        this.eval(xPathContext, n, 3);
        return xPathContext.boolResult;
    }

    public final boolean evalToBoolean(XPathContext xPathContext) {
        this.evalToBoolean(xPathContext, this.codeLen - 1);
        return xPathContext.boolResult;
    }

    public final String evalToString(XPathContext xPathContext) {
        xPathContext.stepPc = 0;
        xPathContext.predPc = 0;
        return this.evalToString(xPathContext, this.codeLen - 1);
    }

    public final String evalToString(XPathContext xPathContext, int n) {
        String string;
        int n2 = xPathContext.consumeKind;
        Object object2 = xPathContext.consumeObject;
        try {
            xPathContext.consumeKind = 3;
            xPathContext.consumeObject = null;
            this.evalToNodes(xPathContext, n, xPathContext);
            xPathContext.resultType = 1;
            string = xPathContext.consumeObject.toString();
            Object var7_6 = null;
            xPathContext.consumeKind = n2;
            xPathContext.consumeObject = object2;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            xPathContext.consumeKind = n2;
            xPathContext.consumeObject = object2;
            throw throwable;
        }
        return string;
    }

    public boolean evalToPredicate(XPathContext xPathContext, int n) {
        this.eval(xPathContext, n, 4);
        return xPathContext.boolResult;
    }

    public final double evalToNumber(XPathContext xPathContext) {
        return this.evalToNumber(xPathContext, this.codeLen - 1);
    }

    private boolean matchPath(XPathContext xPathContext, int n, int n2) {
        if (n == 0) {
            return true;
        }
        short s = this.code[n2 - 1];
        int n3 = n2 + this.code[n2 - s + n - 2];
        int n4 = s == n ? n2 - s - 1 : n2 + this.code[n2 - s + n - 1];
        xPathContext.stepPc = n3;
        short s2 = this.code[n3];
        if (s2 != 105 && !this.matchStep(xPathContext, n3, n4)) {
            return false;
        }
        return xPathContext.position.gotoParent() && this.matchPath(xPathContext, n - 1, n2);
    }

    private boolean matchStep(XPathContext xPathContext, int n, int n2) {
        while (n < n2) {
            if ((n = this.matchSingleStep(xPathContext, n, n2)) >= 0) continue;
            return false;
        }
        return true;
    }

    int matchSingleStep(XPathContext xPathContext, int n, int n2) {
        int n3 = 3;
        block7: while (n != n2) {
            short s = this.code[n];
            ++n;
            if (s >= 100 && s < 113) {
                n3 = s - 100;
                continue;
            }
            switch (s) {
                case 95: {
                    Object object2 = this.values[this.code[n]];
                    if (!object2.equals(xPathContext.position.getNextTypeName())) {
                        return -1;
                    }
                    ++n;
                    continue block7;
                }
                case 90: 
                case 96: {
                    continue block7;
                }
                case 98: {
                    Object var12_12;
                    boolean bl;
                    int n4 = n - 1;
                    short s2 = this.code[n++];
                    if (xPathContext.predPc < n4) {
                        xPathContext.setCounter(s2, 0);
                    }
                    xPathContext.predPc = n4;
                    xPathContext.incrementCounter(s2);
                    short s3 = this.code[n++];
                    n += s3;
                    int n5 = xPathContext.currentPosition;
                    try {
                        xPathContext.currentPosition = xPathContext.counters[s2];
                        bl = this.evalToPredicate(xPathContext, n - 1);
                        var12_12 = null;
                        xPathContext.currentPosition = n5;
                    }
                    catch (Throwable throwable) {
                        var12_12 = null;
                        xPathContext.currentPosition = n5;
                        throw throwable;
                    }
                    if (bl) continue block7;
                    return -1;
                }
            }
        }
        return n;
    }

    public boolean match(XPathContext xPathContext, int n) {
        short s = this.code[n];
        switch (s) {
            case 118: {
                short s2 = this.code[n - 1];
                short s3 = 0;
                do {
                    if (++s3 != s2) continue;
                    return this.match(xPathContext, n - 2 - s2);
                } while (!this.match(xPathContext, this.code[n - s2 + s3] + n - 1));
                return true;
            }
            case 86: {
                int n2 = n--;
                short s4 = this.code[n];
                TreePosition treePosition = (TreePosition)xPathContext.position.clone();
                try {
                    boolean bl = this.matchPath(xPathContext, s4, n2);
                    Object var11_10 = null;
                    xPathContext.position = treePosition;
                    return bl;
                }
                catch (Throwable throwable) {
                    Object var11_11 = null;
                    xPathContext.position = treePosition;
                    throw throwable;
                }
            }
        }
        return false;
    }

    public boolean match(XPathContext xPathContext) {
        return this.match(xPathContext, this.codeLen - 1);
    }

    public static void main(String[] stringArray) throws Exception {
        Object object2;
        XPath xPath = new XPath();
        XPathParser xPathParser = new XPathParser(stringArray[0], xPath);
        xPathParser.parse();
        System.out.print("Parsed len: " + xPath.codeLen + " {");
        int n = 0;
        while (n < xPath.codeLen) {
            System.out.print(" " + xPath.code[n]);
            ++n;
        }
        System.out.println("}");
        TreeList treeList = new TreeList();
        XMLParser xMLParser = new XMLParser(new URL(stringArray[1]), new ParsedXMLToConsumer(treeList));
        xMLParser.parse();
        XPath xPath2 = null;
        if (stringArray.length > 2) {
            xPath2 = new XPath();
            object2 = new XPathParser(stringArray[2], xPath2);
            ((XPathParser)object2).parse();
            System.out.print("Matcher len: " + xPath2.codeLen + " {");
            int n2 = 0;
            while (n2 < xPath2.codeLen) {
                System.out.print(" " + xPath2.code[n2]);
                ++n2;
            }
            System.out.println("}");
        }
        object2 = new PrintWriter(System.out);
        XMLPrinter xMLPrinter = new XMLPrinter((PrintWriter)object2);
        TreePosition treePosition = new TreePosition((Object)treeList);
        XPathContext xPathContext = new XPathContext(treePosition);
        Object object3 = xPath.eval(xPathContext);
        if (object3 instanceof TreePositionList) {
            TreePositionList treePositionList = (TreePositionList)object3;
            int n3 = treePositionList.size();
            System.err.println("#matches:" + n3);
            int n4 = 0;
            while (n4 < n3) {
                treePositionList.get(n4, treePosition);
                int n5 = treePosition.ipos >> 1;
                int n6 = treeList.nextDataIndex(n5);
                System.err.println("#" + n4 + ": " + n5 + " .. " + n6);
                treeList.consumeRange(n5, n6, xMLPrinter);
                ((PrintWriter)object2).flush();
                if (stringArray.length > 2) {
                    System.out.println("matches: " + xPath2.match(xPathContext));
                }
                ++n4;
            }
        } else {
            System.err.println("result: " + object3);
        }
    }
}

