/*
 * Decompiled with CFR 0.152.
 */
package gnu.math;

import gnu.math.DFloNum;
import gnu.math.ExponentialFormat;
import gnu.math.IntNum;
import gnu.math.RatNum;
import gnu.math.RealNum;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;

public class FixedRealFormat
extends Format {
    private int i;
    private int d;
    public int width;
    public int scale;
    public char padChar;
    public boolean showPlus;
    public boolean internalPad;
    public char overflowChar;

    public int getMaximumFractionDigits() {
        return this.d;
    }

    public int getMinimumIntegerDigits() {
        return this.i;
    }

    public void setMaximumFractionDigits(int n) {
        this.d = n;
    }

    public void setMinimumIntegerDigits(int n) {
        this.i = n;
    }

    public void format(RatNum ratNum, boolean bl, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        int n;
        int n2;
        int n3;
        int n4;
        String string;
        int n5;
        int n6;
        int n7 = this.getMaximumFractionDigits();
        int n8 = stringBuffer.length();
        int n9 = 1;
        if (bl) {
            stringBuffer.append('-');
        } else if (this.showPlus) {
            stringBuffer.append('+');
        } else {
            n9 = 0;
        }
        if (n7 < 0) {
            int n10;
            double d = ratNum.doubleValue();
            n6 = (int)(Math.log(d) / ExponentialFormat.LOG10);
            n5 = n6 == Integer.MIN_VALUE ? 0 : 17 - n6;
            string = RealNum.toScaledInt(d, n5).toString();
            n4 = string.length();
            n3 = n4 - n5 + this.scale;
            n7 = this.width > 0 ? this.width - n9 - 1 - n3 : (n4 > 16 ? 16 : n4) - n3;
            if (n7 < 0) {
                n7 = 0;
            }
            stringBuffer.append(string);
            n2 = n8 + n9;
            int n11 = n2 + n3 + n7;
            n4 = stringBuffer.length();
            if (n11 >= n4) {
                n11 = n4;
                n10 = 48;
            } else {
                n10 = stringBuffer.charAt(n11);
            }
            boolean bl2 = n10 >= 53;
            char c = bl2 ? (char)'9' : '0';
            while (n11 > n2 + n3 && stringBuffer.charAt(n11 - 1) == c) {
                --n11;
            }
            n = n11 - n2;
            n7 = n - n3;
            if (bl2 && ExponentialFormat.addOne(stringBuffer, n2, n11)) {
                n7 = 0;
                n = ++n3;
            }
            if (n7 == 0 && (this.width <= 0 || n9 + n3 + 1 < this.width)) {
                n7 = 1;
                ++n;
                stringBuffer.insert(n2 + n3, '0');
            }
            stringBuffer.setLength(n2 + n);
        } else {
            string = RealNum.toScaledInt(ratNum, n7 + this.scale).toString();
            stringBuffer.append(string);
            n = string.length();
            n3 = n - n7;
        }
        int n12 = n3 + n7;
        int n13 = this.getMinimumIntegerDigits();
        n13 = n3 >= 0 && n3 > n13 ? 0 : (n13 -= n3);
        if (n3 + n13 <= 0 && (this.width <= 0 || this.width > n7 + 1 + n9)) {
            ++n13;
        }
        n6 = n9 + n + n13 + 1;
        n5 = this.width - n6;
        n4 = n13;
        while (--n4 >= 0) {
            stringBuffer.insert(n8 + n9, '0');
        }
        if (n5 >= 0) {
            n2 = n8;
            if (this.internalPad && n9 > 0) {
                ++n2;
            }
            while (--n5 >= 0) {
                stringBuffer.insert(n2, this.padChar);
            }
        } else if (this.overflowChar != '\u0000') {
            stringBuffer.setLength(n8);
            this.i = this.width;
            while (--this.i >= 0) {
                stringBuffer.append(this.overflowChar);
            }
            return;
        }
        n2 = stringBuffer.length();
        stringBuffer.insert(n2 - n7, '.');
    }

    public void format(RatNum ratNum, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        boolean bl = ratNum.isNegative();
        if (bl) {
            ratNum = (RatNum)ratNum.rneg();
        }
        this.format(ratNum, bl, stringBuffer, fieldPosition);
    }

    public void format(RealNum realNum, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        if (realNum instanceof RatNum) {
            this.format((RatNum)realNum, stringBuffer, fieldPosition);
        } else {
            this.format(realNum.doubleValue(), stringBuffer, fieldPosition);
        }
    }

    public StringBuffer format(long l, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        this.format(IntNum.make(l), stringBuffer, fieldPosition);
        return stringBuffer;
    }

    public StringBuffer format(double d, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        boolean bl;
        if (d < 0.0) {
            bl = true;
            d = -d;
        } else {
            bl = false;
        }
        this.format(DFloNum.toExact(d), bl, stringBuffer, fieldPosition);
        return stringBuffer;
    }

    public StringBuffer format(Object object2, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return this.format(((RealNum)object2).doubleValue(), stringBuffer, fieldPosition);
    }

    public Number parse(String string, ParsePosition parsePosition) {
        throw new Error("RealFixedFormat.parse - not implemented");
    }

    public Object parseObject(String string, ParsePosition parsePosition) {
        throw new Error("RealFixedFormat.parseObject - not implemented");
    }
}

