/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Image;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.ByteBuffer;
import com.lowagie.text.pdf.CMYKColor;
import com.lowagie.text.pdf.ColorDetails;
import com.lowagie.text.pdf.ExtendedColor;
import com.lowagie.text.pdf.FontDetails;
import com.lowagie.text.pdf.FontMapper;
import com.lowagie.text.pdf.GrayColor;
import com.lowagie.text.pdf.PageResources;
import com.lowagie.text.pdf.PatternColor;
import com.lowagie.text.pdf.PdfAction;
import com.lowagie.text.pdf.PdfAnnotation;
import com.lowagie.text.pdf.PdfAppearance;
import com.lowagie.text.pdf.PdfDestination;
import com.lowagie.text.pdf.PdfDocument;
import com.lowagie.text.pdf.PdfGState;
import com.lowagie.text.pdf.PdfGraphics2D;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfOutline;
import com.lowagie.text.pdf.PdfPatternPainter;
import com.lowagie.text.pdf.PdfPrinterGraphics2D;
import com.lowagie.text.pdf.PdfShading;
import com.lowagie.text.pdf.PdfShadingPattern;
import com.lowagie.text.pdf.PdfSpotColor;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfTextArray;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.ShadingColor;
import com.lowagie.text.pdf.SpotColor;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.print.PrinterJob;
import java.util.ArrayList;

public class PdfContentByte {
    public static final int ALIGN_CENTER = 1;
    public static final int ALIGN_LEFT = 0;
    public static final int ALIGN_RIGHT = 2;
    public static final int LINE_CAP_BUTT = 0;
    public static final int LINE_CAP_ROUND = 1;
    public static final int LINE_CAP_PROJECTING_SQUARE = 2;
    public static final int TEXT_RENDER_MODE_FILL = 0;
    public static final int TEXT_RENDER_MODE_STROKE = 1;
    public static final int TEXT_RENDER_MODE_FILL_STROKE = 2;
    public static final int TEXT_RENDER_MODE_INVISIBLE = 3;
    public static final int TEXT_RENDER_MODE_FILL_CLIP = 4;
    public static final int TEXT_RENDER_MODE_STROKE_CLIP = 5;
    public static final int TEXT_RENDER_MODE_FILL_STROKE_CLIP = 6;
    public static final int TEXT_RENDER_MODE_CLIP = 7;
    protected ByteBuffer content = new ByteBuffer();
    protected PdfWriter writer;
    protected PdfDocument pdf;
    protected GraphicState state = new GraphicState();
    protected ArrayList stateList = new ArrayList();
    protected int separator = 10;

    public PdfContentByte(PdfWriter pdfWriter) {
        if (pdfWriter != null) {
            this.writer = pdfWriter;
            this.pdf = this.writer.getPdfDocument();
        }
    }

    public String toString() {
        return this.content.toString();
    }

    public ByteBuffer getInternalBuffer() {
        return this.content;
    }

    public byte[] toPdf(PdfWriter pdfWriter) {
        return this.content.toByteArray();
    }

    public void add(PdfContentByte pdfContentByte) {
        if (pdfContentByte.writer != null && this.writer != pdfContentByte.writer) {
            throw new RuntimeException("Inconsistent writers. Are you mixing two documents?");
        }
        this.content.append(pdfContentByte.content);
    }

    public float getXTLM() {
        return this.state.xTLM;
    }

    public float getYTLM() {
        return this.state.yTLM;
    }

    public float getLeading() {
        return this.state.leading;
    }

    public void setFlatness(float f) {
        if (f >= 0.0f && f <= 100.0f) {
            this.content.append(f).append(" i").append_i(this.separator);
        }
    }

    public void setLineCap(int n) {
        if (n >= 0 && n <= 2) {
            this.content.append(n).append(" J").append_i(this.separator);
        }
    }

    public void setLineDash(float f) {
        this.content.append("[] ").append(f).append(" d").append_i(this.separator);
    }

    public void setLineDash(float f, float f2) {
        this.content.append("[").append(f).append("] ").append(f2).append(" d").append_i(this.separator);
    }

    public void setLineDash(float f, float f2, float f3) {
        this.content.append("[").append(f).append(' ').append(f2).append("] ").append(f3).append(" d").append_i(this.separator);
    }

    public final void setLineDash(float[] fArray, float f) {
        this.content.append("[");
        int n = 0;
        while (n < fArray.length) {
            this.content.append(fArray[n]);
            if (n < fArray.length - 1) {
                this.content.append(' ');
            }
            ++n;
        }
        this.content.append("] ").append(f).append(" d").append_i(this.separator);
    }

    public void setLineJoin(int n) {
        if (n >= 0 && n <= 2) {
            this.content.append(n).append(" j").append_i(this.separator);
        }
    }

    public void setLineWidth(float f) {
        this.content.append(f).append(" w").append_i(this.separator);
    }

    public void setMiterLimit(float f) {
        if (f > 1.0f) {
            this.content.append(f).append(" M").append_i(this.separator);
        }
    }

    public void clip() {
        this.content.append("W").append_i(this.separator);
    }

    public void eoClip() {
        this.content.append("W*").append_i(this.separator);
    }

    public void setGrayFill(float f) {
        this.content.append(f).append(" g").append_i(this.separator);
    }

    public void resetGrayFill() {
        this.content.append("0 g").append_i(this.separator);
    }

    public void setGrayStroke(float f) {
        this.content.append(f).append(" G").append_i(this.separator);
    }

    public void resetGrayStroke() {
        this.content.append("0 G").append_i(this.separator);
    }

    private void HelperRGB(float f, float f2, float f3) {
        PdfWriter.checkPDFXConformance(this.writer, 3, null);
        if (f < 0.0f) {
            f = 0.0f;
        } else if (f > 1.0f) {
            f = 1.0f;
        }
        if (f2 < 0.0f) {
            f2 = 0.0f;
        } else if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        if (f3 < 0.0f) {
            f3 = 0.0f;
        } else if (f3 > 1.0f) {
            f3 = 1.0f;
        }
        this.content.append(f).append(' ').append(f2).append(' ').append(f3);
    }

    public void setRGBColorFillF(float f, float f2, float f3) {
        this.HelperRGB(f, f2, f3);
        this.content.append(" rg").append_i(this.separator);
    }

    public void resetRGBColorFill() {
        this.content.append("0 g").append_i(this.separator);
    }

    public void setRGBColorStrokeF(float f, float f2, float f3) {
        this.HelperRGB(f, f2, f3);
        this.content.append(" RG").append_i(this.separator);
    }

    public void resetRGBColorStroke() {
        this.content.append("0 G").append_i(this.separator);
    }

    private void HelperCMYK(float f, float f2, float f3, float f4) {
        if (f < 0.0f) {
            f = 0.0f;
        } else if (f > 1.0f) {
            f = 1.0f;
        }
        if (f2 < 0.0f) {
            f2 = 0.0f;
        } else if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        if (f3 < 0.0f) {
            f3 = 0.0f;
        } else if (f3 > 1.0f) {
            f3 = 1.0f;
        }
        if (f4 < 0.0f) {
            f4 = 0.0f;
        } else if (f4 > 1.0f) {
            f4 = 1.0f;
        }
        this.content.append(f).append(' ').append(f2).append(' ').append(f3).append(' ').append(f4);
    }

    public void setCMYKColorFillF(float f, float f2, float f3, float f4) {
        this.HelperCMYK(f, f2, f3, f4);
        this.content.append(" k").append_i(this.separator);
    }

    public void resetCMYKColorFill() {
        this.content.append("0 0 0 1 k").append_i(this.separator);
    }

    public void setCMYKColorStrokeF(float f, float f2, float f3, float f4) {
        this.HelperCMYK(f, f2, f3, f4);
        this.content.append(" K").append_i(this.separator);
    }

    public void resetCMYKColorStroke() {
        this.content.append("0 0 0 1 K").append_i(this.separator);
    }

    public void moveTo(float f, float f2) {
        this.content.append(f).append(' ').append(f2).append(" m").append_i(this.separator);
    }

    public void lineTo(float f, float f2) {
        this.content.append(f).append(' ').append(f2).append(" l").append_i(this.separator);
    }

    public void curveTo(float f, float f2, float f3, float f4, float f5, float f6) {
        this.content.append(f).append(' ').append(f2).append(' ').append(f3).append(' ').append(f4).append(' ').append(f5).append(' ').append(f6).append(" c").append_i(this.separator);
    }

    public void curveTo(float f, float f2, float f3, float f4) {
        this.content.append(f).append(' ').append(f2).append(' ').append(f3).append(' ').append(f4).append(" v").append_i(this.separator);
    }

    public void curveFromTo(float f, float f2, float f3, float f4) {
        this.content.append(f).append(' ').append(f2).append(' ').append(f3).append(' ').append(f4).append(" y").append_i(this.separator);
    }

    public void circle(float f, float f2, float f3) {
        float f4 = 0.5523f;
        this.moveTo(f + f3, f2);
        this.curveTo(f + f3, f2 + f3 * f4, f + f3 * f4, f2 + f3, f, f2 + f3);
        this.curveTo(f - f3 * f4, f2 + f3, f - f3, f2 + f3 * f4, f - f3, f2);
        this.curveTo(f - f3, f2 - f3 * f4, f - f3 * f4, f2 - f3, f, f2 - f3);
        this.curveTo(f + f3 * f4, f2 - f3, f + f3, f2 - f3 * f4, f + f3, f2);
    }

    public void rectangle(float f, float f2, float f3, float f4) {
        this.content.append(f).append(' ').append(f2).append(' ').append(f3).append(' ').append(f4).append(" re").append_i(this.separator);
    }

    public void variableRectangle(Rectangle rectangle) {
        float f = 0.0f;
        float f2 = rectangle.left();
        float f3 = rectangle.bottom();
        if (rectangle.getBorderWidthBottom() > f) {
            this.moveTo(f2, f3);
            if (rectangle.getBorderColorBottom() == null) {
                this.resetRGBColorFill();
            } else {
                this.setColorFill(rectangle.getBorderColorBottom());
            }
            this.lineTo(f2 + rectangle.width(), f3);
            this.lineTo(f2 + rectangle.width() - rectangle.getBorderWidthRight(), f3 + rectangle.getBorderWidthBottom());
            this.lineTo(f2 + rectangle.getBorderWidthLeft(), f3 + rectangle.getBorderWidthBottom());
            this.lineTo(f2, f3);
            this.fill();
        }
        if (rectangle.getBorderWidthLeft() > f) {
            this.moveTo(f2, f3);
            if (rectangle.getBorderColorLeft() == null) {
                this.resetRGBColorFill();
            } else {
                this.setColorFill(rectangle.getBorderColorLeft());
            }
            this.lineTo(f2, f3 + rectangle.height());
            this.lineTo(f2 + rectangle.getBorderWidthLeft(), f3 + rectangle.height() - rectangle.getBorderWidthTop());
            this.lineTo(f2 + rectangle.getBorderWidthLeft(), f3 + rectangle.getBorderWidthBottom());
            this.lineTo(f2, f3);
            this.fill();
        }
        f2 += rectangle.width();
        f3 += rectangle.height();
        if (rectangle.getBorderWidthTop() > f) {
            this.moveTo(f2, f3);
            if (rectangle.getBorderColorTop() == null) {
                this.resetRGBColorFill();
            } else {
                this.setColorFill(rectangle.getBorderColorTop());
            }
            this.lineTo(f2 - rectangle.width(), f3);
            this.lineTo(f2 - rectangle.width() + rectangle.getBorderWidthLeft(), f3 - rectangle.getBorderWidthTop());
            this.lineTo(f2 - rectangle.getBorderWidthRight(), f3 - rectangle.getBorderWidthTop());
            this.lineTo(f2, f3);
            this.fill();
        }
        if (rectangle.getBorderWidthRight() > f) {
            this.moveTo(f2, f3);
            if (rectangle.getBorderColorRight() == null) {
                this.resetRGBColorFill();
            } else {
                this.setColorFill(rectangle.getBorderColorRight());
            }
            this.lineTo(f2, f3 - rectangle.height());
            this.lineTo(f2 - rectangle.getBorderWidthRight(), f3 - rectangle.height() + rectangle.getBorderWidthBottom());
            this.lineTo(f2 - rectangle.getBorderWidthRight(), f3 - rectangle.getBorderWidthTop());
            this.lineTo(f2, f3);
            this.fill();
        }
        this.resetRGBColorFill();
    }

    public void rectangle(Rectangle rectangle) {
        float f = rectangle.left();
        float f2 = rectangle.bottom();
        float f3 = rectangle.right();
        float f4 = rectangle.top();
        Color color = rectangle.backgroundColor();
        if (color != null) {
            this.setColorFill(color);
            this.rectangle(f, f2, f3 - f, f4 - f2);
            this.fill();
            this.resetRGBColorFill();
        } else if ((double)rectangle.grayFill() > 0.0) {
            this.setGrayFill(rectangle.grayFill());
            this.rectangle(f, f2, f3 - f, f4 - f2);
            this.fill();
            this.resetGrayFill();
        }
        if (!rectangle.hasBorders()) {
            return;
        }
        if (rectangle.isUseVariableBorders()) {
            this.variableRectangle(rectangle);
        } else {
            Color color2;
            if (rectangle.borderWidth() != -1.0f) {
                this.setLineWidth(rectangle.borderWidth());
            }
            if ((color2 = rectangle.borderColor()) != null) {
                this.setColorStroke(color2);
            }
            if (rectangle.hasBorder(15)) {
                this.rectangle(f, f2, f3 - f, f4 - f2);
            } else {
                if (rectangle.hasBorder(8)) {
                    this.moveTo(f3, f2);
                    this.lineTo(f3, f4);
                }
                if (rectangle.hasBorder(4)) {
                    this.moveTo(f, f2);
                    this.lineTo(f, f4);
                }
                if (rectangle.hasBorder(2)) {
                    this.moveTo(f, f2);
                    this.lineTo(f3, f2);
                }
                if (rectangle.hasBorder(1)) {
                    this.moveTo(f, f4);
                    this.lineTo(f3, f4);
                }
            }
            this.stroke();
            if (color2 != null) {
                this.resetRGBColorStroke();
            }
        }
    }

    public void closePath() {
        this.content.append("h").append_i(this.separator);
    }

    public void newPath() {
        this.content.append("n").append_i(this.separator);
    }

    public void stroke() {
        this.content.append("S").append_i(this.separator);
    }

    public void closePathStroke() {
        this.content.append("s").append_i(this.separator);
    }

    public void fill() {
        this.content.append("f").append_i(this.separator);
    }

    public void eoFill() {
        this.content.append("f*").append_i(this.separator);
    }

    public void fillStroke() {
        this.content.append("B").append_i(this.separator);
    }

    public void closePathFillStroke() {
        this.content.append("b").append_i(this.separator);
    }

    public void eoFillStroke() {
        this.content.append("B*").append_i(this.separator);
    }

    public void closePathEoFillStroke() {
        this.content.append("b*").append_i(this.separator);
    }

    public void addImage(Image image) throws DocumentException {
        if (!image.hasAbsolutePosition()) {
            throw new DocumentException("The image must have absolute positioning.");
        }
        float[] fArray = image.matrix();
        fArray[4] = image.absoluteX() - fArray[4];
        fArray[5] = image.absoluteY() - fArray[5];
        this.addImage(image, fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]);
    }

    public void addImage(Image image, float f, float f2, float f3, float f4, float f5, float f6) throws DocumentException {
        try {
            if (image.isImgTemplate()) {
                this.writer.addDirectImageSimple(image);
                PdfTemplate pdfTemplate = image.templateData();
                float f7 = pdfTemplate.getWidth();
                float f8 = pdfTemplate.getHeight();
                this.addTemplate(pdfTemplate, f / f7, f2 / f7, f3 / f8, f4 / f8, f5, f6);
            } else {
                PdfName pdfName;
                PageResources pageResources = this.getPageResources();
                Image image2 = image.getImageMask();
                if (image2 != null) {
                    pdfName = this.writer.addDirectImageSimple(image2);
                    pageResources.addXObject(pdfName, this.writer.getImageReference(pdfName));
                }
                pdfName = this.writer.addDirectImageSimple(image);
                pdfName = pageResources.addXObject(pdfName, this.writer.getImageReference(pdfName));
                this.content.append("q ");
                this.content.append(f).append(' ');
                this.content.append(f2).append(' ');
                this.content.append(f3).append(' ');
                this.content.append(f4).append(' ');
                this.content.append(f5).append(' ');
                this.content.append(f6).append(" cm ");
                this.content.append(pdfName.getBytes()).append(" Do Q").append_i(this.separator);
            }
        }
        catch (Exception exception) {
            throw new DocumentException(exception);
        }
    }

    public void reset() {
        this.content.reset();
        this.stateList.clear();
        this.state = new GraphicState();
    }

    public void beginText() {
        this.state.xTLM = 0.0f;
        this.state.yTLM = 0.0f;
        this.content.append("BT").append_i(this.separator);
    }

    public void endText() {
        this.content.append("ET").append_i(this.separator);
    }

    public void saveState() {
        this.content.append("q").append_i(this.separator);
        this.stateList.add(this.state);
    }

    public void restoreState() {
        this.content.append("Q").append_i(this.separator);
        int n = this.stateList.size() - 1;
        if (n < 0) {
            throw new RuntimeException("Unbalanced save/restore state operators.");
        }
        this.state = (GraphicState)this.stateList.get(n);
        this.stateList.remove(n);
    }

    public void setCharacterSpacing(float f) {
        this.content.append(f).append(" Tc").append_i(this.separator);
    }

    public void setWordSpacing(float f) {
        this.content.append(f).append(" Tw").append_i(this.separator);
    }

    public void setHorizontalScaling(float f) {
        this.content.append(f).append(" Tz").append_i(this.separator);
    }

    public void setLeading(float f) {
        this.state.leading = f;
        this.content.append(f).append(" TL").append_i(this.separator);
    }

    public void setFontAndSize(BaseFont baseFont, float f) {
        this.checkWriter();
        this.state.size = f;
        this.state.fontDetails = this.writer.addSimple(baseFont);
        PageResources pageResources = this.getPageResources();
        PdfName pdfName = this.state.fontDetails.getFontName();
        pdfName = pageResources.addFont(pdfName, this.state.fontDetails.getIndirectReference());
        this.content.append(pdfName.getBytes()).append(' ').append(f).append(" Tf").append_i(this.separator);
    }

    public void setTextRenderingMode(int n) {
        this.content.append(n).append(" Tr").append_i(this.separator);
    }

    public void setTextRise(float f) {
        this.content.append(f).append(" Ts").append_i(this.separator);
    }

    private void showText2(String string) {
        if (this.state.fontDetails == null) {
            throw new NullPointerException("Font and size must be set before writing any text");
        }
        byte[] byArray = this.state.fontDetails.convertToBytes(string);
        PdfContentByte.escapeString(byArray, this.content);
    }

    public void showText(String string) {
        this.showText2(string);
        this.content.append("Tj").append_i(this.separator);
    }

    public static PdfTextArray getKernArray(String string, BaseFont baseFont) {
        PdfTextArray pdfTextArray = new PdfTextArray();
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length() - 1;
        char[] cArray = string.toCharArray();
        if (n >= 0) {
            stringBuffer.append(cArray, 0, 1);
        }
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2 + 1];
            int n3 = baseFont.getKerning(cArray[n2], c);
            if (n3 == 0) {
                stringBuffer.append(c);
            } else {
                pdfTextArray.add(stringBuffer.toString());
                stringBuffer.setLength(0);
                stringBuffer.append(cArray, n2 + 1, 1);
                pdfTextArray.add(-n3);
            }
            ++n2;
        }
        pdfTextArray.add(stringBuffer.toString());
        return pdfTextArray;
    }

    public void showTextKerned(String string) {
        if (this.state.fontDetails == null) {
            throw new NullPointerException("Font and size must be set before writing any text");
        }
        BaseFont baseFont = this.state.fontDetails.getBaseFont();
        if (baseFont.hasKernPairs()) {
            this.showText(PdfContentByte.getKernArray(string, baseFont));
        } else {
            this.showText(string);
        }
    }

    public void newlineShowText(String string) {
        this.state.yTLM -= this.state.leading;
        this.showText2(string);
        this.content.append("'").append_i(this.separator);
    }

    public void newlineShowText(float f, float f2, String string) {
        this.state.yTLM -= this.state.leading;
        this.content.append(f).append(' ').append(f2);
        this.showText2(string);
        this.content.append("\"").append_i(this.separator);
    }

    public void setTextMatrix(float f, float f2, float f3, float f4, float f5, float f6) {
        this.state.xTLM = f5;
        this.state.yTLM = f6;
        this.content.append(f).append(' ').append(f2).append_i(32).append(f3).append_i(32).append(f4).append_i(32).append(f5).append_i(32).append(f6).append(" Tm").append_i(this.separator);
    }

    public void setTextMatrix(float f, float f2) {
        this.setTextMatrix(1.0f, 0.0f, 0.0f, 1.0f, f, f2);
    }

    public void moveText(float f, float f2) {
        this.state.xTLM += f;
        this.state.yTLM += f2;
        this.content.append(f).append(' ').append(f2).append(" Td").append_i(this.separator);
    }

    public void moveTextWithLeading(float f, float f2) {
        this.state.xTLM += f;
        this.state.yTLM += f2;
        this.state.leading = -f2;
        this.content.append(f).append(' ').append(f2).append(" TD").append_i(this.separator);
    }

    public void newlineText() {
        this.state.yTLM -= this.state.leading;
        this.content.append("T*").append_i(this.separator);
    }

    int size() {
        return this.content.size();
    }

    static byte[] escapeString(byte[] byArray) {
        ByteBuffer byteBuffer = new ByteBuffer();
        PdfContentByte.escapeString(byArray, byteBuffer);
        return byteBuffer.toByteArray();
    }

    static void escapeString(byte[] byArray, ByteBuffer byteBuffer) {
        byteBuffer.append_i(40);
        int n = 0;
        while (n < byArray.length) {
            byte by = byArray[n];
            switch (by) {
                case 13: {
                    byteBuffer.append("\\r");
                    break;
                }
                case 10: {
                    byteBuffer.append("\\n");
                    break;
                }
                case 9: {
                    byteBuffer.append("\\t");
                    break;
                }
                case 8: {
                    byteBuffer.append("\\b");
                    break;
                }
                case 12: {
                    byteBuffer.append("\\f");
                    break;
                }
                case 40: 
                case 41: 
                case 92: {
                    byteBuffer.append_i(92).append_i(by);
                    break;
                }
                default: {
                    byteBuffer.append_i(by);
                }
            }
            ++n;
        }
        byteBuffer.append(")");
    }

    public void addOutline(PdfOutline pdfOutline) {
    }

    public void addOutline(PdfOutline pdfOutline, String string) {
        this.checkWriter();
        this.pdf.addOutline(pdfOutline, string);
    }

    public PdfOutline getRootOutline() {
        this.checkWriter();
        return this.pdf.getRootOutline();
    }

    public void showTextAligned(int n, String string, float f, float f2, float f3) {
        if (this.state.fontDetails == null) {
            throw new NullPointerException("Font and size must be set before writing any text");
        }
        BaseFont baseFont = this.state.fontDetails.getBaseFont();
        if (f3 == 0.0f) {
            switch (n) {
                case 1: {
                    f -= baseFont.getWidthPoint(string, this.state.size) / 2.0f;
                    break;
                }
                case 2: {
                    f -= baseFont.getWidthPoint(string, this.state.size);
                }
            }
            this.setTextMatrix(f, f2);
            this.showText(string);
        } else {
            double d = (double)f3 * Math.PI / 180.0;
            float f4 = (float)Math.cos(d);
            float f5 = (float)Math.sin(d);
            switch (n) {
                case 1: {
                    float f6 = baseFont.getWidthPoint(string, this.state.size) / 2.0f;
                    f -= f6 * f4;
                    f2 -= f6 * f5;
                    break;
                }
                case 2: {
                    float f7 = baseFont.getWidthPoint(string, this.state.size);
                    f -= f7 * f4;
                    f2 -= f7 * f5;
                }
            }
            this.setTextMatrix(f4, f5, -f5, f4, f, f2);
            this.showText(string);
            this.setTextMatrix(0.0f, 0.0f);
        }
    }

    public void showTextAlignedKerned(int n, String string, float f, float f2, float f3) {
        if (this.state.fontDetails == null) {
            throw new NullPointerException("Font and size must be set before writing any text");
        }
        BaseFont baseFont = this.state.fontDetails.getBaseFont();
        if (f3 == 0.0f) {
            switch (n) {
                case 1: {
                    f -= baseFont.getWidthPointKerned(string, this.state.size) / 2.0f;
                    break;
                }
                case 2: {
                    f -= baseFont.getWidthPointKerned(string, this.state.size);
                }
            }
            this.setTextMatrix(f, f2);
            this.showTextKerned(string);
        } else {
            double d = (double)f3 * Math.PI / 180.0;
            float f4 = (float)Math.cos(d);
            float f5 = (float)Math.sin(d);
            switch (n) {
                case 1: {
                    float f6 = baseFont.getWidthPointKerned(string, this.state.size) / 2.0f;
                    f -= f6 * f4;
                    f2 -= f6 * f5;
                    break;
                }
                case 2: {
                    float f7 = baseFont.getWidthPointKerned(string, this.state.size);
                    f -= f7 * f4;
                    f2 -= f7 * f5;
                }
            }
            this.setTextMatrix(f4, f5, -f5, f4, f, f2);
            this.showTextKerned(string);
            this.setTextMatrix(0.0f, 0.0f);
        }
    }

    public void concatCTM(float f, float f2, float f3, float f4, float f5, float f6) {
        this.content.append(f).append(' ').append(f2).append(' ').append(f3).append(' ');
        this.content.append(f4).append(' ').append(f5).append(' ').append(f6).append(" cm").append_i(this.separator);
    }

    public static ArrayList bezierArc(float f, float f2, float f3, float f4, float f5, float f6) {
        int n;
        float f7;
        float f8;
        if (f > f3) {
            f8 = f;
            f = f3;
            f3 = f8;
        }
        if (f4 > f2) {
            f8 = f2;
            f2 = f4;
            f4 = f8;
        }
        if (Math.abs(f6) <= 90.0f) {
            f7 = f6;
            n = 1;
        } else {
            n = (int)Math.ceil(Math.abs(f6) / 90.0f);
            f7 = f6 / (float)n;
        }
        float f9 = (f + f3) / 2.0f;
        float f10 = (f2 + f4) / 2.0f;
        float f11 = (f3 - f) / 2.0f;
        float f12 = (f4 - f2) / 2.0f;
        float f13 = (float)((double)f7 * Math.PI / 360.0);
        float f14 = (float)Math.abs(1.3333333333333333 * (1.0 - Math.cos(f13)) / Math.sin(f13));
        ArrayList<float[]> arrayList = new ArrayList<float[]>();
        int n2 = 0;
        while (n2 < n) {
            float f15 = (float)((double)(f5 + (float)n2 * f7) * Math.PI / 180.0);
            float f16 = (float)((double)(f5 + (float)(n2 + 1) * f7) * Math.PI / 180.0);
            float f17 = (float)Math.cos(f15);
            float f18 = (float)Math.cos(f16);
            float f19 = (float)Math.sin(f15);
            float f20 = (float)Math.sin(f16);
            if (f7 > 0.0f) {
                arrayList.add(new float[]{f9 + f11 * f17, f10 - f12 * f19, f9 + f11 * (f17 - f14 * f19), f10 - f12 * (f19 + f14 * f17), f9 + f11 * (f18 + f14 * f20), f10 - f12 * (f20 - f14 * f18), f9 + f11 * f18, f10 - f12 * f20});
            } else {
                arrayList.add(new float[]{f9 + f11 * f17, f10 - f12 * f19, f9 + f11 * (f17 + f14 * f19), f10 - f12 * (f19 - f14 * f17), f9 + f11 * (f18 - f14 * f20), f10 - f12 * (f20 + f14 * f18), f9 + f11 * f18, f10 - f12 * f20});
            }
            ++n2;
        }
        return arrayList;
    }

    public void arc(float f, float f2, float f3, float f4, float f5, float f6) {
        ArrayList arrayList = PdfContentByte.bezierArc(f, f2, f3, f4, f5, f6);
        if (arrayList.size() == 0) {
            return;
        }
        float[] fArray = (float[])arrayList.get(0);
        this.moveTo(fArray[0], fArray[1]);
        int n = 0;
        while (n < arrayList.size()) {
            fArray = (float[])arrayList.get(n);
            this.curveTo(fArray[2], fArray[3], fArray[4], fArray[5], fArray[6], fArray[7]);
            ++n;
        }
    }

    public void ellipse(float f, float f2, float f3, float f4) {
        this.arc(f, f2, f3, f4, 0.0f, 360.0f);
    }

    public PdfPatternPainter createPattern(float f, float f2, float f3, float f4) {
        this.checkWriter();
        if (f3 == 0.0f || f4 == 0.0f) {
            throw new RuntimeException("XStep or YStep can not be ZERO.");
        }
        PdfPatternPainter pdfPatternPainter = new PdfPatternPainter(this.writer);
        pdfPatternPainter.setWidth(f);
        pdfPatternPainter.setHeight(f2);
        pdfPatternPainter.setXStep(f3);
        pdfPatternPainter.setYStep(f4);
        this.writer.addSimplePattern(pdfPatternPainter);
        return pdfPatternPainter;
    }

    public PdfPatternPainter createPattern(float f, float f2) {
        return this.createPattern(f, f2, f, f2);
    }

    public PdfPatternPainter createPattern(float f, float f2, float f3, float f4, Color color) {
        this.checkWriter();
        if (f3 == 0.0f || f4 == 0.0f) {
            throw new RuntimeException("XStep or YStep can not be ZERO.");
        }
        PdfPatternPainter pdfPatternPainter = new PdfPatternPainter(this.writer, color);
        pdfPatternPainter.setWidth(f);
        pdfPatternPainter.setHeight(f2);
        pdfPatternPainter.setXStep(f3);
        pdfPatternPainter.setYStep(f4);
        this.writer.addSimplePattern(pdfPatternPainter);
        return pdfPatternPainter;
    }

    public PdfPatternPainter createPattern(float f, float f2, Color color) {
        return this.createPattern(f, f2, f, f2, color);
    }

    public PdfTemplate createTemplate(float f, float f2) {
        return this.createTemplate(f, f2, null);
    }

    PdfTemplate createTemplate(float f, float f2, PdfName pdfName) {
        this.checkWriter();
        PdfTemplate pdfTemplate = new PdfTemplate(this.writer);
        pdfTemplate.setWidth(f);
        pdfTemplate.setHeight(f2);
        this.writer.addDirectTemplateSimple(pdfTemplate, pdfName);
        return pdfTemplate;
    }

    public PdfAppearance createAppearance(float f, float f2) {
        return this.createAppearance(f, f2, null);
    }

    PdfAppearance createAppearance(float f, float f2, PdfName pdfName) {
        this.checkWriter();
        PdfAppearance pdfAppearance = new PdfAppearance(this.writer);
        pdfAppearance.setWidth(f);
        pdfAppearance.setHeight(f2);
        this.writer.addDirectTemplateSimple(pdfAppearance, pdfName);
        return pdfAppearance;
    }

    public void addTemplate(PdfTemplate pdfTemplate, float f, float f2, float f3, float f4, float f5, float f6) {
        this.checkWriter();
        this.checkNoPattern(pdfTemplate);
        PdfName pdfName = this.writer.addDirectTemplateSimple(pdfTemplate, null);
        PageResources pageResources = this.getPageResources();
        pdfName = pageResources.addXObject(pdfName, pdfTemplate.getIndirectReference());
        this.content.append("q ");
        this.content.append(f).append(' ');
        this.content.append(f2).append(' ');
        this.content.append(f3).append(' ');
        this.content.append(f4).append(' ');
        this.content.append(f5).append(' ');
        this.content.append(f6).append(" cm ");
        this.content.append(pdfName.getBytes()).append(" Do Q").append_i(this.separator);
    }

    public void addTemplate(PdfTemplate pdfTemplate, float f, float f2) {
        this.addTemplate(pdfTemplate, 1.0f, 0.0f, 0.0f, 1.0f, f, f2);
    }

    public void setCMYKColorFill(int n, int n2, int n3, int n4) {
        this.content.append((float)(n & 0xFF) / 255.0f);
        this.content.append(' ');
        this.content.append((float)(n2 & 0xFF) / 255.0f);
        this.content.append(' ');
        this.content.append((float)(n3 & 0xFF) / 255.0f);
        this.content.append(' ');
        this.content.append((float)(n4 & 0xFF) / 255.0f);
        this.content.append(" k").append_i(this.separator);
    }

    public void setCMYKColorStroke(int n, int n2, int n3, int n4) {
        this.content.append((float)(n & 0xFF) / 255.0f);
        this.content.append(' ');
        this.content.append((float)(n2 & 0xFF) / 255.0f);
        this.content.append(' ');
        this.content.append((float)(n3 & 0xFF) / 255.0f);
        this.content.append(' ');
        this.content.append((float)(n4 & 0xFF) / 255.0f);
        this.content.append(" K").append_i(this.separator);
    }

    public void setRGBColorFill(int n, int n2, int n3) {
        this.HelperRGB((float)(n & 0xFF) / 255.0f, (float)(n2 & 0xFF) / 255.0f, (float)(n3 & 0xFF) / 255.0f);
        this.content.append(" rg").append_i(this.separator);
    }

    public void setRGBColorStroke(int n, int n2, int n3) {
        this.HelperRGB((float)(n & 0xFF) / 255.0f, (float)(n2 & 0xFF) / 255.0f, (float)(n3 & 0xFF) / 255.0f);
        this.content.append(" RG").append_i(this.separator);
    }

    public void setColorStroke(Color color) {
        PdfWriter.checkPDFXConformance(this.writer, 1, color);
        int n = ExtendedColor.getType(color);
        switch (n) {
            case 1: {
                this.setGrayStroke(((GrayColor)color).getGray());
                break;
            }
            case 2: {
                CMYKColor cMYKColor = (CMYKColor)color;
                this.setCMYKColorStrokeF(cMYKColor.getCyan(), cMYKColor.getMagenta(), cMYKColor.getYellow(), cMYKColor.getBlack());
                break;
            }
            case 3: {
                SpotColor spotColor = (SpotColor)color;
                this.setColorStroke(spotColor.getPdfSpotColor(), spotColor.getTint());
                break;
            }
            case 4: {
                PatternColor patternColor = (PatternColor)color;
                this.setPatternStroke(patternColor.getPainter());
                break;
            }
            case 5: {
                ShadingColor shadingColor = (ShadingColor)color;
                this.setShadingStroke(shadingColor.getPdfShadingPattern());
                break;
            }
            default: {
                this.setRGBColorStroke(color.getRed(), color.getGreen(), color.getBlue());
            }
        }
    }

    public void setColorFill(Color color) {
        PdfWriter.checkPDFXConformance(this.writer, 1, color);
        int n = ExtendedColor.getType(color);
        switch (n) {
            case 1: {
                this.setGrayFill(((GrayColor)color).getGray());
                break;
            }
            case 2: {
                CMYKColor cMYKColor = (CMYKColor)color;
                this.setCMYKColorFillF(cMYKColor.getCyan(), cMYKColor.getMagenta(), cMYKColor.getYellow(), cMYKColor.getBlack());
                break;
            }
            case 3: {
                SpotColor spotColor = (SpotColor)color;
                this.setColorFill(spotColor.getPdfSpotColor(), spotColor.getTint());
                break;
            }
            case 4: {
                PatternColor patternColor = (PatternColor)color;
                this.setPatternFill(patternColor.getPainter());
                break;
            }
            case 5: {
                ShadingColor shadingColor = (ShadingColor)color;
                this.setShadingFill(shadingColor.getPdfShadingPattern());
                break;
            }
            default: {
                this.setRGBColorFill(color.getRed(), color.getGreen(), color.getBlue());
            }
        }
    }

    public void setColorFill(PdfSpotColor pdfSpotColor, float f) {
        this.checkWriter();
        this.state.colorDetails = this.writer.addSimple(pdfSpotColor);
        PageResources pageResources = this.getPageResources();
        PdfName pdfName = this.state.colorDetails.getColorName();
        pdfName = pageResources.addColor(pdfName, this.state.colorDetails.getIndirectReference());
        this.content.append(pdfName.getBytes()).append(" cs ").append(f).append(" scn").append_i(this.separator);
    }

    public void setColorStroke(PdfSpotColor pdfSpotColor, float f) {
        this.checkWriter();
        this.state.colorDetails = this.writer.addSimple(pdfSpotColor);
        PageResources pageResources = this.getPageResources();
        PdfName pdfName = this.state.colorDetails.getColorName();
        pdfName = pageResources.addColor(pdfName, this.state.colorDetails.getIndirectReference());
        this.content.append(pdfName.getBytes()).append(" CS ").append(f).append(" SCN").append_i(this.separator);
    }

    public void setPatternFill(PdfPatternPainter pdfPatternPainter) {
        if (pdfPatternPainter.isStencil()) {
            this.setPatternFill(pdfPatternPainter, pdfPatternPainter.getDefaultColor());
            return;
        }
        this.checkWriter();
        PageResources pageResources = this.getPageResources();
        PdfName pdfName = this.writer.addSimplePattern(pdfPatternPainter);
        pdfName = pageResources.addPattern(pdfName, pdfPatternPainter.getIndirectReference());
        this.content.append(PdfName.PATTERN.getBytes()).append(" cs ").append(pdfName.getBytes()).append(" scn").append_i(this.separator);
    }

    void outputColorNumbers(Color color, float f) {
        PdfWriter.checkPDFXConformance(this.writer, 1, color);
        int n = ExtendedColor.getType(color);
        switch (n) {
            case 0: {
                this.content.append((float)color.getRed() / 255.0f);
                this.content.append(' ');
                this.content.append((float)color.getGreen() / 255.0f);
                this.content.append(' ');
                this.content.append((float)color.getBlue() / 255.0f);
                break;
            }
            case 1: {
                this.content.append(((GrayColor)color).getGray());
                break;
            }
            case 2: {
                CMYKColor cMYKColor = (CMYKColor)color;
                this.content.append(cMYKColor.getCyan()).append(' ').append(cMYKColor.getMagenta());
                this.content.append(' ').append(cMYKColor.getYellow()).append(' ').append(cMYKColor.getBlack());
                break;
            }
            case 3: {
                this.content.append(f);
                break;
            }
            default: {
                throw new RuntimeException("Invalid color type.");
            }
        }
    }

    public void setPatternFill(PdfPatternPainter pdfPatternPainter, Color color) {
        if (ExtendedColor.getType(color) == 3) {
            this.setPatternFill(pdfPatternPainter, color, ((SpotColor)color).getTint());
        } else {
            this.setPatternFill(pdfPatternPainter, color, 0.0f);
        }
    }

    public void setPatternFill(PdfPatternPainter pdfPatternPainter, Color color, float f) {
        this.checkWriter();
        if (!pdfPatternPainter.isStencil()) {
            throw new RuntimeException("An uncolored pattern was expected.");
        }
        PageResources pageResources = this.getPageResources();
        PdfName pdfName = this.writer.addSimplePattern(pdfPatternPainter);
        pdfName = pageResources.addPattern(pdfName, pdfPatternPainter.getIndirectReference());
        ColorDetails colorDetails = this.writer.addSimplePatternColorspace(color);
        PdfName pdfName2 = pageResources.addColor(colorDetails.getColorName(), colorDetails.getIndirectReference());
        this.content.append(pdfName2.getBytes()).append(" cs").append_i(this.separator);
        this.outputColorNumbers(color, f);
        this.content.append(' ').append(pdfName.getBytes()).append(" scn").append_i(this.separator);
    }

    public void setPatternStroke(PdfPatternPainter pdfPatternPainter, Color color) {
        if (ExtendedColor.getType(color) == 3) {
            this.setPatternStroke(pdfPatternPainter, color, ((SpotColor)color).getTint());
        } else {
            this.setPatternStroke(pdfPatternPainter, color, 0.0f);
        }
    }

    public void setPatternStroke(PdfPatternPainter pdfPatternPainter, Color color, float f) {
        this.checkWriter();
        if (!pdfPatternPainter.isStencil()) {
            throw new RuntimeException("An uncolored pattern was expected.");
        }
        PageResources pageResources = this.getPageResources();
        PdfName pdfName = this.writer.addSimplePattern(pdfPatternPainter);
        pdfName = pageResources.addPattern(pdfName, pdfPatternPainter.getIndirectReference());
        ColorDetails colorDetails = this.writer.addSimplePatternColorspace(color);
        PdfName pdfName2 = pageResources.addColor(colorDetails.getColorName(), colorDetails.getIndirectReference());
        this.content.append(pdfName2.getBytes()).append(" CS").append_i(this.separator);
        this.outputColorNumbers(color, f);
        this.content.append(' ').append(pdfName.getBytes()).append(" SCN").append_i(this.separator);
    }

    public void setPatternStroke(PdfPatternPainter pdfPatternPainter) {
        if (pdfPatternPainter.isStencil()) {
            this.setPatternStroke(pdfPatternPainter, pdfPatternPainter.getDefaultColor());
            return;
        }
        this.checkWriter();
        PageResources pageResources = this.getPageResources();
        PdfName pdfName = this.writer.addSimplePattern(pdfPatternPainter);
        pdfName = pageResources.addPattern(pdfName, pdfPatternPainter.getIndirectReference());
        this.content.append(PdfName.PATTERN.getBytes()).append(" CS ").append(pdfName.getBytes()).append(" SCN").append_i(this.separator);
    }

    public void paintShading(PdfShading pdfShading) {
        this.writer.addSimpleShading(pdfShading);
        PageResources pageResources = this.getPageResources();
        PdfName pdfName = pageResources.addShading(pdfShading.getShadingName(), pdfShading.getShadingReference());
        this.content.append(pdfName.getBytes()).append(" sh").append_i(this.separator);
        ColorDetails colorDetails = pdfShading.getColorDetails();
        if (colorDetails != null) {
            pageResources.addColor(colorDetails.getColorName(), colorDetails.getIndirectReference());
        }
    }

    public void paintShading(PdfShadingPattern pdfShadingPattern) {
        this.paintShading(pdfShadingPattern.getShading());
    }

    public void setShadingFill(PdfShadingPattern pdfShadingPattern) {
        this.writer.addSimpleShadingPattern(pdfShadingPattern);
        PageResources pageResources = this.getPageResources();
        PdfName pdfName = pageResources.addPattern(pdfShadingPattern.getPatternName(), pdfShadingPattern.getPatternReference());
        this.content.append(PdfName.PATTERN.getBytes()).append(" cs ").append(pdfName.getBytes()).append(" scn").append_i(this.separator);
        ColorDetails colorDetails = pdfShadingPattern.getColorDetails();
        if (colorDetails != null) {
            pageResources.addColor(colorDetails.getColorName(), colorDetails.getIndirectReference());
        }
    }

    public void setShadingStroke(PdfShadingPattern pdfShadingPattern) {
        this.writer.addSimpleShadingPattern(pdfShadingPattern);
        PageResources pageResources = this.getPageResources();
        PdfName pdfName = pageResources.addPattern(pdfShadingPattern.getPatternName(), pdfShadingPattern.getPatternReference());
        this.content.append(PdfName.PATTERN.getBytes()).append(" CS ").append(pdfName.getBytes()).append(" SCN").append_i(this.separator);
        ColorDetails colorDetails = pdfShadingPattern.getColorDetails();
        if (colorDetails != null) {
            pageResources.addColor(colorDetails.getColorName(), colorDetails.getIndirectReference());
        }
    }

    protected void checkWriter() {
        if (this.writer == null) {
            throw new NullPointerException("The writer in PdfContentByte is null.");
        }
    }

    public void showText(PdfTextArray pdfTextArray) {
        if (this.state.fontDetails == null) {
            throw new NullPointerException("Font and size must be set before writing any text");
        }
        this.content.append("[");
        ArrayList arrayList = pdfTextArray.getArrayList();
        boolean bl = false;
        int n = 0;
        while (n < arrayList.size()) {
            Object e = arrayList.get(n);
            if (e instanceof String) {
                this.showText2((String)e);
                bl = false;
            } else {
                if (bl) {
                    this.content.append(' ');
                } else {
                    bl = true;
                }
                this.content.append(((Float)e).floatValue());
            }
            ++n;
        }
        this.content.append("]TJ").append_i(this.separator);
    }

    public PdfWriter getPdfWriter() {
        return this.writer;
    }

    public PdfDocument getPdfDocument() {
        return this.pdf;
    }

    public void localGoto(String string, float f, float f2, float f3, float f4) {
        this.pdf.localGoto(string, f, f2, f3, f4);
    }

    public boolean localDestination(String string, PdfDestination pdfDestination) {
        return this.pdf.localDestination(string, pdfDestination);
    }

    public PdfContentByte getDuplicate() {
        return new PdfContentByte(this.writer);
    }

    public void remoteGoto(String string, String string2, float f, float f2, float f3, float f4) {
        this.pdf.remoteGoto(string, string2, f, f2, f3, f4);
    }

    public void remoteGoto(String string, int n, float f, float f2, float f3, float f4) {
        this.pdf.remoteGoto(string, n, f, f2, f3, f4);
    }

    public void roundRectangle(float f, float f2, float f3, float f4, float f5) {
        if (f3 < 0.0f) {
            f += f3;
            f3 = -f3;
        }
        if (f4 < 0.0f) {
            f2 += f4;
            f4 = -f4;
        }
        if (f5 < 0.0f) {
            f5 = -f5;
        }
        float f6 = 0.4477f;
        this.moveTo(f + f5, f2);
        this.lineTo(f + f3 - f5, f2);
        this.curveTo(f + f3 - f5 * f6, f2, f + f3, f2 + f5 * f6, f + f3, f2 + f5);
        this.lineTo(f + f3, f2 + f4 - f5);
        this.curveTo(f + f3, f2 + f4 - f5 * f6, f + f3 - f5 * f6, f2 + f4, f + f3 - f5, f2 + f4);
        this.lineTo(f + f5, f2 + f4);
        this.curveTo(f + f5 * f6, f2 + f4, f, f2 + f4 - f5 * f6, f, f2 + f4 - f5);
        this.lineTo(f, f2 + f5);
        this.curveTo(f, f2 + f5 * f6, f + f5 * f6, f2, f + f5, f2);
    }

    public void setAction(PdfAction pdfAction, float f, float f2, float f3, float f4) {
        this.pdf.setAction(pdfAction, f, f2, f3, f4);
    }

    public void setLiteral(String string) {
        this.content.append(string);
    }

    public void setLiteral(char c) {
        this.content.append(c);
    }

    public void setLiteral(float f) {
        this.content.append(f);
    }

    void checkNoPattern(PdfTemplate pdfTemplate) {
        if (pdfTemplate.getType() == 3) {
            throw new RuntimeException("Invalid use of a pattern. A template was expected.");
        }
    }

    public void drawRadioField(float f, float f2, float f3, float f4, boolean bl) {
        float f5;
        if (f > f3) {
            f5 = f;
            f = f3;
            f3 = f5;
        }
        if (f2 > f4) {
            f5 = f2;
            f2 = f4;
            f4 = f5;
        }
        this.setLineWidth(1.0f);
        this.setLineCap(1);
        this.setColorStroke(new Color(192, 192, 192));
        this.arc(f + 1.0f, f2 + 1.0f, f3 - 1.0f, f4 - 1.0f, 0.0f, 360.0f);
        this.stroke();
        this.setLineWidth(1.0f);
        this.setLineCap(1);
        this.setColorStroke(new Color(160, 160, 160));
        this.arc(f + 0.5f, f2 + 0.5f, f3 - 0.5f, f4 - 0.5f, 45.0f, 180.0f);
        this.stroke();
        this.setLineWidth(1.0f);
        this.setLineCap(1);
        this.setColorStroke(new Color(0, 0, 0));
        this.arc(f + 1.5f, f2 + 1.5f, f3 - 1.5f, f4 - 1.5f, 45.0f, 180.0f);
        this.stroke();
        if (bl) {
            this.setLineWidth(1.0f);
            this.setLineCap(1);
            this.setColorFill(new Color(0, 0, 0));
            this.arc(f + 4.0f, f2 + 4.0f, f3 - 4.0f, f4 - 4.0f, 0.0f, 360.0f);
            this.fill();
        }
    }

    public void drawTextField(float f, float f2, float f3, float f4) {
        float f5;
        if (f > f3) {
            f5 = f;
            f = f3;
            f3 = f5;
        }
        if (f2 > f4) {
            f5 = f2;
            f2 = f4;
            f4 = f5;
        }
        this.setColorStroke(new Color(192, 192, 192));
        this.setLineWidth(1.0f);
        this.setLineCap(0);
        this.rectangle(f, f2, f3 - f, f4 - f2);
        this.stroke();
        this.setLineWidth(1.0f);
        this.setLineCap(0);
        this.setColorFill(new Color(255, 255, 255));
        this.rectangle(f + 0.5f, f2 + 0.5f, f3 - f - 1.0f, f4 - f2 - 1.0f);
        this.fill();
        this.setColorStroke(new Color(192, 192, 192));
        this.setLineWidth(1.0f);
        this.setLineCap(0);
        this.moveTo(f + 1.0f, f2 + 1.5f);
        this.lineTo(f3 - 1.5f, f2 + 1.5f);
        this.lineTo(f3 - 1.5f, f4 - 1.0f);
        this.stroke();
        this.setColorStroke(new Color(160, 160, 160));
        this.setLineWidth(1.0f);
        this.setLineCap(0);
        this.moveTo(f + 1.0f, f2 + 1.0f);
        this.lineTo(f + 1.0f, f4 - 1.0f);
        this.lineTo(f3 - 1.0f, f4 - 1.0f);
        this.stroke();
        this.setColorStroke(new Color(0, 0, 0));
        this.setLineWidth(1.0f);
        this.setLineCap(0);
        this.moveTo(f + 2.0f, f2 + 2.0f);
        this.lineTo(f + 2.0f, f4 - 2.0f);
        this.lineTo(f3 - 2.0f, f4 - 2.0f);
        this.stroke();
    }

    public void drawButton(float f, float f2, float f3, float f4, String string, BaseFont baseFont, float f5) {
        float f6;
        if (f > f3) {
            f6 = f;
            f = f3;
            f3 = f6;
        }
        if (f2 > f4) {
            f6 = f2;
            f2 = f4;
            f4 = f6;
        }
        this.setColorStroke(new Color(0, 0, 0));
        this.setLineWidth(1.0f);
        this.setLineCap(0);
        this.rectangle(f, f2, f3 - f, f4 - f2);
        this.stroke();
        this.setLineWidth(1.0f);
        this.setLineCap(0);
        this.setColorFill(new Color(192, 192, 192));
        this.rectangle(f + 0.5f, f2 + 0.5f, f3 - f - 1.0f, f4 - f2 - 1.0f);
        this.fill();
        this.setColorStroke(new Color(255, 255, 255));
        this.setLineWidth(1.0f);
        this.setLineCap(0);
        this.moveTo(f + 1.0f, f2 + 1.0f);
        this.lineTo(f + 1.0f, f4 - 1.0f);
        this.lineTo(f3 - 1.0f, f4 - 1.0f);
        this.stroke();
        this.setColorStroke(new Color(160, 160, 160));
        this.setLineWidth(1.0f);
        this.setLineCap(0);
        this.moveTo(f + 1.0f, f2 + 1.0f);
        this.lineTo(f3 - 1.0f, f2 + 1.0f);
        this.lineTo(f3 - 1.0f, f4 - 1.0f);
        this.stroke();
        this.resetRGBColorFill();
        this.beginText();
        this.setFontAndSize(baseFont, f5);
        this.showTextAligned(1, string, f + (f3 - f) / 2.0f, f2 + (f4 - f2 - f5) / 2.0f, 0.0f);
        this.endText();
    }

    public Graphics2D createGraphicsShapes(float f, float f2) {
        return new PdfGraphics2D(this, f, f2, null, true, false, 0.0f);
    }

    public Graphics2D createPrinterGraphicsShapes(float f, float f2, PrinterJob printerJob) {
        return new PdfPrinterGraphics2D(this, f, f2, null, true, false, 0.0f, printerJob);
    }

    public Graphics2D createGraphics(float f, float f2) {
        return new PdfGraphics2D(this, f, f2, null, false, false, 0.0f);
    }

    public Graphics2D createPrinterGraphics(float f, float f2, PrinterJob printerJob) {
        return new PdfPrinterGraphics2D(this, f, f2, null, false, false, 0.0f, printerJob);
    }

    public Graphics2D createGraphics(float f, float f2, boolean bl, float f3) {
        return new PdfGraphics2D(this, f, f2, null, false, bl, f3);
    }

    public Graphics2D createPrinterGraphics(float f, float f2, boolean bl, float f3, PrinterJob printerJob) {
        return new PdfPrinterGraphics2D(this, f, f2, null, false, bl, f3, printerJob);
    }

    public Graphics2D createGraphicsShapes(float f, float f2, boolean bl, float f3) {
        return new PdfGraphics2D(this, f, f2, null, true, bl, f3);
    }

    public Graphics2D createPrinterGraphicsShapes(float f, float f2, boolean bl, float f3, PrinterJob printerJob) {
        return new PdfPrinterGraphics2D(this, f, f2, null, true, bl, f3, printerJob);
    }

    public Graphics2D createGraphics(float f, float f2, FontMapper fontMapper) {
        return new PdfGraphics2D(this, f, f2, fontMapper, false, false, 0.0f);
    }

    public Graphics2D createPrinterGraphics(float f, float f2, FontMapper fontMapper, PrinterJob printerJob) {
        return new PdfPrinterGraphics2D(this, f, f2, fontMapper, false, false, 0.0f, printerJob);
    }

    public Graphics2D createGraphics(float f, float f2, FontMapper fontMapper, boolean bl, float f3) {
        return new PdfGraphics2D(this, f, f2, fontMapper, false, bl, f3);
    }

    public Graphics2D createPrinterGraphics(float f, float f2, FontMapper fontMapper, boolean bl, float f3, PrinterJob printerJob) {
        return new PdfPrinterGraphics2D(this, f, f2, fontMapper, false, bl, f3, printerJob);
    }

    PageResources getPageResources() {
        return this.pdf.getPageResources();
    }

    public void setGState(PdfGState pdfGState) {
        PdfObject[] pdfObjectArray = this.writer.addSimpleExtGState(pdfGState);
        PageResources pageResources = this.getPageResources();
        PdfName pdfName = pageResources.addExtGState((PdfName)pdfObjectArray[0], (PdfIndirectReference)pdfObjectArray[1]);
        this.content.append(pdfName.getBytes()).append(" gs").append_i(this.separator);
    }

    public void transform(AffineTransform affineTransform) {
        double[] dArray = new double[6];
        affineTransform.getMatrix(dArray);
        this.content.append(dArray[0]).append(' ').append(dArray[1]).append(' ').append(dArray[2]).append(' ');
        this.content.append(dArray[3]).append(' ').append(dArray[4]).append(' ').append(dArray[5]).append(" cm").append_i(this.separator);
    }

    void addAnnotation(PdfAnnotation pdfAnnotation) {
        this.writer.addAnnotation(pdfAnnotation);
    }

    public void setDefaultColorspace(PdfName pdfName, PdfObject pdfObject) {
        PageResources pageResources = this.getPageResources();
        pageResources.addDefaultColor(pdfName, pdfObject);
    }

    static class GraphicState {
        FontDetails fontDetails;
        ColorDetails colorDetails;
        float size;
        protected float xTLM = 0.0f;
        protected float yTLM = 0.0f;
        protected float leading = 0.0f;

        GraphicState() {
        }
    }
}

