/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.Chunk;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.ElementListener;
import com.lowagie.text.MarkupAttributes;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Set;

public class Rectangle
implements Element,
MarkupAttributes {
    public static final int UNDEFINED = -1;
    public static final int TOP = 1;
    public static final int BOTTOM = 2;
    public static final int LEFT = 4;
    public static final int RIGHT = 8;
    public static final int NO_BORDER = 0;
    public static final int BOX = 15;
    protected float llx;
    protected float lly;
    protected float urx;
    protected float ury;
    protected int border = -1;
    protected float borderWidth = -1.0f;
    protected Color color = null;
    protected Color borderColorLeft = null;
    protected Color borderColorRight = null;
    protected Color borderColorTop = null;
    protected Color borderColorBottom = null;
    protected float borderWidthLeft = -1.0f;
    protected float borderWidthRight = -1.0f;
    protected float borderWidthTop = -1.0f;
    protected float borderWidthBottom = -1.0f;
    protected boolean useVariableBorders = false;
    protected Color background = null;
    protected float grayFill = 0.0f;
    protected int rotation = 0;
    protected Properties markupAttributes;

    public Rectangle(float f, float f2, float f3, float f4) {
        this.llx = f;
        this.lly = f2;
        this.urx = f3;
        this.ury = f4;
    }

    public Rectangle(float f, float f2) {
        this(0.0f, 0.0f, f, f2);
    }

    public Rectangle(Rectangle rectangle) {
        this(rectangle.llx, rectangle.lly, rectangle.urx, rectangle.ury);
        this.cloneNonPositionParameters(rectangle);
    }

    public void cloneNonPositionParameters(Rectangle rectangle) {
        this.rotation = rectangle.rotation;
        this.border = rectangle.border;
        this.borderWidth = rectangle.borderWidth;
        this.color = rectangle.color;
        this.background = rectangle.background;
        this.grayFill = rectangle.grayFill;
        this.borderColorLeft = rectangle.borderColorLeft;
        this.borderColorRight = rectangle.borderColorRight;
        this.borderColorTop = rectangle.borderColorTop;
        this.borderColorBottom = rectangle.borderColorBottom;
        this.borderWidthLeft = rectangle.borderWidthLeft;
        this.borderWidthRight = rectangle.borderWidthRight;
        this.borderWidthTop = rectangle.borderWidthTop;
        this.borderWidthBottom = rectangle.borderWidthBottom;
        this.useVariableBorders = rectangle.useVariableBorders;
    }

    public boolean process(ElementListener elementListener) {
        try {
            return elementListener.add(this);
        }
        catch (DocumentException documentException) {
            return false;
        }
    }

    public int type() {
        return 30;
    }

    public ArrayList getChunks() {
        return new ArrayList();
    }

    public void normalize() {
        float f;
        if (this.llx > this.urx) {
            f = this.llx;
            this.llx = this.urx;
            this.urx = f;
        }
        if (this.lly > this.ury) {
            f = this.lly;
            this.lly = this.ury;
            this.ury = f;
        }
    }

    public Rectangle rectangle(float f, float f2) {
        Rectangle rectangle = new Rectangle(this);
        if (this.top() > f) {
            rectangle.setTop(f);
            rectangle.setBorder(this.border - (this.border & 1));
        }
        if (this.bottom() < f2) {
            rectangle.setBottom(f2);
            rectangle.setBorder(this.border - (this.border & 2));
        }
        return rectangle;
    }

    public Rectangle rotate() {
        Rectangle rectangle = new Rectangle(this.lly, this.llx, this.ury, this.urx);
        rectangle.rotation = this.rotation + 90;
        rectangle.rotation %= 360;
        return rectangle;
    }

    public void setLeft(float f) {
        this.llx = f;
    }

    public void setRight(float f) {
        this.urx = f;
    }

    public void setTop(float f) {
        this.ury = f;
    }

    public void setBottom(float f) {
        this.lly = f;
    }

    public void setBorder(int n) {
        this.border = n;
    }

    public void enableBorderSide(int n) {
        if (this.border == -1) {
            this.border = 0;
        }
        this.border |= n;
    }

    public void disableBorderSide(int n) {
        if (this.border == -1) {
            this.border = 0;
        }
        this.border &= ~n;
    }

    public void setBorderWidth(float f) {
        this.borderWidth = f;
    }

    public void setBorderColor(Color color) {
        this.color = color;
    }

    public void setBorderColorRight(Color color) {
        this.borderColorRight = color;
    }

    public void setBorderColorLeft(Color color) {
        this.borderColorLeft = color;
    }

    public void setBorderColorTop(Color color) {
        this.borderColorTop = color;
    }

    public void setBorderColorBottom(Color color) {
        this.borderColorBottom = color;
    }

    public void setBackgroundColor(Color color) {
        this.background = color;
    }

    public void setGrayFill(float f) {
        if (f >= 0.0f && (double)f <= 1.0) {
            this.grayFill = f;
        }
    }

    public float left() {
        return this.llx;
    }

    public float right() {
        return this.urx;
    }

    public float top() {
        return this.ury;
    }

    public float bottom() {
        return this.lly;
    }

    public float left(float f) {
        return this.llx + f;
    }

    public float right(float f) {
        return this.urx - f;
    }

    public float top(float f) {
        return this.ury - f;
    }

    public float bottom(float f) {
        return this.lly + f;
    }

    public float width() {
        return this.urx - this.llx;
    }

    public float height() {
        return this.ury - this.lly;
    }

    public boolean hasBorders() {
        return this.border > 0 && (this.borderWidth > 0.0f || this.borderWidthLeft > 0.0f || this.borderWidthRight > 0.0f || this.borderWidthTop > 0.0f || this.borderWidthBottom > 0.0f);
    }

    public boolean hasBorder(int n) {
        return this.border != -1 && (this.border & n) == n;
    }

    public int border() {
        return this.border;
    }

    public float borderWidth() {
        return this.borderWidth;
    }

    public Color borderColor() {
        return this.color;
    }

    public Color backgroundColor() {
        return this.background;
    }

    public float grayFill() {
        return this.grayFill;
    }

    public int getRotation() {
        return this.rotation;
    }

    public void setMarkupAttribute(String string, String string2) {
        this.markupAttributes = this.markupAttributes == null ? new Properties() : this.markupAttributes;
        this.markupAttributes.put(string, string2);
    }

    public void setMarkupAttributes(Properties properties) {
        this.markupAttributes = properties;
    }

    public String getMarkupAttribute(String string) {
        return this.markupAttributes == null ? null : String.valueOf(this.markupAttributes.get(string));
    }

    public Set getMarkupAttributeNames() {
        return Chunk.getKeySet(this.markupAttributes);
    }

    public Properties getMarkupAttributes() {
        return this.markupAttributes;
    }

    public Color getBorderColorLeft() {
        return this.borderColorLeft;
    }

    public Color getBorderColorRight() {
        return this.borderColorRight;
    }

    public Color getBorderColorTop() {
        return this.borderColorTop;
    }

    public Color getBorderColorBottom() {
        return this.borderColorBottom;
    }

    public float getBorderWidthLeft() {
        return this.getVariableBorderWidth(this.borderWidthLeft, 4);
    }

    public void setBorderWidthLeft(float f) {
        this.borderWidthLeft = f;
        this.updateBorderBasedOnWidth(f, 4);
    }

    public float getBorderWidthRight() {
        return this.getVariableBorderWidth(this.borderWidthRight, 8);
    }

    public void setBorderWidthRight(float f) {
        this.borderWidthRight = f;
        this.updateBorderBasedOnWidth(f, 8);
    }

    public float getBorderWidthTop() {
        return this.getVariableBorderWidth(this.borderWidthTop, 1);
    }

    public void setBorderWidthTop(float f) {
        this.borderWidthTop = f;
        this.updateBorderBasedOnWidth(f, 1);
    }

    public float getBorderWidthBottom() {
        return this.getVariableBorderWidth(this.borderWidthBottom, 2);
    }

    public void setBorderWidthBottom(float f) {
        this.borderWidthBottom = f;
        this.updateBorderBasedOnWidth(f, 2);
    }

    private void updateBorderBasedOnWidth(float f, int n) {
        this.useVariableBorders = true;
        if (f > 0.0f) {
            this.enableBorderSide(n);
        } else {
            this.disableBorderSide(n);
        }
    }

    private float getVariableBorderWidth(float f, int n) {
        if ((this.border & n) != 0) {
            return f != -1.0f ? f : this.borderWidth;
        }
        return 0.0f;
    }

    public boolean isUseVariableBorders() {
        return this.useVariableBorders;
    }

    public void setUseVariableBorders(boolean bl) {
        this.useVariableBorders = bl;
    }
}

