/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Vector;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DocumentWriter;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SegmentMerger;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.RAMDirectory;

public class IndexWriter {
    public static final long WRITE_LOCK_TIMEOUT = 1000L;
    public static final long COMMIT_LOCK_TIMEOUT = 10000L;
    public static final String WRITE_LOCK_NAME = "write.lock";
    public static final String COMMIT_LOCK_NAME = "commit.lock";
    public static final int DEFAULT_MERGE_FACTOR = 10;
    public static final int DEFAULT_MAX_BUFFERED_DOCS = 10;
    public static final int DEFAULT_MIN_MERGE_DOCS = 10;
    public static final int DEFAULT_MAX_MERGE_DOCS = Integer.MAX_VALUE;
    public static final int DEFAULT_MAX_FIELD_LENGTH = 10000;
    public static final int DEFAULT_TERM_INDEX_INTERVAL = 128;
    private Directory directory;
    private Analyzer analyzer;
    private Similarity similarity = Similarity.getDefault();
    private SegmentInfos segmentInfos = new SegmentInfos();
    private final Directory ramDirectory = new RAMDirectory();
    private Lock writeLock;
    private int termIndexInterval = 128;
    private boolean useCompoundFile = true;
    private boolean closeDir;
    public int maxFieldLength = 10000;
    public int mergeFactor = 10;
    public int minMergeDocs = 10;
    public int maxMergeDocs = Integer.MAX_VALUE;
    public PrintStream infoStream = null;

    public boolean getUseCompoundFile() {
        return this.useCompoundFile;
    }

    public void setUseCompoundFile(boolean value) {
        this.useCompoundFile = value;
    }

    public void setSimilarity(Similarity similarity) {
        this.similarity = similarity;
    }

    public Similarity getSimilarity() {
        return this.similarity;
    }

    public void setTermIndexInterval(int interval) {
        this.termIndexInterval = interval;
    }

    public int getTermIndexInterval() {
        return this.termIndexInterval;
    }

    public IndexWriter(String path, Analyzer a, boolean create) throws IOException {
        this(FSDirectory.getDirectory(path, create), a, create, true);
    }

    public IndexWriter(File path, Analyzer a, boolean create) throws IOException {
        this(FSDirectory.getDirectory(path, create), a, create, true);
    }

    public IndexWriter(Directory d, Analyzer a, boolean create) throws IOException {
        this(d, a, create, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IndexWriter(Directory d, Analyzer a, final boolean create, boolean closeDir) throws IOException {
        this.closeDir = closeDir;
        this.directory = d;
        this.analyzer = a;
        Lock writeLock = this.directory.makeLock(WRITE_LOCK_NAME);
        if (!writeLock.obtain(1000L)) {
            throw new IOException("Index locked for write: " + writeLock);
        }
        this.writeLock = writeLock;
        Directory directory = this.directory;
        synchronized (directory) {
            new Lock.With(this.directory.makeLock(COMMIT_LOCK_NAME), 10000L){

                public Object doBody() throws IOException {
                    if (create) {
                        IndexWriter.this.segmentInfos.write(IndexWriter.this.directory);
                    } else {
                        IndexWriter.this.segmentInfos.read(IndexWriter.this.directory);
                    }
                    return null;
                }
            }.run();
        }
    }

    public void setMaxMergeDocs(int maxMergeDocs) {
        this.maxMergeDocs = maxMergeDocs;
    }

    public int getMaxMergeDocs() {
        return this.maxMergeDocs;
    }

    public void setMaxFieldLength(int maxFieldLength) {
        this.maxFieldLength = maxFieldLength;
    }

    public int getMaxFieldLength() {
        return this.maxFieldLength;
    }

    public void setMaxBufferedDocs(int maxBufferedDocs) {
        if (maxBufferedDocs < 2) {
            throw new IllegalArgumentException("maxBufferedDocs must at least be 2");
        }
        this.minMergeDocs = maxBufferedDocs;
    }

    public int getMaxBufferedDocs() {
        return this.minMergeDocs;
    }

    public void setMergeFactor(int mergeFactor) {
        if (mergeFactor < 2) {
            throw new IllegalArgumentException("mergeFactor cannot be less than 2");
        }
        this.mergeFactor = mergeFactor;
    }

    public int getMergeFactor() {
        return this.mergeFactor;
    }

    public void setInfoStream(PrintStream infoStream) {
        this.infoStream = infoStream;
    }

    public PrintStream getInfoStream() {
        return this.infoStream;
    }

    public synchronized void close() throws IOException {
        this.flushRamSegments();
        this.ramDirectory.close();
        if (this.writeLock != null) {
            this.writeLock.release();
            this.writeLock = null;
        }
        if (this.closeDir) {
            this.directory.close();
        }
    }

    protected void finalize() throws IOException {
        if (this.writeLock != null) {
            this.writeLock.release();
            this.writeLock = null;
        }
    }

    public Directory getDirectory() {
        return this.directory;
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    public synchronized int docCount() {
        int count = 0;
        int i = 0;
        while (i < this.segmentInfos.size()) {
            SegmentInfo si = this.segmentInfos.info(i);
            count += si.docCount;
            ++i;
        }
        return count;
    }

    public void addDocument(Document doc) throws IOException {
        this.addDocument(doc, this.analyzer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDocument(Document doc, Analyzer analyzer) throws IOException {
        DocumentWriter dw = new DocumentWriter(this.ramDirectory, analyzer, this);
        dw.setInfoStream(this.infoStream);
        String segmentName = this.newSegmentName();
        dw.addDocument(segmentName, doc);
        IndexWriter indexWriter = this;
        synchronized (indexWriter) {
            this.segmentInfos.addElement(new SegmentInfo(segmentName, 1, this.ramDirectory));
            this.maybeMergeSegments();
        }
    }

    final int getSegmentsCounter() {
        return this.segmentInfos.counter;
    }

    private final synchronized String newSegmentName() {
        return "_" + Integer.toString(this.segmentInfos.counter++, 36);
    }

    public synchronized void optimize() throws IOException {
        this.flushRamSegments();
        while (this.segmentInfos.size() > 1 || this.segmentInfos.size() == 1 && (SegmentReader.hasDeletions(this.segmentInfos.info(0)) || this.segmentInfos.info((int)0).dir != this.directory || this.useCompoundFile && (!SegmentReader.usesCompoundFile(this.segmentInfos.info(0)) || SegmentReader.hasSeparateNorms(this.segmentInfos.info(0))))) {
            int minSegment = this.segmentInfos.size() - this.mergeFactor;
            this.mergeSegments(minSegment < 0 ? 0 : minSegment);
        }
    }

    public synchronized void addIndexes(Directory[] dirs) throws IOException {
        this.optimize();
        int start = this.segmentInfos.size();
        int i = 0;
        while (i < dirs.length) {
            SegmentInfos sis = new SegmentInfos();
            sis.read(dirs[i]);
            int j = 0;
            while (j < sis.size()) {
                this.segmentInfos.addElement(sis.info(j));
                ++j;
            }
            ++i;
        }
        while (this.segmentInfos.size() > start + this.mergeFactor) {
            int base = start + 1;
            while (base < this.segmentInfos.size()) {
                int end = Math.min(this.segmentInfos.size(), base + this.mergeFactor);
                if (end - base > 1) {
                    this.mergeSegments(base, end);
                }
                ++base;
            }
        }
        this.optimize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addIndexes(IndexReader[] readers) throws IOException {
        this.optimize();
        final String mergedName = this.newSegmentName();
        SegmentMerger merger = new SegmentMerger(this, mergedName);
        final Vector<SegmentReader> segmentsToDelete = new Vector<SegmentReader>();
        SegmentReader sReader = null;
        if (this.segmentInfos.size() == 1) {
            sReader = SegmentReader.get(this.segmentInfos.info(0));
            merger.add(sReader);
            segmentsToDelete.addElement(sReader);
        }
        int i = 0;
        while (i < readers.length) {
            merger.add(readers[i]);
            ++i;
        }
        int docCount = merger.merge();
        this.segmentInfos.setSize(0);
        this.segmentInfos.addElement(new SegmentInfo(mergedName, docCount, this.directory));
        if (sReader != null) {
            sReader.close();
        }
        Directory directory = this.directory;
        synchronized (directory) {
            new Lock.With(this.directory.makeLock(COMMIT_LOCK_NAME), 10000L){

                public Object doBody() throws IOException {
                    IndexWriter.this.segmentInfos.write(IndexWriter.this.directory);
                    IndexWriter.this.deleteSegments(segmentsToDelete);
                    return null;
                }
            }.run();
        }
        if (this.useCompoundFile) {
            final Vector filesToDelete = merger.createCompoundFile(String.valueOf(mergedName) + ".tmp");
            Directory directory2 = this.directory;
            synchronized (directory2) {
                new Lock.With(this.directory.makeLock(COMMIT_LOCK_NAME), 10000L){

                    public Object doBody() throws IOException {
                        IndexWriter.this.directory.renameFile(String.valueOf(mergedName) + ".tmp", String.valueOf(mergedName) + ".cfs");
                        IndexWriter.this.deleteFiles(filesToDelete);
                        return null;
                    }
                }.run();
            }
        }
    }

    private final void flushRamSegments() throws IOException {
        int minSegment = this.segmentInfos.size() - 1;
        int docCount = 0;
        while (minSegment >= 0 && this.segmentInfos.info((int)minSegment).dir == this.ramDirectory) {
            docCount += this.segmentInfos.info((int)minSegment).docCount;
            --minSegment;
        }
        if (minSegment < 0 || docCount + this.segmentInfos.info((int)minSegment).docCount > this.mergeFactor || this.segmentInfos.info((int)(this.segmentInfos.size() - 1)).dir != this.ramDirectory) {
            ++minSegment;
        }
        if (minSegment >= this.segmentInfos.size()) {
            return;
        }
        this.mergeSegments(minSegment);
    }

    private final void maybeMergeSegments() throws IOException {
        long targetMergeDocs = this.minMergeDocs;
        while (targetMergeDocs <= (long)this.maxMergeDocs) {
            int minSegment = this.segmentInfos.size();
            int mergeDocs = 0;
            while (--minSegment >= 0) {
                SegmentInfo si = this.segmentInfos.info(minSegment);
                if ((long)si.docCount >= targetMergeDocs) break;
                mergeDocs += si.docCount;
            }
            if ((long)mergeDocs < targetMergeDocs) break;
            this.mergeSegments(minSegment + 1);
            targetMergeDocs *= (long)this.mergeFactor;
        }
    }

    private final void mergeSegments(int minSegment) throws IOException {
        this.mergeSegments(minSegment, this.segmentInfos.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void mergeSegments(int minSegment, int end) throws IOException {
        final String mergedName = this.newSegmentName();
        if (this.infoStream != null) {
            this.infoStream.print("merging segments");
        }
        SegmentMerger merger = new SegmentMerger(this, mergedName);
        final Vector<SegmentReader> segmentsToDelete = new Vector<SegmentReader>();
        int i = minSegment;
        while (i < end) {
            SegmentInfo si = this.segmentInfos.info(i);
            if (this.infoStream != null) {
                this.infoStream.print(" " + si.name + " (" + si.docCount + " docs)");
            }
            SegmentReader reader = SegmentReader.get(si);
            merger.add(reader);
            if (reader.directory() == this.directory || reader.directory() == this.ramDirectory) {
                segmentsToDelete.addElement(reader);
            }
            ++i;
        }
        int mergedDocCount = merger.merge();
        if (this.infoStream != null) {
            this.infoStream.println(" into " + mergedName + " (" + mergedDocCount + " docs)");
        }
        int i22 = end - 1;
        while (i22 >= minSegment) {
            this.segmentInfos.remove(i22);
            --i22;
        }
        this.segmentInfos.addElement(new SegmentInfo(mergedName, mergedDocCount, this.directory));
        merger.closeReaders();
        Directory i22 = this.directory;
        synchronized (i22) {
            new Lock.With(this.directory.makeLock(COMMIT_LOCK_NAME), 10000L){

                public Object doBody() throws IOException {
                    IndexWriter.this.segmentInfos.write(IndexWriter.this.directory);
                    IndexWriter.this.deleteSegments(segmentsToDelete);
                    return null;
                }
            }.run();
        }
        if (this.useCompoundFile) {
            final Vector filesToDelete = merger.createCompoundFile(String.valueOf(mergedName) + ".tmp");
            Directory directory = this.directory;
            synchronized (directory) {
                new Lock.With(this.directory.makeLock(COMMIT_LOCK_NAME), 10000L){

                    public Object doBody() throws IOException {
                        IndexWriter.this.directory.renameFile(String.valueOf(mergedName) + ".tmp", String.valueOf(mergedName) + ".cfs");
                        IndexWriter.this.deleteFiles(filesToDelete);
                        return null;
                    }
                }.run();
            }
        }
    }

    private final void deleteSegments(Vector segments) throws IOException {
        Vector deletable = new Vector();
        this.deleteFiles(this.readDeleteableFiles(), deletable);
        int i = 0;
        while (i < segments.size()) {
            SegmentReader reader = (SegmentReader)segments.elementAt(i);
            if (reader.directory() == this.directory) {
                this.deleteFiles(reader.files(), deletable);
            } else {
                this.deleteFiles(reader.files(), reader.directory());
            }
            ++i;
        }
        this.writeDeleteableFiles(deletable);
    }

    private final void deleteFiles(Vector files) throws IOException {
        Vector deletable = new Vector();
        this.deleteFiles(this.readDeleteableFiles(), deletable);
        this.deleteFiles(files, deletable);
        this.writeDeleteableFiles(deletable);
    }

    private final void deleteFiles(Vector files, Directory directory) throws IOException {
        int i = 0;
        while (i < files.size()) {
            directory.deleteFile((String)files.elementAt(i));
            ++i;
        }
    }

    private final void deleteFiles(Vector files, Vector deletable) throws IOException {
        int i = 0;
        while (i < files.size()) {
            block4: {
                String file = (String)files.elementAt(i);
                try {
                    this.directory.deleteFile(file);
                }
                catch (IOException e) {
                    if (!this.directory.fileExists(file)) break block4;
                    if (this.infoStream != null) {
                        this.infoStream.println(String.valueOf(e.toString()) + "; Will re-try later.");
                    }
                    deletable.addElement(file);
                }
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Vector readDeleteableFiles() throws IOException {
        Vector<String> result = new Vector<String>();
        if (!this.directory.fileExists("deletable")) {
            return result;
        }
        IndexInput input = this.directory.openInput("deletable");
        try {
            int i = input.readInt();
            while (i > 0) {
                result.addElement(input.readString());
                --i;
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            input.close();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        input.close();
        return result;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void writeDeleteableFiles(Vector files) throws IOException {
        IndexOutput output = this.directory.createOutput("deleteable.new");
        try {
            output.writeInt(files.size());
            int i = 0;
            while (i < files.size()) {
                output.writeString((String)files.elementAt(i));
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            output.close();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        output.close();
        this.directory.renameFile("deleteable.new", "deletable");
    }
}

