/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import org.apache.lucene.store.BufferedIndexInput;
import org.apache.lucene.store.RAMFile;

class RAMInputStream
extends BufferedIndexInput
implements Cloneable {
    private RAMFile file;
    private int pointer = 0;
    private long length;

    public RAMInputStream(RAMFile f) {
        this.file = f;
        this.length = this.file.length;
    }

    public void readInternal(byte[] dest, int destOffset, int len) {
        int remainder = len;
        int start = this.pointer;
        while (remainder != 0) {
            int bufferNumber = start / 1024;
            int bufferOffset = start % 1024;
            int bytesInBuffer = 1024 - bufferOffset;
            int bytesToCopy = bytesInBuffer >= remainder ? remainder : bytesInBuffer;
            byte[] buffer = (byte[])this.file.buffers.elementAt(bufferNumber);
            System.arraycopy(buffer, bufferOffset, dest, destOffset, bytesToCopy);
            destOffset += bytesToCopy;
            start += bytesToCopy;
            remainder -= bytesToCopy;
        }
        this.pointer += len;
    }

    public void close() {
    }

    public void seekInternal(long pos) {
        this.pointer = (int)pos;
    }

    public long length() {
        return this.length;
    }
}

