/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.Serializable;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.Parameter;

public class BooleanClause
implements Serializable {
    public Query query;
    public boolean required = false;
    public boolean prohibited = false;
    private Occur occur = Occur.SHOULD;

    public BooleanClause(Query q, boolean r, boolean p) {
        this.query = q;
        this.required = r;
        this.prohibited = p;
        this.occur = this.required ? (this.prohibited ? Occur.MUST_NOT : Occur.MUST) : (this.prohibited ? Occur.MUST_NOT : Occur.SHOULD);
    }

    public BooleanClause(Query query, Occur occur) {
        this.query = query;
        this.occur = occur;
        this.setFields(occur);
    }

    public Occur getOccur() {
        return this.occur;
    }

    public void setOccur(Occur occur) {
        this.occur = occur;
        this.setFields(occur);
    }

    public Query getQuery() {
        return this.query;
    }

    public void setQuery(Query query) {
        this.query = query;
    }

    public boolean isProhibited() {
        return this.prohibited;
    }

    public boolean isRequired() {
        return this.required;
    }

    private void setFields(Occur occur) {
        if (occur == Occur.MUST) {
            this.required = true;
            this.prohibited = false;
        } else if (occur == Occur.SHOULD) {
            this.required = false;
            this.prohibited = false;
        } else if (occur == Occur.MUST_NOT) {
            this.required = false;
            this.prohibited = true;
        } else {
            throw new IllegalArgumentException("Unknown operator " + occur);
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof BooleanClause)) {
            return false;
        }
        BooleanClause other = (BooleanClause)o;
        return this.query.equals(other.query) && this.required == other.required && this.prohibited == other.prohibited;
    }

    public int hashCode() {
        return this.query.hashCode() ^ (this.required ? 1 : 0) ^ (this.prohibited ? 2 : 0);
    }

    public String toString() {
        return String.valueOf(this.occur.toString()) + this.query.toString();
    }

    public static final class Occur
    extends Parameter
    implements Serializable {
        public static final Occur MUST = new Occur("MUST");
        public static final Occur SHOULD = new Occur("SHOULD");
        public static final Occur MUST_NOT = new Occur("MUST_NOT");

        private Occur(String name) {
            super(name);
        }

        public String toString() {
            if (this == MUST) {
                return "+";
            }
            if (this == MUST_NOT) {
                return "-";
            }
            return "";
        }
    }
}

