/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultipleTermPositions;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ExactPhraseScorer;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.SloppyPhraseScorer;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.ToStringUtils;

public class MultiPhraseQuery
extends Query {
    private String field;
    private ArrayList termArrays = new ArrayList();
    private Vector positions = new Vector();
    private int slop = 0;

    public void setSlop(int s) {
        this.slop = s;
    }

    public int getSlop() {
        return this.slop;
    }

    public void add(Term term) {
        this.add(new Term[]{term});
    }

    public void add(Term[] terms) {
        int position = 0;
        if (this.positions.size() > 0) {
            position = (Integer)this.positions.lastElement() + 1;
        }
        this.add(terms, position);
    }

    public void add(Term[] terms, int position) {
        if (this.termArrays.size() == 0) {
            this.field = terms[0].field();
        }
        int i = 0;
        while (i < terms.length) {
            if (terms[i].field() != this.field) {
                throw new IllegalArgumentException("All phrase terms must be in the same field (" + this.field + "): " + terms[i]);
            }
            ++i;
        }
        this.termArrays.add(terms);
        this.positions.addElement(new Integer(position));
    }

    public int[] getPositions() {
        int[] result = new int[this.positions.size()];
        int i = 0;
        while (i < this.positions.size()) {
            result[i] = (Integer)this.positions.elementAt(i);
            ++i;
        }
        return result;
    }

    public Query rewrite(IndexReader reader) {
        if (this.termArrays.size() == 1) {
            Term[] terms = (Term[])this.termArrays.get(0);
            BooleanQuery boq = new BooleanQuery(true);
            int i = 0;
            while (i < terms.length) {
                boq.add(new TermQuery(terms[i]), BooleanClause.Occur.SHOULD);
                ++i;
            }
            boq.setBoost(this.getBoost());
            return boq;
        }
        return this;
    }

    protected Weight createWeight(Searcher searcher) throws IOException {
        return new MultiPhraseWeight(searcher);
    }

    public final String toString(String f) {
        StringBuffer buffer = new StringBuffer();
        if (!this.field.equals(f)) {
            buffer.append(this.field);
            buffer.append(":");
        }
        buffer.append("\"");
        Iterator i = this.termArrays.iterator();
        while (i.hasNext()) {
            Term[] terms = (Term[])i.next();
            if (terms.length > 1) {
                buffer.append("(");
                int j = 0;
                while (j < terms.length) {
                    buffer.append(terms[j].text());
                    if (j < terms.length - 1) {
                        buffer.append(" ");
                    }
                    ++j;
                }
                buffer.append(")");
            } else {
                buffer.append(terms[0].text());
            }
            if (!i.hasNext()) continue;
            buffer.append(" ");
        }
        buffer.append("\"");
        if (this.slop != 0) {
            buffer.append("~");
            buffer.append(this.slop);
        }
        buffer.append(ToStringUtils.boost(this.getBoost()));
        return buffer.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof MultiPhraseQuery)) {
            return false;
        }
        MultiPhraseQuery other = (MultiPhraseQuery)o;
        return this.getBoost() == other.getBoost() && this.slop == other.slop && this.termArrays.equals(other.termArrays) && this.positions.equals(other.positions);
    }

    public int hashCode() {
        return Float.floatToIntBits(this.getBoost()) ^ this.slop ^ this.termArrays.hashCode() ^ this.positions.hashCode() ^ 0x4AC65113;
    }

    private class MultiPhraseWeight
    implements Weight {
        private Similarity similarity;
        private float value;
        private float idf;
        private float queryNorm;
        private float queryWeight;

        public MultiPhraseWeight(Searcher searcher) throws IOException {
            this.similarity = MultiPhraseQuery.this.getSimilarity(searcher);
            Iterator i = MultiPhraseQuery.this.termArrays.iterator();
            while (i.hasNext()) {
                Term[] terms = (Term[])i.next();
                int j = 0;
                while (j < terms.length) {
                    this.idf += MultiPhraseQuery.this.getSimilarity(searcher).idf(terms[j], searcher);
                    ++j;
                }
            }
        }

        public Query getQuery() {
            return MultiPhraseQuery.this;
        }

        public float getValue() {
            return this.value;
        }

        public float sumOfSquaredWeights() {
            this.queryWeight = this.idf * MultiPhraseQuery.this.getBoost();
            return this.queryWeight * this.queryWeight;
        }

        public void normalize(float queryNorm) {
            this.queryNorm = queryNorm;
            this.queryWeight *= queryNorm;
            this.value = this.queryWeight * this.idf;
        }

        public Scorer scorer(IndexReader reader) throws IOException {
            if (MultiPhraseQuery.this.termArrays.size() == 0) {
                return null;
            }
            TermPositions[] tps = new TermPositions[MultiPhraseQuery.this.termArrays.size()];
            int i = 0;
            while (i < tps.length) {
                Term[] terms = (Term[])MultiPhraseQuery.this.termArrays.get(i);
                TermPositions p = terms.length > 1 ? new MultipleTermPositions(reader, terms) : reader.termPositions(terms[0]);
                if (p == null) {
                    return null;
                }
                tps[i] = p;
                ++i;
            }
            if (MultiPhraseQuery.this.slop == 0) {
                return new ExactPhraseScorer(this, tps, MultiPhraseQuery.this.getPositions(), this.similarity, reader.norms(MultiPhraseQuery.this.field));
            }
            return new SloppyPhraseScorer(this, tps, MultiPhraseQuery.this.getPositions(), this.similarity, MultiPhraseQuery.this.slop, reader.norms(MultiPhraseQuery.this.field));
        }

        public Explanation explain(IndexReader reader, int doc) throws IOException {
            Explanation result = new Explanation();
            result.setDescription("weight(" + this.getQuery() + " in " + doc + "), product of:");
            Explanation idfExpl = new Explanation(this.idf, "idf(" + this.getQuery() + ")");
            Explanation queryExpl = new Explanation();
            queryExpl.setDescription("queryWeight(" + this.getQuery() + "), product of:");
            Explanation boostExpl = new Explanation(MultiPhraseQuery.this.getBoost(), "boost");
            if (MultiPhraseQuery.this.getBoost() != 1.0f) {
                queryExpl.addDetail(boostExpl);
            }
            queryExpl.addDetail(idfExpl);
            Explanation queryNormExpl = new Explanation(this.queryNorm, "queryNorm");
            queryExpl.addDetail(queryNormExpl);
            queryExpl.setValue(boostExpl.getValue() * idfExpl.getValue() * queryNormExpl.getValue());
            result.addDetail(queryExpl);
            Explanation fieldExpl = new Explanation();
            fieldExpl.setDescription("fieldWeight(" + this.getQuery() + " in " + doc + "), product of:");
            Explanation tfExpl = this.scorer(reader).explain(doc);
            fieldExpl.addDetail(tfExpl);
            fieldExpl.addDetail(idfExpl);
            Explanation fieldNormExpl = new Explanation();
            byte[] fieldNorms = reader.norms(MultiPhraseQuery.this.field);
            float fieldNorm = fieldNorms != null ? Similarity.decodeNorm(fieldNorms[doc]) : 0.0f;
            fieldNormExpl.setValue(fieldNorm);
            fieldNormExpl.setDescription("fieldNorm(field=" + MultiPhraseQuery.this.field + ", doc=" + doc + ")");
            fieldExpl.addDetail(fieldNormExpl);
            fieldExpl.setValue(tfExpl.getValue() * idfExpl.getValue() * fieldNormExpl.getValue());
            result.addDetail(fieldExpl);
            result.setValue(queryExpl.getValue() * fieldExpl.getValue());
            if (queryExpl.getValue() == 1.0f) {
                return fieldExpl;
            }
            return result;
        }
    }
}

