/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.html.simpleparser;

import com.lowagie.text.Chunk;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.Paragraph;
import com.lowagie.text.html.simpleparser.ChainedProperties;
import java.awt.Color;
import java.util.HashMap;
import java.util.StringTokenizer;

public class FactoryProperties {
    public static HashMap colorTable = new HashMap();
    public static HashMap followTags = new HashMap();

    static {
        followTags.put("i", "i");
        followTags.put("b", "b");
        followTags.put("u", "u");
        followTags.put("sub", "sub");
        followTags.put("sup", "sup");
        followTags.put("em", "i");
        followTags.put("strong", "b");
        colorTable.put("black", new Color(0));
        colorTable.put("green", new Color(32768));
        colorTable.put("silver", new Color(0xC0C0C0));
        colorTable.put("lime", new Color(65280));
        colorTable.put("gray", new Color(0x808080));
        colorTable.put("olive", new Color(0x808000));
        colorTable.put("white", new Color(0xFFFFFF));
        colorTable.put("yellow", new Color(0xFFFF00));
        colorTable.put("maroon", new Color(0x800000));
        colorTable.put("navy", new Color(128));
        colorTable.put("red", new Color(0xFF0000));
        colorTable.put("blue", new Color(255));
        colorTable.put("purple", new Color(0x800080));
        colorTable.put("teal", new Color(32896));
        colorTable.put("fuchsia", new Color(0xFF00FF));
        colorTable.put("aqua", new Color(65535));
    }

    public static Chunk createChunk(String string, ChainedProperties chainedProperties) {
        Chunk chunk = new Chunk(string, FactoryProperties.getFont(chainedProperties));
        if (chainedProperties.hasProperty("sub")) {
            chunk.setTextRise(-6.0f);
        } else if (chainedProperties.hasProperty("sup")) {
            chunk.setTextRise(6.0f);
        }
        return chunk;
    }

    public static Paragraph createParagraph(HashMap hashMap) {
        Paragraph paragraph = new Paragraph();
        String string = (String)hashMap.get("align");
        if (string != null) {
            if (string.equalsIgnoreCase("center")) {
                paragraph.setAlignment(1);
            } else if (string.equalsIgnoreCase("right")) {
                paragraph.setAlignment(2);
            } else if (string.equalsIgnoreCase("justify")) {
                paragraph.setAlignment(3);
            }
        }
        paragraph.setLeading(0.0f, 1.5f);
        return paragraph;
    }

    public static Paragraph createParagraph(ChainedProperties chainedProperties) {
        Paragraph paragraph = new Paragraph();
        String string = chainedProperties.getProperty("align");
        if (string != null) {
            if (string.equalsIgnoreCase("center")) {
                paragraph.setAlignment(1);
            } else if (string.equalsIgnoreCase("right")) {
                paragraph.setAlignment(2);
            } else if (string.equalsIgnoreCase("justify")) {
                paragraph.setAlignment(3);
            }
        }
        paragraph.setLeading(0.0f, 1.5f);
        return paragraph;
    }

    public static Font getFont(ChainedProperties chainedProperties) {
        String string = chainedProperties.getProperty("face");
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken().trim();
                if (FontFactory.isRegistered(string)) break;
            }
        }
        int n = 0;
        if (chainedProperties.hasProperty("i")) {
            n |= 2;
        }
        if (chainedProperties.hasProperty("b")) {
            n |= 1;
        }
        if (chainedProperties.hasProperty("u")) {
            n |= 4;
        }
        String string2 = chainedProperties.getProperty("size");
        float f = 12.0f;
        if (string2 != null) {
            f = Float.valueOf(string2).floatValue();
        }
        Color color = FactoryProperties.decodeColor(chainedProperties.getProperty("color"));
        return FontFactory.getFont(string, "Cp1252", true, f, n, color);
    }

    public static Color decodeColor(String string) {
        if (string == null) {
            return null;
        }
        Color color = (Color)colorTable.get(string = string.toLowerCase().trim());
        if (color != null) {
            return color;
        }
        try {
            if (string.startsWith("#")) {
                return new Color(Integer.parseInt(string.substring(1), 16));
            }
        }
        catch (Exception exception) {}
        return null;
    }
}

