/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.index.TermPositions;

final class SegmentMergeInfo {
    Term term;
    int base;
    TermEnum termEnum;
    IndexReader reader;
    private TermPositions postings;
    private int[] docMap;

    SegmentMergeInfo(int b, TermEnum te, IndexReader r) throws IOException {
        this.base = b;
        this.reader = r;
        this.termEnum = te;
        this.term = te.term();
    }

    int[] getDocMap() {
        if (this.docMap == null && this.reader.hasDeletions()) {
            int maxDoc = this.reader.maxDoc();
            this.docMap = new int[maxDoc];
            int j = 0;
            int i = 0;
            while (i < maxDoc) {
                this.docMap[i] = this.reader.isDeleted(i) ? -1 : j++;
                ++i;
            }
        }
        return this.docMap;
    }

    TermPositions getPositions() throws IOException {
        if (this.postings == null) {
            this.postings = this.reader.termPositions();
        }
        return this.postings;
    }

    final boolean next() throws IOException {
        if (this.termEnum.next()) {
            this.term = this.termEnum.term();
            return true;
        }
        this.term = null;
        return false;
    }

    final void close() throws IOException {
        this.termEnum.close();
        if (this.postings != null) {
            this.postings.close();
        }
    }
}

