#include "pg_ddl_decode_proto.h"

#include "libpq/pqformat.h"

/*
 * Write BEGIN to the output stream.
 */
void
pglogical_write_begin(StringInfo out, ReorderBufferTXN *txn)
{
	uint8	flags = 0;

	pq_sendbyte(out, 'B');		/* BEGIN */

	/* send the flags field its self */
	pq_sendbyte(out, flags);

	/* fixed fields */
	pq_sendint64(out, txn->final_lsn);
	pq_sendint64(out, txn->commit_time);
	pq_sendint(out, txn->xid, 4);
}

/*
 * Write COMMIT to the output stream.
 */
void
pglogical_write_commit(StringInfo out, ReorderBufferTXN *txn, XLogRecPtr commit_lsn)
{
	uint8 flags = 0;

	pq_sendbyte(out, 'C');		/* sending COMMIT */

	/* send the flags field */
	pq_sendbyte(out, flags);

	/* send fixed fields */
	pq_sendint64(out, commit_lsn);
	pq_sendint64(out, txn->end_lsn);
	pq_sendint64(out, txn->commit_time);
}

/*
 * Write DDL logical message to the output stream.
 */
void
pglogical_write_ddl(StringInfo out, const char *message, Size sz)
{
	uint8 flags = 0;

	pq_sendbyte(out, 'M');		/* action DDL message */

	/* send the flags field */
	pq_sendbyte(out, flags);

	pq_sendint(out, sz, 4);		/* message length */
	pq_sendbytes(out, message, sz);
}
