/*
 * Decompiled with CFR 0.152.
 */
package com.steadystate.css.dom;

import com.steadystate.css.dom.DOMExceptionImpl;
import com.steadystate.css.dom.Property;
import com.steadystate.css.format.CSSFormat;
import com.steadystate.css.format.CSSFormatable;
import com.steadystate.css.parser.CSSOMParser;
import com.steadystate.css.util.LangUtils;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.w3c.css.sac.InputSource;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSS2Properties;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSValue;

public class CSSStyleDeclarationImpl
implements CSSStyleDeclaration,
CSSFormatable,
CSS2Properties,
Serializable {
    private static final long serialVersionUID = -2373755821317100189L;
    private static final String PRIORITY_IMPORTANT = "important";
    private CSSRule parentRule_;
    private List<Property> properties_ = new ArrayList<Property>();
    private static final String AZIMUTH = "azimuth";
    private static final String BACKGROUND = "background";
    private static final String BACKGROUND_ATTACHMENT = "background-attachment";
    private static final String BACKGROUND_COLOR = "background-color";
    private static final String BACKGROUND_IMAGE = "background-image";
    private static final String BACKGROUND_POSITION = "background-position";
    private static final String BACKGROUND_REPEAT = "background-repeat";
    private static final String BORDER = "border";
    private static final String BORDER_BOTTOM = "border-bottom";
    private static final String BORDER_BOTTOM_COLOR = "border-bottom-color";
    private static final String BORDER_BOTTOM_STYLE = "border-bottom-style";
    private static final String BORDER_BOTTOM_WIDTH = "border-bottom-width";
    private static final String BORDER_COLLAPSE = "border-collapse";
    private static final String BORDER_COLOR = "border-color";
    private static final String BORDER_LEFT = "border-left";
    private static final String BORDER_LEFT_COLOR = "border-left-color";
    private static final String BORDER_LEFT_STYLE = "border-left-style";
    private static final String BORDER_LEFT_WIDTH = "border-left-width";
    private static final String BORDER_RIGHT = "border-right";
    private static final String BORDER_RIGHT_COLOR = "border-right-color";
    private static final String BORDER_RIGHT_STYLE = "border-right-style";
    private static final String BORDER_RIGHT_WIDTH = "border-right-width";
    private static final String BORDER_SPACING = "border-spacing";
    private static final String BORDER_STYLE = "border-style";
    private static final String BORDER_TOP = "border-top";
    private static final String BORDER_TOP_COLOR = "border-top-color";
    private static final String BORDER_TOP_STYLE = "border-top-style";
    private static final String BORDER_TOP_WIDTH = "border-top-width";
    private static final String BORDER_WIDTH = "border-width";
    private static final String BOTTOM = "bottom";
    private static final String CAPTION_SIDE = "caption-side";
    private static final String CLEAR = "clear";
    private static final String CLIP = "clip";
    private static final String COLOR = "color";
    private static final String CONTENT = "content";
    private static final String COUNTER_INCREMENT = "counter-increment";
    private static final String COUNTER_RESET = "counter-reset";
    private static final String CSS_FLOAT = "css-float";
    private static final String CUE = "cue";
    private static final String CUE_AFTER = "cue-after";
    private static final String CUE_BEFORE = "cue-before";
    private static final String CURSOR = "cursor";
    private static final String DIRECTION = "direction";
    private static final String DISPLAY = "display";
    private static final String ELEVATION = "elevation";
    private static final String EMPTY_CELLS = "empty-cells";
    private static final String FONT = "font";
    private static final String FONT_FAMILY = "font-family";
    private static final String FONT_SIZE = "font-size";
    private static final String FONT_SIZE_ADJUST = "font-size-adjust";
    private static final String FONT_STRETCH = "font-stretch";
    private static final String FONT_STYLE = "font-style";
    private static final String FONT_VARIANT = "font-variant";
    private static final String FONT_WEIGHT = "font-weight";
    private static final String HEIGHT = "height";
    private static final String LEFT = "left";
    private static final String LETTER_SPACING = "letter-spacing";
    private static final String LINE_HEIGHT = "line-height";
    private static final String LIST_STYLE = "list-style";
    private static final String LIST_STYLE_IMAGE = "list-style-image";
    private static final String LIST_STYLE_POSITION = "list-style-position";
    private static final String LIST_STYLE_TYPE = "list-style-type";
    private static final String MARGIN = "margin";
    private static final String MARGIN_BOTTOM = "margin-bottom";
    private static final String MARGIN_LEFT = "margin-left";
    private static final String MARGIN_RIGHT = "margin-right";
    private static final String MARGIN_TOP = "margin-top";
    private static final String MARKER_OFFSET = "marker-offset";
    private static final String MARKS = "marks";
    private static final String MAX_HEIGHT = "max-height";
    private static final String MAX_WIDTH = "max-width";
    private static final String MIN_HEIGHT = "min-height";
    private static final String MIN_WIDTH = "min-width";
    private static final String ORPHANS = "orphans";
    private static final String OUTLINE = "outline";
    private static final String OUTLINE_COLOR = "outline-color";
    private static final String OUTLINE_STYLE = "outline-style";
    private static final String OUTLINE_WIDTH = "outline-width";
    private static final String OVERFLOW = "overflow";
    private static final String PADDING = "padding";
    private static final String PADDING_BOTTOM = "padding-bottom";
    private static final String PADDING_LEFT = "padding-left";
    private static final String PADDING_RIGHT = "padding-right";
    private static final String PADDING_TOP = "padding-top";
    private static final String PAGE = "page";
    private static final String PAGE_BREAK_AFTER = "page-break-after";
    private static final String PAGE_BREAK_BEFORE = "page-break-before";
    private static final String PAGE_BREAK_INSIDE = "page-break-inside";
    private static final String PAUSE = "pause";
    private static final String PAUSE_AFTER = "pause-after";
    private static final String PAUSE_BEFORE = "pause-before";
    private static final String PITCH = "pitch";
    private static final String PITCH_RANGE = "pitch-range";
    private static final String PLAY_DURING = "play-during";
    private static final String POSITION = "position";
    private static final String QUOTES = "quotes";
    private static final String RICHNESS = "richness";
    private static final String RIGHT = "right";
    private static final String SIZE = "size";
    private static final String SPEAK = "speak";
    private static final String SPEAK_HEADER = "speak-header";
    private static final String SPEAK_NUMERAL = "speak-numeral";
    private static final String SPEAK_PUNCTUATION = "speak-puctuation";
    private static final String SPEECH_RATE = "speech-rate";
    private static final String STRESS = "stress";
    private static final String TABLE_LAYOUT = "table-layout";
    private static final String TEXT_ALIGN = "text-align";
    private static final String TEXT_DECORATION = "text-decoration";
    private static final String TEXT_INDENT = "text-indent";
    private static final String TEXT_SHADOW = "text-shadow";
    private static final String TEXT_TRANSFORM = "text-transform";
    private static final String TOP = "top";
    private static final String UNICODE_BIDI = "unicode-bidi";
    private static final String VERTICAL_ALIGN = "vertical-align";
    private static final String VISIBILITY = "visibility";
    private static final String VOICE_FAMILY = "voice-family";
    private static final String VOLUME = "volume";
    private static final String WHITE_SPACE = "white-space";
    private static final String WIDOWS = "widows";
    private static final String WIDTH = "width";
    private static final String WORD_SPACING = "word_spacing";
    private static final String Z_INDEX = "z-index";

    public void setParentRule(CSSRule parentRule) {
        this.parentRule_ = parentRule;
    }

    public List<Property> getProperties() {
        return this.properties_;
    }

    public void setProperties(List<Property> properties) {
        this.properties_ = properties;
    }

    public CSSStyleDeclarationImpl(CSSRule parentRule) {
        this.parentRule_ = parentRule;
    }

    public CSSStyleDeclarationImpl() {
    }

    @Override
    public String getCssText() {
        return this.getCssText(null);
    }

    @Override
    public String getCssText(CSSFormat format) {
        boolean nl = format != null && format.getPropertiesInSeparateLines();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.properties_.size(); ++i) {
            Property p = this.properties_.get(i);
            if (p != null) {
                if (nl) {
                    sb.append(format.getNewLine());
                    sb.append(format.getPropertiesIndent());
                }
                sb.append(p.getCssText(format));
            }
            if (i < this.properties_.size() - 1) {
                sb.append(";");
                if (nl) continue;
                sb.append(' ');
                continue;
            }
            if (!nl) continue;
            sb.append(format.getNewLine());
        }
        return sb.toString();
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        try {
            InputSource is = new InputSource((Reader)new StringReader(cssText));
            CSSOMParser parser = new CSSOMParser();
            this.properties_.clear();
            parser.parseStyleDeclaration(this, is);
        }
        catch (Exception e) {
            throw new DOMExceptionImpl(12, 0, e.getMessage());
        }
    }

    @Override
    public String getPropertyValue(String propertyName) {
        Property p = this.getPropertyDeclaration(propertyName);
        if (p == null || p.getValue() == null) {
            return "";
        }
        return p.getValue().toString();
    }

    @Override
    public CSSValue getPropertyCSSValue(String propertyName) {
        Property p = this.getPropertyDeclaration(propertyName);
        return p == null ? null : p.getValue();
    }

    @Override
    public String removeProperty(String propertyName) throws DOMException {
        if (null == propertyName) {
            return "";
        }
        for (int i = 0; i < this.properties_.size(); ++i) {
            Property p = this.properties_.get(i);
            if (p == null || !propertyName.equalsIgnoreCase(p.getName())) continue;
            this.properties_.remove(i);
            if (p.getValue() == null) {
                return "";
            }
            return p.getValue().toString();
        }
        return "";
    }

    @Override
    public String getPropertyPriority(String propertyName) {
        Property p = this.getPropertyDeclaration(propertyName);
        if (p == null) {
            return "";
        }
        return p.isImportant() ? PRIORITY_IMPORTANT : "";
    }

    @Override
    public void setProperty(String propertyName, String value, String priority) throws DOMException {
        try {
            CSSValue expr = null;
            if (!value.isEmpty()) {
                CSSOMParser parser = new CSSOMParser();
                InputSource is = new InputSource((Reader)new StringReader(value));
                expr = parser.parsePropertyValue(is);
            }
            Property p = this.getPropertyDeclaration(propertyName);
            boolean important = PRIORITY_IMPORTANT.equalsIgnoreCase(priority);
            if (p == null) {
                p = new Property(propertyName, expr, important);
                this.addProperty(p);
            } else {
                p.setValue(expr);
                p.setImportant(important);
            }
        }
        catch (Exception e) {
            throw new DOMExceptionImpl(12, 0, e.getMessage());
        }
    }

    @Override
    public int getLength() {
        return this.properties_.size();
    }

    @Override
    public String item(int index) {
        Property p = this.properties_.get(index);
        return p == null ? "" : p.getName();
    }

    @Override
    public CSSRule getParentRule() {
        return this.parentRule_;
    }

    public void addProperty(Property p) {
        if (null == p) {
            return;
        }
        this.properties_.add(p);
    }

    public Property getPropertyDeclaration(String propertyName) {
        if (null == propertyName) {
            return null;
        }
        for (int i = this.properties_.size() - 1; i > -1; --i) {
            Property p = this.properties_.get(i);
            if (p == null || !propertyName.equalsIgnoreCase(p.getName())) continue;
            return p;
        }
        return null;
    }

    public String toString() {
        return this.getCssText();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CSSStyleDeclaration)) {
            return false;
        }
        CSSStyleDeclaration csd = (CSSStyleDeclaration)obj;
        return this.equalsProperties(csd);
    }

    private boolean equalsProperties(CSSStyleDeclaration csd) {
        if (csd == null || this.getLength() != csd.getLength()) {
            return false;
        }
        for (int i = 0; i < this.getLength(); ++i) {
            String propertyPriority2;
            String propertyValue2;
            String propertyName = this.item(i);
            String propertyValue1 = this.getPropertyValue(propertyName);
            if (!LangUtils.equals(propertyValue1, propertyValue2 = csd.getPropertyValue(propertyName))) {
                return false;
            }
            String propertyPriority1 = this.getPropertyPriority(propertyName);
            if (LangUtils.equals(propertyPriority1, propertyPriority2 = csd.getPropertyPriority(propertyName))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = 17;
        hash = LangUtils.hashCode(hash, this.properties_);
        return hash;
    }

    @Override
    public String getAzimuth() {
        return this.getPropertyValue(AZIMUTH);
    }

    @Override
    public void setAzimuth(String azimuth) throws DOMException {
        this.setProperty(AZIMUTH, azimuth, null);
    }

    @Override
    public String getBackground() {
        return this.getPropertyValue(BACKGROUND);
    }

    @Override
    public void setBackground(String background) throws DOMException {
        this.setProperty(BACKGROUND, background, null);
    }

    @Override
    public String getBackgroundAttachment() {
        return this.getPropertyValue(BACKGROUND_ATTACHMENT);
    }

    @Override
    public void setBackgroundAttachment(String backgroundAttachment) throws DOMException {
        this.setProperty(BACKGROUND_ATTACHMENT, backgroundAttachment, null);
    }

    @Override
    public String getBackgroundColor() {
        return this.getPropertyValue(BACKGROUND_COLOR);
    }

    @Override
    public void setBackgroundColor(String backgroundColor) throws DOMException {
        this.setProperty(BACKGROUND_COLOR, backgroundColor, null);
    }

    @Override
    public String getBackgroundImage() {
        return this.getPropertyValue(BACKGROUND_IMAGE);
    }

    @Override
    public void setBackgroundImage(String backgroundImage) throws DOMException {
        this.setProperty(BACKGROUND_IMAGE, backgroundImage, null);
    }

    @Override
    public String getBackgroundPosition() {
        return this.getPropertyValue(BACKGROUND_POSITION);
    }

    @Override
    public void setBackgroundPosition(String backgroundPosition) throws DOMException {
        this.setProperty(BACKGROUND_POSITION, backgroundPosition, null);
    }

    @Override
    public String getBackgroundRepeat() {
        return this.getPropertyValue(BACKGROUND_REPEAT);
    }

    @Override
    public void setBackgroundRepeat(String backgroundRepeat) throws DOMException {
        this.setProperty(BACKGROUND_REPEAT, backgroundRepeat, null);
    }

    @Override
    public String getBorder() {
        return this.getPropertyValue(BORDER);
    }

    @Override
    public void setBorder(String border) throws DOMException {
        this.setProperty(BORDER, border, null);
    }

    @Override
    public String getBorderCollapse() {
        return this.getPropertyValue(BORDER_COLLAPSE);
    }

    @Override
    public void setBorderCollapse(String borderCollapse) throws DOMException {
        this.setProperty(BORDER_COLLAPSE, borderCollapse, null);
    }

    @Override
    public String getBorderColor() {
        return this.getPropertyValue(BORDER_COLOR);
    }

    @Override
    public void setBorderColor(String borderColor) throws DOMException {
        this.setProperty(BORDER_COLOR, borderColor, null);
    }

    @Override
    public String getBorderSpacing() {
        return this.getPropertyValue(BORDER_SPACING);
    }

    @Override
    public void setBorderSpacing(String borderSpacing) throws DOMException {
        this.setProperty(BORDER_SPACING, borderSpacing, null);
    }

    @Override
    public String getBorderStyle() {
        return this.getPropertyValue(BORDER_STYLE);
    }

    @Override
    public void setBorderStyle(String borderStyle) throws DOMException {
        this.setProperty(BORDER_STYLE, borderStyle, null);
    }

    @Override
    public String getBorderTop() {
        return this.getPropertyValue(BORDER_TOP);
    }

    @Override
    public void setBorderTop(String borderTop) throws DOMException {
        this.setProperty(BORDER_TOP, borderTop, null);
    }

    @Override
    public String getBorderRight() {
        return this.getPropertyValue(BORDER_RIGHT);
    }

    @Override
    public void setBorderRight(String borderRight) throws DOMException {
        this.setProperty(BORDER_RIGHT, borderRight, null);
    }

    @Override
    public String getBorderBottom() {
        return this.getPropertyValue(BORDER_BOTTOM);
    }

    @Override
    public void setBorderBottom(String borderBottom) throws DOMException {
        this.setProperty(BORDER_BOTTOM, borderBottom, null);
    }

    @Override
    public String getBorderLeft() {
        return this.getPropertyValue(BORDER_LEFT);
    }

    @Override
    public void setBorderLeft(String borderLeft) throws DOMException {
        this.setProperty(BORDER_LEFT, borderLeft, null);
    }

    @Override
    public String getBorderTopColor() {
        return this.getPropertyValue(BORDER_TOP_COLOR);
    }

    @Override
    public void setBorderTopColor(String borderTopColor) throws DOMException {
        this.setProperty(BORDER_TOP_COLOR, borderTopColor, null);
    }

    @Override
    public String getBorderRightColor() {
        return this.getPropertyValue(BORDER_RIGHT_COLOR);
    }

    @Override
    public void setBorderRightColor(String borderRightColor) throws DOMException {
        this.setProperty(BORDER_RIGHT_COLOR, borderRightColor, null);
    }

    @Override
    public String getBorderBottomColor() {
        return this.getPropertyValue(BORDER_BOTTOM_COLOR);
    }

    @Override
    public void setBorderBottomColor(String borderBottomColor) throws DOMException {
        this.setProperty(BORDER_BOTTOM_COLOR, borderBottomColor, null);
    }

    @Override
    public String getBorderLeftColor() {
        return this.getPropertyValue(BORDER_LEFT_COLOR);
    }

    @Override
    public void setBorderLeftColor(String borderLeftColor) throws DOMException {
        this.setProperty(BORDER_LEFT_COLOR, borderLeftColor, null);
    }

    @Override
    public String getBorderTopStyle() {
        return this.getPropertyValue(BORDER_TOP_STYLE);
    }

    @Override
    public void setBorderTopStyle(String borderTopStyle) throws DOMException {
        this.setProperty(BORDER_TOP_STYLE, borderTopStyle, null);
    }

    @Override
    public String getBorderRightStyle() {
        return this.getPropertyValue(BORDER_RIGHT_STYLE);
    }

    @Override
    public void setBorderRightStyle(String borderRightStyle) throws DOMException {
        this.setProperty(BORDER_RIGHT_STYLE, borderRightStyle, null);
    }

    @Override
    public String getBorderBottomStyle() {
        return this.getPropertyValue(BORDER_BOTTOM_STYLE);
    }

    @Override
    public void setBorderBottomStyle(String borderBottomStyle) throws DOMException {
        this.setProperty(BORDER_BOTTOM_STYLE, borderBottomStyle, null);
    }

    @Override
    public String getBorderLeftStyle() {
        return this.getPropertyValue(BORDER_LEFT_STYLE);
    }

    @Override
    public void setBorderLeftStyle(String borderLeftStyle) throws DOMException {
        this.setProperty(BORDER_LEFT_STYLE, borderLeftStyle, null);
    }

    @Override
    public String getBorderTopWidth() {
        return this.getPropertyValue(BORDER_TOP_WIDTH);
    }

    @Override
    public void setBorderTopWidth(String borderTopWidth) throws DOMException {
        this.setProperty(BORDER_TOP_WIDTH, borderTopWidth, null);
    }

    @Override
    public String getBorderRightWidth() {
        return this.getPropertyValue(BORDER_RIGHT_WIDTH);
    }

    @Override
    public void setBorderRightWidth(String borderRightWidth) throws DOMException {
        this.setProperty(BORDER_RIGHT_WIDTH, borderRightWidth, null);
    }

    @Override
    public String getBorderBottomWidth() {
        return this.getPropertyValue(BORDER_BOTTOM_WIDTH);
    }

    @Override
    public void setBorderBottomWidth(String borderBottomWidth) throws DOMException {
        this.setProperty(BORDER_BOTTOM_WIDTH, borderBottomWidth, null);
    }

    @Override
    public String getBorderLeftWidth() {
        return this.getPropertyValue(BORDER_LEFT_WIDTH);
    }

    @Override
    public void setBorderLeftWidth(String borderLeftWidth) throws DOMException {
        this.setProperty(BORDER_LEFT_WIDTH, borderLeftWidth, null);
    }

    @Override
    public String getBorderWidth() {
        return this.getPropertyValue(BORDER_WIDTH);
    }

    @Override
    public void setBorderWidth(String borderWidth) throws DOMException {
        this.setProperty(BORDER_WIDTH, borderWidth, null);
    }

    @Override
    public String getBottom() {
        return this.getPropertyValue(BOTTOM);
    }

    @Override
    public void setBottom(String bottom) throws DOMException {
        this.setProperty(BOTTOM, bottom, null);
    }

    @Override
    public String getCaptionSide() {
        return this.getPropertyValue(CAPTION_SIDE);
    }

    @Override
    public void setCaptionSide(String captionSide) throws DOMException {
        this.setProperty(CAPTION_SIDE, captionSide, null);
    }

    @Override
    public String getClear() {
        return this.getPropertyValue(CLEAR);
    }

    @Override
    public void setClear(String clear) throws DOMException {
        this.setProperty(CLEAR, clear, null);
    }

    @Override
    public String getClip() {
        return this.getPropertyValue(CLIP);
    }

    @Override
    public void setClip(String clip) throws DOMException {
        this.setProperty(CLIP, clip, null);
    }

    @Override
    public String getColor() {
        return this.getPropertyValue(COLOR);
    }

    @Override
    public void setColor(String color) throws DOMException {
        this.setProperty(COLOR, color, null);
    }

    @Override
    public String getContent() {
        return this.getPropertyValue(CONTENT);
    }

    @Override
    public void setContent(String content) throws DOMException {
        this.setProperty(CONTENT, content, null);
    }

    @Override
    public String getCounterIncrement() {
        return this.getPropertyValue(COUNTER_INCREMENT);
    }

    @Override
    public void setCounterIncrement(String counterIncrement) throws DOMException {
        this.setProperty(COUNTER_INCREMENT, counterIncrement, null);
    }

    @Override
    public String getCounterReset() {
        return this.getPropertyValue(COUNTER_RESET);
    }

    @Override
    public void setCounterReset(String counterReset) throws DOMException {
        this.setProperty(COUNTER_RESET, counterReset, null);
    }

    @Override
    public String getCue() {
        return this.getPropertyValue(CUE);
    }

    @Override
    public void setCue(String cue) throws DOMException {
        this.setProperty(CUE, cue, null);
    }

    @Override
    public String getCueAfter() {
        return this.getPropertyValue(CUE_AFTER);
    }

    @Override
    public void setCueAfter(String cueAfter) throws DOMException {
        this.setProperty(CUE_AFTER, cueAfter, null);
    }

    @Override
    public String getCueBefore() {
        return this.getPropertyValue(CUE_BEFORE);
    }

    @Override
    public void setCueBefore(String cueBefore) throws DOMException {
        this.setProperty(CUE_BEFORE, cueBefore, null);
    }

    @Override
    public String getCursor() {
        return this.getPropertyValue(CURSOR);
    }

    @Override
    public void setCursor(String cursor) throws DOMException {
        this.setProperty(CURSOR, cursor, null);
    }

    @Override
    public String getDirection() {
        return this.getPropertyValue(DIRECTION);
    }

    @Override
    public void setDirection(String direction) throws DOMException {
        this.setProperty(DIRECTION, direction, null);
    }

    @Override
    public String getDisplay() {
        return this.getPropertyValue(DISPLAY);
    }

    @Override
    public void setDisplay(String display) throws DOMException {
        this.setProperty(DISPLAY, display, null);
    }

    @Override
    public String getElevation() {
        return this.getPropertyValue(ELEVATION);
    }

    @Override
    public void setElevation(String elevation) throws DOMException {
        this.setProperty(ELEVATION, elevation, null);
    }

    @Override
    public String getEmptyCells() {
        return this.getPropertyValue(EMPTY_CELLS);
    }

    @Override
    public void setEmptyCells(String emptyCells) throws DOMException {
        this.setProperty(EMPTY_CELLS, emptyCells, null);
    }

    @Override
    public String getCssFloat() {
        return this.getPropertyValue(CSS_FLOAT);
    }

    @Override
    public void setCssFloat(String cssFloat) throws DOMException {
        this.setProperty(CSS_FLOAT, cssFloat, null);
    }

    @Override
    public String getFont() {
        return this.getPropertyValue(FONT);
    }

    @Override
    public void setFont(String font) throws DOMException {
        this.setProperty(FONT, font, null);
    }

    @Override
    public String getFontFamily() {
        return this.getPropertyValue(FONT_FAMILY);
    }

    @Override
    public void setFontFamily(String fontFamily) throws DOMException {
        this.setProperty(FONT_FAMILY, fontFamily, null);
    }

    @Override
    public String getFontSize() {
        return this.getPropertyValue(FONT_SIZE);
    }

    @Override
    public void setFontSize(String fontSize) throws DOMException {
        this.setProperty(FONT_SIZE, fontSize, null);
    }

    @Override
    public String getFontSizeAdjust() {
        return this.getPropertyValue(FONT_SIZE_ADJUST);
    }

    @Override
    public void setFontSizeAdjust(String fontSizeAdjust) throws DOMException {
        this.setProperty(FONT_SIZE_ADJUST, fontSizeAdjust, null);
    }

    @Override
    public String getFontStretch() {
        return this.getPropertyValue(FONT_STRETCH);
    }

    @Override
    public void setFontStretch(String fontStretch) throws DOMException {
        this.setProperty(FONT_STRETCH, fontStretch, null);
    }

    @Override
    public String getFontStyle() {
        return this.getPropertyValue(FONT_STYLE);
    }

    @Override
    public void setFontStyle(String fontStyle) throws DOMException {
        this.setProperty(FONT_STYLE, fontStyle, null);
    }

    @Override
    public String getFontVariant() {
        return this.getPropertyValue(FONT_VARIANT);
    }

    @Override
    public void setFontVariant(String fontVariant) throws DOMException {
        this.setProperty(FONT_VARIANT, fontVariant, null);
    }

    @Override
    public String getFontWeight() {
        return this.getPropertyValue(FONT_WEIGHT);
    }

    @Override
    public void setFontWeight(String fontWeight) throws DOMException {
        this.setProperty(FONT_WEIGHT, fontWeight, null);
    }

    @Override
    public String getHeight() {
        return this.getPropertyValue(HEIGHT);
    }

    @Override
    public void setHeight(String height) throws DOMException {
        this.setProperty(HEIGHT, height, null);
    }

    @Override
    public String getLeft() {
        return this.getPropertyValue(LEFT);
    }

    @Override
    public void setLeft(String left) throws DOMException {
        this.setProperty(LEFT, left, null);
    }

    @Override
    public String getLetterSpacing() {
        return this.getPropertyValue(LETTER_SPACING);
    }

    @Override
    public void setLetterSpacing(String letterSpacing) throws DOMException {
        this.setProperty(LETTER_SPACING, letterSpacing, null);
    }

    @Override
    public String getLineHeight() {
        return this.getPropertyValue(LINE_HEIGHT);
    }

    @Override
    public void setLineHeight(String lineHeight) throws DOMException {
        this.setProperty(LINE_HEIGHT, lineHeight, null);
    }

    @Override
    public String getListStyle() {
        return this.getPropertyValue(LIST_STYLE);
    }

    @Override
    public void setListStyle(String listStyle) throws DOMException {
        this.setProperty(LIST_STYLE, listStyle, null);
    }

    @Override
    public String getListStyleImage() {
        return this.getPropertyValue(LIST_STYLE_IMAGE);
    }

    @Override
    public void setListStyleImage(String listStyleImage) throws DOMException {
        this.setProperty(LIST_STYLE_IMAGE, listStyleImage, null);
    }

    @Override
    public String getListStylePosition() {
        return this.getPropertyValue(LIST_STYLE_POSITION);
    }

    @Override
    public void setListStylePosition(String listStylePosition) throws DOMException {
        this.setProperty(LIST_STYLE_POSITION, listStylePosition, null);
    }

    @Override
    public String getListStyleType() {
        return this.getPropertyValue(LIST_STYLE_TYPE);
    }

    @Override
    public void setListStyleType(String listStyleType) throws DOMException {
        this.setProperty(LIST_STYLE_TYPE, listStyleType, null);
    }

    @Override
    public String getMargin() {
        return this.getPropertyValue(MARGIN);
    }

    @Override
    public void setMargin(String margin) throws DOMException {
        this.setProperty(MARGIN, margin, null);
    }

    @Override
    public String getMarginTop() {
        return this.getPropertyValue(MARGIN_TOP);
    }

    @Override
    public void setMarginTop(String marginTop) throws DOMException {
        this.setProperty(MARGIN_TOP, marginTop, null);
    }

    @Override
    public String getMarginRight() {
        return this.getPropertyValue(MARGIN_RIGHT);
    }

    @Override
    public void setMarginRight(String marginRight) throws DOMException {
        this.setProperty(MARGIN_RIGHT, marginRight, null);
    }

    @Override
    public String getMarginBottom() {
        return this.getPropertyValue(MARGIN_BOTTOM);
    }

    @Override
    public void setMarginBottom(String marginBottom) throws DOMException {
        this.setProperty(MARGIN_BOTTOM, marginBottom, null);
    }

    @Override
    public String getMarginLeft() {
        return this.getPropertyValue(MARGIN_LEFT);
    }

    @Override
    public void setMarginLeft(String marginLeft) throws DOMException {
        this.setProperty(MARGIN_LEFT, marginLeft, null);
    }

    @Override
    public String getMarkerOffset() {
        return this.getPropertyValue(MARKER_OFFSET);
    }

    @Override
    public void setMarkerOffset(String markerOffset) throws DOMException {
        this.setProperty(MARKER_OFFSET, markerOffset, null);
    }

    @Override
    public String getMarks() {
        return this.getPropertyValue(MARKS);
    }

    @Override
    public void setMarks(String marks) throws DOMException {
        this.setProperty(MARKS, marks, null);
    }

    @Override
    public String getMaxHeight() {
        return this.getPropertyValue(MAX_HEIGHT);
    }

    @Override
    public void setMaxHeight(String maxHeight) throws DOMException {
        this.setProperty(MAX_HEIGHT, maxHeight, null);
    }

    @Override
    public String getMaxWidth() {
        return this.getPropertyValue(MAX_WIDTH);
    }

    @Override
    public void setMaxWidth(String maxWidth) throws DOMException {
        this.setProperty(MAX_WIDTH, maxWidth, null);
    }

    @Override
    public String getMinHeight() {
        return this.getPropertyValue(MIN_HEIGHT);
    }

    @Override
    public void setMinHeight(String minHeight) throws DOMException {
        this.setProperty(MIN_HEIGHT, minHeight, null);
    }

    @Override
    public String getMinWidth() {
        return this.getPropertyValue(MIN_WIDTH);
    }

    @Override
    public void setMinWidth(String minWidth) throws DOMException {
        this.setProperty(MIN_WIDTH, minWidth, null);
    }

    @Override
    public String getOrphans() {
        return this.getPropertyValue(ORPHANS);
    }

    @Override
    public void setOrphans(String orphans) throws DOMException {
        this.setProperty(ORPHANS, orphans, null);
    }

    @Override
    public String getOutline() {
        return this.getPropertyValue(OUTLINE);
    }

    @Override
    public void setOutline(String outline) throws DOMException {
        this.setProperty(OUTLINE, outline, null);
    }

    @Override
    public String getOutlineColor() {
        return this.getPropertyValue(OUTLINE_COLOR);
    }

    @Override
    public void setOutlineColor(String outlineColor) throws DOMException {
        this.setProperty(OUTLINE_COLOR, outlineColor, null);
    }

    @Override
    public String getOutlineStyle() {
        return this.getPropertyValue(OUTLINE_STYLE);
    }

    @Override
    public void setOutlineStyle(String outlineStyle) throws DOMException {
        this.setProperty(OUTLINE_STYLE, outlineStyle, null);
    }

    @Override
    public String getOutlineWidth() {
        return this.getPropertyValue(OUTLINE_WIDTH);
    }

    @Override
    public void setOutlineWidth(String outlineWidth) throws DOMException {
        this.setProperty(OUTLINE_WIDTH, outlineWidth, null);
    }

    @Override
    public String getOverflow() {
        return this.getPropertyValue(OVERFLOW);
    }

    @Override
    public void setOverflow(String overflow) throws DOMException {
        this.setProperty(OVERFLOW, overflow, null);
    }

    @Override
    public String getPadding() {
        return this.getPropertyValue(PADDING);
    }

    @Override
    public void setPadding(String padding) throws DOMException {
        this.setProperty(PADDING, padding, null);
    }

    @Override
    public String getPaddingTop() {
        return this.getPropertyValue(PADDING_TOP);
    }

    @Override
    public void setPaddingTop(String paddingTop) throws DOMException {
        this.setProperty(PADDING_TOP, paddingTop, null);
    }

    @Override
    public String getPaddingRight() {
        return this.getPropertyValue(PADDING_RIGHT);
    }

    @Override
    public void setPaddingRight(String paddingRight) throws DOMException {
        this.setProperty(PADDING_RIGHT, paddingRight, null);
    }

    @Override
    public String getPaddingBottom() {
        return this.getPropertyValue(PADDING_BOTTOM);
    }

    @Override
    public void setPaddingBottom(String paddingBottom) throws DOMException {
        this.setProperty(PADDING_BOTTOM, paddingBottom, null);
    }

    @Override
    public String getPaddingLeft() {
        return this.getPropertyValue(PADDING_LEFT);
    }

    @Override
    public void setPaddingLeft(String paddingLeft) throws DOMException {
        this.setProperty(PADDING_LEFT, paddingLeft, null);
    }

    @Override
    public String getPage() {
        return this.getPropertyValue(PAGE);
    }

    @Override
    public void setPage(String page) throws DOMException {
        this.setProperty(PAGE, page, null);
    }

    @Override
    public String getPageBreakAfter() {
        return this.getPropertyValue(PAGE_BREAK_AFTER);
    }

    @Override
    public void setPageBreakAfter(String pageBreakAfter) throws DOMException {
        this.setProperty(PAGE_BREAK_AFTER, pageBreakAfter, null);
    }

    @Override
    public String getPageBreakBefore() {
        return this.getPropertyValue(PAGE_BREAK_BEFORE);
    }

    @Override
    public void setPageBreakBefore(String pageBreakBefore) throws DOMException {
        this.setProperty(PAGE_BREAK_BEFORE, PAGE_BREAK_BEFORE, null);
    }

    @Override
    public String getPageBreakInside() {
        return this.getPropertyValue(PAGE_BREAK_INSIDE);
    }

    @Override
    public void setPageBreakInside(String pageBreakInside) throws DOMException {
        this.setProperty(PAGE_BREAK_INSIDE, pageBreakInside, null);
    }

    @Override
    public String getPause() {
        return this.getPropertyValue(PAUSE);
    }

    @Override
    public void setPause(String pause) throws DOMException {
        this.setProperty(PAUSE, pause, null);
    }

    @Override
    public String getPauseAfter() {
        return this.getPropertyValue(PAUSE_AFTER);
    }

    @Override
    public void setPauseAfter(String pauseAfter) throws DOMException {
        this.setProperty(PAUSE_AFTER, pauseAfter, null);
    }

    @Override
    public String getPauseBefore() {
        return this.getPropertyValue(PAUSE_BEFORE);
    }

    @Override
    public void setPauseBefore(String pauseBefore) throws DOMException {
        this.setProperty(PAUSE_BEFORE, PAUSE_BEFORE, null);
    }

    @Override
    public String getPitch() {
        return this.getPropertyValue(PITCH);
    }

    @Override
    public void setPitch(String pitch) throws DOMException {
        this.setProperty(PITCH, pitch, null);
    }

    @Override
    public String getPitchRange() {
        return this.getPropertyValue(PITCH_RANGE);
    }

    @Override
    public void setPitchRange(String pitchRange) throws DOMException {
        this.setProperty(PITCH_RANGE, pitchRange, null);
    }

    @Override
    public String getPlayDuring() {
        return this.getPropertyValue(PLAY_DURING);
    }

    @Override
    public void setPlayDuring(String playDuring) throws DOMException {
        this.setProperty(PLAY_DURING, playDuring, null);
    }

    @Override
    public String getPosition() {
        return this.getPropertyValue(POSITION);
    }

    @Override
    public void setPosition(String position) throws DOMException {
        this.setProperty(POSITION, position, null);
    }

    @Override
    public String getQuotes() {
        return this.getPropertyValue(QUOTES);
    }

    @Override
    public void setQuotes(String quotes) throws DOMException {
        this.setProperty(QUOTES, quotes, null);
    }

    @Override
    public String getRichness() {
        return this.getPropertyValue(RICHNESS);
    }

    @Override
    public void setRichness(String richness) throws DOMException {
        this.setProperty(RICHNESS, richness, null);
    }

    @Override
    public String getRight() {
        return this.getPropertyValue(RIGHT);
    }

    @Override
    public void setRight(String right) throws DOMException {
        this.setProperty(RIGHT, right, null);
    }

    @Override
    public String getSize() {
        return this.getPropertyValue(SIZE);
    }

    @Override
    public void setSize(String size) throws DOMException {
        this.setProperty(SIZE, size, null);
    }

    @Override
    public String getSpeak() {
        return this.getPropertyValue(SPEAK);
    }

    @Override
    public void setSpeak(String speak) throws DOMException {
        this.setProperty(SPEAK, speak, null);
    }

    @Override
    public String getSpeakHeader() {
        return this.getPropertyValue(SPEAK_HEADER);
    }

    @Override
    public void setSpeakHeader(String speakHeader) throws DOMException {
        this.setProperty(SPEAK_HEADER, speakHeader, null);
    }

    @Override
    public String getSpeakNumeral() {
        return this.getPropertyValue(SPEAK_NUMERAL);
    }

    @Override
    public void setSpeakNumeral(String speakNumeral) throws DOMException {
        this.setProperty(SPEAK_NUMERAL, speakNumeral, null);
    }

    @Override
    public String getSpeakPunctuation() {
        return this.getPropertyValue(SPEAK_PUNCTUATION);
    }

    @Override
    public void setSpeakPunctuation(String speakPunctuation) throws DOMException {
        this.setProperty(SPEAK_PUNCTUATION, speakPunctuation, null);
    }

    @Override
    public String getSpeechRate() {
        return this.getPropertyValue(SPEECH_RATE);
    }

    @Override
    public void setSpeechRate(String speechRate) throws DOMException {
        this.setProperty(SPEECH_RATE, speechRate, null);
    }

    @Override
    public String getStress() {
        return this.getPropertyValue(STRESS);
    }

    @Override
    public void setStress(String stress) throws DOMException {
        this.setProperty(STRESS, stress, null);
    }

    @Override
    public String getTableLayout() {
        return this.getPropertyValue(TABLE_LAYOUT);
    }

    @Override
    public void setTableLayout(String tableLayout) throws DOMException {
        this.setProperty(TABLE_LAYOUT, tableLayout, null);
    }

    @Override
    public String getTextAlign() {
        return this.getPropertyValue(TEXT_ALIGN);
    }

    @Override
    public void setTextAlign(String textAlign) throws DOMException {
        this.setProperty(TEXT_ALIGN, textAlign, null);
    }

    @Override
    public String getTextDecoration() {
        return this.getPropertyValue(TEXT_DECORATION);
    }

    @Override
    public void setTextDecoration(String textDecoration) throws DOMException {
        this.setProperty(TEXT_DECORATION, textDecoration, null);
    }

    @Override
    public String getTextIndent() {
        return this.getPropertyValue(TEXT_INDENT);
    }

    @Override
    public void setTextIndent(String textIndent) throws DOMException {
        this.setProperty(TEXT_INDENT, textIndent, null);
    }

    @Override
    public String getTextShadow() {
        return this.getPropertyValue(TEXT_SHADOW);
    }

    @Override
    public void setTextShadow(String textShadow) throws DOMException {
        this.setProperty(TEXT_SHADOW, textShadow, null);
    }

    @Override
    public String getTextTransform() {
        return this.getPropertyValue(TEXT_TRANSFORM);
    }

    @Override
    public void setTextTransform(String textTransform) throws DOMException {
        this.setProperty(TEXT_TRANSFORM, textTransform, null);
    }

    @Override
    public String getTop() {
        return this.getPropertyValue(TOP);
    }

    @Override
    public void setTop(String top) throws DOMException {
        this.setProperty(TOP, top, null);
    }

    @Override
    public String getUnicodeBidi() {
        return this.getPropertyValue(UNICODE_BIDI);
    }

    @Override
    public void setUnicodeBidi(String unicodeBidi) throws DOMException {
        this.setProperty(UNICODE_BIDI, unicodeBidi, null);
    }

    @Override
    public String getVerticalAlign() {
        return this.getPropertyValue(VERTICAL_ALIGN);
    }

    @Override
    public void setVerticalAlign(String verticalAlign) throws DOMException {
        this.setProperty(VERTICAL_ALIGN, verticalAlign, null);
    }

    @Override
    public String getVisibility() {
        return this.getPropertyValue(VISIBILITY);
    }

    @Override
    public void setVisibility(String visibility) throws DOMException {
        this.setProperty(VISIBILITY, visibility, null);
    }

    @Override
    public String getVoiceFamily() {
        return this.getPropertyValue(VOICE_FAMILY);
    }

    @Override
    public void setVoiceFamily(String voiceFamily) throws DOMException {
        this.setProperty(VOICE_FAMILY, voiceFamily, null);
    }

    @Override
    public String getVolume() {
        return this.getPropertyValue(VOLUME);
    }

    @Override
    public void setVolume(String volume) throws DOMException {
        this.setProperty(VOLUME, volume, null);
    }

    @Override
    public String getWhiteSpace() {
        return this.getPropertyValue(WHITE_SPACE);
    }

    @Override
    public void setWhiteSpace(String whiteSpace) throws DOMException {
        this.setProperty(WHITE_SPACE, whiteSpace, null);
    }

    @Override
    public String getWidows() {
        return this.getPropertyValue(WIDOWS);
    }

    @Override
    public void setWidows(String widows) throws DOMException {
        this.setProperty(WIDOWS, widows, null);
    }

    @Override
    public String getWidth() {
        return this.getPropertyValue(WIDTH);
    }

    @Override
    public void setWidth(String width) throws DOMException {
        this.setProperty(WIDTH, width, null);
    }

    @Override
    public String getWordSpacing() {
        return this.getPropertyValue(WORD_SPACING);
    }

    @Override
    public void setWordSpacing(String wordSpacing) throws DOMException {
        this.setProperty(WORD_SPACING, wordSpacing, null);
    }

    @Override
    public String getZIndex() {
        return this.getPropertyValue(Z_INDEX);
    }

    @Override
    public void setZIndex(String zIndex) throws DOMException {
        this.setProperty(Z_INDEX, zIndex, null);
    }
}

