package cz.eman.jsonrpc.server.tcp;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;

import org.apache.log4j.Logger;

import cz.eman.jsonrpc.server.RpcHandler;

public abstract class TcpJsonServer {
	protected static Logger log;

	protected Socket socket;

	protected PrintWriter writer = null;

	protected BufferedReader reader = null;

	protected RpcHandler handler;

	protected ServerSocket ss;

	protected Object implementation;

	protected int port;

	protected Map<String, IRpcCallListener> listeners = new HashMap<String, IRpcCallListener>();

	public TcpJsonServer(final Object o, final int port) throws IOException {
		log = Logger.getLogger(this.getClass());
		this.implementation = o;
		this.port = port;
		handler = new RpcHandler();
		RpcHandler.registerInstance(o.getClass().getName(), o);
		ss = new ServerSocket(port);
		log.debug("listening at: " + ss);
	}

	public abstract void start() throws IOException;

	public void addListener(final String listenerId, final IRpcCallListener listener) {
		log.debug("adding listenerId: " + listenerId + " count before: " + listeners.size());
		if (listener != null) {
			listeners.put(listenerId, listener);
		}
	}

	public void removeListener(final String listenerId) {
		listeners.remove(listenerId);
	}

	public void close() throws IOException {
		ss.close();
	}

	public void removeAllListeners() {
		listeners.clear();
	}

	protected void onConnect() {

	}

	protected void onException() {

	}

}
