/*
 * File: sfo_45_arrange_an_array_into_the_smallest_number_s1.cpp
 * Created Time: 2021-12-09
 * Author: Krahets (krahets@163.com)
 */

#include "../include/include.hpp"

// ===== Solution Code =====
class Solution {
  public:
    string minNumber(vector<int> &nums) {
        vector<string> strs;
        for (int i = 0; i < nums.size(); i++)
            strs.push_back(to_string(nums[i]));
        quickSort(strs, 0, strs.size() - 1);
        string res;
        for (string s : strs)
            res.append(s);
        return res;
    }

  private:
    void quickSort(vector<string> &strs, int l, int r) {
        if (l >= r)
            return;
        int i = l, j = r;
        while (i < j) {
            while (strs[j] + strs[l] >= strs[l] + strs[j] && i < j)
                j--;
            while (strs[i] + strs[l] <= strs[l] + strs[i] && i < j)
                i++;
            swap(strs[i], strs[j]);
        }
        swap(strs[i], strs[l]);
        quickSort(strs, l, i - 1);
        quickSort(strs, i + 1, r);
    }
};

int main() {
    // ======= Test Case =======
    vector<int> nums = {3, 30, 34, 5, 9};
    // ====== Driver Code ======
    Solution *slt = new Solution();
    string res = slt->minNumber(nums);
    cout << res << endl;

    return 0;
}
