/*
 * Decompiled with CFR 0.152.
 */
package php.java.bridge;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringTokenizer;
import php.java.bridge.DynamicJavaBridgeClassLoader;
import php.java.bridge.Util;

class JarLibraryPath {
    private String path;
    private boolean isCached;
    private String rawPath;
    private String rawContextDir;
    private String cwd;
    private String searchpath;
    private URL[] urls;
    private boolean hasResult;
    private int result = 1;
    static Map urlCache = Collections.synchronizedMap(new HashMap());

    protected JarLibraryPath() {
        this.isCached = true;
    }

    public JarLibraryPath(String string, String string2, String string3, String string4) throws IOException {
        if (string2 == null) {
            throw new NullPointerException("rawContextDir");
        }
        this.rawPath = string;
        this.rawContextDir = string2;
        this.path = this.makePath(string);
        this.cwd = string3;
        this.searchpath = string4;
        this.urls = this.checkURLs();
    }

    public int hashCode() {
        if (this.hasResult) {
            return this.result;
        }
        this.result = this.result * 31 + this.rawPath.hashCode();
        this.result = this.result * 31 + this.rawContextDir.hashCode();
        this.hasResult = true;
        return this.result;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        JarLibraryPath jarLibraryPath = (JarLibraryPath)object;
        if (this.rawContextDir != jarLibraryPath.rawContextDir) {
            return false;
        }
        return this.rawPath.equals(jarLibraryPath.rawPath);
    }

    private String makePath(String string) {
        char c = string.charAt(0);
        if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c != '.' || c != '/') {
            string = ";" + string;
        }
        return string;
    }

    private String makeContextDir(String string) {
        string = new File(string, "lib").getAbsolutePath();
        return string;
    }

    public URL[] getURLs() {
        return this.urls;
    }

    private URL[] checkURLs() throws IOException {
        URL[] uRLArray = (URL[])urlCache.get(this);
        if (uRLArray != null) {
            this.urls = uRLArray;
            this.isCached = true;
            return uRLArray;
        }
        this.isCached = false;
        return this.createUrls();
    }

    static File checkSearchPath(String string, String string2) {
        int n;
        boolean bl;
        if (string2 == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, File.pathSeparator);
        File file = new File(string);
        boolean bl2 = bl = file.getParent() != null;
        if (!bl && (n = string.lastIndexOf(46)) != -1) {
            string = string.substring(0, n) + File.separator + string;
        }
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            file = new File(string3, string);
            if (!file.isFile()) continue;
            return file;
        }
        return null;
    }

    private URL[] createUrls() throws IOException {
        Object object;
        LinkedList<URL[]> linkedList = new LinkedList<URL[]>();
        String string = this.path.substring(1);
        StringTokenizer stringTokenizer = new StringTokenizer(string, this.path.substring(0, 1));
        String string2 = this.makeContextDir(this.rawContextDir);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            try {
                object = new URL(string3);
                object = DynamicJavaBridgeClassLoader.checkUrl((URL)object);
            }
            catch (MalformedURLException malformedURLException) {
                try {
                    File file = null;
                    File file2 = null;
                    StringBuffer stringBuffer = new StringBuffer();
                    file = new File(string3);
                    if (file.isFile() || file.isAbsolute()) {
                        stringBuffer.append(string3);
                        file2 = file;
                    } else {
                        file = new File(string2, string3);
                        if (file.isFile()) {
                            stringBuffer.append(file.getAbsolutePath());
                            file2 = file;
                        } else {
                            file = new File("/usr/share/java/" + string3);
                            if (file.isFile()) {
                                stringBuffer.append(file.getAbsolutePath());
                                file2 = file;
                            } else {
                                file = new File(Util.JAVABRIDGE_LIB, string3);
                                if (file.isFile()) {
                                    stringBuffer.append(file.getAbsolutePath());
                                    file2 = file;
                                } else {
                                    file = JarLibraryPath.checkSearchPath(string3, this.searchpath);
                                    if (file != null) {
                                        stringBuffer.append(file.getAbsolutePath());
                                        file2 = file;
                                    } else if (this.cwd != null && (file = new File(this.cwd, string3)).isFile()) {
                                        stringBuffer.append(file.getAbsolutePath());
                                        file2 = file;
                                    } else {
                                        stringBuffer.append(string3);
                                        file2 = new File(string3);
                                    }
                                }
                            }
                        }
                    }
                    if (file2 != null && file2.isDirectory()) {
                        DynamicJavaBridgeClassLoader.addJars(linkedList, file);
                        int n = stringBuffer.length();
                        if (n > 0) {
                            if (stringBuffer.charAt(n - 1) == File.separatorChar) {
                                stringBuffer.setCharAt(n - 1, '/');
                            } else if (stringBuffer.charAt(n - 1) != '/') {
                                stringBuffer.append('/');
                            }
                        }
                    }
                    if (!file2.isDirectory()) {
                        DynamicJavaBridgeClassLoader.checkJarFile(file2);
                    }
                    object = new URL("file", null, stringBuffer.toString());
                }
                catch (MalformedURLException malformedURLException2) {
                    Util.printStackTrace(malformedURLException2);
                    continue;
                }
            }
            linkedList.add((URL[])object);
        }
        object = new URL[linkedList.size()];
        linkedList.toArray((T[])object);
        return object;
    }

    public String getPath() {
        return this.path;
    }

    public void addToCache() {
        if (!this.isCached) {
            urlCache.put(this, this.urls);
            this.urls = null;
        }
    }
}

