/*
 * Decompiled with CFR 0.152.
 */
package php.java.bridge;

import java.io.UnsupportedEncodingException;
import php.java.bridge.JavaBridge;
import php.java.bridge.Util;

final class ParserString {
    protected byte[] string;
    protected int off;
    protected int length;
    private JavaBridge bridge;
    static final byte[] digits = new byte[]{127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 127, 127, 127, 127, 127, 127, 127, 10, 11, 12, 13, 14, 15, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 10, 11, 12, 13, 14, 15};

    protected ParserString(JavaBridge javaBridge) {
        this.bridge = javaBridge;
    }

    public String getUTF8StringValue() {
        try {
            return new String(this.string, this.off, this.length, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Util.printStackTrace(unsupportedEncodingException);
            return new String(this.string, this.off, this.length);
        }
    }

    public String getStringValue() {
        return this.bridge.getString(this.string, this.off, this.length);
    }

    public String getCachedStringValue() {
        return this.bridge.getCachedString(this.string, this.off, this.length);
    }

    public String getASCIIStringValue() {
        return this.bridge.stringCache.getString(this.string, this.off, this.length, "ASCII");
    }

    public int getClassicIntValue() {
        int n;
        if (this.length == 0) {
            return 0;
        }
        int n2 = this.off;
        int n3 = this.length;
        int n4 = 0;
        if (this.string[n2] == 45) {
            ++n2;
            n = -1;
        } else if (this.string[n2] == 43) {
            ++n2;
            --n3;
            n = 1;
        } else {
            n = 1;
        }
        int n5 = 1;
        while (true) {
            int n6 = --n3;
            --n3;
            if (n6 <= 0) break;
            n4 += (this.string[n2 + n3] - 48) * n5;
            n5 *= 10;
        }
        return n4 * n;
    }

    public long getClassicLongValue() {
        long l;
        if (this.length == 0) {
            return 0L;
        }
        int n = this.off;
        int n2 = this.length;
        long l2 = 0L;
        if (this.string[n] == 45) {
            ++n;
            l = -1L;
        } else if (this.string[n] == 43) {
            ++n;
            --n2;
            l = 1L;
        } else {
            l = 1L;
        }
        long l3 = 1L;
        while (true) {
            int n3 = --n2;
            --n2;
            if (n3 <= 0) break;
            l2 += (long)(this.string[n + n2] - 48) * l3;
            l3 *= 10L;
        }
        return l2 * l;
    }

    public int getIntValue() {
        if (this.length == 0) {
            return 0;
        }
        int n = 0;
        int n2 = 0;
        byte[] byArray = this.string;
        int n3 = this.off;
        while (true) {
            n += digits[byArray[n3++]];
            if (++n2 == this.length) break;
            n <<= 4;
        }
        return n;
    }

    public long getLongValue() {
        if (this.length == 0) {
            return 0L;
        }
        long l = 0L;
        int n = 0;
        byte[] byArray = this.string;
        int n2 = this.off;
        while (true) {
            l += (long)digits[byArray[n2++]];
            if (++n == this.length) break;
            l <<= 4;
        }
        return l;
    }

    public double getDoubleValue() {
        return Double.parseDouble(this.getASCIIStringValue());
    }

    public String toString() {
        return "{" + this.getUTF8StringValue() + " @:" + String.valueOf(this.off) + " l:" + String.valueOf(this.length) + "}";
    }
}

