/*
 * Decompiled with CFR 0.152.
 */
package php.java.bridge;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import php.java.bridge.Base64EncodingOutputBuffer;
import php.java.bridge.HexOutputBuffer;
import php.java.bridge.JavaBridge;
import php.java.bridge.PhpExactNumber;
import php.java.bridge.PhpString;
import php.java.bridge.Request;
import php.java.bridge.Util;

public final class Response {
    public static final int VALUES_WRITER = 1;
    public static final int COERCE_WRITER = 2;
    static final byte[] append_for_OutBuf_getFirstBytes = new byte[]{46, 46, 46};
    static final byte[] append_none_for_OutBuf_getFirstBytes = new byte[0];
    static final byte[] digits = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
    protected HexOutputBuffer buf;
    long peer;
    protected JavaBridge bridge;
    private boolean hasLastAsyncException;
    private boolean hasLastAsyncExceptionSet;
    static final String MSG = "FATAL: UNDECLARED RuntimeException PASSED TO PHP.";
    private Writer defaultWriter;
    private Writer writer;
    private Writer currentWriter;
    private Writer arrayValuesWriter = null;
    private Writer arrayValueWriter = null;
    private Writer coerceWriter = null;
    private Writer asyncWriter = null;
    private Writer asyncVoidWriter = null;
    private Writer objectWriter = null;
    static final byte[] e = "\"/>".getBytes();
    static final byte[] c = "\">".getBytes();
    static final byte[] I = "\" i=\"".getBytes();
    static final byte[] S = "<S v=\"".getBytes();
    static final byte[] B = "<B v=\"".getBytes();
    static final byte[] L = "<L v=\"".getBytes();
    static final byte[] D = "<D v=\"".getBytes();
    static final byte[] E = "<E v=\"".getBytes();
    static final byte[] O = "<O v=\"".getBytes();
    static final byte[] N = "<N i=\"".getBytes();
    static final byte[] V = "<V i=\"".getBytes();
    static final byte[] Nul = "<N />".getBytes();
    static final byte[] VoidF = "<V n=\"F\"/>".getBytes();
    static final byte[] VoidT = "<V n=\"T\"/>".getBytes();
    static final byte[] m = "\" m=\"".getBytes();
    static final byte[] mT = "\" m=\"T".getBytes();
    static final byte[] mF = "\" m=\"F".getBytes();
    static final byte[] n = "\" n=\"".getBytes();
    static final byte[] nT = "\" n=\"T".getBytes();
    static final byte[] nF = "\" n=\"F".getBytes();
    static final byte[] p = "\" p=\"".getBytes();
    static final byte[] pa = "\" p=\"A".getBytes();
    static final byte[] pc = "\" p=\"C".getBytes();
    static final byte[] pe = "\" p=\"E".getBytes();
    static final byte[] po = "\" p=\"O".getBytes();
    static final byte[] Xa = "<X t=\"A".getBytes();
    static final byte[] Xh = "<X t=\"H".getBytes();
    static final byte[] Xe = "</X>".getBytes();
    static final byte[] A = "<A v=\"".getBytes();
    static final byte[] Ae = "</A>".getBytes();
    static final byte[] P = "<P>".getBytes();
    static final byte[] Pn = "<P t=\"N\" v=\"".getBytes();
    static final byte[] Ps = "<P t=\"S\" v=\"".getBytes();
    static final byte[] Pe = "</P>".getBytes();
    static final byte[] FA = "<F p=\"A\"/>".getBytes();
    static final byte[] Fa = "<F p=\"a\"/>".getBytes();
    static final byte[] FE = "<F p=\"E\"/>".getBytes();
    static final byte[] Fe = "<F p=\"e\"/>".getBytes();
    static final byte[] quote = "&quot;".getBytes();
    static final byte[] amp = "&amp;".getBytes();
    static /* synthetic */ Class class$php$java$bridge$Request$PhpNull;
    static /* synthetic */ Class class$java$lang$String;

    protected final Object wrapUndeclared(Throwable throwable, boolean bl) {
        if (bl) {
            return throwable;
        }
        this.bridge.warn("FATAL: UNDECLARED RuntimeException PASSED TO PHP. " + throwable);
        return new UndeclaredThrowableErrorMarker(throwable);
    }

    private DelegateWriter getDefaultDelegate() {
        return new ArrayWriter();
    }

    private Writer getDefaultWriter() {
        if (this.bridge.options.preferValues()) {
            DefaultWriter defaultWriter = new DefaultWriter();
            defaultWriter.delegate = this.getDefaultDelegate();
            return defaultWriter;
        }
        return this.getDefaultObjectWriter();
    }

    protected HexOutputBuffer createBase64OutputBuffer() {
        return new Base64OutputBuffer(this.bridge);
    }

    protected HexOutputBuffer createOutputBuffer() {
        if (this.bridge.options.base64Data()) {
            return this.createBase64OutputBuffer();
        }
        return new HexOutputBuffer(this.bridge);
    }

    public Response(JavaBridge javaBridge) {
        this.bridge = javaBridge;
        this.buf = this.createOutputBuffer();
        this.writer = this.defaultWriter = this.getDefaultWriter();
        this.currentWriter = this.defaultWriter;
    }

    protected Response(JavaBridge javaBridge, HexOutputBuffer hexOutputBuffer) {
        this.bridge = javaBridge;
        this.buf = hexOutputBuffer;
        this.writer = this.defaultWriter = this.getDefaultWriter();
        this.currentWriter = this.defaultWriter;
    }

    public Response copyResponse() throws IOException {
        this.flush();
        return new Response(this.bridge, this.buf);
    }

    public void setResultProcedure(long l, String string, String string2, Object[] objectArray) {
        this.writer.setResultProcedure(l, string, string2, objectArray);
    }

    public void setResultException(Throwable throwable, boolean bl) {
        this.writer.setResultException(throwable, bl);
    }

    public void setResultClass(Class clazz) {
        this.writer.setResultClass(clazz);
    }

    public void setResult(Object object, Class clazz, boolean bl) {
        this.writer.setResult(object, clazz, bl);
    }

    public boolean isAsync() {
        return this.writer.isAsync();
    }

    protected void setFinish(boolean bl) {
        if (!this.hasLastAsyncExceptionSet) {
            this.hasLastAsyncException = this.bridge.lastAsyncException != null;
        }
        this.setDefaultWriter();
        this.writer.setFinish(bl);
        this.hasLastAsyncExceptionSet = false;
        this.hasLastAsyncException = false;
    }

    protected Writer setArrayValueWriter() {
        this.writer = this.getArrayValueWriter();
        return this.writer;
    }

    Writer setArrayValuesWriter() {
        this.writer = this.getArrayValuesWriter();
        return this.writer;
    }

    Writer setCoerceWriter() {
        this.writer = this.getCoerceWriter();
        return this.writer;
    }

    public Writer setAsyncWriter() {
        this.writer = this.getAsyncWriter();
        return this.writer;
    }

    public Writer setAsyncVoidWriter() {
        this.writer = this.getAsyncVoidWriter();
        return this.writer;
    }

    public Writer setObjectWriter() {
        this.currentWriter = this.getObjectWriter();
        return this.currentWriter;
    }

    public Writer setDefaultWriter() {
        this.writer = this.currentWriter = this.defaultWriter;
        return this.currentWriter;
    }

    protected void setID(long l) {
    }

    void writeString(byte[] byArray) {
        this.buf.appendString(byArray);
        this.buf.append(e);
    }

    void writeString(String string) {
        this.writeString(this.bridge.options.getBytes(string));
    }

    void writeBoolean(boolean bl) {
        this.buf.append(B);
        this.buf.write(bl ? 84 : 70);
        this.buf.append(e);
    }

    void writeLong(long l) {
        this.buf.appendLong(l);
        this.buf.append(e);
    }

    void writeDouble(double d) {
        this.buf.append(D);
        this.buf.append(d);
        this.buf.append(e);
    }

    void writeVoid(boolean bl) {
        this.buf.append(bl ? VoidT : VoidF);
    }

    void writeVoid() {
        this.buf.append(VoidT);
    }

    void writeNull() {
        this.buf.append(Nul);
    }

    protected byte[] getType(Class clazz) {
        if (clazz.isArray() || List.class.isAssignableFrom(clazz) || Map.class.isAssignableFrom(clazz)) {
            return pa;
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            return pc;
        }
        if (Throwable.class.isAssignableFrom(clazz)) {
            return pe;
        }
        return po;
    }

    void writeObject(Object object, boolean bl) {
        if (object == null) {
            this.writeNull();
            return;
        }
        Class<?> clazz = object.getClass();
        this.buf.append(O);
        this.buf.append(this.bridge.globalRef.append(object));
        this.buf.append(m);
        this.buf.append(Util.toBytes(clazz.getName()));
        this.buf.append(this.getType(clazz));
        this.buf.append(bl ? nT : nF);
        this.buf.append(e);
    }

    void writeObject(Object object) {
        if (object == null) {
            this.writeNull();
            return;
        }
        Class<?> clazz = object.getClass();
        this.buf.append(O);
        this.buf.append(this.bridge.globalRef.append(object));
        this.buf.append(m);
        this.buf.append(Util.toBytes(clazz.getName()));
        this.buf.append(this.getType(clazz));
        this.buf.append(nT);
        this.buf.append(e);
    }

    void writeClass(Class clazz, boolean bl) {
        if (clazz == null) {
            this.writeNull();
            return;
        }
        this.buf.append(O);
        this.buf.append(this.bridge.globalRef.append(clazz));
        this.buf.append(m);
        this.buf.append(Util.toBytes(clazz.getName()));
        this.buf.append(po);
        this.buf.append(bl ? nT : nF);
        this.buf.append(e);
    }

    void writeClass(Class clazz) {
        if (clazz == null) {
            this.writeNull();
            return;
        }
        this.buf.append(O);
        this.buf.append(this.bridge.globalRef.append(clazz));
        this.buf.append(m);
        this.buf.append(Util.toBytes(clazz.getName()));
        this.buf.append(po);
        this.buf.append(nT);
        this.buf.append(e);
    }

    void writeException(Object object, boolean bl) {
        this.buf.append(E);
        this.buf.append(this.bridge.globalRef.append(object));
        this.buf.append(bl ? mT : mF);
        this.buf.append(e);
    }

    void writeFinish(boolean bl) {
        if (this.hasLastAsyncException) {
            this.buf.append(bl ? Fa : Fe);
        } else {
            this.buf.append(bl ? FA : FE);
        }
    }

    void writeCompositeBegin_a() {
        this.buf.append(Xa);
        this.buf.append(c);
    }

    void writeCompositeBegin_h() {
        this.buf.append(Xh);
        this.buf.append(c);
    }

    void writeCompositeEnd() {
        this.buf.append(Xe);
    }

    void writePairBegin_s(String string) {
        this.buf.append(Ps);
        this.buf.appendQuoted(string);
        this.buf.append(c);
    }

    void writePairBegin_n(int n) {
        this.buf.append(Pn);
        this.buf.append(n);
        this.buf.append(c);
    }

    void writePairBegin() {
        this.buf.append(P);
    }

    void writePairEnd() {
        this.buf.append(Pe);
    }

    void writeApplyBegin(long l, String string, String string2, int n) {
        this.buf.append(A);
        this.buf.append(l);
        this.buf.append(p);
        this.buf.appendQuoted(string);
        this.buf.append(m);
        this.buf.appendQuoted(string2);
        this.buf.append(Response.n);
        this.buf.append(n);
        this.buf.append(c);
    }

    void writeApplyEnd() {
        this.buf.append(Ae);
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    protected void reset() {
        this.writer.reset();
    }

    protected void setBridge(JavaBridge javaBridge) {
        this.bridge = javaBridge;
    }

    protected void recycle() {
        this.hasLastAsyncException = this.bridge.lastAsyncException != null;
        this.hasLastAsyncExceptionSet = true;
        this.reset();
        this.setDefaultWriter();
    }

    public String toString() {
        return this.newString(this.buf.getFirstBytes());
    }

    private String newString(byte[] byArray) {
        return this.bridge.getString(byArray, 0, byArray.length);
    }

    private Writer getArrayValuesWriter() {
        if (this.arrayValuesWriter == null) {
            ClassicWriter classicWriter = new ClassicWriter();
            classicWriter.delegate = new ArrayValuesWriter();
            this.arrayValuesWriter = classicWriter;
        }
        return this.arrayValuesWriter;
    }

    private Writer getArrayValueWriter() {
        if (this.arrayValueWriter == null) {
            ArrayValueWriter arrayValueWriter = new ArrayValueWriter();
            arrayValueWriter.delegate = new ArrayValuesWriter();
            this.arrayValueWriter = arrayValueWriter;
        }
        return this.arrayValueWriter;
    }

    private Writer getCoerceWriter() {
        if (this.coerceWriter == null) {
            this.coerceWriter = new CoerceWriter();
            return this.coerceWriter;
        }
        return this.coerceWriter;
    }

    private Writer getDefaultObjectWriter() {
        if (this.objectWriter == null) {
            this.objectWriter = new DefaultObjectWriter();
            return this.objectWriter;
        }
        return this.objectWriter;
    }

    private Writer getObjectWriter() {
        if (this.objectWriter == null) {
            this.objectWriter = new ObjectWriter();
            return this.objectWriter;
        }
        return this.objectWriter;
    }

    private Writer getAsyncWriter() {
        if (this.asyncWriter == null) {
            this.asyncWriter = new AsyncWriter();
            return this.asyncWriter;
        }
        return this.asyncWriter;
    }

    private Writer getAsyncVoidWriter() {
        if (this.asyncVoidWriter == null) {
            this.asyncVoidWriter = new AsyncVoidWriter();
            return this.asyncVoidWriter;
        }
        return this.asyncVoidWriter;
    }

    protected final class CoerceWriter
    extends Writer {
        protected CoerceWriter() {
        }

        public void setResult(Object object, Class clazz, boolean bl) {
            this.setResult(object);
        }

        public boolean setResult(Object object) {
            if (object instanceof PhpString) {
                object = ((PhpString)object).getString();
            }
            if (this.staticType.isPrimitive()) {
                if (this.staticType == Boolean.TYPE) {
                    if (object instanceof Boolean) {
                        Response.this.writeBoolean((Boolean)object);
                    } else if (object == null) {
                        Response.this.writeBoolean(false);
                    } else if (object instanceof byte[]) {
                        Response.this.writeBoolean(((byte[])object).length != 0);
                    } else if (object instanceof String) {
                        Response.this.writeBoolean(((String)object).length() != 0);
                    } else if (object instanceof PhpString) {
                        Response.this.writeBoolean(((PhpString)object).getBytes().length != 0);
                    } else if (object instanceof Number) {
                        if (object instanceof Integer || object instanceof Short || object instanceof Byte) {
                            Response.this.writeBoolean(((Number)object).longValue() != 0L);
                        } else {
                            Response.this.writeBoolean(((Number)object).doubleValue() != 0.0);
                        }
                    } else {
                        Response.this.writeBoolean(true);
                    }
                } else if (this.staticType == Byte.TYPE || this.staticType == Short.TYPE || this.staticType == Integer.TYPE || this.staticType == Long.TYPE) {
                    if (object instanceof Number) {
                        Response.this.writeLong(((Number)object).longValue());
                    } else {
                        try {
                            Response.this.writeLong(new Long(Util.stringValueOf(object)));
                        }
                        catch (NumberFormatException numberFormatException) {
                            Response.this.writeLong(0L);
                        }
                    }
                } else if (this.staticType == Float.TYPE || this.staticType == Double.TYPE) {
                    if (object instanceof Number) {
                        Response.this.writeDouble(((Number)object).doubleValue());
                    } else {
                        try {
                            Response.this.writeDouble(new Double(Util.stringValueOf(object)));
                        }
                        catch (NumberFormatException numberFormatException) {
                            Response.this.writeDouble(0.0);
                        }
                    }
                } else if (this.staticType == Character.TYPE) {
                    Response.this.writeString(Util.stringValueOf(object));
                } else if (this.staticType == Void.TYPE) {
                    Response.this.writeVoid();
                } else {
                    Util.logFatal("Unknown type");
                    Response.this.writeObject(object);
                }
            } else if (this.staticType == (class$java$lang$String == null ? (class$java$lang$String = Response.class$("java.lang.String")) : class$java$lang$String)) {
                if (object instanceof byte[]) {
                    Response.this.writeString((byte[])object);
                } else {
                    Response.this.writeString(Util.stringValueOf(object));
                }
            } else {
                Response.this.writeObject(object);
            }
            return true;
        }
    }

    protected final class AsyncVoidWriter
    extends Writer {
        protected AsyncVoidWriter() {
        }

        public boolean isAsync() {
            return true;
        }

        public void setResultProcedure(long l, String string, String string2, Object[] objectArray) {
            throw new IllegalStateException("Cannot call " + string2 + ": callbacks not allowed in stream mode");
        }

        public void setResultException(Throwable throwable, boolean bl) {
            this.hasDeclaredExceptions = bl;
            Response.this.bridge.lastAsyncException = throwable;
            Response.this.wrapUndeclared(Response.this.bridge.lastAsyncException, bl);
        }

        public void setResultObject(Object object) {
        }

        public void setResultClass(Class clazz) {
        }

        public boolean setResult(Object object) {
            return true;
        }

        public void flush() throws IOException {
            if (Response.this.bridge.logLevel >= 4) {
                Response.this.bridge.logDebug(" |<- <NONE>");
            }
            this.reset();
        }
    }

    protected final class AsyncWriter
    extends Writer {
        protected AsyncWriter() {
        }

        public boolean isAsync() {
            return true;
        }

        public void setResultException(Throwable throwable, boolean bl) {
            this.hasDeclaredExceptions = bl;
            Response.this.bridge.lastAsyncException = throwable;
            this.setResultObject(Response.this.wrapUndeclared(Response.this.bridge.lastAsyncException, bl));
        }

        public void setResultObject(Object object) {
            if (this.staticType == Void.TYPE) {
                throw new IllegalStateException("Use the AsyncVoidWriter instead");
            }
            if (object == null) {
                object = Request.PHPNULL;
            }
            if (Response.this.bridge.logLevel >= 4) {
                Response.this.writeObject(object);
            } else {
                Response.this.bridge.globalRef.append(object);
            }
        }

        public void setResultClass(Class clazz) {
            if (clazz == null) {
                Class clazz2 = clazz = class$php$java$bridge$Request$PhpNull == null ? (class$php$java$bridge$Request$PhpNull = Response.class$("php.java.bridge.Request$PhpNull")) : class$php$java$bridge$Request$PhpNull;
            }
            if (Response.this.bridge.logLevel >= 4) {
                Response.this.writeClass(clazz);
            } else {
                Response.this.bridge.globalRef.append(clazz);
            }
        }

        public boolean setResult(Object object) {
            this.setResultObject(object);
            return true;
        }

        public void flush() throws IOException {
            if (Response.this.bridge.logLevel >= 4) {
                Response.this.bridge.logDebug(" |<- " + Response.this.newString(Response.this.buf.getFirstBytes()));
            }
            this.reset();
        }
    }

    protected final class ObjectWriter
    extends DefaultObjectWriter {
        protected ObjectWriter() {
        }

        public void setResultException(Throwable throwable, boolean bl) {
            this.hasDeclaredExceptions = bl;
            Response.this.bridge.lastAsyncException = throwable;
            this.setResultObject(Response.this.wrapUndeclared(Response.this.bridge.lastAsyncException, bl));
        }
    }

    protected class DefaultObjectWriter
    extends Writer {
        protected DefaultObjectWriter() {
        }

        public void setResultObject(Object object) {
            if (this.staticType == Void.TYPE) {
                Response.this.writeVoid(this.hasDeclaredExceptions);
                return;
            }
            if (object == null) {
                object = Request.PHPNULL;
            }
            Response.this.writeObject(object, this.hasDeclaredExceptions);
        }

        public void setResultClass(Class clazz) {
            if (clazz == null) {
                clazz = class$php$java$bridge$Request$PhpNull == null ? (class$php$java$bridge$Request$PhpNull = Response.class$("php.java.bridge.Request$PhpNull")) : class$php$java$bridge$Request$PhpNull;
            }
            Response.this.writeClass(clazz, this.hasDeclaredExceptions);
        }

        public boolean setResult(Object object) {
            this.setResultObject(object);
            return true;
        }
    }

    protected class ArrayValueWriter
    extends IncompleteArrayValueWriter {
        protected ArrayValueWriter() {
        }

        public void setResult(Object object, Class clazz, boolean bl) {
            if (!this.delegate.setResult(object)) {
                this.setResultArray(object);
            }
        }

        public boolean setResult(Object object) {
            if (!super.setResult(object)) {
                Response.this.writeObject(object);
            }
            return true;
        }

        private boolean setResultArray(Object object) {
            Response.this.writeCompositeBegin_a();
            Response.this.writePairBegin();
            this.setResult(object);
            Response.this.writePairEnd();
            Response.this.writeCompositeEnd();
            return true;
        }
    }

    protected class DefaultWriter
    extends WriterWithDelegate {
        protected DefaultWriter() {
        }

        public boolean setResult(Object object) {
            if (this.staticType.isPrimitive()) {
                if (this.staticType == Boolean.TYPE) {
                    Response.this.writeBoolean((Boolean)object);
                } else if (this.staticType == Byte.TYPE || this.staticType == Short.TYPE || this.staticType == Integer.TYPE) {
                    Response.this.writeLong(((Number)object).longValue());
                } else if (this.staticType == Long.TYPE) {
                    Response.this.writeDouble(((Number)object).doubleValue());
                } else if (this.staticType == Float.TYPE || this.staticType == Double.TYPE) {
                    Response.this.writeDouble(((Number)object).doubleValue());
                } else if (this.staticType == Character.TYPE) {
                    Response.this.writeString(Util.stringValueOf(object));
                } else if (this.staticType == Void.TYPE) {
                    Response.this.writeVoid();
                } else {
                    Util.logFatal("Unknown type");
                    Response.this.writeObject(object);
                }
            } else if (object instanceof PhpString) {
                if (object == null) {
                    Response.this.writeNull();
                } else {
                    Response.this.writeString(((PhpString)object).getBytes());
                }
            } else if (!this.delegate.setResult(object)) {
                Response.this.writeObject(object);
            }
            return true;
        }
    }

    protected class ClassicWriter
    extends IncompleteClassicWriter {
        protected ClassicWriter() {
        }

        public boolean setResult(Object object) {
            if (super.setResult(object)) {
                return true;
            }
            if (!this.delegate.setResult(object)) {
                Response.this.writeObject(object);
            }
            return true;
        }
    }

    protected abstract class IncompleteArrayValueWriter
    extends WriterWithDelegate {
        protected IncompleteArrayValueWriter() {
        }

        public boolean setResult(Object object) {
            if (object == null) {
                Response.this.writeNull();
            } else if (object instanceof PhpString) {
                Response.this.writeString(((PhpString)object).getBytes());
            } else if (object instanceof PhpExactNumber) {
                Response.this.writeLong(((PhpExactNumber)object).longValue());
            } else {
                return false;
            }
            return true;
        }
    }

    protected abstract class IncompleteClassicWriter
    extends WriterWithDelegate {
        protected IncompleteClassicWriter() {
        }

        public boolean setResult(Object object) {
            if (object == null) {
                Response.this.writeNull();
            } else if (object instanceof byte[]) {
                Response.this.writeString((byte[])object);
            } else if (object instanceof String) {
                Response.this.writeString((String)object);
            } else if (object instanceof PhpString) {
                Response.this.writeString(((PhpString)object).getBytes());
            } else if (object instanceof Number) {
                if (object instanceof Integer || object instanceof Short || object instanceof Byte) {
                    Response.this.writeLong(((Number)object).longValue());
                } else {
                    Response.this.writeDouble(((Number)object).doubleValue());
                }
            } else if (object instanceof Boolean) {
                Response.this.writeBoolean((Boolean)object);
            } else {
                return false;
            }
            return true;
        }
    }

    protected class ArrayValuesWriter
    extends DelegateWriter {
        protected ArrayValuesWriter() {
        }

        public boolean setResult(Object object) {
            if (object.getClass().isArray()) {
                long l = Array.getLength(object);
                Response.this.writeCompositeBegin_a();
                int n = 0;
                while ((long)n < l) {
                    Response.this.writePairBegin();
                    Response.this.writer.setResult(Array.get(object, n));
                    Response.this.writePairEnd();
                    ++n;
                }
                Response.this.writeCompositeEnd();
            } else if (object instanceof Map) {
                Map map = (Map)object;
                Response.this.writeCompositeBegin_h();
                Iterator iterator = map.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    Object k = entry.getKey();
                    Object v = entry.getValue();
                    if (k instanceof Number && !(k instanceof Double) && !(k instanceof Float)) {
                        Response.this.writePairBegin_n(((Number)k).intValue());
                        Response.this.writer.setResult(v);
                    } else {
                        Response.this.writePairBegin_s(String.valueOf(k));
                        Response.this.writer.setResult(map.get(k));
                    }
                    Response.this.writePairEnd();
                }
                Response.this.writeCompositeEnd();
            } else if (object instanceof Collection) {
                Collection collection = (Collection)object;
                Response.this.writeCompositeBegin_h();
                int n = 0;
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    Response.this.writePairBegin_n(n++);
                    Response.this.writer.setResult(e);
                    Response.this.writePairEnd();
                }
                Response.this.writeCompositeEnd();
            } else {
                return false;
            }
            return true;
        }
    }

    protected class ArrayWriter
    extends DelegateWriter {
        protected ArrayWriter() {
        }

        public boolean setResult(Object object) {
            return false;
        }
    }

    protected abstract class WriterWithDelegate
    extends Writer {
        protected DelegateWriter delegate;

        protected WriterWithDelegate() {
        }

        public void setType(Class clazz) {
            super.setType(clazz);
            this.delegate.setType(clazz);
        }
    }

    protected abstract class Writer
    extends DelegateWriter {
        protected boolean hasDeclaredExceptions;

        protected Writer() {
        }

        public boolean isAsync() {
            return false;
        }

        public void setResultProcedure(long l, String string, String string2, Object[] objectArray) {
            int n = objectArray == null ? 0 : objectArray.length;
            Response.this.writeApplyBegin(l, string, string2, n);
            for (int i = 0; i < n; ++i) {
                Response.this.writePairBegin();
                this.setResult(objectArray[i], objectArray[i].getClass(), true);
                Response.this.writePairEnd();
            }
            Response.this.writeApplyEnd();
        }

        public void setResultException(Throwable throwable, boolean bl) {
            this.hasDeclaredExceptions = bl;
            Response.this.writeException(Response.this.wrapUndeclared(throwable, bl), bl);
        }

        public void setResultObject(Object object) {
            Response.this.writeObject(object);
        }

        public void setResultClass(Class clazz) {
            Response.this.writeClass(clazz);
        }

        public void setResult(Object object, Class clazz, boolean bl) {
            this.hasDeclaredExceptions = bl;
            this.setType(clazz);
            this.setResult(object);
        }

        public void setFinish(boolean bl) {
            Response.this.writeFinish(bl);
        }

        public void reset() {
            Response.this.writer = Response.this.currentWriter;
            Response.this.buf.reset();
        }

        public void flush() throws IOException {
            if (Response.this.bridge.logLevel >= 4) {
                Response.this.bridge.logDebug(" <-- " + Response.this.newString(Response.this.buf.getFirstBytes()));
            }
            Response.this.buf.writeTo(Response.this.bridge.out);
            this.reset();
        }
    }

    protected abstract class DelegateWriter {
        protected Class staticType;

        protected DelegateWriter() {
        }

        public abstract boolean setResult(Object var1);

        public void setType(Class clazz) {
            this.staticType = clazz;
        }
    }

    private static final class UndeclaredThrowableErrorMarker
    extends RuntimeException {
        private static final long serialVersionUID = -578332461418889089L;
        private Throwable e;

        public UndeclaredThrowableErrorMarker(Throwable throwable) {
            this.e = throwable;
        }

        public String toString() {
            return "FATAL: UNDECLARED RuntimeException PASSED TO PHP. " + String.valueOf(this.e);
        }

        public Throwable getCause() {
            return this.e;
        }
    }

    private class Base64OutputBuffer
    extends Base64EncodingOutputBuffer {
        Base64OutputBuffer(JavaBridge javaBridge) {
            super(javaBridge);
        }

        protected void appendQuoted(byte[] byArray) {
            this.appendBase64(byArray);
        }
    }
}

