/*
 * Decompiled with CFR 0.152.
 */
package php.java.bridge.http;

import php.java.bridge.AppThreadPool;
import php.java.bridge.DynamicClassLoader;
import php.java.bridge.SessionFactory;
import php.java.bridge.Util;
import php.java.bridge.http.AbstractChannelName;
import php.java.bridge.http.ContextFactory;
import php.java.bridge.http.IContextFactory;
import php.java.bridge.http.PipeContextServer;
import php.java.bridge.http.SocketContextServer;

public final class ContextServer
implements ContextFactory.ICredentials {
    private PipeContextServer ctx;
    private String contextName;
    private static SocketContextServer sock = null;
    private static AppThreadPool pool;

    private static synchronized AppThreadPool getAppThreadPool() {
        if (pool != null) {
            return pool;
        }
        pool = new AppThreadPool("JavaBridgeContextRunner", Integer.parseInt(Util.THREAD_POOL_MAX_SIZE));
        return pool;
    }

    public ContextServer(String string) {
        this.contextName = string;
        this.ctx = new PipeContextServer(this, ContextServer.getAppThreadPool(), string);
    }

    private static final synchronized void destroyContextServer() {
        if (sock != null) {
            sock.destroy();
        }
        sock = null;
        ContextFactory.destroyAll();
        SessionFactory.destroyTimer();
        DynamicClassLoader.destroyObserver();
        if (pool != null) {
            pool.destroy();
        }
        pool = null;
        Util.destroy();
    }

    public void destroy() {
        this.ctx.destroy();
        ContextServer.destroyContextServer();
    }

    public boolean isAvailable(String string) {
        if (string != null && this.ctx.isAvailable()) {
            return true;
        }
        SocketContextServer socketContextServer = ContextServer.getSocketContextServer(this, ContextServer.getAppThreadPool());
        return socketContextServer != null && socketContextServer.isAvailable();
    }

    private static synchronized SocketContextServer getSocketContextServer(ContextServer contextServer, AppThreadPool appThreadPool) {
        if (sock != null) {
            return sock;
        }
        sock = new SocketContextServer(appThreadPool);
        return sock;
    }

    public void start(AbstractChannelName abstractChannelName) {
        boolean bl = abstractChannelName.start();
        if (!bl) {
            throw new IllegalStateException("Pipe- and SocketContextServer not available");
        }
    }

    public AbstractChannelName getFallbackChannelName(String string, IContextFactory iContextFactory) {
        if (string != null && this.ctx.isAvailable()) {
            return new PipeChannelName(string, iContextFactory);
        }
        SocketContextServer socketContextServer = ContextServer.getSocketContextServer(this, ContextServer.getAppThreadPool());
        return socketContextServer.isAvailable() ? new SocketChannelName(socketContextServer.getChannelName(), iContextFactory) : null;
    }

    public ContextFactory.ICredentials getCredentials(String string) {
        if (string != null && this.ctx.isAvailable()) {
            return this;
        }
        return ContextFactory.NO_CREDENTIALS;
    }

    public String toString() {
        return "ContextServer: " + this.contextName;
    }

    private class SocketChannelName
    extends AbstractChannelName {
        public SocketChannelName(String string, IContextFactory iContextFactory) {
            super(string, iContextFactory);
        }

        public boolean startChannel() {
            return sock.start(this);
        }

        public String toString() {
            return "Socket:" + this.getName();
        }
    }

    private class PipeChannelName
    extends AbstractChannelName {
        public PipeChannelName(String string, IContextFactory iContextFactory) {
            super(string, iContextFactory);
        }

        public boolean startChannel() {
            return ContextServer.this.ctx.start(this);
        }

        public String toString() {
            return "Pipe:" + this.getName();
        }
    }
}

