/*
 * Decompiled with CFR 0.152.
 */
package php.java.script;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Map;
import php.java.bridge.Util;
import php.java.script.ResultProxy;

abstract class CGIRunner
extends Thread {
    protected Map env;
    protected OutputStream out;
    protected OutputStream err;
    protected Reader reader;
    protected Util.HeaderParser headerParser;
    private ScriptLock scriptLock = new ScriptLock();
    private Lock phpScript = new Lock();
    private ResultProxy resultProxy;
    private Writer writer;

    protected CGIRunner(String string, Reader reader, Map map, OutputStream outputStream, OutputStream outputStream2, Util.HeaderParser headerParser, ResultProxy resultProxy) {
        super(string);
        this.reader = reader;
        this.env = map;
        this.out = outputStream;
        this.err = outputStream2;
        this.headerParser = headerParser;
        this.resultProxy = resultProxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.doRun();
        }
        catch (IOException iOException) {
            Util.printStackTrace((Throwable)iOException);
            this.phpScript.val = iOException;
        }
        catch (Util.Process.PhpException phpException) {
            this.phpScript.val = (Object)phpException;
        }
        catch (Exception exception) {
            Util.printStackTrace((Throwable)exception);
        }
        finally {
            this.phpScript.finish();
            this.scriptLock.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRun() throws IOException, Util.Process.PhpException {
        Util.Process process = Util.ProcessWithErrorHandler.start((String[])Util.getPhpArgs((String[])new String[]{null}), null, (Map)this.env, (boolean)true, (boolean)true, (OutputStream)this.err);
        InputStream inputStream = null;
        try {
            inputStream = process.getInputStream();
            OutputStream outputStream = process.getOutputStream();
            this.writer = new BufferedWriter(new OutputStreamWriter(outputStream));
            new Thread(){

                public void doRun() throws IOException {
                    int n;
                    char[] cArray = new char[8192];
                    while ((n = CGIRunner.this.reader.read(cArray)) != -1) {
                        CGIRunner.this.writer.write(cArray, 0, n);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        this.doRun();
                    }
                    catch (IOException iOException) {
                        Util.printStackTrace((Throwable)iOException);
                    }
                    finally {
                        try {
                            CGIRunner.this.writer.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }.start();
            byte[] byArray = new byte[8192];
            Util.parseBody((byte[])byArray, (InputStream)inputStream, (Util.OutputStreamFactory)new Util.OutputStreamFactory(){

                public OutputStream getOutputStream() throws IOException {
                    return CGIRunner.this.out;
                }
            }, (Util.HeaderParser)this.headerParser);
            process.waitFor();
            this.resultProxy.setResult(process.exitValue());
        }
        catch (IOException iOException) {
            Util.printStackTrace((Throwable)iOException);
            throw iOException;
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            try {
                process.destroy();
            }
            catch (Exception exception) {
                Util.printStackTrace((Throwable)exception);
            }
        }
        process.checkError();
    }

    public synchronized void call(Object object) throws InterruptedException {
        this.phpScript.setVal(object);
        this.wait();
    }

    public Object getPhpScript() throws Exception {
        Object object = this.phpScript.getVal();
        if (object instanceof Exception) {
            throw (Exception)object;
        }
        return object;
    }

    private synchronized void releaseContinuation() {
        this.notify();
    }

    public void release() throws InterruptedException {
        this.releaseContinuation();
        this.scriptLock.waitForRunner();
    }

    protected class Lock {
        private Object val = null;
        private boolean finish = false;

        protected Lock() {
        }

        public synchronized Object getVal() {
            if (!this.finish && this.val == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
            return this.val;
        }

        public synchronized void setVal(Object object) {
            this.val = object;
            this.notify();
        }

        public synchronized void finish() {
            this.finish = true;
            this.notify();
        }
    }

    private static class ScriptLock {
        private boolean running = true;

        private ScriptLock() {
        }

        public synchronized void waitForRunner() throws InterruptedException {
            if (this.running) {
                this.wait();
            }
        }

        public synchronized void finish() {
            this.running = false;
            this.notify();
        }
    }
}

