/*
 * Decompiled with CFR 0.152.
 */
package php.java.bridge;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import php.java.bridge.Base64EncodingOutputBuffer;
import php.java.bridge.HexOutputBuffer;
import php.java.bridge.JavaBridge;
import php.java.bridge.PhpExactNumber;
import php.java.bridge.PhpString;
import php.java.bridge.Request;
import php.java.bridge.Util;

public final class Response {
    public static final int VALUES_WRITER = 1;
    public static final int COERCE_WRITER = 2;
    static final byte[] append_for_OutBuf_getFirstBytes = new byte[]{46, 46, 46};
    static final byte[] append_none_for_OutBuf_getFirstBytes = new byte[0];
    protected HexOutputBuffer buf;
    long peer;
    protected JavaBridge bridge;
    private boolean hasLastAsyncException;
    private boolean hasLastAsyncExceptionSet;
    static final String MSG = "FATAL: Undeclared java.lang.RuntimeException detected.";
    private Writer defaultWriter;
    private Writer writer;
    private Writer currentWriter;
    private Writer arrayValuesWriter = null;
    private Writer arrayValueWriter = null;
    private Writer coerceWriter = null;
    private Writer asyncWriter = null;
    private Writer asyncVoidWriter = null;
    private Writer objectWriter = null;
    static final byte[] e = "\"/>".getBytes();
    static final byte[] c = "\">".getBytes();
    static final byte[] I = "\" i=\"".getBytes();
    static final byte[] S = "<S v=\"".getBytes();
    static final byte[] B = "<B v=\"".getBytes();
    static final byte[] L = "<L v=\"".getBytes();
    static final byte[] D = "<D v=\"".getBytes();
    static final byte[] E = "<E v=\"".getBytes();
    static final byte[] O = "<O v=\"".getBytes();
    static final byte[] N = "<N i=\"".getBytes();
    static final byte[] V = "<V i=\"".getBytes();
    static final byte[] Nul = "<N />".getBytes();
    static final byte[] VoidF = "<V n=\"F\"/>".getBytes();
    static final byte[] VoidT = "<V n=\"T\"/>".getBytes();
    static final byte[] m = "\" m=\"".getBytes();
    static final byte[] mT = "\" m=\"T".getBytes();
    static final byte[] mF = "\" m=\"F".getBytes();
    static final byte[] n = "\" n=\"".getBytes();
    static final byte[] nT = "\" n=\"T".getBytes();
    static final byte[] nF = "\" n=\"F".getBytes();
    static final byte[] p = "\" p=\"".getBytes();
    static final byte[] pa = "\" p=\"A".getBytes();
    static final byte[] pc = "\" p=\"C".getBytes();
    static final byte[] pe = "\" p=\"E".getBytes();
    static final byte[] po = "\" p=\"O".getBytes();
    static final byte[] Xa = "<X t=\"A".getBytes();
    static final byte[] Xh = "<X t=\"H".getBytes();
    static final byte[] Xe = "</X>".getBytes();
    static final byte[] A = "<A v=\"".getBytes();
    static final byte[] Ae = "</A>".getBytes();
    static final byte[] P = "<P>".getBytes();
    static final byte[] Pn = "<P t=\"N\" v=\"".getBytes();
    static final byte[] Ps = "<P t=\"S\" v=\"".getBytes();
    static final byte[] Pe = "</P>".getBytes();
    static final byte[] FA = "<F p=\"A\"/>".getBytes();
    static final byte[] Fa = "<F p=\"a\"/>".getBytes();
    static final byte[] FE = "<F p=\"E\"/>".getBytes();
    static final byte[] Fe = "<F p=\"e\"/>".getBytes();
    static final byte[] quote = "&quot;".getBytes();
    static final byte[] amp = "&amp;".getBytes();
    static /* synthetic */ Class class$php$java$bridge$Request$PhpNull;
    static /* synthetic */ Class class$java$lang$String;

    protected final Object wrapUndeclared(Throwable o, boolean hasDeclaredExceptions) {
        if (hasDeclaredExceptions || this.bridge.options.preferValues()) {
            return o;
        }
        this.bridge.setLastAsyncException(o);
        this.bridge.warn("FATAL: Undeclared java.lang.RuntimeException detected. " + o);
        return new UndeclaredThrowableErrorMarker(o);
    }

    private DelegateWriter getDefaultDelegate() {
        return new ArrayWriter();
    }

    private Writer getDefaultWriter() {
        if (this.bridge.options.preferValues()) {
            DefaultWriter writer = new DefaultWriter();
            writer.delegate = this.getDefaultDelegate();
            return writer;
        }
        return this.getDefaultObjectWriter();
    }

    protected HexOutputBuffer createBase64OutputBuffer() {
        return new Base64OutputBuffer(this.bridge);
    }

    protected HexOutputBuffer createOutputBuffer() {
        if (this.bridge.options.base64Data()) {
            return this.createBase64OutputBuffer();
        }
        return new HexOutputBuffer(this.bridge);
    }

    public Response(JavaBridge bridge) {
        this.bridge = bridge;
        this.buf = this.createOutputBuffer();
        this.writer = this.defaultWriter = this.getDefaultWriter();
        this.currentWriter = this.defaultWriter;
    }

    protected Response(JavaBridge bridge, HexOutputBuffer buf) {
        this.bridge = bridge;
        this.buf = buf;
        this.writer = this.defaultWriter = this.getDefaultWriter();
        this.currentWriter = this.defaultWriter;
    }

    public Response copyResponse() throws IOException {
        this.flush();
        return new Response(this.bridge, this.buf);
    }

    public void setResultProcedure(long object, String cname, String name, Object[] args) {
        this.writer.setResultProcedure(object, cname, name, args);
    }

    public void setResultException(Throwable value, boolean hasDeclaredExceptions) {
        this.writer.setResultException(value, hasDeclaredExceptions);
    }

    public void setResultClass(Class value) {
        this.writer.setResultClass(value);
    }

    public void setResult(Object value, Class type, boolean hasDeclaredExceptions) {
        this.writer.setResult(value, type, hasDeclaredExceptions);
    }

    public boolean isAsync() {
        return this.writer.isAsync();
    }

    protected void setFinish(boolean keepAlive) {
        if (!this.hasLastAsyncExceptionSet) {
            this.hasLastAsyncException = this.bridge.lastAsyncException != null;
        }
        this.setDefaultWriter();
        this.writer.setFinish(keepAlive);
        this.hasLastAsyncExceptionSet = false;
        this.hasLastAsyncException = false;
    }

    protected Writer setArrayValueWriter() {
        this.writer = this.getArrayValueWriter();
        return this.writer;
    }

    Writer setArrayValuesWriter() {
        this.writer = this.getArrayValuesWriter();
        return this.writer;
    }

    Writer setCoerceWriter() {
        this.writer = this.getCoerceWriter();
        return this.writer;
    }

    public Writer setAsyncWriter() {
        this.writer = this.getAsyncWriter();
        return this.writer;
    }

    public Writer setAsyncVoidWriter() {
        this.writer = this.getAsyncVoidWriter();
        return this.writer;
    }

    public Writer setObjectWriter() {
        this.currentWriter = this.getObjectWriter();
        return this.currentWriter;
    }

    public Writer setDefaultWriter() {
        this.writer = this.currentWriter = this.defaultWriter;
        return this.currentWriter;
    }

    protected void setID(long id) {
    }

    void writeString(byte[] s) {
        this.buf.appendString(s);
        this.buf.append(e);
    }

    void writeString(String s) {
        this.writeString(this.bridge.options.getBytes(s));
    }

    void writeBoolean(boolean b) {
        this.buf.append(B);
        this.buf.write(b ? 84 : 70);
        this.buf.append(e);
    }

    void writeLong(long l) {
        this.buf.appendLong(l);
        this.buf.append(e);
    }

    void writeDouble(double d) {
        this.buf.append(D);
        this.buf.append(d);
        this.buf.append(e);
    }

    void writeVoid(boolean hasDeclaredExceptions) {
        this.buf.append(hasDeclaredExceptions ? VoidT : VoidF);
    }

    void writeVoid() {
        this.buf.append(VoidT);
    }

    void writeNull() {
        this.buf.append(Nul);
    }

    protected byte[] getType(Class type) {
        if (type.isArray() || List.class.isAssignableFrom(type) || Map.class.isAssignableFrom(type)) {
            return pa;
        }
        if (Collection.class.isAssignableFrom(type)) {
            return pc;
        }
        if (Throwable.class.isAssignableFrom(type)) {
            return pe;
        }
        return po;
    }

    void writeObject(Object o, boolean hasDeclaredExceptions) {
        if (o == null) {
            this.writeNull();
            return;
        }
        Class<?> dynamicType = o.getClass();
        this.buf.append(O);
        this.buf.append(this.bridge.globalRef.append(o));
        this.buf.append(m);
        this.buf.append(Util.toBytes(dynamicType.getName()));
        this.buf.append(this.getType(dynamicType));
        this.buf.append(hasDeclaredExceptions ? nT : nF);
        this.buf.append(e);
    }

    void writeObject(Object o) {
        if (o == null) {
            this.writeNull();
            return;
        }
        Class<?> dynamicType = o.getClass();
        this.buf.append(O);
        this.buf.append(this.bridge.globalRef.append(o));
        this.buf.append(m);
        this.buf.append(Util.toBytes(dynamicType.getName()));
        this.buf.append(this.getType(dynamicType));
        this.buf.append(nT);
        this.buf.append(e);
    }

    void writeClass(Class o, boolean hasDeclaredExceptions) {
        if (o == null) {
            this.writeNull();
            return;
        }
        this.buf.append(O);
        this.buf.append(this.bridge.globalRef.append(o));
        this.buf.append(m);
        this.buf.append(Util.toBytes(o.getName()));
        this.buf.append(po);
        this.buf.append(hasDeclaredExceptions ? nT : nF);
        this.buf.append(e);
    }

    void writeClass(Class o) {
        if (o == null) {
            this.writeNull();
            return;
        }
        this.buf.append(O);
        this.buf.append(this.bridge.globalRef.append(o));
        this.buf.append(m);
        this.buf.append(Util.toBytes(o.getName()));
        this.buf.append(po);
        this.buf.append(nT);
        this.buf.append(e);
    }

    void writeException(Object o, boolean hasDeclaredExceptions) {
        this.buf.append(E);
        this.buf.append(this.bridge.globalRef.append(o));
        this.buf.append(hasDeclaredExceptions ? mT : mF);
        this.buf.append(e);
    }

    void writeFinish(boolean keepAlive) {
        if (this.hasLastAsyncException) {
            this.buf.append(keepAlive ? Fa : Fe);
        } else {
            this.buf.append(keepAlive ? FA : FE);
        }
    }

    void writeCompositeBegin_a() {
        this.buf.append(Xa);
        this.buf.append(c);
    }

    void writeCompositeBegin_h() {
        this.buf.append(Xh);
        this.buf.append(c);
    }

    void writeCompositeEnd() {
        this.buf.append(Xe);
    }

    void writePairBegin_s(String key) {
        this.buf.append(Ps);
        this.buf.appendQuoted(key);
        this.buf.append(c);
    }

    void writePairBegin_n(int key) {
        this.buf.append(Pn);
        this.buf.append(key);
        this.buf.append(c);
    }

    void writePairBegin() {
        this.buf.append(P);
    }

    void writePairEnd() {
        this.buf.append(Pe);
    }

    void writeApplyBegin(long object, String pos, String str, int argCount) {
        this.buf.append(A);
        this.buf.append(object);
        this.buf.append(p);
        this.buf.appendQuoted(pos);
        this.buf.append(m);
        this.buf.appendQuoted(str);
        this.buf.append(n);
        this.buf.append(argCount);
        this.buf.append(c);
    }

    void writeApplyEnd() {
        this.buf.append(Ae);
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    protected void reset() {
        this.writer.reset();
    }

    protected void setBridge(JavaBridge bridge) {
        this.bridge = bridge;
    }

    protected void recycle() {
        this.hasLastAsyncException = this.bridge.lastAsyncException != null;
        this.hasLastAsyncExceptionSet = true;
        this.reset();
        this.setDefaultWriter();
    }

    public String toString() {
        return this.newString(this.buf.getFirstBytes());
    }

    private String newString(byte[] b) {
        return this.bridge.getString(b, 0, b.length);
    }

    private Writer getArrayValuesWriter() {
        if (this.arrayValuesWriter == null) {
            ClassicWriter writer = new ClassicWriter();
            writer.delegate = new ArrayValuesWriter();
            this.arrayValuesWriter = writer;
        }
        return this.arrayValuesWriter;
    }

    private Writer getArrayValueWriter() {
        if (this.arrayValueWriter == null) {
            ArrayValueWriter writer = new ArrayValueWriter();
            writer.delegate = new ArrayValuesWriter();
            this.arrayValueWriter = writer;
        }
        return this.arrayValueWriter;
    }

    private Writer getCoerceWriter() {
        if (this.coerceWriter == null) {
            this.coerceWriter = new CoerceWriter();
            return this.coerceWriter;
        }
        return this.coerceWriter;
    }

    private Writer getDefaultObjectWriter() {
        if (this.objectWriter == null) {
            this.objectWriter = new DefaultObjectWriter();
            return this.objectWriter;
        }
        return this.objectWriter;
    }

    private Writer getObjectWriter() {
        if (this.objectWriter == null) {
            this.objectWriter = new ObjectWriter();
            return this.objectWriter;
        }
        return this.objectWriter;
    }

    private Writer getAsyncWriter() {
        if (this.asyncWriter == null) {
            this.asyncWriter = new AsyncWriter();
            return this.asyncWriter;
        }
        return this.asyncWriter;
    }

    private Writer getAsyncVoidWriter() {
        if (this.asyncVoidWriter == null) {
            this.asyncVoidWriter = new AsyncVoidWriter();
            return this.asyncVoidWriter;
        }
        return this.asyncVoidWriter;
    }

    protected final class CoerceWriter
    extends Writer {
        protected CoerceWriter() {
        }

        public void setResult(Object value, Class resultType, boolean hasDeclaredExceptions) {
            this.setResult(value);
        }

        public boolean setResult(Object value) {
            if (value instanceof PhpString) {
                value = ((PhpString)value).getString();
            }
            if (this.staticType.isPrimitive()) {
                if (this.staticType == Boolean.TYPE) {
                    if (value instanceof Boolean) {
                        Response.this.writeBoolean((Boolean)value);
                    } else if (value == null) {
                        Response.this.writeBoolean(false);
                    } else if (value instanceof byte[]) {
                        Response.this.writeBoolean(((byte[])value).length != 0);
                    } else if (value instanceof String) {
                        Response.this.writeBoolean(((String)value).length() != 0);
                    } else if (value instanceof PhpString) {
                        Response.this.writeBoolean(((PhpString)value).getBytes().length != 0);
                    } else if (value instanceof Number) {
                        if (value instanceof Integer || value instanceof Short || value instanceof Byte) {
                            Response.this.writeBoolean(((Number)value).longValue() != 0L);
                        } else {
                            Response.this.writeBoolean(((Number)value).doubleValue() != 0.0);
                        }
                    } else {
                        Response.this.writeBoolean(true);
                    }
                } else if (this.staticType == Byte.TYPE || this.staticType == Short.TYPE || this.staticType == Integer.TYPE || this.staticType == Long.TYPE) {
                    if (value instanceof Number) {
                        Response.this.writeLong(((Number)value).longValue());
                    } else {
                        try {
                            Response.this.writeLong(new Long(Util.stringValueOf(value)));
                        }
                        catch (NumberFormatException n) {
                            Response.this.writeLong(0L);
                        }
                    }
                } else if (this.staticType == Float.TYPE || this.staticType == Double.TYPE) {
                    if (value instanceof Number) {
                        Response.this.writeDouble(((Number)value).doubleValue());
                    } else {
                        try {
                            Response.this.writeDouble(new Double(Util.stringValueOf(value)));
                        }
                        catch (NumberFormatException n) {
                            Response.this.writeDouble(0.0);
                        }
                    }
                } else if (this.staticType == Character.TYPE) {
                    Response.this.writeString(Util.stringValueOf(value));
                } else if (this.staticType == Void.TYPE) {
                    Response.this.writeVoid();
                } else {
                    Util.logFatal("Unknown type");
                    Response.this.writeObject(value);
                }
            } else if (this.staticType == (class$java$lang$String == null ? (class$java$lang$String = Response.class$("java.lang.String")) : class$java$lang$String)) {
                if (value instanceof byte[]) {
                    Response.this.writeString((byte[])value);
                } else {
                    Response.this.writeString(Util.stringValueOf(value));
                }
            } else {
                Response.this.writeObject(value);
            }
            return true;
        }
    }

    protected final class AsyncVoidWriter
    extends Writer {
        protected AsyncVoidWriter() {
        }

        public boolean isAsync() {
            return true;
        }

        public void setResultProcedure(long object, String cname, String name, Object[] args) {
            throw new IllegalStateException("Cannot call " + name + ": callbacks not allowed in stream mode");
        }

        public void setResultException(Throwable o, boolean hasDeclaredExceptions) {
            this.hasDeclaredExceptions = hasDeclaredExceptions;
            Response.this.wrapUndeclared(o, hasDeclaredExceptions);
        }

        public void setResultObject(Object value) {
        }

        public void setResultClass(Class value) {
        }

        public boolean setResult(Object value) {
            return true;
        }

        public void flush() throws IOException {
            if (Response.this.bridge.logLevel >= 4) {
                Response.this.bridge.logDebug(" |<- <NONE>");
            }
            this.reset();
        }
    }

    protected final class AsyncWriter
    extends Writer {
        protected AsyncWriter() {
        }

        public boolean isAsync() {
            return true;
        }

        public void setResultException(Throwable o, boolean hasDeclaredExceptions) {
            this.hasDeclaredExceptions = hasDeclaredExceptions;
            this.setResultObject(Response.this.wrapUndeclared(o, hasDeclaredExceptions));
        }

        public void setResultObject(Object value) {
            if (this.staticType == Void.TYPE) {
                throw new IllegalStateException("Use the AsyncVoidWriter instead");
            }
            if (value == null) {
                value = Request.PHPNULL;
            }
            if (Response.this.bridge.logLevel >= 4) {
                Response.this.writeObject(value);
            } else {
                Response.this.bridge.globalRef.append(value);
            }
        }

        public void setResultClass(Class value) {
            if (value == null) {
                Class clazz = value = class$php$java$bridge$Request$PhpNull == null ? (class$php$java$bridge$Request$PhpNull = Response.class$("php.java.bridge.Request$PhpNull")) : class$php$java$bridge$Request$PhpNull;
            }
            if (Response.this.bridge.logLevel >= 4) {
                Response.this.writeClass(value);
            } else {
                Response.this.bridge.globalRef.append(value);
            }
        }

        public boolean setResult(Object value) {
            this.setResultObject(value);
            return true;
        }

        public void flush() throws IOException {
            if (Response.this.bridge.logLevel >= 4) {
                Response.this.bridge.logDebug(" |<- " + Response.this.newString(Response.this.buf.getFirstBytes()));
            }
            this.reset();
        }
    }

    protected final class ObjectWriter
    extends DefaultObjectWriter {
        protected ObjectWriter() {
        }

        public void setResultException(Throwable o, boolean hasDeclaredExceptions) {
            this.hasDeclaredExceptions = hasDeclaredExceptions;
            this.setResultObject(Response.this.wrapUndeclared(o, hasDeclaredExceptions));
        }
    }

    protected class DefaultObjectWriter
    extends Writer {
        protected DefaultObjectWriter() {
        }

        public void setResultObject(Object value) {
            if (this.staticType == Void.TYPE) {
                Response.this.writeVoid(this.hasDeclaredExceptions);
                return;
            }
            if (value == null) {
                value = Request.PHPNULL;
            }
            Response.this.writeObject(value, this.hasDeclaredExceptions);
        }

        public void setResultClass(Class value) {
            if (value == null) {
                value = class$php$java$bridge$Request$PhpNull == null ? (class$php$java$bridge$Request$PhpNull = Response.class$("php.java.bridge.Request$PhpNull")) : class$php$java$bridge$Request$PhpNull;
            }
            Response.this.writeClass(value, this.hasDeclaredExceptions);
        }

        public boolean setResult(Object value) {
            this.setResultObject(value);
            return true;
        }
    }

    protected class ArrayValueWriter
    extends IncompleteArrayValueWriter {
        protected ArrayValueWriter() {
        }

        public void setResult(Object value, Class type, boolean hasDeclaredExceptions) {
            if (!this.delegate.setResult(value)) {
                this.setResultArray(value);
            }
        }

        public boolean setResult(Object value) {
            if (!super.setResult(value)) {
                Response.this.writeObject(value);
            }
            return true;
        }

        private boolean setResultArray(Object value) {
            Response.this.writeCompositeBegin_a();
            Response.this.writePairBegin();
            this.setResult(value);
            Response.this.writePairEnd();
            Response.this.writeCompositeEnd();
            return true;
        }
    }

    protected class DefaultWriter
    extends WriterWithDelegate {
        protected DefaultWriter() {
        }

        public boolean setResult(Object value) {
            if (this.staticType.isPrimitive()) {
                if (this.staticType == Boolean.TYPE) {
                    Response.this.writeBoolean((Boolean)value);
                } else if (this.staticType == Byte.TYPE || this.staticType == Short.TYPE || this.staticType == Integer.TYPE) {
                    Response.this.writeLong(((Number)value).longValue());
                } else if (this.staticType == Long.TYPE) {
                    Response.this.writeDouble(((Number)value).doubleValue());
                } else if (this.staticType == Float.TYPE || this.staticType == Double.TYPE) {
                    Response.this.writeDouble(((Number)value).doubleValue());
                } else if (this.staticType == Character.TYPE) {
                    Response.this.writeString(Util.stringValueOf(value));
                } else if (this.staticType == Void.TYPE) {
                    Response.this.writeVoid();
                } else {
                    Util.logFatal("Unknown type");
                    Response.this.writeObject(value);
                }
            } else if (value instanceof PhpString) {
                Response.this.writeString(((PhpString)value).getBytes());
            } else if (!this.delegate.setResult(value)) {
                Response.this.writeObject(value);
            }
            return true;
        }
    }

    protected class ClassicWriter
    extends IncompleteClassicWriter {
        protected ClassicWriter() {
        }

        public boolean setResult(Object value) {
            if (super.setResult(value)) {
                return true;
            }
            if (!this.delegate.setResult(value)) {
                Response.this.writeObject(value);
            }
            return true;
        }
    }

    protected abstract class IncompleteArrayValueWriter
    extends WriterWithDelegate {
        protected IncompleteArrayValueWriter() {
        }

        public boolean setResult(Object value) {
            if (value == null) {
                Response.this.writeNull();
            } else if (value instanceof PhpString) {
                Response.this.writeString(((PhpString)value).getBytes());
            } else if (value instanceof PhpExactNumber) {
                Response.this.writeLong(((PhpExactNumber)value).longValue());
            } else {
                return false;
            }
            return true;
        }
    }

    protected abstract class IncompleteClassicWriter
    extends WriterWithDelegate {
        protected IncompleteClassicWriter() {
        }

        public boolean setResult(Object value) {
            if (value == null) {
                Response.this.writeNull();
            } else if (value instanceof byte[]) {
                Response.this.writeString((byte[])value);
            } else if (value instanceof String) {
                Response.this.writeString((String)value);
            } else if (value instanceof PhpString) {
                Response.this.writeString(((PhpString)value).getBytes());
            } else if (value instanceof Number) {
                if (value instanceof Integer || value instanceof Short || value instanceof Byte) {
                    Response.this.writeLong(((Number)value).longValue());
                } else {
                    Response.this.writeDouble(((Number)value).doubleValue());
                }
            } else if (value instanceof Boolean) {
                Response.this.writeBoolean((Boolean)value);
            } else {
                return false;
            }
            return true;
        }
    }

    protected class ArrayValuesWriter
    extends DelegateWriter {
        protected ArrayValuesWriter() {
        }

        public boolean setResult(Object value) {
            if (value.getClass().isArray()) {
                long length = Array.getLength(value);
                Response.this.writeCompositeBegin_a();
                int i = 0;
                while ((long)i < length) {
                    Response.this.writePairBegin();
                    Response.this.writer.setResult(Array.get(value, i));
                    Response.this.writePairEnd();
                    ++i;
                }
                Response.this.writeCompositeEnd();
            } else if (value instanceof Map) {
                Map ht = (Map)value;
                Response.this.writeCompositeBegin_h();
                Iterator e = ht.entrySet().iterator();
                while (e.hasNext()) {
                    Map.Entry entry = e.next();
                    Object key = entry.getKey();
                    Object val = entry.getValue();
                    if (key instanceof Number && !(key instanceof Double) && !(key instanceof Float)) {
                        Response.this.writePairBegin_n(((Number)key).intValue());
                        Response.this.writer.setResult(val);
                    } else {
                        Response.this.writePairBegin_s(String.valueOf(key));
                        Response.this.writer.setResult(ht.get(key));
                    }
                    Response.this.writePairEnd();
                }
                Response.this.writeCompositeEnd();
            } else if (value instanceof Collection) {
                Collection ht = (Collection)value;
                Response.this.writeCompositeBegin_h();
                int counter = 0;
                Iterator e = ht.iterator();
                while (e.hasNext()) {
                    Object val = e.next();
                    Response.this.writePairBegin_n(counter++);
                    Response.this.writer.setResult(val);
                    Response.this.writePairEnd();
                }
                Response.this.writeCompositeEnd();
            } else {
                return false;
            }
            return true;
        }
    }

    protected class ArrayWriter
    extends DelegateWriter {
        protected ArrayWriter() {
        }

        public boolean setResult(Object value) {
            return false;
        }
    }

    protected abstract class WriterWithDelegate
    extends Writer {
        protected DelegateWriter delegate;

        protected WriterWithDelegate() {
        }

        public void setType(Class type) {
            super.setType(type);
            this.delegate.setType(type);
        }
    }

    protected abstract class Writer
    extends DelegateWriter {
        protected boolean hasDeclaredExceptions;

        protected Writer() {
        }

        public boolean isAsync() {
            return false;
        }

        public void setResultProcedure(long object, String cname, String name, Object[] args) {
            int argsLength = args == null ? 0 : args.length;
            Response.this.writeApplyBegin(object, cname, name, argsLength);
            for (int i = 0; i < argsLength; ++i) {
                Response.this.writePairBegin();
                this.setResult(args[i], args[i].getClass(), true);
                Response.this.writePairEnd();
            }
            Response.this.writeApplyEnd();
        }

        public void setResultException(Throwable o, boolean hasDeclaredExceptions) {
            this.hasDeclaredExceptions = hasDeclaredExceptions;
            Response.this.writeException(Response.this.wrapUndeclared(o, hasDeclaredExceptions), hasDeclaredExceptions);
        }

        public void setResultObject(Object value) {
            Response.this.writeObject(value);
        }

        public void setResultClass(Class value) {
            Response.this.writeClass(value);
        }

        public void setResult(Object value, Class type, boolean hasDeclaredExceptions) {
            this.hasDeclaredExceptions = hasDeclaredExceptions;
            this.setType(type);
            this.setResult(value);
        }

        public void setFinish(boolean keepAlive) {
            Response.this.writeFinish(keepAlive);
        }

        public void reset() {
            Response.this.writer = Response.this.currentWriter;
            Response.this.buf.reset();
        }

        public void flush() throws IOException {
            if (Response.this.bridge.logLevel >= 4) {
                Response.this.bridge.logDebug(" <-- " + Response.this.newString(Response.this.buf.getFirstBytes()));
            }
            Response.this.buf.writeTo(Response.this.bridge.out);
            Response.this.bridge.getFactory().flushBuffer();
            this.reset();
        }
    }

    protected abstract class DelegateWriter {
        protected Class staticType;

        protected DelegateWriter() {
        }

        public abstract boolean setResult(Object var1);

        public void setType(Class type) {
            this.staticType = type;
        }
    }

    private static final class UndeclaredThrowableErrorMarker
    extends RuntimeException {
        private static final long serialVersionUID = -578332461418889089L;
        private Throwable e;

        public UndeclaredThrowableErrorMarker(Throwable e) {
            this.e = e;
        }

        public String toString() {
            return "FATAL: Undeclared java.lang.RuntimeException detected. " + String.valueOf(this.e);
        }

        public Throwable getCause() {
            return this.e;
        }

        public String getMessage() {
            return this.e.getMessage();
        }

        public String getLocalizedMessage() {
            return this.e.getLocalizedMessage();
        }

        public StackTraceElement[] getStackTrace() {
            return this.e.getStackTrace();
        }
    }

    private class Base64OutputBuffer
    extends Base64EncodingOutputBuffer {
        Base64OutputBuffer(JavaBridge bridge) {
            super(bridge);
        }

        protected void appendQuoted(byte[] s) {
            this.appendBase64(s);
        }
    }
}

