/*
 * Decompiled with CFR 0.152.
 */
package php.java.bridge;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;
import php.java.bridge.AppThreadPool;
import php.java.bridge.ChainsawLogger;
import php.java.bridge.FileLogger;
import php.java.bridge.ILogger;
import php.java.bridge.JavaBridge;
import php.java.bridge.JavaBridgeRunner;
import php.java.bridge.ThreadPool;
import php.java.bridge.http.FCGIConnectionPool;

public final class Util {
    public static final ThreadPool PHP_SCRIPT_ENGINE_THREAD_POOL;
    public static FCGIConnectionPool fcgiConnectionPool;
    public static int MAX_WAIT;
    public static Class JAVA_INC;
    public static Class PHPDEBUGGER_PHP;
    public static Class JAVA_PROXY;
    public static Class LAUNCHER_UNIX;
    public static Class LAUNCHER_WINDOWS;
    public static Class LAUNCHER_WINDOWS2;
    public static Class LAUNCHER_WINDOWS3;
    public static Class LAUNCHER_WINDOWS4;
    public static final byte[] HEX_DIGITS;
    public static final boolean USE_SH_WRAPPER;
    public static final String[] ALLOW_URL_INCLUDE;
    public static final String X_JAVABRIDGE_OVERRIDE_HOSTS = "X_JAVABRIDGE_OVERRIDE_HOSTS";
    public static final String X_JAVABRIDGE_CONTEXT = "X_JAVABRIDGE_CONTEXT";
    public static final String X_JAVABRIDGE_OVERRIDE_HOSTS_REDIRECT = "X_JAVABRIDGE_OVERRIDE_HOSTS_REDIRECT";
    public static final String X_JAVABRIDGE_REDIRECT = "X_JAVABRIDGE_REDIRECT";
    public static final String X_JAVABRIDGE_INCLUDE = "X_JAVABRIDGE_INCLUDE";
    public static final String X_JAVABRIDGE_INCLUDE_ONLY = "X_JAVABRIDGE_INCLUDE_ONLY";
    private static String[] PHP_ARGS;
    private static String DEFAULT_PHP_ARGS;
    public static String[] DEFAULT_CGI_LOCATIONS;
    public static final String ASCII = "ASCII";
    public static final String UTF8 = "UTF-8";
    public static final String DEFAULT_ENCODING = "UTF-8";
    public static final int BUF_SIZE = 8192;
    public static List ENVIRONMENT_BLACKLIST;
    public static HashMap COMMON_ENVIRONMENT;
    public static final String[] DEFAULT_EXT_DIRS;
    public static final boolean IS_GNU_JAVA;
    public static String EXTENSION_NAME;
    public static String THREAD_POOL_MAX_SIZE;
    public static int DEFAULT_LOG_LEVEL;
    public static final int BACKLOG = 20;
    public static final Object[] ZERO_ARG;
    public static final Class[] ZERO_PARAM;
    public static final byte[] RN;
    public static File TMPDIR;
    public static String VM_NAME;
    public static boolean JAVABRIDGE_PROMISCUOUS;
    public static String DEFAULT_LOG_FILE;
    private static boolean DEFAULT_LOG_FILE_SET;
    public static String JAVABRIDGE_BASE;
    public static String VERSION;
    public static String osArch;
    public static String osName;
    public static String PHP_EXEC;
    public static File HOME_DIR;
    private static String sessionSavePath;
    static PrintStream logStream;
    private static ILogger defaultLogger;
    public static int logLevel;

    private Util() {
    }

    private static String getProperty(Properties p, String key, String defaultValue) {
        String s = null;
        if (p != null) {
            s = p.getProperty(key);
        }
        if (s == null) {
            s = System.getProperty("php.java.bridge." + String.valueOf(key).toLowerCase());
        }
        if (s == null) {
            s = defaultValue;
        }
        return s;
    }

    private static void initGlobals() {
        String val;
        Properties p;
        block57: {
            try {
                JAVA_INC = Class.forName("php.java.bridge.JavaInc");
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                PHPDEBUGGER_PHP = Class.forName("php.java.bridge.PhpDebuggerPHP");
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                JAVA_PROXY = Class.forName("php.java.bridge.JavaProxy");
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                LAUNCHER_UNIX = Class.forName("php.java.bridge.LauncherUnix");
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                LAUNCHER_WINDOWS = Class.forName("php.java.bridge.LauncherWindows");
                LAUNCHER_WINDOWS2 = Class.forName("php.java.bridge.LauncherWindows2");
                LAUNCHER_WINDOWS3 = Class.forName("php.java.bridge.LauncherWindows3");
                LAUNCHER_WINDOWS4 = Class.forName("php.java.bridge.LauncherWindows4");
            }
            catch (Exception e) {
                // empty catch block
            }
            p = new Properties();
            try {
                InputStream in = Util.class.getResourceAsStream("global.properties");
                p.load(in);
                VERSION = p.getProperty("BACKEND_VERSION");
            }
            catch (Throwable t) {
                VERSION = "unknown";
            }
            ENVIRONMENT_BLACKLIST = Util.getEnvironmentBlacklist(p);
            COMMON_ENVIRONMENT = Util.getCommonEnvironment(ENVIRONMENT_BLACKLIST);
            DEFAULT_CGI_LOCATIONS = new String[]{"/usr/bin/php-cgi", "c:/Program Files/PHP/php-cgi.exe"};
            try {
                if (new File(DEFAULT_CGI_LOCATIONS[0]).exists() || new File(DEFAULT_CGI_LOCATIONS[0]).exists()) break block57;
                try {
                    String programFiles;
                    File filePath = null;
                    boolean found = false;
                    String path = (String)COMMON_ENVIRONMENT.get("PATH");
                    StringTokenizer tok = new StringTokenizer(path, File.pathSeparator);
                    while (tok.hasMoreTokens()) {
                        String s = tok.nextToken();
                        filePath = new File(s, "php-cgi.exe");
                        if (filePath.exists()) {
                            found = true;
                            break;
                        }
                        filePath = new File(s, "php-cgi");
                        if (!filePath.exists()) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        filePath = new File("/usr/php/bin/php-cgi");
                        found = filePath.exists();
                    }
                    if (!found && (programFiles = (String)COMMON_ENVIRONMENT.get("ProgramFiles")) != null) {
                        filePath = new File(programFiles + "\\PHP\\php-cgi.exe");
                        found = filePath.exists();
                    }
                    if (found) {
                        DEFAULT_CGI_LOCATIONS = new String[]{filePath.getCanonicalPath(), DEFAULT_CGI_LOCATIONS[0], DEFAULT_CGI_LOCATIONS[1]};
                    }
                }
                catch (Exception e) {}
            }
            catch (Throwable xe) {
                // empty catch block
            }
        }
        try {
            MAX_WAIT = Integer.parseInt(Util.getProperty(p, "php.java.bridge.max_wait", "15000"));
        }
        catch (Exception e) {
            MAX_WAIT = 15000;
        }
        try {
            HOME_DIR = new File(System.getProperty("user.home"));
        }
        catch (Exception e) {
            HOME_DIR = null;
        }
        try {
            JAVABRIDGE_BASE = Util.getProperty(p, "php.java.bridge.base", System.getProperty("user.home"));
        }
        catch (Exception e) {
            JAVABRIDGE_BASE = ".";
        }
        try {
            VM_NAME = "unknown";
            VM_NAME = System.getProperty("java.version") + "@" + System.getProperty("java.vendor.url");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            JAVABRIDGE_PROMISCUOUS = false;
            JAVABRIDGE_PROMISCUOUS = Util.getProperty(p, "php.java.bridge.promiscuous", "false").toLowerCase().equals("true");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            THREAD_POOL_MAX_SIZE = "20";
            THREAD_POOL_MAX_SIZE = Util.getProperty(p, "THREADS", "20");
        }
        catch (Throwable t) {
            // empty catch block
        }
        TMPDIR = new File(System.getProperty("java.io.tmpdir", "/tmp"));
        if (!TMPDIR.exists() || !TMPDIR.isDirectory()) {
            TMPDIR = null;
        }
        sessionSavePath = null;
        if (TMPDIR != null) {
            try {
                TMPDIR = TMPDIR.getCanonicalFile();
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        if (TMPDIR != null) {
            sessionSavePath = TMPDIR.getPath();
        }
        DEFAULT_PHP_ARGS = "-d java.session=On -d display_errors=Off -d log_errors=On -d java.persistent_servlet_connections=On";
        try {
            String str = Util.getProperty(p, "PHP_EXEC_ARGS", DEFAULT_PHP_ARGS);
            String[] args = str.split(" ");
            for (int i = 0; i < args.length; ++i) {
                try {
                    args[i] = URLDecoder.decode(args[i], "UTF-8");
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
            PHP_ARGS = args;
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            EXTENSION_NAME = "JavaBridge";
            EXTENSION_NAME = Util.getProperty(p, "EXTENSION_DISPLAY_NAME", "JavaBridge");
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            PHP_EXEC = Util.getProperty(p, "PHP_EXEC", null);
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            String s = Util.getProperty(p, "DEFAULT_LOG_LEVEL", "3");
            logLevel = DEFAULT_LOG_LEVEL = Integer.parseInt(s);
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            DEFAULT_LOG_FILE_SET = false;
            DEFAULT_LOG_FILE = Util.getProperty(p, "DEFAULT_LOG_FILE", EXTENSION_NAME + ".log");
            DEFAULT_LOG_FILE_SET = System.getProperty("php.java.bridge.default_log_file") != null;
        }
        catch (Throwable t) {
            // empty catch block
        }
        String separator = "/-+.,;: ";
        try {
            val = System.getProperty("os.arch").toLowerCase();
            StringTokenizer t = new StringTokenizer(val, separator);
            osArch = t.nextToken();
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (osArch == null) {
            osArch = "unknown";
        }
        try {
            val = System.getProperty("os.name").toLowerCase();
            StringTokenizer t = new StringTokenizer(val, separator);
            osName = t.nextToken();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (osName == null) {
            osName = "unknown";
        }
    }

    public static void println(int level, String msg) {
        Util.getLogger().log(level, msg);
    }

    public static void warn(String msg) {
        if (logLevel <= 0) {
            return;
        }
        Util.getLogger().warn(msg);
    }

    public static void printStackTrace(Throwable t) {
        Util.getLogger().printStackTrace(t);
    }

    public static void logDebug(String msg) {
        if (logLevel > 3) {
            Util.println(4, msg);
        }
    }

    public static void logFatal(String msg) {
        if (logLevel > 0) {
            Util.println(1, msg);
        }
    }

    public static void logError(String msg) {
        if (logLevel > 1) {
            Util.println(2, msg);
        }
    }

    public static void logMessage(String msg) {
        if (logLevel > 2) {
            Util.println(3, msg);
        }
    }

    public static String getClassName(Object obj) {
        if (obj == null) {
            return "null";
        }
        Class c = Util.getClass(obj);
        String name = c.getName();
        if (name.startsWith("[")) {
            name = "array_of_" + name.substring(1);
        }
        return name;
    }

    public static String getShortClassName(Object obj) {
        String name = Util.getClassName(obj);
        int idx = name.lastIndexOf(46);
        if (idx != -1) {
            name = name.substring(idx + 1);
        }
        return name;
    }

    public static String getShortName(Class clazz) {
        int idx;
        String name = clazz.getName();
        if (name.startsWith("[")) {
            name = "array_of_" + name.substring(1);
        }
        if ((idx = name.lastIndexOf(46)) != -1) {
            name = name.substring(idx + 1);
        }
        return name;
    }

    public static Class getClass(Object obj) {
        if (obj == null) {
            return null;
        }
        return obj instanceof Class ? (Class<?>)obj : obj.getClass();
    }

    public static void appendObject(Object obj, StringBuffer buf) {
        if (obj == null) {
            buf.append("null");
            return;
        }
        if (obj instanceof Class) {
            if (((Class)obj).isInterface()) {
                buf.append("[i:");
            } else {
                buf.append("[c:");
            }
        } else {
            buf.append("[o:");
        }
        buf.append(Util.getShortClassName(obj));
        buf.append("]:");
        buf.append("\"");
        buf.append(Util.stringValueOf(obj));
        buf.append("\"");
    }

    public static void appendTrace(Throwable throwable, String trace, StringBuffer buf) {
        buf.append(" at:\n");
        StackTraceElement[] stack = throwable.getStackTrace();
        int top = stack.length;
        for (int i = 0; i < top; ++i) {
            buf.append("#-");
            buf.append(top - i);
            buf.append(" ");
            buf.append(stack[i].toString());
            buf.append("\n");
        }
        buf.append(trace);
    }

    public static void appendShortObject(Object obj, StringBuffer buf) {
        if (obj == null) {
            buf.append("null");
            return;
        }
        if (obj instanceof Class) {
            if (((Class)obj).isInterface()) {
                buf.append("[i:");
            } else {
                buf.append("[c:");
            }
        } else {
            buf.append("[o:");
        }
        buf.append(Util.getShortClassName(obj));
        buf.append("]");
    }

    public static void appendParam(Class c, StringBuffer buf) {
        if (c.isInterface()) {
            buf.append("(i:");
        } else if (c == Class.class) {
            buf.append("(c:");
        } else {
            buf.append("(o:");
        }
        buf.append(Util.getShortClassName(c));
        buf.append(")");
    }

    public static void appendParam(Object obj, StringBuffer buf) {
        if (obj instanceof Class) {
            Class c = (Class)obj;
            if (c.isInterface()) {
                buf.append("(i:");
            } else {
                buf.append("(c:");
            }
        } else {
            buf.append("(o:");
        }
        buf.append(Util.getShortClassName(obj));
        buf.append(")");
    }

    public static String argsToString(Object[] args, Class[] params) {
        StringBuffer buffer = new StringBuffer("");
        Util.appendArgs(args, params, buffer);
        return buffer.toString();
    }

    public static void appendArgs(Object[] args, Class[] params, StringBuffer buf) {
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                if (params != null) {
                    Util.appendParam(params[i], buf);
                }
                Util.appendShortObject(args[i], buf);
                if (i + 1 >= args.length) continue;
                buf.append(", ");
            }
        }
    }

    public static byte[] toBytes(String s) {
        try {
            return s.getBytes(ASCII);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return s.getBytes();
        }
    }

    public static String[] hashToStringArray(Map h) {
        Vector<String> v = new Vector<String>();
        Iterator e = h.keySet().iterator();
        while (e.hasNext()) {
            String k = e.next().toString();
            v.add(k + "=" + h.get(k));
        }
        Object[] strArr = new String[v.size()];
        v.copyInto(strArr);
        return strArr;
    }

    public static synchronized void setDefaultLogger(ILogger logger) {
        defaultLogger = logger;
    }

    public static ILogger getLogger() {
        return defaultLogger;
    }

    public static String getHostAddress(boolean promiscuous) {
        String addr = "127.0.0.1";
        try {
            if (JAVABRIDGE_PROMISCUOUS || promiscuous) {
                addr = InetAddress.getLocalHost().getHostAddress();
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return addr;
    }

    public static String[] checkCgiBinary(String php) {
        File location;
        File phpFile = new File(php);
        String path = phpFile.getParent();
        String file = phpFile.getName();
        StringBuffer buf = new StringBuffer();
        if (path != null) {
            buf.append(path);
            buf.append(File.separatorChar);
        }
        buf.append(osArch);
        buf.append("-");
        buf.append(osName);
        buf.append(File.separatorChar);
        buf.append(file);
        if (USE_SH_WRAPPER) {
            location = new File(buf.toString() + ".sh");
            if (logLevel > 3) {
                Util.logDebug("trying: " + location);
            }
            if (location.exists()) {
                return new String[]{"/bin/sh", location.getAbsolutePath()};
            }
        } else {
            location = new File(buf.toString() + ".exe");
            if (logLevel > 3) {
                Util.logDebug("trying: " + location);
            }
            if (location.exists()) {
                return new String[]{location.getAbsolutePath()};
            }
        }
        location = new File(buf.toString());
        if (logLevel > 3) {
            Util.logDebug("trying: " + location);
        }
        if (location.exists()) {
            return new String[]{location.getAbsolutePath()};
        }
        return null;
    }

    public static String checkError(String s) {
        return s.startsWith("PHP") && s.indexOf("error:") > -1 ? s : null;
    }

    static void redirectOutput(String logFile) {
        Util.redirectJavaOutput(logFile);
    }

    static void redirectJavaOutput(String logFile) {
        logStream = System.err;
        if (logFile != null && logFile.length() > 0) {
            try {
                logStream = new PrintStream(new FileOutputStream(logFile));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            System.setErr(logStream);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            System.setOut(logStream);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(9);
        }
    }

    private static List getEnvironmentBlacklist(Properties p) {
        LinkedList<String> l = new LinkedList<String>();
        try {
            String s = Util.getProperty(p, "PHP_ENV_BLACKLIST", "PHPRC");
            StringTokenizer t = new StringTokenizer(s, " ");
            while (t.hasMoreTokens()) {
                l.add(t.nextToken());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            l = new LinkedList();
            l.add("PHPRC");
        }
        return l;
    }

    private static HashMap getCommonEnvironment(List blacklist) {
        String s;
        String val;
        String[] entries = new String[]{"PATH", "PATH", "LD_LIBRARY_PATH", "LD_ASSUME_KERNEL", "USER", "TMP", "TEMP", "HOME", "HOMEPATH", "LANG", "TZ", "OS"};
        HashMap<String, String> defaultEnv = new HashMap<String, String>();
        Method m = null;
        try {
            m = System.class.getMethod("getenv", String.class);
        }
        catch (Exception e) {
            // empty catch block
        }
        for (int i = 0; i < entries.length; ++i) {
            val = null;
            if (m != null) {
                try {
                    val = (String)m.invoke((Object)(class$java$lang$System == null ? Util.class$("java.lang.System") : class$java$lang$System), (Object[])new String[]{entries[i]});
                }
                catch (Exception e) {
                    m = null;
                }
            }
            if (val == null) {
                try {
                    val = System.getProperty(entries[i]);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (val == null || blacklist.contains(entries[i])) continue;
            defaultEnv.put(entries[i], val);
        }
        val = null;
        String key = null;
        if (new File("c:/winnt").isDirectory()) {
            val = "c:\\winnt";
        } else if (new File("c:/windows").isDirectory()) {
            val = "c:\\windows";
        }
        try {
            key = "SystemRoot";
            s = System.getenv("SystemRoot");
            if (s != null) {
                val = s;
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            key = "Windows.SystemRoot";
            s = System.getProperty("Windows.SystemRoot");
            if (s != null) {
                val = s;
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (val != null && !blacklist.contains(key)) {
            defaultEnv.put("SystemRoot", val);
        }
        try {
            m = System.class.getMethod("getenv", ZERO_PARAM);
            Map map = (Map)m.invoke((Object)System.class, ZERO_ARG);
            Iterator ii = map.entrySet().iterator();
            while (ii.hasNext()) {
                Map.Entry entry = ii.next();
                key = (String)entry.getKey();
                val = (String)entry.getValue();
                if (blacklist.contains(key)) continue;
                defaultEnv.put(key, val);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return defaultEnv;
    }

    public static String stringValueOf(Object object) {
        String s = String.valueOf(object);
        if (s == null) {
            s = String.valueOf(s);
        }
        return s;
    }

    public static AppThreadPool createThreadPool(String name) {
        AppThreadPool pool = null;
        int maxSize = 20;
        try {
            maxSize = Integer.parseInt(THREAD_POOL_MAX_SIZE);
        }
        catch (Throwable t) {
            Util.printStackTrace(t);
        }
        if (maxSize > 0) {
            pool = new AppThreadPool(name, maxSize);
        }
        return pool;
    }

    static boolean setConfiguredLogger(String logFile) {
        try {
            return Util.tryConfiguredChainsawLogger(logFile);
        }
        catch (Exception e) {
            Util.printStackTrace(e);
            Util.setDefaultLogger(new FileLogger());
            return true;
        }
    }

    private static boolean tryConfiguredChainsawLogger(String logFile) throws Exception {
        if (logFile != null && logFile.length() > 0 && logFile.charAt(0) == '@') {
            logFile = logFile.substring(1, logFile.length());
            int idx = logFile.indexOf(58);
            int port = -1;
            String host = null;
            if (idx != -1) {
                String p = logFile.substring(idx + 1, logFile.length());
                if (p.length() > 0) {
                    port = Integer.parseInt(p);
                }
                host = logFile.substring(0, idx);
            } else if (logFile.length() > 0) {
                host = logFile;
            }
            ConfiguredChainsawLogger logger = ConfiguredChainsawLogger.createLogger(host, port);
            Util.setDefaultLogger(logger);
            return true;
        }
        return false;
    }

    public static String formatDateTime(long ms) {
        Timestamp t = new Timestamp(ms);
        DateFormat formatter = DateFormat.getDateTimeInstance(0, 1, Locale.ENGLISH);
        formatter.setTimeZone(TimeZone.getTimeZone("GMT"));
        String str = formatter.format(t);
        return str;
    }

    static final boolean checkVM() {
        try {
            return "libgcj".equals(System.getProperty("gnu.classpath.vm.shortname"));
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static final ClassLoader getContextClassLoader() {
        ClassLoader loader = null;
        try {
            loader = Thread.currentThread().getContextClassLoader();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (loader == null) {
            loader = JavaBridge.class.getClassLoader();
        }
        return loader;
    }

    public static final Class classForName(String name) throws ClassNotFoundException {
        return Class.forName(name, true, Util.getContextClassLoader());
    }

    public static String getSimpleRedirectString(String webPath, String socketName, boolean isSecure) {
        try {
            StringBuffer buf = new StringBuffer();
            buf.append(socketName);
            buf.append("/");
            buf.append(webPath);
            URI uri = new URI(isSecure ? "s:127.0.0.1" : "h:127.0.0.1", buf.toString(), null);
            return uri.toASCIIString() + ".phpjavabridge";
        }
        catch (URISyntaxException e) {
            Util.printStackTrace(e);
            StringBuffer buf = new StringBuffer(isSecure ? "s:127.0.0.1" : "h:127.0.0.1:");
            buf.append(socketName);
            buf.append('/');
            buf.append(webPath);
            buf.append(".phpjavabridge");
            return buf.toString();
        }
    }

    public static void destroy() {
        try {
            PHP_SCRIPT_ENGINE_THREAD_POOL.destroy();
        }
        catch (Exception e) {
            Util.printStackTrace(e);
        }
        try {
            if (fcgiConnectionPool != null) {
                fcgiConnectionPool.destroy();
            }
        }
        catch (Exception e) {
            Util.printStackTrace(e);
        }
        try {
            JavaBridgeRunner.destroyRunner();
        }
        catch (Exception e) {
            Util.printStackTrace(e);
        }
    }

    static {
        Util.initGlobals();
        PHP_SCRIPT_ENGINE_THREAD_POOL = new ThreadPool("JavaBridgeStandaloneScriptEngineProxy", Integer.parseInt(THREAD_POOL_MAX_SIZE)){

            protected ThreadPool.Delegate createDelegate(String name) {
                ThreadPool.Delegate d = super.createDelegate(name);
                d.setDaemon(true);
                return d;
            }
        };
        HEX_DIGITS = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
        USE_SH_WRAPPER = new File("/bin/sh").exists();
        ALLOW_URL_INCLUDE = new String[]{"-d", "allow_url_include=On"};
        DEFAULT_EXT_DIRS = new String[]{"/usr/share/java/ext", "/usr/java/packages/lib/ext"};
        IS_GNU_JAVA = Util.checkVM();
        ZERO_ARG = new Object[0];
        ZERO_PARAM = new Class[0];
        RN = Util.toBytes("\r\n");
        defaultLogger = new Logger(new FileLogger());
    }

    private static final class ConfiguredChainsawLogger
    extends ChainsawLogger {
        private String host;
        private int port;

        private ConfiguredChainsawLogger(String host, int port) {
            this.host = host;
            this.port = port;
        }

        public static ConfiguredChainsawLogger createLogger(String host, int port) throws Exception {
            ConfiguredChainsawLogger logger = new ConfiguredChainsawLogger(host, port);
            logger.init();
            return logger;
        }

        public void configure(String host, int port) throws Exception {
            host = this.host != null ? this.host : host;
            port = this.port > 0 ? this.port : port;
            super.configure(host, port);
        }
    }

    public static class ProcessWithErrorHandler
    extends Process {
        StringBuffer error = null;
        InputStream in = null;
        OutputStream err = null;

        protected ProcessWithErrorHandler(String[] args, boolean includeJava, String cgiDir, String pearDir, String webInfDir, File homeDir, Map env, boolean tryOtherLocations, boolean preferSystemPhp, OutputStream err) throws IOException {
            super(args, includeJava, cgiDir, pearDir, webInfDir, homeDir, env, tryOtherLocations, preferSystemPhp);
            this.err = err;
        }

        protected void start() throws IOException {
            super.start();
            new Thread("CGIErrorReader"){

                public void run() {
                    ProcessWithErrorHandler.this.readErrorStream();
                }
            }.start();
        }

        public void checkError() throws Process.PhpException {
            String errorString;
            String string = errorString = this.error == null ? null : Util.checkError(this.error.toString());
            if (errorString != null) {
                throw new Process.PhpException(errorString);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void readErrorStream() {
            byte[] buf = new byte[8192];
            try {
                int c;
                this.in = this.proc.getErrorStream();
                while ((c = this.in.read(buf)) != -1) {
                    this.err.write(buf, 0, c);
                    String s = new String(buf, 0, c, Util.ASCII);
                    if (logLevel > 4) {
                        Util.logError(s);
                    }
                    if (this.error == null) {
                        this.error = new StringBuffer(s);
                        continue;
                    }
                    this.error.append(s);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (this.in != null) {
                    try {
                        this.in.close();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
                this.notify();
            }
        }

        public synchronized int waitFor() throws InterruptedException {
            if (this.in == null) {
                this.wait();
            }
            return super.waitFor();
        }

        public static Process start(String[] args, boolean includeJava, String cgiDir, String pearDir, String webInfDir, File homeDir, Map env, boolean tryOtherLocations, boolean preferSystemPhp, OutputStream err) throws IOException {
            ProcessWithErrorHandler proc = new ProcessWithErrorHandler(args, includeJava, cgiDir, pearDir, webInfDir, homeDir, env, tryOtherLocations, preferSystemPhp, err);
            ((Process)proc).start();
            return proc;
        }
    }

    public static class Process
    extends java.lang.Process {
        protected java.lang.Process proc;
        private String[] args;
        private File homeDir;
        private Map env;
        private boolean tryOtherLocations;
        private boolean preferSystemPhp;
        private boolean isOldPhpVersion = false;
        private boolean includeJava;
        private String cgiDir;
        private String pearDir;
        private String webInfDir;

        private String getQuoted(String key, String val) {
            if (this.isOldPhpVersion) {
                return key + val;
            }
            StringBuffer buf = new StringBuffer(key);
            buf.append("'");
            buf.append(val);
            buf.append("'");
            return buf.toString();
        }

        private String[] getPhpArgs(String[] args, boolean includeJava, String cgiDir, String pearDir, String webInfDir) {
            String[] allArgs = new String[args.length + PHP_ARGS.length + (sessionSavePath != null ? 2 : 0) + (includeJava ? 1 : 0) + (cgiDir != null ? 2 : 0) + (pearDir != null ? 2 : 0) + (webInfDir != null ? 2 : 0)];
            int i = 0;
            for (i = 0; i < args.length; ++i) {
                allArgs[i] = args[i];
            }
            if (sessionSavePath != null) {
                allArgs[i++] = "-d";
                allArgs[i++] = this.getQuoted("session.save_path=", sessionSavePath);
            }
            if (cgiDir != null) {
                File extDir = new File(cgiDir, osArch + "-" + osName);
                try {
                    cgiDir = extDir.getCanonicalPath();
                }
                catch (IOException e) {
                    Util.printStackTrace(e);
                    cgiDir = extDir.getAbsolutePath();
                }
                allArgs[i++] = "-d";
                allArgs[i++] = this.getQuoted("java.os_arch_dir=", cgiDir);
            }
            if (pearDir != null) {
                allArgs[i++] = "-d";
                allArgs[i++] = this.getQuoted("java.pear_dir=", pearDir);
            }
            if (webInfDir != null) {
                allArgs[i++] = "-d";
                allArgs[i++] = this.getQuoted("java.web_inf_dir=", webInfDir);
            }
            if (includeJava) {
                allArgs[i++] = "-C";
            }
            for (int j = 0; j < PHP_ARGS.length; ++j) {
                allArgs[i++] = PHP_ARGS[j];
            }
            return allArgs;
        }

        protected String[] quoteArgs(String[] s) {
            if (!USE_SH_WRAPPER) {
                for (int j = 0; j < s.length; ++j) {
                    if (s[j] == null) continue;
                    s[j] = "\"" + s[j] + "\"";
                }
            }
            return s;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean testPhp(String[] php, String[] args) {
            block42: {
                Runtime rt = Runtime.getRuntime();
                String[] s = this.quoteArgs(this.getTestArgumentArray(php, args));
                byte[] buf = new byte[8192];
                InputStream in = null;
                OutputStream out = null;
                InputStream err = null;
                try {
                    int c;
                    this.proc = rt.exec(s, Util.hashToStringArray(this.env), this.homeDir);
                    in = this.proc.getInputStream();
                    err = this.proc.getErrorStream();
                    out = this.proc.getOutputStream();
                    out.close();
                    out = null;
                    while ((c = err.read(buf)) > 0) {
                        Util.logError(new String(buf, 0, c, Util.ASCII));
                    }
                    err.close();
                    err = null;
                    ByteArrayOutputStream outBuf = new ByteArrayOutputStream();
                    while ((c = in.read(buf)) > 0) {
                        outBuf.write(buf, 0, c);
                    }
                    in.close();
                    in = null;
                    int errCode = this.proc.waitFor();
                    int result = this.proc.exitValue();
                    if (errCode != 0 || result != 0) {
                        throw new IOException("php could not be run, returned error code: " + errCode + ", result: " + result);
                    }
                    try {
                        this.checkOldPhpVersion(outBuf);
                    }
                    catch (Throwable t) {
                        try {
                            Util.printStackTrace(t);
                            break block42;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            outBuf.close();
                        }
                    }
                    outBuf.close();
                }
                catch (IOException e) {
                    Util.logFatal("Fatal Error: Failed to start PHP " + Arrays.asList(s) + ", reason: " + e);
                    boolean bl = false;
                    return bl;
                }
                catch (InterruptedException e) {
                    boolean bl = false;
                    return bl;
                }
                finally {
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (Exception e) {}
                    try {
                        if (out != null) {
                            out.close();
                        }
                    }
                    catch (Exception e) {}
                    try {
                        if (err != null) {
                            err.close();
                        }
                    }
                    catch (Exception e) {}
                }
            }
            return true;
        }

        private void checkOldPhpVersion(ByteArrayOutputStream outBuf) {
            String ver = outBuf.toString();
            StringTokenizer tok = new StringTokenizer(ver);
            int n = tok.countTokens();
            if (n < 2) {
                return;
            }
            String[] str = new String[n];
            int i = 0;
            while (tok.hasMoreTokens()) {
                str[i] = tok.nextToken();
                ++i;
            }
            tok = new StringTokenizer(str[1], ".");
            n = tok.countTokens();
            if (n < 1) {
                return;
            }
            str = new String[n];
            i = 0;
            while (tok.hasMoreTokens()) {
                str[i] = tok.nextToken();
                ++i;
            }
            int major = Integer.parseInt(str[0]);
            if (major > 5) {
                return;
            }
            if (major == 5) {
                if (n < 2) {
                    return;
                }
                int minor = Integer.parseInt(str[1]);
                if (minor > 2) {
                    return;
                }
            }
            this.isOldPhpVersion = true;
        }

        protected void runPhp(String[] php, String[] args) throws IOException {
            Runtime rt = Runtime.getRuntime();
            String[] s = this.quoteArgs(this.getArgumentArray(php, args));
            this.proc = rt.exec(s, Util.hashToStringArray(this.env), this.homeDir);
            if (logLevel > 3) {
                Util.logDebug("Started " + Arrays.asList(s));
            }
        }

        protected String[] getTestArgumentArray(String[] php, String[] args) {
            LinkedList<String> buf = new LinkedList<String>();
            buf.addAll(Arrays.asList(php));
            buf.add("-v");
            return buf.toArray(new String[buf.size()]);
        }

        protected String[] getArgumentArray(String[] php, String[] args) {
            LinkedList<String> buf = new LinkedList<String>();
            buf.addAll(Arrays.asList(php));
            buf.addAll(Arrays.asList(ALLOW_URL_INCLUDE));
            for (int i = 1; i < args.length; ++i) {
                buf.add(args[i]);
            }
            return buf.toArray(new String[buf.size()]);
        }

        protected void start() throws NullPointerException, IOException {
            String[] php = new String[]{null};
            if (this.args == null) {
                this.args = new String[]{null};
            }
            String phpExec = this.args[0];
            String[] cgiBinary = null;
            if (PHP_EXEC == null) {
                if (!this.preferSystemPhp) {
                    if (phpExec != null && (cgiBinary = Util.checkCgiBinary(phpExec)) != null) {
                        php = cgiBinary;
                    }
                    if (this.tryOtherLocations && php[0] == null) {
                        for (int i = 0; i < DEFAULT_CGI_LOCATIONS.length; ++i) {
                            File location = new File(DEFAULT_CGI_LOCATIONS[i]);
                            if (!location.exists()) continue;
                            php[0] = location.getAbsolutePath();
                            break;
                        }
                    }
                } else {
                    if (this.tryOtherLocations && php[0] == null) {
                        for (int i = 0; i < DEFAULT_CGI_LOCATIONS.length; ++i) {
                            File location = new File(DEFAULT_CGI_LOCATIONS[i]);
                            if (!location.exists()) continue;
                            php[0] = location.getAbsolutePath();
                            break;
                        }
                    }
                    if (phpExec != null && php[0] == null && (cgiBinary = Util.checkCgiBinary(phpExec)) != null) {
                        php = cgiBinary;
                    }
                }
            }
            if (php[0] == null && this.tryOtherLocations) {
                php[0] = PHP_EXEC;
            }
            if (php[0] == null && phpExec != null && new File(phpExec).exists()) {
                php[0] = phpExec;
            }
            if (php[0] == null) {
                php[0] = "php-cgi";
            }
            if (logLevel > 3) {
                Util.logDebug("Using php binary: " + Arrays.asList(php));
            }
            if (this.homeDir != null && cgiBinary == null) {
                this.homeDir = HOME_DIR;
            }
            if (this.homeDir != null && !this.homeDir.exists()) {
                this.homeDir = null;
            }
            if (!this.testPhp(php, this.args)) {
                throw new IOException("PHP not found. Please install php-cgi. PHP test command was: " + Arrays.asList(this.getTestArgumentArray(php, this.args)) + " ");
            }
            this.runPhp(php, this.getPhpArgs(this.args, this.includeJava, this.cgiDir, this.pearDir, this.webInfDir));
        }

        protected Process(String[] args, boolean includeJava, String cgiDir, String pearDir, String webInfDir, File homeDir, Map env, boolean tryOtherLocations, boolean preferSystemPhp) {
            this.args = args;
            this.homeDir = homeDir;
            this.env = env;
            this.tryOtherLocations = tryOtherLocations;
            this.preferSystemPhp = preferSystemPhp;
            this.includeJava = includeJava;
            this.cgiDir = cgiDir;
            this.pearDir = pearDir;
            this.webInfDir = webInfDir;
        }

        public static Process start(String[] args, boolean includeJava, String cgiDir, String pearDir, String webInfDir, File homeDir, Map env, boolean tryOtherLocations, boolean preferSystemPhp, OutputStream err) throws IOException {
            Process proc = new Process(args, includeJava, cgiDir, pearDir, webInfDir, homeDir, env, tryOtherLocations, preferSystemPhp);
            proc.start();
            return proc;
        }

        public void checkError() throws PhpException {
        }

        public OutputStream getOutputStream() {
            return this.proc.getOutputStream();
        }

        public InputStream getInputStream() {
            return this.proc.getInputStream();
        }

        public InputStream getErrorStream() {
            return this.proc.getErrorStream();
        }

        public int waitFor() throws InterruptedException {
            return this.proc.waitFor();
        }

        public int exitValue() {
            return this.proc.exitValue();
        }

        public void destroy() {
            this.proc.destroy();
        }

        public static class PhpException
        extends Exception {
            private static final long serialVersionUID = 767047598257671018L;
            private String errorString;

            public PhpException(String errorString) {
                super(errorString);
                this.errorString = errorString;
            }

            public String getError() {
                return this.errorString;
            }
        }
    }

    public static class Thread
    extends java.lang.Thread {
        public Thread() {
            this.initThread();
        }

        public Thread(String name) {
            super(name);
            this.initThread();
        }

        public Thread(Runnable target) {
            super(target);
            this.initThread();
        }

        public Thread(ThreadGroup group, Runnable target) {
            super(group, target);
            this.initThread();
        }

        public Thread(ThreadGroup group, String name) {
            super(group, name);
            this.initThread();
        }

        public Thread(Runnable target, String name) {
            super(target, name);
            this.initThread();
        }

        public Thread(ThreadGroup group, Runnable target, String name) {
            super(group, target, name);
            this.initThread();
        }

        public Thread(ThreadGroup group, Runnable target, String name, long stackSize) {
            super(group, target, name, stackSize);
            this.initThread();
        }

        private void initThread() {
            this.setDaemon(true);
        }
    }

    public static class Logger
    implements ILogger {
        protected ChainsawLogger clogger = null;
        protected ILogger logger;

        public Logger() {
            this.logger = new FileLogger();
        }

        public Logger(ILogger logger) {
            this(!DEFAULT_LOG_FILE_SET, logger);
        }

        public Logger(boolean useChainsaw, ILogger logger) {
            if (useChainsaw) {
                try {
                    this.clogger = ChainsawLogger.createChainsawLogger();
                }
                catch (Throwable t) {
                    if (logLevel > 5) {
                        t.printStackTrace();
                    }
                    this.logger = logger;
                }
            } else {
                this.logger = logger;
            }
        }

        private ILogger getLogger() {
            if (this.logger == null) {
                this.logger = new FileLogger();
                return this.logger;
            }
            return this.logger;
        }

        public void printStackTrace(Throwable t) {
            if (this.clogger == null) {
                this.logger.printStackTrace(t);
            } else {
                try {
                    this.clogger.printStackTrace(t);
                }
                catch (Exception e) {
                    this.clogger = null;
                    this.getLogger().printStackTrace(t);
                }
            }
        }

        public void log(int level, String msg) {
            if (this.clogger == null) {
                this.logger.log(level, msg);
            } else {
                try {
                    this.clogger.log(level, msg);
                }
                catch (Exception e) {
                    this.clogger = null;
                    this.getLogger().log(level, msg);
                }
            }
        }

        public void warn(String msg) {
            if (this.clogger == null) {
                this.logger.warn(msg);
            } else {
                try {
                    this.clogger.warn(msg);
                }
                catch (Exception e) {
                    this.clogger = null;
                    this.getLogger().warn(msg);
                }
            }
        }
    }
}

