/*
 * Decompiled with CFR 0.152.
 */
package php.java.bridge.http;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Map;
import php.java.bridge.ILogger;
import php.java.bridge.Util;
import php.java.bridge.http.FCGIConnectException;
import php.java.bridge.http.FCGIConnection;
import php.java.bridge.http.FCGIConnectionFactory;
import php.java.bridge.http.IFCGIProcessFactory;
import php.java.bridge.http.SocketChannel;

class SocketChannelFactory
extends FCGIConnectionFactory {
    public static final String LOCAL_HOST = "127.0.0.1";
    private int port;
    private ServerSocket fcgiTestSocket = null;
    private int fcgiTestPort;

    public SocketChannelFactory(IFCGIProcessFactory processFactory, boolean promiscuous) {
        super(processFactory);
        this.promiscuous = promiscuous;
    }

    public void test() throws FCGIConnectException {
        try {
            Socket testSocket = new Socket(InetAddress.getByName(this.getName()), this.port);
            testSocket.close();
        }
        catch (IOException e) {
            if (this.lastException != null) {
                throw new FCGIConnectException(String.valueOf(e), this.lastException);
            }
            throw new FCGIConnectException(e);
        }
    }

    private Socket doConnect(String host, int port) throws FCGIConnectException {
        Socket s = null;
        try {
            s = new Socket(InetAddress.getByName(host), port);
        }
        catch (IOException e) {
            throw new FCGIConnectException(e);
        }
        try {
            s.setTcpNoDelay(true);
        }
        catch (SocketException e) {
            Util.printStackTrace(e);
        }
        return s;
    }

    public FCGIConnection connect() throws FCGIConnectException {
        Socket s = this.doConnect(this.getName(), this.getPort());
        return new SocketChannel(s);
    }

    protected void waitForDaemon() throws UnknownHostException, InterruptedException {
        long T0 = System.currentTimeMillis();
        int count = 15;
        InetAddress addr = InetAddress.getByName(LOCAL_HOST);
        if (Util.logLevel > 3) {
            Util.logDebug("Waiting for PHP FastCGI daemon");
        }
        while (count-- > 0) {
            try {
                Socket s = new Socket(addr, this.getPort());
                s.close();
                break;
            }
            catch (IOException e) {
                if (System.currentTimeMillis() - 16000L > T0) break;
                Thread.sleep(1000L);
            }
        }
        if (count == -1) {
            Util.logError("Timeout waiting for PHP FastCGI daemon");
        }
        if (Util.logLevel > 3) {
            Util.logDebug("done waiting for PHP FastCGI daemon");
        }
    }

    protected Util.Process doBind(Map env, String php, boolean includeJava) throws IOException {
        if (this.proc != null) {
            return null;
        }
        StringBuffer buf = new StringBuffer(Util.JAVABRIDGE_PROMISCUOUS || this.promiscuous ? "" : LOCAL_HOST);
        buf.append(':');
        buf.append(String.valueOf(this.getPort()));
        String port = buf.toString();
        File home = null;
        if (php != null) {
            try {
                home = new File(php).getParentFile();
            }
            catch (Exception e) {
                Util.printStackTrace(e);
            }
        }
        this.proc = this.processFactory.createFCGIProcess(new String[]{php, "-b", port}, includeJava, home, env);
        this.proc.start();
        return (Util.Process)((Object)this.proc);
    }

    protected int getPort() {
        return this.port;
    }

    protected String getName() {
        return LOCAL_HOST;
    }

    public String getFcgiStartCommand(String base, String php_fcgi_max_requests) {
        String msg = "cd " + base + File.separator + Util.osArch + "-" + Util.osName + "\n" + "REDIRECT_STATUS=200 " + "X_JAVABRIDGE_OVERRIDE_HOSTS=\"/\" " + "PHP_FCGI_CHILDREN=\"5\" " + "PHP_FCGI_MAX_REQUESTS=\"" + php_fcgi_max_requests + "\" /usr/bin/php-cgi -b 127.0.0.1:" + this.getPort() + "\n\n";
        return msg;
    }

    protected void bind(ILogger logger) throws InterruptedException, IOException {
        if (this.fcgiTestSocket != null) {
            this.fcgiTestSocket.close();
            this.fcgiTestSocket = null;
        }
        super.bind(logger);
    }

    public void findFreePort(boolean select) {
        this.fcgiTestPort = 9667;
        this.fcgiTestSocket = null;
        for (int i = 9668; select && i < 9767; ++i) {
            try {
                ServerSocket s = new ServerSocket(i, 20, InetAddress.getByName(LOCAL_HOST));
                this.fcgiTestPort = i;
                this.fcgiTestSocket = s;
                break;
            }
            catch (IOException iOException) {
                continue;
            }
        }
    }

    public void setDefaultPort() {
        this.port = 9667;
    }

    protected void setDynamicPort() {
        this.port = this.fcgiTestPort;
    }

    public void destroy() {
        super.destroy();
        if (this.fcgiTestSocket != null) {
            try {
                this.fcgiTestSocket.close();
                this.fcgiTestSocket = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String toString() {
        return "ChannelName@127.0.0.1:" + this.port;
    }
}

