/*
 * Decompiled with CFR 0.152.
 */
package php.java.bridge.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import php.java.bridge.AppThreadPool;
import php.java.bridge.ILogger;
import php.java.bridge.ISocketFactory;
import php.java.bridge.JavaBridge;
import php.java.bridge.Util;
import php.java.bridge.http.AbstractChannel;
import php.java.bridge.http.AbstractChannelName;
import php.java.bridge.http.ContextFactory;
import php.java.bridge.http.ContextRunner;
import php.java.bridge.http.IContextServer;

public final class SocketContextServer
implements Runnable,
IContextServer {
    private AppThreadPool threadPool;
    private ISocketFactory serverSocket = null;
    protected List sockets = Collections.synchronizedList(new ArrayList());
    private ILogger logger;
    private String contextName;
    public static final boolean SOCKET_SERVER_AVAIL = SocketContextServer.checkTestTunnel("php.java.bridge.no_socket_server");

    public SocketContextServer(AppThreadPool threadPool, boolean promiscuous, String contextName) {
        this.threadPool = threadPool;
        this.contextName = contextName;
        try {
            this.serverSocket = JavaBridge.bind(promiscuous ? "INET:0" : "INET_LOCAL:0");
            SecurityManager sec = System.getSecurityManager();
            if (sec != null) {
                sec.checkAccept("127.0.0.1", Integer.parseInt(this.serverSocket.getSocketName()));
            }
            Util.Thread t = new Util.Thread(this, "JavaBridgeSocketContextServer(" + this.serverSocket.getSocketName() + ")");
            t.start();
        }
        catch (Throwable t) {
            Util.warn("Local communication channel not available.");
            Util.printStackTrace(t);
            if (this.serverSocket != null) {
                try {
                    this.serverSocket.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            this.serverSocket = null;
        }
    }

    private boolean accept() {
        InputStream in = null;
        OutputStream out = null;
        Socket socket = null;
        Channel channel = null;
        try {
            try {
                socket = this.serverSocket.accept();
            }
            catch (IOException ex) {
                return false;
            }
            in = socket.getInputStream();
            out = socket.getOutputStream();
            channel = new Channel(this.getChannelName(), in, out, socket);
            ContextRunner runner = new ContextRunner(channel, this.logger);
            if (this.threadPool != null) {
                this.threadPool.start(runner);
            } else {
                Util.Thread t = new Util.Thread(runner, "JavaBridgeContextRunner(" + this.contextName + ")");
                t.start();
            }
        }
        catch (SecurityException t) {
            if (channel != null) {
                channel.shutdown();
            }
            ContextFactory.destroyAll();
            Util.printStackTrace(t);
            return false;
        }
        catch (Throwable t) {
            if (channel != null) {
                channel.shutdown();
            }
            Util.printStackTrace(t);
        }
        return true;
    }

    public void run() {
        while (this.serverSocket != null) {
            if (this.accept()) continue;
            this.destroy();
        }
        if (Util.logLevel > 4) {
            System.err.println("SocketContextServer stopped, the local channel is not available anymore.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeAllSockets() {
        List list = this.sockets;
        synchronized (list) {
            Iterator ii = this.sockets.iterator();
            while (ii.hasNext()) {
                Socket sock = (Socket)ii.next();
                ii.remove();
                try {
                    sock.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public void destroy() {
        this.closeAllSockets();
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (IOException e) {
                Util.printStackTrace(e);
            }
            this.serverSocket = null;
        }
    }

    private static boolean checkTestTunnel(String property) {
        try {
            return !"true".equals(System.getProperty(property));
        }
        catch (SecurityException e) {
            return false;
        }
        catch (Throwable t) {
            return true;
        }
    }

    public boolean isAvailable() {
        return SOCKET_SERVER_AVAIL && this.serverSocket != null;
    }

    public String getChannelName() {
        return this.serverSocket.getSocketName();
    }

    public boolean start(AbstractChannelName channelName, ILogger logger) {
        this.logger = logger;
        return this.isAvailable();
    }

    protected class Channel
    extends AbstractChannel {
        protected Socket sock;
        protected InputStream in;
        protected OutputStream out;
        protected String name;

        public Channel(String name, InputStream in, OutputStream out, Socket sock) {
            this.name = name;
            this.in = in;
            this.out = out;
            this.sock = sock;
            SocketContextServer.this.sockets.add(sock);
        }

        public String getName() {
            return this.name;
        }

        public InputStream getInputStream() {
            return this.in;
        }

        public OutputStream getOuptutStream() {
            return this.out;
        }

        public Socket getSocket() {
            return this.sock;
        }

        public void shutdown() {
            if (this.in != null) {
                try {
                    this.in.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            if (this.out != null) {
                try {
                    this.out.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            if (SocketContextServer.this.sockets.remove(this.sock)) {
                try {
                    this.sock.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }
}

