/*
 * Decompiled with CFR 0.152.
 */
package javax.script;

import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.SimpleBindings;

public class SimpleScriptContext
implements ScriptContext {
    protected Bindings globalScope;
    protected Bindings engineScope = new SimpleBindings();
    private static final List scopes = Arrays.asList(new Integer(100), new Integer(200));
    protected Writer errorWriter;
    protected Reader reader;
    protected Writer writer;

    public Object getAttribute(String name) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (this.engineScope.get(name) != null) {
            return this.engineScope.get(name);
        }
        if (this.globalScope.get(name) != null) {
            return this.globalScope.get(name);
        }
        return null;
    }

    public Object getAttribute(String name, int scope) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        switch (scope) {
            case 100: {
                return this.engineScope.get(name);
            }
            case 200: {
                return this.globalScope.get(name);
            }
        }
        throw new IllegalArgumentException("invalid scope");
    }

    public int getAttributesScope(String name) {
        if (this.engineScope.containsKey(name)) {
            return 100;
        }
        if (this.globalScope.containsKey(name)) {
            return 200;
        }
        return -1;
    }

    public Bindings getBindings(int scope) {
        switch (scope) {
            case 100: {
                return this.engineScope;
            }
            case 200: {
                return this.globalScope;
            }
        }
        return null;
    }

    public Object removeAttribute(String name, int scope) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        switch (scope) {
            case 100: {
                return this.engineScope.remove(name);
            }
            case 200: {
                return this.globalScope.remove(name);
            }
        }
        throw new IllegalArgumentException("invalid scope");
    }

    public void setAttribute(String name, Object value, int scope) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        switch (scope) {
            case 100: {
                this.engineScope.put(name, value);
                break;
            }
            case 200: {
                this.globalScope.put(name, value);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid scope");
            }
        }
    }

    public void setBindings(Bindings namespace, int scope) throws IllegalArgumentException {
        switch (scope) {
            case 100: {
                this.engineScope = namespace;
                break;
            }
            case 200: {
                this.globalScope = namespace;
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid scope");
            }
        }
    }

    public List getScopes() {
        return scopes;
    }

    public Writer getErrorWriter() {
        if (this.errorWriter == null) {
            this.errorWriter = new PrintWriter(System.err, true);
            return this.errorWriter;
        }
        return this.errorWriter;
    }

    public void setErrorWriter(Writer writer) {
        this.errorWriter = writer;
    }

    public Reader getReader() {
        if (this.reader == null) {
            return new InputStreamReader(System.in);
        }
        return this.reader;
    }

    public void setReader(Reader reader) {
        this.reader = reader;
    }

    public Writer getWriter() {
        if (this.writer == null) {
            this.writer = new PrintWriter(System.out, true);
        }
        return this.writer;
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }
}

