/*
 * Decompiled with CFR 0.152.
 */
package php.java.bridge.http;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import php.java.bridge.NotImplementedException;

public class HttpRequest {
    private HashMap headers;
    private String method;
    private String uri;
    private InputStream in;
    private byte[] buf;
    private int bufStart = 0;
    private int bufEnd = 0;
    private int contentLength = -1;
    private int count = 0;

    public HttpRequest(InputStream inputStream) {
        this.in = new HttpInputStream(new BufferedInputStream(inputStream));
        this.headers = new HashMap();
    }

    public String getHeader(String string) {
        return (String)this.headers.get(string);
    }

    public String getMethod() {
        return this.method;
    }

    public String getRequestURI() {
        return this.uri;
    }

    public InputStream getInputStream() {
        return this.in;
    }

    public void pushBack(byte[] buf, int start, int length) {
        this.buf = buf;
        this.bufStart = start;
        this.bufEnd = length + start;
    }

    public void addHeader(String line) {
        block3: {
            try {
                this.headers.put(line.substring(0, line.indexOf(":")).trim(), line.substring(line.indexOf(":") + 1).trim());
            }
            catch (StringIndexOutOfBoundsException e) {
                int i1 = -1;
                int i2 = -1;
                i1 = line.indexOf(32);
                if (i1 != -1) {
                    this.method = line.substring(0, i1).trim().toUpperCase().intern();
                    i2 = line.indexOf(32, i1 + 1);
                }
                if (i2 <= i1) break block3;
                this.uri = line.substring(i1 + 1, i2);
            }
        }
    }

    public void setContentLength(int contentLength) {
        this.count = 0;
        this.contentLength = contentLength;
    }

    public void close() throws IOException {
        try {
            if (this.in != null) {
                this.in.close();
            }
        }
        finally {
            this.in = null;
        }
    }

    private class HttpInputStream
    extends InputStream {
        private InputStream in;

        public HttpInputStream(InputStream in) {
            this.in = in;
        }

        public int read() throws IOException {
            throw new NotImplementedException();
        }

        public int read(byte[] b, int start, int length) throws IOException {
            if (HttpRequest.this.contentLength > -1 && HttpRequest.this.count == HttpRequest.this.contentLength) {
                return -1;
            }
            if (HttpRequest.this.bufStart != HttpRequest.this.bufEnd) {
                if (HttpRequest.this.bufEnd - HttpRequest.this.bufStart < length) {
                    length = HttpRequest.this.bufEnd - HttpRequest.this.bufStart;
                }
                System.arraycopy(HttpRequest.this.buf, HttpRequest.this.bufStart, b, start, length);
                HttpRequest.this.bufStart = HttpRequest.this.bufStart + length;
                HttpRequest.this.count = HttpRequest.this.count + length;
                return length;
            }
            int n = this.in.read(b, start, length);
            HttpRequest.this.count = HttpRequest.this.count + n;
            return n;
        }

        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }
    }
}

