/*
 * Decompiled with CFR 0.152.
 */
package php.java.bridge.parser;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import php.java.bridge.parser.PhpArray;

public final class ConstructorCache {
    Map map;
    static final Entry noCache = new NoCache();

    private void init() {
        this.map = new HashMap();
    }

    public ConstructorCache() {
        this.init();
    }

    public Constructor get(Entry entry) {
        if (entry == noCache) {
            return null;
        }
        CachedConstructor cache = (CachedConstructor)this.map.get(entry);
        if (cache == null) {
            return null;
        }
        entry.setMethod(cache);
        return cache.get();
    }

    public void put(Entry entry, Constructor method) {
        if (entry != noCache) {
            CachedConstructor cache = new CachedConstructor(method);
            entry.setMethod(cache);
            this.map.put(entry, cache);
        }
    }

    public Entry getEntry(String name, Object[] args) {
        Class[] params = new Class[args.length];
        int i = 0;
        while (i < args.length) {
            Class<?> c;
            Class<?> clazz = c = args[i] == null ? null : args[i].getClass();
            if (c == PhpArray.class) {
                return noCache;
            }
            params[i] = c;
            ++i;
        }
        return new Entry(name, params);
    }

    public void clear() {
        this.init();
    }

    private static class CachedConstructor {
        private Constructor method;
        private Class[] typeCache;

        public CachedConstructor(Constructor method) {
            this.method = method;
        }

        public Constructor get() {
            return this.method;
        }

        public Class[] getParameterTypes() {
            if (this.typeCache != null) {
                return this.typeCache;
            }
            this.typeCache = this.method.getParameterTypes();
            return this.typeCache;
        }
    }

    public static class Entry {
        String name;
        Class[] params;
        private boolean hasResult = false;
        private int result = 1;
        private CachedConstructor cache;

        protected Entry() {
        }

        protected Entry(String name, Class[] params) {
            this.name = name;
            this.params = params;
        }

        public int hashCode() {
            if (this.hasResult) {
                return this.result;
            }
            int i = 0;
            while (i < this.params.length) {
                this.result = this.result * 31 + (this.params[i] == null ? 0 : this.params[i].hashCode());
                ++i;
            }
            this.result = this.result * 31 + this.name.hashCode();
            this.hasResult = true;
            return this.result;
        }

        public boolean equals(Object o) {
            Entry that = (Entry)o;
            if (this.params.length != that.params.length) {
                return false;
            }
            if (!this.name.equals(that.name)) {
                return false;
            }
            int i = 0;
            while (i < this.params.length) {
                if (this.params[i] != that.params[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        public void setMethod(CachedConstructor cache) {
            this.cache = cache;
        }

        public Class[] getParameterTypes(Constructor method) {
            return this.cache.getParameterTypes();
        }
    }

    private static final class NoCache
    extends Entry {
        private NoCache() {
        }

        @Override
        public Class[] getParameterTypes(Constructor method) {
            return method.getParameterTypes();
        }
    }
}

