/*
 * Decompiled with CFR 0.152.
 */
package php.java.fastcgi;

import java.io.IOException;
import php.java.bridge.util.Logger;
import php.java.fastcgi.IContinuation;
import php.java.fastcgi.PhpException;

public abstract class Continuation
implements IContinuation,
Runnable {
    private ScriptLock scriptLock = new ScriptLock();
    private Lock phpScript = new Lock();
    private Object lockObject = new Object();

    protected Continuation() {
    }

    /*
     * Loose catch block
     */
    @Override
    public void run() {
        block9: {
            try {
                try {
                    this.doRun();
                }
                catch (IOException e) {
                    this.phpScript.val = e;
                    this.phpScript.finish();
                    this.scriptLock.finish();
                }
                catch (PhpException e1) {
                    this.phpScript.val = e1;
                    this.phpScript.finish();
                    this.scriptLock.finish();
                }
                catch (Exception ex) {
                    this.phpScript.val = ex;
                    Logger.printStackTrace(ex);
                    this.phpScript.finish();
                    this.scriptLock.finish();
                    break block9;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
            }
            finally {
                this.phpScript.finish();
                this.scriptLock.finish();
            }
        }
    }

    protected abstract void doRun() throws IOException, PhpException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void call(Object script) throws InterruptedException {
        Object object = this.lockObject;
        synchronized (object) {
            this.phpScript.setVal(script);
            this.lockObject.wait();
        }
    }

    @Override
    public Object getPhpScript() throws Exception {
        Object val = this.phpScript.getVal();
        if (val instanceof Exception) {
            throw (Exception)val;
        }
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() throws InterruptedException {
        Object object = this.lockObject;
        synchronized (object) {
            this.lockObject.notifyAll();
        }
        this.scriptLock.waitForRunner();
    }

    protected class Lock {
        private Object val = null;
        private boolean finish = false;

        protected Lock() {
        }

        public synchronized Object getVal() {
            if (!this.finish && this.val == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            return this.val;
        }

        public synchronized void setVal(Object val) {
            this.val = val;
            this.notify();
        }

        public synchronized void finish() {
            this.finish = true;
            this.notify();
        }
    }

    private static class ScriptLock {
        private boolean running = true;

        private ScriptLock() {
        }

        public synchronized void waitForRunner() throws InterruptedException {
            if (this.running) {
                this.wait();
            }
        }

        public synchronized void finish() {
            this.running = false;
            this.notify();
        }
    }
}

