/*
 * Decompiled with CFR 0.152.
 */
package php.java.fastcgi;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import php.java.bridge.Util;
import php.java.bridge.util.Logger;

public class FCGIHelper {
    protected int phpFcgiConnectionPoolSize = Integer.parseInt(System.getProperty("php.java.bridge.php_fcgi_connection_pool_size", "5"));
    protected int phpFcgiConnectionPoolTimeout = Integer.parseInt(System.getProperty("php.java.bridge.php_fcgi_connection_pool_timeout", "-1"));
    protected boolean phpTryOtherLocations;
    protected boolean preferSystemPhp;
    protected boolean phpIncludeJava;
    protected boolean phpIncludeDebugger;
    protected int phpFcgiMaxRequests = Integer.parseInt(System.getProperty("php.java.bridge.php_fcgi_max_requests", "500"));
    protected boolean promiscuous;
    protected String socketPort;
    protected String cgiDir;
    protected String pearDir = null;
    protected String webInfDir = null;
    protected String php;

    public FCGIHelper() {
        this.phpTryOtherLocations = Util.PHP_EXEC == null;
        this.preferSystemPhp = "true".equalsIgnoreCase(System.getProperty("php.java.bridge.prefer_system_php_exec", "true"));
        this.php = Util.PHP_EXEC == null ? "php-cgi" : Util.PHP_EXEC;
        this.phpIncludeJava = "true".equalsIgnoreCase(System.getProperty("php.java.bridge.php_include_java", "true"));
        this.phpIncludeDebugger = "true".equalsIgnoreCase(System.getProperty("php.java.bridge.php_include_debugger", "false"));
        this.promiscuous = Util.JAVABRIDGE_PROMISCUOUS;
        this.cgiDir = Util.DEFAULT_CGI_LOCATIONS[0];
        this.socketPort = System.getProperty("php.java.bridge.php_fcgi_external_socket_pool");
    }

    public String getSocketPort() {
        return this.socketPort;
    }

    public boolean isExternalFCGIPool() {
        return this.socketPort != null && !"true".equalsIgnoreCase(this.socketPort);
    }

    public boolean isInternalDefaultPort() {
        return this.socketPort != null && "true".equalsIgnoreCase(this.socketPort);
    }

    public int getPhpFcgiConnectionPoolSize() {
        return this.phpFcgiConnectionPoolSize;
    }

    public int getPhpFcgiConnectionPoolTimeout() {
        return this.phpFcgiConnectionPoolTimeout;
    }

    public boolean isPhpTryOtherLocations() {
        return this.phpTryOtherLocations;
    }

    public boolean isPreferSystemPhp() {
        return this.preferSystemPhp;
    }

    public String getPhp() {
        return this.php;
    }

    public boolean isPhpIncludeJava() {
        return this.phpIncludeJava;
    }

    public boolean isPhpIncludeDebugger() {
        return this.phpIncludeDebugger;
    }

    public int getPhpFcgiMaxRequests() {
        return this.phpFcgiMaxRequests;
    }

    public boolean isPromiscuous() {
        return this.promiscuous;
    }

    public void createLauncher(File cgiOsDir) {
        File javaIncFile = new File(cgiOsDir, "launcher.sh");
        if (Util.USE_SH_WRAPPER) {
            try {
                if (!javaIncFile.exists() || javaIncFile.length() == 0L) {
                    Field f = Util.LAUNCHER_UNIX.getField("bytes");
                    byte[] buf = (byte[])f.get(Util.LAUNCHER_UNIX);
                    FileOutputStream out = new FileOutputStream(javaIncFile);
                    ((OutputStream)out).write(buf);
                    ((OutputStream)out).close();
                }
            }
            catch (Exception e) {
                Logger.printStackTrace(e);
            }
        }
        File javaProxyFile = new File(cgiOsDir, "launcher.exe");
        if (!Util.USE_SH_WRAPPER) {
            try {
                if (!javaProxyFile.exists() || javaProxyFile.length() == 0L) {
                    FileOutputStream out = new FileOutputStream(javaProxyFile);
                    Class[] classArray = new Class[]{Util.LAUNCHER_WINDOWS, Util.LAUNCHER_WINDOWS2, Util.LAUNCHER_WINDOWS3, Util.LAUNCHER_WINDOWS4, Util.LAUNCHER_WINDOWS5, Util.LAUNCHER_WINDOWS6, Util.LAUNCHER_WINDOWS7};
                    int n = classArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Class c = classArray[n2];
                        if (c != null) {
                            Field f = c.getField("bytes");
                            byte[] buf = (byte[])f.get(c);
                            ((OutputStream)out).write(buf);
                        }
                        ++n2;
                    }
                    ((OutputStream)out).close();
                    if (javaProxyFile.length() == 0L) {
                        throw new IllegalStateException("LAUNCHER_WINDOWS class missing");
                    }
                }
            }
            catch (Exception e) {
                Logger.printStackTrace(e);
            }
        }
    }

    public String getCgiDir() {
        return this.cgiDir;
    }

    public void setCgiDir(String cgiDir) {
        this.cgiDir = cgiDir;
    }

    public String getPearDir() {
        return this.pearDir;
    }

    public void setPearDir(String pearDir) {
        this.pearDir = pearDir;
    }

    public String getWebInfDir() {
        return this.webInfDir;
    }

    public void setWebInfDir(String webInfDir) {
        this.webInfDir = webInfDir;
    }
}

