/*
 * Decompiled with CFR 0.152.
 */
package php.java.script;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.script.AbstractScriptEngine;
import javax.script.Bindings;
import javax.script.Invocable;
import javax.script.ScriptContext;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import javax.script.SimpleScriptContext;
import php.java.bridge.Util;
import php.java.bridge.http.AbstractChannelName;
import php.java.bridge.http.ContextServer;
import php.java.bridge.http.IContext;
import php.java.bridge.http.IContextFactory;
import php.java.bridge.http.WriterOutputStream;
import php.java.bridge.parser.PhpProcedure;
import php.java.bridge.parser.Request;
import php.java.bridge.util.Logger;
import php.java.bridge.util.Thread;
import php.java.fastcgi.Continuation;
import php.java.fastcgi.FCGIHeaderParser;
import php.java.script.IPhpScriptContext;
import php.java.script.IPhpScriptEngine;
import php.java.script.PhpScriptContext;
import php.java.script.PhpScriptContextFactory;
import php.java.script.PhpScriptException;
import php.java.script.PhpScriptWriter;
import php.java.script.ResultProxy;

public abstract class PhpScriptEngine
extends AbstractScriptEngine
implements IPhpScriptEngine,
Closeable,
Invocable {
    protected static final HashSet engines = new HashSet();
    private static boolean registeredHook = false;
    private static final String PHP_EMPTY_SCRIPT = "<?php ?>";
    private static final String[] STANDARD_BINDING_KEYS = new String[]{"javax.script.argv", "javax.script.engine", "javax.script.engine_version", "javax.script.filename", "javax.script.language", "javax.script.language_version", "javax.script.name"};
    protected Object script = null;
    protected Object scriptClosure = null;
    protected Continuation continuation = null;
    protected Map env = null;
    protected IContextFactory ctx = null;
    protected ScriptEngineFactory factory = null;
    protected File scriptFile;
    protected Reader localReader;
    protected ResultProxy resultProxy;
    static final Reader DUMMY_READER = new Reader(){

        @Override
        public void close() throws IOException {
            PhpScriptEngine.throwNoOutputFile();
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            PhpScriptEngine.throwNoOutputFile();
            return 0;
        }
    };
    private ScriptContext ctxCache;

    static HashMap getProcessEnvironment() {
        return new HashMap();
    }

    protected void setStandardBindings() {
        int i = 0;
        String[] stringArray = STANDARD_BINDING_KEYS;
        int n = STANDARD_BINDING_KEYS.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            switch (i++) {
                case 0: {
                    this.getBindings(100).put(s, (Object)new String[]{Util.PHP_EXEC == null ? "php-cgi" : Util.PHP_EXEC});
                    break;
                }
                case 1: {
                    this.getBindings(100).put(s, (Object)this.factory.getEngineName());
                    break;
                }
                case 2: {
                    this.getBindings(100).put(s, (Object)this.factory.getEngineVersion());
                    break;
                }
                case 4: {
                    this.getBindings(100).put(s, (Object)this.factory.getLanguageName());
                    break;
                }
                case 5: {
                    this.getBindings(100).put(s, (Object)this.factory.getLanguageVersion());
                    break;
                }
                case 6: {
                    this.getBindings(100).put(s, (Object)this.factory.getEngineName());
                }
            }
            ++n2;
        }
    }

    protected void setStandardEnvironmentValues(Map env) {
        env.put("X_JAVABRIDGE_CONTEXT", this.ctx.getId());
        this.getBindings(100).put(STANDARD_BINDING_KEYS[3], env.get("SCRIPT_FILENAME"));
    }

    protected Object invoke(String methodName, Object[] args) throws ScriptException, NoSuchMethodException {
        if (methodName == null) {
            this.release();
            return null;
        }
        if (this.scriptClosure == null) {
            if (Logger.getLogLevel() > 4) {
                Logger.warn("Evaluating an empty script either because eval() has not been called or release() has been called.");
            }
            this.eval(PHP_EMPTY_SCRIPT);
        }
        try {
            return this.invoke(this.scriptClosure, methodName, args);
        }
        catch (Request.AbortException e) {
            this.release();
            throw new ScriptException(e);
        }
        catch (NoSuchMethodError e) {
            throw new NoSuchMethodException(String.valueOf(e.getMessage()));
        }
    }

    @Override
    public Object invokeFunction(String methodName, Object ... args) throws ScriptException, NoSuchMethodException {
        return this.invoke(methodName, args);
    }

    private void checkPhpClosure(Object thiz) {
        if (thiz == null) {
            throw new IllegalStateException("PHP script did not pass its continuation to us!. Please check if the previous call to eval() reported any errors. Or else check if it called OUR continuation.");
        }
    }

    protected Object invoke(Object thiz, String methodName, Object[] args) throws ScriptException, NoSuchMethodException {
        this.checkPhpClosure(thiz);
        PhpProcedure proc = (PhpProcedure)Proxy.getInvocationHandler(thiz);
        try {
            return proc.invoke(this.script, methodName, args);
        }
        catch (ScriptException e) {
            throw e;
        }
        catch (NoSuchMethodException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (NoSuchMethodError e) {
            throw new NoSuchMethodException(String.valueOf(e.getMessage()));
        }
        catch (Error er) {
            throw er;
        }
        catch (Throwable e) {
            throw new PhpScriptException("Invocation threw exception ", e);
        }
    }

    public Object getInterface(Class clasz) {
        this.checkPhpClosure(this.script);
        return this.getInterface(this.script, clasz);
    }

    public Object getInterface(Object thiz, Class clasz) {
        Class[] classArray;
        this.checkPhpClosure(thiz);
        if (clasz == null) {
            classArray = Util.ZERO_PARAM;
        } else {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = clasz;
        }
        Class[] interfaces = classArray;
        return PhpProcedure.createProxy(interfaces, (PhpProcedure)Proxy.getInvocationHandler(thiz));
    }

    protected Object evalPhp(Reader reader) throws ScriptException {
        if (this.continuation != null || reader == null) {
            this.release();
        }
        if (reader == null) {
            return null;
        }
        this.setNewContextFactory((Map)PhpScriptEngine.getProcessEnvironment().clone());
        this.compileScript(reader);
        try {
            try {
                this.script = this.doEvalPhp(this.getArgs());
                if (this.script != null) {
                    this.scriptClosure = this.script;
                }
            }
            catch (Exception e) {
                Logger.printStackTrace(e);
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                if (e instanceof ScriptException) {
                    throw (ScriptException)e;
                }
                throw new ScriptException(e);
            }
        }
        finally {
            this.resultProxy = new ResultProxy(this).withResult(this.ctx.getContext().getExitCode());
            this.handleRelease();
        }
        return this.resultProxy;
    }

    protected String[] getArgs() {
        String[] args = (String[])this.get("javax.script.argv");
        if (args == null) {
            throw new NullPointerException("ScriptEngine.ARGV must not be null");
        }
        return args;
    }

    @Override
    public Object invokeMethod(Object thiz, String methodName, Object ... args) throws ScriptException, NoSuchMethodException {
        return this.invoke(thiz, methodName, args);
    }

    protected void addNewContextFactory() {
        this.ctx = PhpScriptContextFactory.addNew((IContext)((Object)this.getContext()));
    }

    protected ContextServer getContextServer() {
        return ((IPhpScriptContext)this.getContext()).getContextServer();
    }

    protected void setNewContextFactory(Map env) {
        this.resultProxy = null;
        this.env = env;
        this.addNewContextFactory();
        ContextServer contextServer = this.getContextServer();
        AbstractChannelName channelName = contextServer.getChannelName(this.ctx);
        if (channelName != null) {
            env.put("X_JAVABRIDGE_REDIRECT", channelName.getName());
            this.ctx.getBridge();
            contextServer.start(channelName);
        }
        this.setStandardEnvironmentValues(env);
    }

    protected void compileScript(Reader reader) throws ScriptException {
        IPhpScriptContext phpScriptContext = (IPhpScriptContext)this.getContext();
        try {
            if (this.scriptFile == null) {
                this.scriptFile = phpScriptContext.compile(reader);
            }
            if (this.env != null) {
                this.env.put("SCRIPT_FILENAME", this.scriptFile.getAbsolutePath());
            }
        }
        catch (IOException e) {
            throw new ScriptException(e);
        }
    }

    @Override
    public Object eval(Reader reader, ScriptContext context) throws ScriptException {
        ScriptContext current = this.getContext();
        if (current != context) {
            try {
                this.setContext(context);
                Object object = this.evalPhp(reader);
                return object;
            }
            finally {
                this.setContext(current);
            }
        }
        return this.evalPhp(reader);
    }

    protected Continuation getContinuation(String[] args) throws IOException {
        FCGIHeaderParser headerParser = FCGIHeaderParser.DEFAULT_HEADER_PARSER;
        IPhpScriptContext phpScriptContext = (IPhpScriptContext)this.getContext();
        OutputStream out = ((PhpScriptWriter)this.getContext().getWriter()).getOutputStream();
        OutputStream err = ((PhpScriptWriter)this.getContext().getErrorWriter()).getOutputStream();
        if (out instanceof WriterOutputStream) {
            headerParser = new SimpleHeaderParser((WriterOutputStream)out);
        }
        Continuation kont = phpScriptContext.createContinuation(args, this.env, out, err, headerParser);
        phpScriptContext.setContinuation(kont);
        phpScriptContext.startContinuation();
        return kont;
    }

    protected final Object doEvalPhp(String[] args) throws Exception {
        this.continuation = this.getContinuation(args);
        return this.continuation.getPhpScript();
    }

    @Override
    public Object eval(String script, ScriptContext context) throws ScriptException {
        if (script == null) {
            return this.evalPhp(null);
        }
        script = script.trim();
        StringReader localReader = new StringReader(script);
        try {
            Object object = this.eval((Reader)localReader, context);
            return object;
        }
        finally {
            try {
                ((Reader)localReader).close();
            }
            catch (IOException e) {
                Logger.printStackTrace(e);
            }
        }
    }

    @Override
    public ScriptEngineFactory getFactory() {
        return this.factory;
    }

    @Override
    public Bindings createBindings() {
        return new SimpleBindings();
    }

    static final void throwNoOutputFile() {
        throw new IllegalStateException("No compilation output file has been set!");
    }

    @Override
    protected ScriptContext getScriptContext(Bindings bindings) {
        return new PhpScriptContext(super.getScriptContext(bindings));
    }

    @Override
    public ScriptContext getContext() {
        if (this.ctxCache == null) {
            this.ctxCache = super.getContext();
            if (!(this.ctxCache instanceof IPhpScriptContext)) {
                if (this.ctxCache == null) {
                    this.ctxCache = new SimpleScriptContext();
                }
                this.ctxCache = new PhpScriptContext(this.ctxCache);
                super.setContext(this.ctxCache);
            }
        }
        return this.ctxCache;
    }

    @Override
    public void setContext(ScriptContext context) {
        super.setContext(context);
        this.ctxCache = null;
        this.getContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleRelease() {
        HashSet hashSet = engines;
        synchronized (hashSet) {
            if (!registeredHook) {
                registeredHook = true;
                try {
                    Runtime.getRuntime().addShutdownHook(new Thread(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            HashSet hashSet = engines;
                            synchronized (hashSet) {
                                Iterator ii = engines.iterator();
                                while (ii.hasNext()) {
                                    PhpScriptEngine e = (PhpScriptEngine)ii.next();
                                    e.releaseInternal(true);
                                    if (PhpScriptEngine.this.ctx != null) {
                                        PhpScriptEngine.this.ctx.destroy();
                                    }
                                    ii.remove();
                                }
                                ((IPhpScriptContext)PhpScriptEngine.this.getContext()).destroy();
                            }
                        }
                    });
                }
                catch (SecurityException securityException) {}
            }
            engines.add(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void release() {
        HashSet hashSet = engines;
        synchronized (hashSet) {
            this.releaseInternal(true);
            engines.remove(this);
        }
    }

    protected void deleteScript() {
        if (this.scriptFile != null) {
            try {
                this.scriptFile.delete();
            }
            catch (Exception e) {
                Logger.printStackTrace(e);
            }
            this.scriptFile = null;
        }
    }

    protected void releaseInternal(boolean deleteScript) {
        if (this.continuation != null) {
            try {
                this.continuation.release();
                this.ctx.releaseManaged();
                this.resultProxy.setResult(this.ctx.getContext().getExitCode());
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            this.ctx = null;
            this.continuation = null;
            this.script = null;
            this.scriptClosure = null;
            try {
                this.getContext().getWriter().flush();
            }
            catch (Exception e) {
                Logger.printStackTrace(e);
            }
            try {
                this.getContext().getErrorWriter().flush();
            }
            catch (Exception e) {
                Logger.printStackTrace(e);
            }
            if (deleteScript) {
                this.deleteScript();
            }
        }
    }

    private final class SimpleHeaderParser
    extends FCGIHeaderParser {
        private WriterOutputStream writer;

        public SimpleHeaderParser(WriterOutputStream writer) {
            this.writer = writer;
        }

        @Override
        public void parseHeader(String header) {
            if (header == null) {
                return;
            }
            int idx = header.indexOf(58);
            if (idx == -1) {
                return;
            }
            String key = header.substring(0, idx).trim().toLowerCase();
            String val = header.substring(idx + 1).trim();
            this.addHeader(key, val);
        }

        @Override
        public void addHeader(String key, String val) {
            if (val != null && key.equals("content-type")) {
                int idx = val.indexOf(59);
                if (idx == -1) {
                    return;
                }
                String enc = val.substring(idx + 1).trim();
                if ((idx = enc.indexOf(61)) == -1) {
                    return;
                }
                enc = enc.substring(idx + 1);
                this.writer.setEncoding(enc);
            }
        }
    }
}

