/*
 * Decompiled with CFR 0.152.
 */
package php.java.servlet;

import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import php.java.bridge.Util;
import php.java.bridge.http.ContextServer;
import php.java.bridge.util.ILogger;
import php.java.bridge.util.Logger;
import php.java.bridge.util.ThreadPool;
import php.java.fastcgi.ConnectionException;
import php.java.fastcgi.Continuation;
import php.java.fastcgi.FCGIConnectionPool;
import php.java.fastcgi.FCGIHeaderParser;
import php.java.fastcgi.FCGIHelper;
import php.java.fastcgi.FCGIProcessException;
import php.java.fastcgi.FCGIProxy;
import php.java.servlet.FCGIServletHelper;
import php.java.servlet.ServletUtil;

public class ContextLoaderListener
implements ServletContextListener {
    private LinkedList closeables = new LinkedList();
    protected ServletContext context;
    private FCGIServletHelper helper = new FCGIServletHelper();
    protected boolean promiscuous = true;
    protected ContextLoaderListener listener;
    private ContextServer contextServer;
    private ThreadPool fcgiThreadPool;
    public static final String CONTEXT_LOADER_LISTENER = String.valueOf(ContextLoaderListener.class.getName()) + ".ROOT";
    private final Object globalCtxLock = new Object();
    private FCGIConnectionPool fcgiConnectionPool = null;

    public void destroyCloseables(ServletContext ctx) {
        LinkedList list = this.closeables;
        if (list == null) {
            return;
        }
        try {
            try {
                for (Object c : list) {
                    try {
                        Method close = c.getClass().getMethod("close", Util.ZERO_PARAM);
                        close.setAccessible(true);
                        close.invoke(c, Util.ZERO_ARG);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                this.closeables.clear();
            }
        }
        finally {
            this.closeables.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextDestroyed(ServletContextEvent event) {
        ServletContext ctx = event.getServletContext();
        try {
            this.destroyCloseables(ctx);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.contextServer != null) {
            this.contextServer.destroy();
        }
        Object object = this.globalCtxLock;
        synchronized (object) {
            if (this.fcgiConnectionPool != null) {
                this.fcgiConnectionPool.destroy();
            }
            this.fcgiConnectionPool = null;
        }
        if (this.fcgiThreadPool != null) {
            this.fcgiThreadPool.destroy();
            this.fcgiThreadPool = null;
        }
    }

    public void contextInitialized(ServletContextEvent event) {
        final ServletContext ctx = event.getServletContext();
        Logger.setLogger((ILogger)new ILogger(){

            public void printStackTrace(Throwable t) {
                ctx.log(String.valueOf(t), t);
            }

            public void log(int level, String msg) {
                switch (level) {
                    case 1: {
                        ctx.log("fatal:" + msg);
                        break;
                    }
                    case 2: {
                        ctx.log("error:" + msg);
                        break;
                    }
                    case 3: {
                        ctx.log("info:" + msg);
                        break;
                    }
                    case 4: {
                        ctx.log("debug:" + msg);
                        break;
                    }
                    default: {
                        ctx.log(msg);
                    }
                }
            }

            public void warn(String msg) {
                ctx.log("WARNING: " + msg);
            }
        });
        ctx.setAttribute(CONTEXT_LOADER_LISTENER, (Object)this);
        this.context = ctx;
        this.helper.init(this.context);
        String servletContextName = ServletUtil.getRealPath(this.context, "");
        if (servletContextName == null) {
            servletContextName = "";
        }
        this.contextServer = new ContextServer(servletContextName, this.promiscuous);
        this.fcgiThreadPool = new ThreadPool("JavaBridgeServletScriptEngineProxy", this.helper.getPhpFcgiConnectionPoolSize());
    }

    public ThreadPool getThreadPool() {
        return this.fcgiThreadPool;
    }

    public List getCloseables() {
        return this.closeables;
    }

    public static ContextLoaderListener getContextLoaderListener(ServletContext ctx) {
        return (ContextLoaderListener)ctx.getAttribute(CONTEXT_LOADER_LISTENER);
    }

    public ContextServer getContextServer() {
        return this.contextServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FCGIConnectionPool getConnectionPool() throws FCGIProcessException, ConnectionException {
        Object object = this.globalCtxLock;
        synchronized (object) {
            if (this.fcgiConnectionPool != null) {
                return this.fcgiConnectionPool;
            }
            String[] args = new String[]{this.helper.getPhp()};
            HashMap<String, String> env = new HashMap<String, String>();
            env.put("REDIRECT_STATUS", "200");
            return this.getConnectionPool(args, env);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FCGIConnectionPool getConnectionPool(String[] args, Map env) throws FCGIProcessException, ConnectionException {
        Object object = this.globalCtxLock;
        synchronized (object) {
            if (this.fcgiConnectionPool != null) {
                return this.fcgiConnectionPool;
            }
            this.fcgiConnectionPool = FCGIConnectionPool.createConnectionPool((String[])args, (Map)env, (FCGIHelper)this.helper);
            return this.fcgiConnectionPool;
        }
    }

    public Continuation createContinuation(String[] args, Map env, OutputStream out, OutputStream err, FCGIHeaderParser headerParser) throws FCGIProcessException, ConnectionException {
        return new FCGIProxy(env, out, err, headerParser, args == null ? this.fcgiConnectionPool : this.getConnectionPool(args, env));
    }

    public FCGIServletHelper getHelper() {
        return this.helper;
    }
}

