/*
 * Decompiled with CFR 0.152.
 */
package php.java.servlet;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import php.java.bridge.http.Context;
import php.java.bridge.util.Logger;
import php.java.bridge.util.NotImplementedException;
import php.java.servlet.ContextLoaderListener;
import php.java.servlet.ServletUtil;

public class HttpContext
extends Context {
    protected HttpServletResponse response;
    protected ServletContext context;
    protected HttpServletRequest request;

    public Object getAttribute(String name) throws IllegalArgumentException {
        Object result;
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (this.getEngineScope() != null && (result = this.getEngineScope().get(name)) != null) {
            return result;
        }
        if (this.getGlobalScope() != null && (result = this.getGlobalScope().get(name)) != null) {
            return result;
        }
        result = this.request.getAttribute(name);
        if (result != null) {
            return result;
        }
        result = this.request.getSession().getAttribute(name);
        if (result != null) {
            return result;
        }
        result = this.context.getAttribute(name);
        if (result != null) {
            return result;
        }
        return null;
    }

    public HttpContext(ServletContext kontext, HttpServletRequest req, HttpServletResponse res) {
        this.context = kontext;
        this.response = res;
        this.request = req;
    }

    public Writer getWriter() throws IOException {
        return this.response.getWriter();
    }

    public Object getHttpServletResponse() {
        return this.getAttribute("php.java.servlet.HttpServletResponse");
    }

    public Object getHttpServletRequest() {
        return this.getAttribute("php.java.servlet.HttpServletRequest");
    }

    public Object getServlet() {
        return this.getAttribute("php.java.servlet.Servlet");
    }

    public Object getServletConfig() {
        return this.getAttribute("php.java.servlet.ServletConfig");
    }

    public Object getServletContext() {
        return this.getAttribute("php.java.servlet.ServletContext");
    }

    public static void handleManaged(Object closeable, ServletContext ctx) {
        List list = ContextLoaderListener.getContextLoaderListener(ctx).getCloseables();
        list.add(closeable);
    }

    public Object init(Object callable) throws Exception {
        if (Logger.getLogLevel() > 3) {
            Logger.logDebug((String)"calling servlet context init");
        }
        return Context.getManageable((Object)callable);
    }

    public void onShutdown(Object closeable) {
        if (Logger.getLogLevel() > 3) {
            Logger.logDebug((String)"calling servlet context register shutdown ");
        }
        HttpContext.handleManaged(closeable, this.context);
    }

    public static String getRealPathInternal(String path, ServletContext ctx) {
        return ServletUtil.getRealPath(ctx, path);
    }

    public String getRealPath(String path) {
        return ServletUtil.getRealPath(this.context, path);
    }

    public String getRedirectString() {
        throw new NotImplementedException();
    }

    public String getRedirectString(String webPath) {
        throw new NotImplementedException();
    }

    public String getSocketName() {
        return String.valueOf(ServletUtil.getLocalPort((ServletRequest)this.request));
    }
}

