/*
 * Decompiled with CFR 0.152.
 */
package php.java.bridge.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import php.java.bridge.JavaBridge;
import php.java.bridge.Util;
import php.java.bridge.http.IContext;
import php.java.bridge.http.IContextFactory;
import php.java.bridge.http.IContextFactoryVisitor;
import php.java.bridge.http.ISession;
import php.java.bridge.http.SessionFactory;
import php.java.bridge.http.SimpleContextFactory;
import php.java.bridge.parser.Request;
import php.java.bridge.util.Logger;

public final class ContextFactory
extends SessionFactory
implements IContextFactory {
    public static final String EMPTY_CONTEXT_NAME = "";
    private static final HashMap contexts;
    private static final HashMap liveContexts;
    private String id;
    private long timestamp = System.currentTimeMillis();
    private IContextFactoryVisitor visitor;
    private boolean initialized;
    private static long counter;

    private static synchronized String addNext(String webContext, ContextFactory thiz, boolean isManaged) {
        ++counter;
        try {
            webContext = URLEncoder.encode(webContext, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            Logger.printStackTrace(e);
        }
        String id = Long.toHexString(counter) + "@" + webContext;
        if (isManaged) {
            liveContexts.put(id, thiz);
        } else {
            contexts.put(id, thiz);
        }
        return id;
    }

    private static synchronized void remove(String id) {
        ContextFactory ob = (ContextFactory)liveContexts.remove(id);
        if (Logger.getLogLevel() > 4) {
            Logger.logDebug("contextfactory: removed context: " + (ob == null ? "already handled" : String.valueOf(ob.visitor)) + ", # of contexts: " + contexts.size());
        }
    }

    private static synchronized ContextFactory moveContext(String id) {
        Object o = liveContexts.get(id);
        if (o != null) {
            return (ContextFactory)o;
        }
        o = contexts.remove(id);
        if (o != null) {
            liveContexts.put(id, o);
            return (ContextFactory)o;
        }
        return null;
    }

    public ContextFactory(String webContext, boolean isManaged) {
        this.id = ContextFactory.addNext(webContext, this, isManaged);
        if (Logger.getLogLevel() > 4) {
            Logger.logDebug("contextfactory: new context: " + this.id + " for web context" + webContext + ", # of contexts: " + contexts.size());
        }
    }

    public static IContextFactory addNew() {
        return new SimpleContextFactory(EMPTY_CONTEXT_NAME, false);
    }

    public static IContextFactory get(String id) {
        ContextFactory factory = ContextFactory.moveContext(id);
        if (factory == null) {
            return null;
        }
        if (factory.initialized) {
            throw new SecurityException("illegal access");
        }
        factory.initialized = true;
        return factory.visitor;
    }

    private static synchronized void switchContext(String id, ContextFactory thiz) {
        boolean contextIsManaged = true;
        ContextFactory factory = (ContextFactory)liveContexts.get(id);
        if (factory == null) {
            factory = (ContextFactory)contexts.get(id);
            contextIsManaged = false;
        }
        if (factory == null || factory == thiz) {
            return;
        }
        JavaBridge bridge = thiz.getBridge();
        JavaBridge newBridge = factory.checkBridge();
        if (newBridge == null) {
            throw new IllegalStateException("recycle empty context");
        }
        if (Logger.getLogLevel() > 4) {
            Logger.logDebug("contextfactory: setting new bridge. visited: " + bridge.getFactory() + " <= visitor: " + newBridge.getFactory());
        }
        bridge.request.setBridge(newBridge);
        bridge = newBridge;
        if (contextIsManaged) {
            liveContexts.remove(id);
            contexts.put(id, factory);
        }
        factory.visitor.release();
        thiz.accept(factory.visitor);
        thiz.visitor.initialize();
        if (Logger.getLogLevel() > 4) {
            Logger.logDebug("contextfactory: " + thiz + " is swiching thread context");
        }
        if (Logger.getLogLevel() > 4) {
            Logger.logDebug("contextfactory: accepted visitor: " + factory.visitor);
        }
    }

    @Override
    public void recycle(String id) {
        ContextFactory.switchContext(id, this);
    }

    @Override
    public void recycle() {
        if (Logger.getLogLevel() >= 4) {
            Logger.logDebug("contextfactory: finish context called (recycle context factory) " + this.visitor);
        }
        super.recycle();
    }

    @Override
    public void destroy() {
        if (Logger.getLogLevel() > 4) {
            Logger.logDebug("contextfactory: context destroyed (remove context factory): " + this.visitor);
        }
        ContextFactory.remove(this.getId());
        super.destroy();
        this.visitor.invalidate();
    }

    private static synchronized void destroyOrphaned() {
        long timestamp = System.currentTimeMillis();
        Iterator ii = contexts.values().iterator();
        while (ii.hasNext()) {
            ContextFactory ctx = (ContextFactory)ii.next();
            if (ctx.timestamp + (long)Util.MAX_WAIT >= timestamp) continue;
            ctx.visitor.invalidate();
            Logger.warn("contextfactory: Orphaned context: " + ctx.visitor + " removed.");
            ii.remove();
        }
    }

    public static synchronized void destroyAll() {
        ContextFactory ctx;
        Iterator ii = contexts.values().iterator();
        while (ii.hasNext()) {
            ctx = (ContextFactory)ii.next();
            ctx.visitor.invalidate();
            if (Logger.getLogLevel() > 4) {
                Logger.logDebug("contextfactory: Orphaned context: " + ctx.visitor + " removed.");
            }
            ii.remove();
        }
        ii = contexts.values().iterator();
        while (ii.hasNext()) {
            ctx = (ContextFactory)ii.next();
            ctx.visitor.invalidate();
            ii.remove();
        }
    }

    @Override
    public void releaseManaged() throws InterruptedException {
        this.visitor.releaseManaged();
    }

    @Override
    public void waitFor(long timeout) throws InterruptedException {
        this.visitor.waitFor(timeout);
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String toString() {
        return "Context# " + this.id;
    }

    @Override
    public IContext getContext() {
        return this.visitor.getContext();
    }

    @Override
    public void setContext(IContext context) {
        this.visitor.setContext(context);
    }

    private void setVisitor(IContextFactoryVisitor newVisitor) {
        this.visitor = newVisitor;
    }

    public void accept(IContextFactoryVisitor visitor) {
        visitor.visit(this);
        this.setVisitor(visitor);
    }

    @Override
    public ISession getSimpleSession(String name, short clientIsNew, int timeout) {
        return super.getSession(name, clientIsNew, timeout);
    }

    @Override
    public ISession getSession(String name, short clientIsNew, int timeout) {
        return this.visitor.getSession(name, clientIsNew, timeout);
    }

    @Override
    public synchronized void release() {
        ContextFactory ob = (ContextFactory)contexts.remove(this.id);
        if (Logger.getLogLevel() > 4) {
            Logger.logDebug("contextfactory: released empty context: " + (ob != null ? String.valueOf(ob.visitor) : "<already handled>") + ", # of contexts: " + contexts.size() + ", # of live contexts: " + liveContexts.size());
        }
    }

    @Override
    public void initialize() {
        this.visitor.initialize();
    }

    @Override
    public void invalidate() {
        this.visitor.invalidate();
    }

    @Override
    public void parseHeader(Request req, InputStream in) throws IOException {
        JavaBridge bridge = this.getBridge();
        in.read();
        byte shortPathHeader = (byte)(0xFF & in.read());
        bridge.out.write(0);
        bridge.out.flush();
        int len = 0xFF & in.read() | 0xFF & in.read() << 8;
        byte[] buf = new byte[len];
        in.read(buf);
        String newContext = new String(buf, 0, len, "ASCII");
        IContextFactory factory = (IContextFactory)bridge.getFactory();
        factory.recycle(newContext);
        if (shortPathHeader != -1) {
            req.init(shortPathHeader);
        }
    }

    static {
        try {
            ContextFactory.getTimer().addJob(new Runnable(){

                @Override
                public void run() {
                    ContextFactory.destroyOrphaned();
                }
            });
        }
        catch (Throwable t) {
            Logger.printStackTrace(t);
        }
        contexts = new HashMap();
        liveContexts = new HashMap();
        counter = 0L;
    }
}

