/*
 * Decompiled with CFR 0.152.
 */
package php.java.bridge.util;

import java.io.FileOutputStream;
import java.io.PrintStream;
import php.java.bridge.util.FileLogger;
import php.java.bridge.util.ILogger;

public class Logger {
    private static ILogger logger;
    private static PrintStream logStream;
    private static int logLevel;

    public static void println(int level, String msg) {
        Logger.getLogger().log(level, msg);
    }

    public static void warn(String msg) {
        if (Logger.getLogLevel() <= 0) {
            return;
        }
        Logger.getLogger().warn(msg);
    }

    public static void printStackTrace(Throwable t) {
        Logger.getLogger().printStackTrace(t);
    }

    public static void logDebug(String msg) {
        if (Logger.getLogLevel() > 3) {
            Logger.println(4, msg);
        }
    }

    public static void logFatal(String msg) {
        if (Logger.getLogLevel() > 0) {
            Logger.println(1, msg);
        }
    }

    public static void logError(String msg) {
        if (Logger.getLogLevel() > 1) {
            Logger.println(2, msg);
        }
    }

    public static void logMessage(String msg) {
        if (Logger.getLogLevel() > 2) {
            Logger.println(3, msg);
        }
    }

    public static void setLogger(ILogger logger) {
        Logger.logger = logger;
    }

    public static ILogger getLogger() {
        if (logger == null) {
            logger = new FileLogger();
        }
        return logger;
    }

    public static void redirectOutput(String logFile) {
        Logger.redirectJavaOutput(logFile);
    }

    public static void redirectJavaOutput(String logFile) {
        Logger.setLogStream(System.err);
        if (logFile != null && logFile.length() > 0) {
            try {
                Logger.setLogStream(new PrintStream(new FileOutputStream(logFile)));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            System.setErr(Logger.getLogStream());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            System.setOut(Logger.getLogStream());
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(9);
        }
    }

    public static void setLogger(String logFile) {
        Logger.setLogger(new FileLogger());
    }

    public static PrintStream getLogStream() {
        return logStream;
    }

    public static void setLogStream(PrintStream logStream) {
        Logger.logStream = logStream;
    }

    public static int getLogLevel() {
        return logLevel;
    }

    public static void setLogLevel(int logLevel) {
        Logger.logLevel = logLevel;
    }
}

