/*
 * Decompiled with CFR 0.152.
 */
package php.java.fastcgi;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import php.java.bridge.util.NotImplementedException;
import php.java.fastcgi.ConnectionException;

public class FCGIOutputStream
extends OutputStream {
    private OutputStream out;
    private int id;

    public FCGIOutputStream(OutputStream out) {
        this.out = out;
    }

    public void write(int type, byte[] buf) throws ConnectionException {
        this.write(type, buf, buf.length);
    }

    public void write(int type, byte[] buf, int length) throws ConnectionException {
        int requestId = this.id;
        byte[] header = new byte[]{1, (byte)type, (byte)(requestId >> 8 & 0xFF), (byte)(requestId & 0xFF), -1, -1, 0, 0};
        int contentLength = length;
        int pos = 0;
        while (pos + 65535 <= contentLength) {
            this.write(header);
            this.write(buf, pos, 65535);
            pos += 65535;
        }
        contentLength = length % 65535;
        header[4] = (byte)(contentLength >> 8 & 0xFF);
        header[5] = (byte)(contentLength & 0xFF);
        this.write(header);
        this.write(buf, pos, contentLength);
    }

    public void writeBegin(boolean isLast) throws ConnectionException {
        int role = 1;
        byte lastChild = (byte)(!isLast ? 1 : 0);
        byte[] body = new byte[]{(byte)(role >> 8 & 0xFF), (byte)(role & 0xFF), lastChild, 0, 0, 0, 0, 0};
        this.write(1, body);
    }

    private void writeLength(ByteArrayOutputStream out, int keyLen) throws IOException {
        if (keyLen < 128) {
            out.write((byte)keyLen);
        } else {
            byte[] b = new byte[]{(byte)((keyLen >> 24 | 0x80) & 0xFF), (byte)(keyLen >> 16 & 0xFF), (byte)(keyLen >> 8 & 0xFF), (byte)keyLen};
            out.write(b);
        }
    }

    public void writeParams(Map props) throws ConnectionException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        for (Object k : props.keySet()) {
            Object v = props.get(k);
            String key = String.valueOf(k);
            String val = String.valueOf(v);
            int keyLen = key.length();
            int valLen = val.length();
            if (keyLen == 0 || valLen == 0) continue;
            try {
                this.writeLength(out, keyLen);
                this.writeLength(out, valLen);
                out.write(key.getBytes("ASCII"));
                out.write(val.getBytes("ASCII"));
            }
            catch (IOException e) {
                throw new ConnectionException(e);
            }
        }
        this.write(4, out.toByteArray());
    }

    @Override
    public void write(byte[] buf) throws ConnectionException {
        this.write(buf, 0, buf.length);
    }

    @Override
    public void write(byte[] buf, int off, int buflength) throws ConnectionException {
        try {
            this.out.write(buf, off, buflength);
        }
        catch (IOException ex) {
            throw new ConnectionException(ex);
        }
    }

    @Override
    public void write(int b) throws ConnectionException {
        throw new NotImplementedException();
    }

    @Override
    public void close() throws ConnectionException {
        this.flush();
    }

    @Override
    public void flush() throws ConnectionException {
        try {
            this.out.flush();
        }
        catch (IOException ex) {
            throw new ConnectionException(ex);
        }
    }

    public void setId(int id) {
        this.id = id;
    }
}

