/*
 * Decompiled with CFR 0.152.
 */
package gnu.lists;

import gnu.lists.Consumer;
import gnu.lists.Convert;
import gnu.lists.Sequence;
import gnu.lists.SimpleVector;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;

public class S32Vector
extends SimpleVector
implements Externalizable {
    int[] data;
    protected static int[] empty = new int[0];

    public S32Vector() {
        this.data = empty;
    }

    public S32Vector(int n, int n2) {
        int[] nArray = new int[n];
        this.data = nArray;
        this.size = n;
        while (--n >= 0) {
            nArray[n] = n2;
        }
    }

    public S32Vector(int n) {
        this.data = new int[n];
        this.size = n;
    }

    public S32Vector(int[] nArray) {
        this.data = nArray;
        this.size = nArray.length;
    }

    public S32Vector(Sequence sequence) {
        this.data = new int[sequence.size()];
        this.addAll((Collection)sequence);
    }

    public int getBufferLength() {
        return this.data.length;
    }

    public void setBufferLength(int n) {
        int n2 = this.data.length;
        if (n2 != n) {
            int[] nArray = new int[n];
            System.arraycopy(this.data, 0, nArray, 0, n2 < n ? n2 : n);
            this.data = nArray;
        }
    }

    protected Object getBuffer() {
        return this.data;
    }

    public final int intAt(int n) {
        if (n > this.size) {
            throw new IndexOutOfBoundsException();
        }
        return this.data[n];
    }

    public final int intAtBuffer(int n) {
        return this.data[n];
    }

    public final Object get(int n) {
        if (n > this.size) {
            throw new IndexOutOfBoundsException();
        }
        return Convert.toObject(this.data[n]);
    }

    public final Object getBuffer(int n) {
        return Convert.toObject(this.data[n]);
    }

    public Object setBuffer(int n, Object object2) {
        int n2 = this.data[n];
        this.data[n] = Convert.toInt(object2);
        return Convert.toObject(n2);
    }

    public final void setIntAt(int n, int n2) {
        if (n > this.size) {
            throw new IndexOutOfBoundsException();
        }
        this.data[n] = n2;
    }

    public final void setIntAtBuffer(int n, int n2) {
        this.data[n] = n2;
    }

    protected void clearBuffer(int n, int n2) {
        while (--n2 >= 0) {
            this.data[n++] = 0;
        }
    }

    public int getElementKind() {
        return 22;
    }

    public String getTag() {
        return "s32";
    }

    public boolean consumeNext(int n, Object object2, Consumer consumer) {
        int n2 = n >>> 1;
        if (n2 >= this.size) {
            return false;
        }
        consumer.writeInt(this.data[n2]);
        return true;
    }

    public void consume(int n, Object object2, int n2, Object object3, Consumer consumer) {
        if (consumer.ignoring()) {
            return;
        }
        int n3 = n >>> 1;
        int n4 = n2 >>> 1;
        while (n3 < n4) {
            consumer.writeInt(this.data[n3]);
            ++n3;
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n = this.size;
        objectOutput.writeInt(n);
        int n2 = 0;
        while (n2 < n) {
            objectOutput.writeInt(this.data[n2]);
            ++n2;
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = objectInput.readInt();
            ++n2;
        }
        this.data = nArray;
        this.size = n;
    }
}

