package php.java.bridge.http;

import java.io.IOException;
import java.io.Writer;
import javax.script.ScriptContext;

public interface IContext {

    /**
     * The engine scope
     */
    static final int ENGINE_SCOPE = ScriptContext.ENGINE_SCOPE;

    /**
     * The global scope
     */
    static final int GLOBAL_SCOPE = ScriptContext.GLOBAL_SCOPE;

    /**
     * This key can be used to get the current JavaBridge instance.
     * Example: <code>java_context-&gt;getAttribute("php.java.bridge.JavaBridge");</code>
     */
    public static final String JAVA_BRIDGE = "php.java.bridge.JavaBridge";
    /**
     * This key can be used to get the current ServletContext instance.
     * Example: <code>java_context-&gt;getAttribute("php.java.servlet.ServletContext");</code>
     */
    public static final String SERVLET_CONTEXT = "php.java.servlet.ServletContext";
    /**
     * This key can be used to get the current ServletConfig instance.
     * Example: <code>java_context-&gt;getAttribute("php.java.servlet.ServletConfig");</code>
     */
    public static final String SERVLET_CONFIG = "php.java.servlet.ServletConfig";
    /**
     * This key can be used to get the current Servlet instance.
     * Example: <code>java_context-&gt;getAttribute("php.java.servlet.Servlet");</code>
     */
    public static final String SERVLET = "php.java.servlet.Servlet";
    /**
     * This key can be used to get the current HttpServletRequest instance.
     * Example: <code>java_context-&gt;getAttribute("php.java.servlet.HttpServletRequest");</code>
     */
    public static final String SERVLET_REQUEST = "php.java.servlet.HttpServletRequest";
    /**
     * This key can be used to get the current HttpServletResponse instance.
     * Example: <code>java_context-&gt;getAttribute("php.java.servlet.HttpServletResponse");</code>
     */
    public static final String SERVLET_RESPONSE = "php.java.servlet.HttpServletResponse";
    
    /**
     * Retrieves the value for getAttribute(String, int) for the 
     * lowest scope in which it returns a non-null value.
     * 
     * @param name the name of the attribute 
     * @return the value of the attribute
     */
    public abstract Object getAttribute(String name)
	    throws IllegalArgumentException;

    /**
     * Retrieves the value associated with specified name in the 
     * specified level of scope. Returns null if no value is 
     * associated with specified key in specified level of scope.
     *  
     * @param name the name of the attribute
     * @param scope the level of scope
     * @return the value value associated with the specified name in
     *         specified level of scope
     */
    public abstract Object getAttribute(String name, int scope)
	    throws IllegalArgumentException;

    /**
     * Retrieves the lowest value of scopes for which the attribute 
     * is defined. If there is no associate scope with the given 
     * attribute (-1) is returned.
     * 
     * @param  name the name of attribute
     * @return the value of level of scope  
     */
    public abstract int getAttributesScope(String name);

    /**
     * Retrieves an instance of java.io.Writer which can be used by 
     * scripts to display their output.
     * 
     * @return an instance of java.io.Writer
     */
    public abstract Writer getWriter() throws IOException;

    /**
     * Removes the specified attribute form the specified level of 
     * scope.
     * 
     * @param name the name of the attribute
     * @param scope the level of scope 
     * @return value which is removed
     * @throws IllegalArgumentException
     */
    public abstract Object removeAttribute(String name, int scope)
	    throws IllegalArgumentException;

    /**
     * Sets an attribute specified by the name in specified level of 
     * scope.
     *  
     * @param name   the name of the attribute
     * @param value the value of the attribute
     * @param scope the level of the scope
     * @throws IllegalArguementException if the name is null scope is
     *         invlaid
     */
    public abstract void setAttribute(String name, Object value, int scope)
	    throws IllegalArgumentException;

}