/*
 * Decompiled with CFR 0.152.
 */
package gnu.lists;

import gnu.lists.AbstractSequence;
import gnu.lists.Consumer;
import gnu.lists.Convert;
import gnu.lists.PositionContainer;
import gnu.lists.Sequence;
import java.util.Collection;
import java.util.Iterator;

public abstract class SimpleVector
extends AbstractSequence
implements Sequence {
    public int size;

    public final int size() {
        return this.size;
    }

    public void setSize(int n) {
        int n2 = this.size;
        this.size = n;
        if (n < n2) {
            this.clearBuffer(n, n2 - n);
        } else {
            int n3 = this.getBufferLength();
            if (n > n3) {
                int n4 = n3 < 16 ? 16 : 2 * n3;
                this.setBufferLength(n > n4 ? n : n4);
            }
        }
    }

    public abstract int getBufferLength();

    public abstract void setBufferLength(int var1);

    protected boolean isAfter(int n, Object object2) {
        return (n & 1) != 0;
    }

    protected int nextIndex(int n, Object object2) {
        return n >>> 1;
    }

    public void makePosition(int n, boolean bl, PositionContainer positionContainer, int n2) {
        positionContainer.setPosition(n2, n << 1 | (bl ? 1 : 0), null);
        positionContainer.setSequence(n2, this);
    }

    protected abstract Object getBuffer();

    public Object get(int n) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        return this.getBuffer(n);
    }

    protected Object getNext(int n, Object object2) {
        int n2 = n >>> 1;
        return n2 >= this.size ? Sequence.eofValue : this.getBuffer(n2);
    }

    public int intAtBuffer(int n) {
        return Convert.toInt(this.getBuffer(n));
    }

    public int intAt(int n) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        return this.intAtBuffer(n);
    }

    public long longAt(int n) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        return this.longAtBuffer(n);
    }

    public long longAtBuffer(int n) {
        return Convert.toLong(this.getBuffer(n));
    }

    protected abstract Object getBuffer(int var1);

    public Object set(int n, Object object2) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        Object object3 = this.getBuffer(n);
        this.setBuffer(n, object2);
        return object3;
    }

    protected abstract Object setBuffer(int var1, Object var2);

    public void fill(Object object2) {
        int n = this.size;
        while (--n >= 0) {
            this.setBuffer(n, object2);
        }
    }

    public void fill(int n, int n2, Object object2) {
        if (n < 0 || n2 > this.size) {
            throw new IndexOutOfBoundsException();
        }
        int n3 = n;
        while (n3 < n2) {
            this.setBuffer(n3, object2);
            ++n3;
        }
    }

    public void shift(int n, int n2, int n3) {
        Object object2 = this.getBuffer();
        System.arraycopy(object2, n, object2, n2, n3);
    }

    public boolean add(Object object2) {
        this.add(this.size, object2);
        return true;
    }

    protected void add(PositionContainer positionContainer, int n, Object object2) {
        int n2 = positionContainer.getPositionInt(n);
        this.add(n2 >>> 1, object2);
        positionContainer.setPosition(n, n2 + 2, null);
    }

    public void add(int n, Object object2) {
        int n2;
        this.size = n2 = this.size + 1;
        int n3 = this.getBufferLength();
        if (n2 > n3) {
            this.setBufferLength(n3 < 16 ? 16 : 2 * n3);
        }
        this.size = n2;
        if (this.size != n) {
            this.shift(n, n + 1, this.size - n);
        }
        this.set(n, object2);
    }

    public boolean addAll(int n, Collection collection) {
        boolean bl = false;
        int n2 = collection.size();
        this.setSize(this.size + n2);
        this.shift(n, n + n2, this.size - n2 - n);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.set(n++, iterator.next());
            bl = true;
        }
        return bl;
    }

    protected abstract void clearBuffer(int var1, int var2);

    protected void remove(int n, Object object2, int n2, Object object3) {
        if ((n >>>= 1) < 0 || n > (n2 >>>= 1) || n2 >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        this.shift(n2, n, this.size - n2);
        int n3 = n2 - n;
        this.size -= n3;
        this.clearBuffer(this.size, n3);
    }

    protected void remove(int n, Object object2, int n2) {
        int n3;
        int n4;
        int n5 = n >>> 1;
        if (n2 >= 0) {
            n4 = n5;
            n3 = n5 + n2;
        } else {
            n4 = n5 + n2;
            n3 = n5;
            n2 = -n2;
        }
        if (n4 < 0 || n3 >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        this.shift(n3, n4, this.size - n3);
        this.size -= n2;
        this.clearBuffer(this.size, n2);
    }

    public Object remove(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        Object object2 = this.get(n);
        this.shift(n + 1, n, 1);
        --this.size;
        this.clearBuffer(this.size, 1);
        return object2;
    }

    public boolean remove(Object object2) {
        int n = this.indexOf(object2);
        if (n < 0) {
            return false;
        }
        Object object3 = this.get(n);
        this.shift(n + 1, n, 1);
        --this.size;
        this.clearBuffer(this.size, 1);
        return true;
    }

    public boolean removeAll(Collection collection) {
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        while (n2 < this.size) {
            Object object2 = this.get(n2);
            if (collection.contains(object2)) {
                bl = true;
            } else {
                if (bl) {
                    this.set(n, object2);
                }
                ++n;
            }
            ++n2;
        }
        this.setSize(n);
        return bl;
    }

    public boolean retainAll(Collection collection) {
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        while (n2 < this.size) {
            Object object2 = this.get(n2);
            if (!collection.contains(object2)) {
                bl = true;
            } else {
                if (bl) {
                    this.set(n, object2);
                }
                ++n;
            }
            ++n2;
        }
        this.setSize(n);
        return bl;
    }

    public void clear() {
        this.setSize(0);
    }

    public String getTag() {
        return null;
    }

    public void consume(int n, int n2, Consumer consumer) {
        this.consume(n << 1, null, n + n2 << 1, null, consumer);
    }

    public boolean consumeNext(int n, Object object2, Consumer consumer) {
        int n2 = n >>> 1;
        if (n2 >= this.size) {
            return false;
        }
        consumer.writeObject(this.getBuffer(n2));
        return true;
    }

    protected void consume(int n, Object object2, int n2, Object object3, Consumer consumer) {
        if (consumer.ignoring()) {
            return;
        }
        int n3 = n >>> 1;
        int n4 = n2 >>> 1;
        while (n3 < n4) {
            consumer.writeObject(this.getBuffer(n3));
            ++n3;
        }
    }

    protected int getNextKind(int n, Object object2) {
        return this.hasNext(n, object2) ? this.getElementKind() : 0;
    }

    public int getElementKind() {
        return 32;
    }
}

