/*
 * Decompiled with CFR 0.152.
 */
package kawa.lang;

import gnu.expr.Declaration;
import gnu.expr.Expression;
import gnu.expr.QuoteExp;
import gnu.expr.ScopeExp;
import gnu.lists.Pair;
import gnu.mapping.Printable;
import gnu.mapping.Procedure;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.PrintWriter;
import java.util.Vector;
import kawa.lang.Syntax;
import kawa.lang.SyntaxForm;
import kawa.lang.Translator;

public class Macro
extends Syntax
implements Printable,
Externalizable {
    public Expression expander;

    public Expression getExpander() {
        return this.expander;
    }

    public static Macro make(String string, Procedure procedure) {
        Macro macro = new Macro(string, procedure);
        return macro;
    }

    public void bind(Declaration declaration) {
        declaration.setSimple(false);
        declaration.setFlag(49152);
        declaration.noteValue(new QuoteExp(this));
    }

    public void setExpander(Procedure procedure) {
        this.expander = new QuoteExp(procedure);
    }

    public Macro() {
    }

    public Macro(String string, Procedure procedure) {
        super(string);
        this.expander = new QuoteExp(procedure);
    }

    public Macro(String string, Expression expression) {
        super(string);
        this.expander = expression;
    }

    public Macro(String string) {
        super(string);
    }

    public Expression rewriteForm(Pair pair, Translator translator) {
        return translator.rewrite(this.expand(pair, translator));
    }

    public String toString() {
        return "#<macro " + this.getName() + '>';
    }

    public void print(PrintWriter printWriter) {
        printWriter.print("#<macro ");
        printWriter.print(this.getName());
        printWriter.print('>');
    }

    public Object expand(Pair pair, Translator translator) {
        try {
            Procedure procedure = (Procedure)this.getExpander().eval(translator.getGlobalEnvironment());
            SyntaxForm syntaxForm = new SyntaxForm();
            syntaxForm.form = pair;
            syntaxForm.tr = translator;
            Object object2 = procedure.apply1(syntaxForm);
            return object2;
        }
        catch (Exception exception) {
            return translator.syntaxError("evaluating syntax transformer `" + this.getName() + "' threw " + exception);
        }
    }

    public boolean scanForDefinitions(Pair pair, Vector vector, ScopeExp scopeExp, Translator translator) {
        String string = translator.getFile();
        int n = translator.getLine();
        int n2 = translator.getColumn();
        Syntax syntax2 = translator.currentSyntax;
        try {
            translator.setLine(pair);
            translator.currentSyntax = this;
            boolean bl = translator.scan_form(this.expand(pair, translator), vector, scopeExp);
            Object var11_10 = null;
            translator.setLine(string, n, n2);
            translator.currentSyntax = syntax2;
            return bl;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            translator.setLine(string, n, n2);
            translator.currentSyntax = syntax2;
            throw throwable;
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.getName());
        objectOutput.writeObject(((QuoteExp)this.expander).getValue());
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.setName((String)objectInput.readObject());
        this.expander = new QuoteExp(objectInput.readObject());
    }
}

