/*
 * Decompiled with CFR 0.152.
 */
package php.java.bridge;

import java.io.IOException;
import java.io.InputStream;
import php.java.bridge.IJavaBridgeFactory;
import php.java.bridge.JavaBridge;
import php.java.bridge.classloader.SimpleJavaBridgeClassLoader;
import php.java.bridge.http.IContext;
import php.java.bridge.http.ISession;
import php.java.bridge.parser.Request;
import php.java.bridge.util.Logger;

public abstract class JavaBridgeFactory
implements IJavaBridgeFactory {
    protected JavaBridge bridge = null;
    protected SimpleJavaBridgeClassLoader javaBridgeClassLoader;

    @Override
    public abstract ISession getSession(String var1, short var2, int var3);

    @Override
    public abstract IContext getContext();

    protected JavaBridge checkBridge() {
        return this.bridge;
    }

    @Override
    public JavaBridge getBridge() {
        if (this.bridge != null) {
            return this.bridge;
        }
        this.bridge = new JavaBridge(this);
        if (Logger.getLogLevel() >= 4) {
            Logger.logDebug("created new bridge: " + this.bridge);
        }
        return this.bridge;
    }

    @Override
    public boolean isNew() {
        return this.bridge == null;
    }

    @Override
    public void recycle() {
    }

    @Override
    public void destroy() {
        this.bridge = null;
    }

    @Override
    public void parseHeader(Request req, InputStream in) throws IOException {
        in.read();
        byte option = (byte)(0xFF & in.read());
        if (option == -1) {
            throw new IllegalStateException("not within a JEE environment");
        }
        req.init(option);
    }
}

