/*
 * Decompiled with CFR 0.152.
 */
package php.java.bridge.classloader;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringTokenizer;
import php.java.bridge.Util;
import php.java.bridge.classloader.DynamicJavaBridgeClassLoader;
import php.java.bridge.util.Logger;

class JarLibraryPath {
    private String path;
    private boolean isCached;
    private String rawPath;
    private String rawContextDir;
    private String cwd;
    private String searchpath;
    private URL[] urls;
    private boolean hasResult;
    private int result = 1;
    static Map urlCache = Collections.synchronizedMap(new HashMap());

    protected JarLibraryPath() {
        this.isCached = true;
    }

    public JarLibraryPath(String rawPath, String rawContextDir, String cwd, String searchpath) throws IOException {
        if (rawContextDir == null) {
            throw new NullPointerException("rawContextDir");
        }
        this.rawPath = rawPath;
        this.rawContextDir = rawContextDir;
        this.path = this.makePath(rawPath);
        this.cwd = cwd;
        this.searchpath = searchpath;
        this.urls = this.checkURLs();
    }

    public int hashCode() {
        if (this.hasResult) {
            return this.result;
        }
        this.result = this.result * 31 + this.rawPath.hashCode();
        this.result = this.result * 31 + this.rawContextDir.hashCode();
        this.hasResult = true;
        return this.result;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        JarLibraryPath that = (JarLibraryPath)o;
        if (this.rawContextDir != that.rawContextDir) {
            return false;
        }
        return this.rawPath.equals(that.rawPath);
    }

    private String makePath(String rawPath) {
        char c = rawPath.charAt(0);
        if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c != '.' || c != '/') {
            rawPath = ";" + rawPath;
        }
        return rawPath;
    }

    private String makeContextDir(String rawContextDir) {
        rawContextDir = new File(rawContextDir, "lib").getAbsolutePath();
        return rawContextDir;
    }

    public URL[] getURLs() {
        return this.urls;
    }

    private URL[] checkURLs() throws IOException {
        URL[] urls = (URL[])urlCache.get(this);
        if (urls != null) {
            this.urls = urls;
            this.isCached = true;
            return urls;
        }
        this.isCached = false;
        return this.createUrls();
    }

    static File checkSearchPath(String s, String searchpath) {
        int idx;
        boolean hasParent;
        if (searchpath == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(searchpath, File.pathSeparator);
        File f = new File(s);
        boolean bl = hasParent = f.getParent() != null;
        if (!hasParent && (idx = s.lastIndexOf(46)) != -1) {
            s = s.substring(0, idx) + File.separator + s;
        }
        while (st.hasMoreTokens()) {
            String el = st.nextToken();
            f = new File(el, s);
            if (!f.isFile()) continue;
            return f;
        }
        return null;
    }

    private URL[] createUrls() throws IOException {
        LinkedList<URL> toAdd = new LinkedList<URL>();
        String currentPath = this.path.substring(1);
        StringTokenizer st = new StringTokenizer(currentPath, this.path.substring(0, 1));
        String contextDir = this.makeContextDir(this.rawContextDir);
        while (st.hasMoreTokens()) {
            URL url;
            String s = st.nextToken();
            try {
                url = new URL(s);
                url = DynamicJavaBridgeClassLoader.checkUrl(url);
            }
            catch (MalformedURLException e) {
                try {
                    File f = null;
                    File file = null;
                    StringBuffer buf = new StringBuffer();
                    f = new File(s);
                    if (f.isFile() || f.isAbsolute()) {
                        buf.append(s);
                        file = f;
                    } else {
                        f = new File(contextDir, s);
                        if (f.isFile()) {
                            buf.append(f.getAbsolutePath());
                            file = f;
                        } else {
                            f = new File("/usr/share/java/" + s);
                            if (f.isFile()) {
                                buf.append(f.getAbsolutePath());
                                file = f;
                            } else {
                                f = new File(Util.JAVABRIDGE_LIB, s);
                                if (f.isFile()) {
                                    buf.append(f.getAbsolutePath());
                                    file = f;
                                } else {
                                    f = JarLibraryPath.checkSearchPath(s, this.searchpath);
                                    if (f != null) {
                                        buf.append(f.getAbsolutePath());
                                        file = f;
                                    } else if (this.cwd != null && (f = new File(this.cwd, s)).isFile()) {
                                        buf.append(f.getAbsolutePath());
                                        file = f;
                                    } else {
                                        buf.append(s);
                                        file = new File(s);
                                    }
                                }
                            }
                        }
                    }
                    if (file != null && file.isDirectory()) {
                        DynamicJavaBridgeClassLoader.addJars(toAdd, f);
                        int l = buf.length();
                        if (l > 0) {
                            if (buf.charAt(l - 1) == File.separatorChar) {
                                buf.setCharAt(l - 1, '/');
                            } else if (buf.charAt(l - 1) != '/') {
                                buf.append('/');
                            }
                        }
                    }
                    if (!file.isDirectory()) {
                        DynamicJavaBridgeClassLoader.checkJarFile(file);
                    }
                    url = new URL("file", null, buf.toString());
                }
                catch (MalformedURLException e1) {
                    Logger.printStackTrace(e1);
                    continue;
                }
            }
            toAdd.add(url);
        }
        URL[] urls = new URL[toAdd.size()];
        toAdd.toArray(urls);
        return urls;
    }

    public String getPath() {
        return this.path;
    }

    public void addToCache() {
        if (!this.isCached) {
            urlCache.put(this, this.urls);
            this.urls = null;
        }
    }
}

