/*
 * Decompiled with CFR 0.152.
 */
package php.java.bridge.generated;

public class PhpDebuggerPHP {
    private static final String data = "<?php /*-*- mode: php; tab-width:4 -*-*/\n\n  /**\n   * PHPDebugger.inc -- A PHP debugger for Eclipse for PHP Developers\n   *\n   * Copyright (C) 2009,2010 Jost Boekemeier.\n   *\n   * This file is part of the PHP/Java Bridge.\n   * \n   * The PHP/Java Bridge (\"the library\") is free software; you can\n   * redistribute it and/or modify it under the terms of the GNU General\n   * Public License as published by the Free Software Foundation; either\n   * version 2, or (at your option) any later version.\n   * \n   * The library is distributed in the hope that it will be useful, but\n   * WITHOUT ANY WARRANTY; without even the implied warranty of\n   * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU\n   * General Public License for more details.\n   * \n   * You should have received a copy of the GNU General Public License\n   * along with the PHP/Java Bridge; see the file COPYING.  If not, write to the\n   * Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA\n   * 02111-1307 USA.\n   * \n   * Linking this file statically or dynamically with other modules is\n   * making a combined work based on this library.  Thus, the terms and\n   * conditions of the GNU General Public License cover the whole\n   * combination.\n   * \n   * As a special exception, the copyright holders of this library give you\n   * permission to link this library with independent modules to produce an\n   * executable, regardless of the license terms of these independent\n   * modules, and to copy and distribute the resulting executable under\n   * terms of your choice, provided that you also meet, for each linked\n   * independent module, the terms and conditions of the license of that\n   * module.  An independent module is a module which is not derived from\n   * or based on this library.  If you modify this library, you may extend\n   * this exception to your version of the library, but you are not\n   * obligated to do so.  If you do not wish to do so, delete this\n   * exception statement from your version. \n   *\n   * Installation:\n   *\n   * Install \"Eclipse for PHP Developers\" version >= 3.5.2\n   * \n   * - Open Window -> Preferences -> Servers and set Default Web Server to: http://localhost:8080\n   * - Deploy JavaBridgeTemplate.war\n   * - Create a new Project using .../apache-tomcat-7.0.75/webapps/JavaBridgeTemplate as directory\n   * - Open index.php and start debugger: Default Web Server with Zend Debugger (other options default)\n   * - Click debug \n   *\n   * To debug standalone applications, remove zend_extension=ZendDebugger.so from your php.ini and set:\n   * \n   *<code>\n   * ;; activate the PHPDebugger in the php.ini\n   * auto_prepend_file=PHPDebugger.php\n   *</code>\n   *\n   * - Debug your PHP scripts as usual. \n   *\n   *\n   * @category   java\n   * @package    pdb\n   * @author     Jost Boekemeier\n   * @license    GPL+Classpath exception\n   * @version    7.0\n   * @link       http://php-java-bridge.sf.net/phpdebugger\n   */\n\n\n/** @access private */\ndefine (\"PDB_DEBUG\", 0);\nset_time_limit (0);\nif(!function_exists(\"token_get_all\")) {\n\tdl(\"tokenizer.so\");\n}\n\nif ($pdb_script_orig = $pdb_script = pdb_getDebugHeader(\"X_JAVABRIDGE_INCLUDE\", $_SERVER)) {\n\tif ($pdb_script!=\"@\") {\n\t\tif (($_SERVER['REMOTE_ADDR']=='127.0.0.1') || (($pdb_script = realpath($pdb_script)) && (!strncmp($_SERVER['DOCUMENT_ROOT'], $pdb_script, strlen($_SERVER['DOCUMENT_ROOT']))))) {\n\t\t\t$_SERVER['SCRIPT_FILENAME'] = $pdb_script; // set to the original script filename\n\t\t} else {\n\t\t\ttrigger_error(\"illegal access: \".$pdb_script_orig, E_USER_ERROR);\n\t\t\tunset($pdb_script);\n\t\t}\n\t}\n}\n\n\n\nif (!class_exists(\"pdb_Parser\")) {\n  /**\n   * The PHP parser\n   * @access private\n   */\n  class pdb_Parser {\n\tconst BLOCK = 1;\n\tconst STATEMENT = 2;\n\tconst EXPRESSION = 3;\n\tconst FUNCTION_BLOCK = 4; // BLOCK w/ STEP() as last statement\n\n\tprivate $scriptName, $content;\n\tprivate $code;\n\tprivate $output;\n\tprivate $line, $currentLine;\n\tprivate $beginStatement, $inPhp, $inDQuote;\n \n\t/**\n\t * Create a new PHP parser\n\t * @param string the script name\n\t * @param string the script content\n\t * @access private\n\t */\n\tpublic function __construct($scriptName, $content) {\n\t  $this->scriptName = $scriptName;\n\t  $this->content = $content;\n\t  $this->code = token_get_all($content);\n\t  $this->output = \"\";\n\t  $this->line = $this->currentLine = 0;\n\t  $this->beginStatement = $this->inPhp = $this->inDQuote = false;\n\t}\n\n\tprivate function toggleDQuote($chr) {\n\t  if ($chr == '\"') $this->inDQuote = !$this->inDQuote;\n\t}\n\n\tprivate function each() {\n\t  $next = each ($this->code);\n\t  if ($next) {\n\t\t$cur = current($this->code);\n\t\tif (is_array($cur)) {\n\t\t  $this->currentLine = $cur[2] + ($cur[1][0] == \"\\n\" ? substr_count($cur[1], \"\\n\") : 0);\n\t\t  if ($this->isWhitespace($cur)) {\n\t\t\t$this->write($cur[1]);\n\t\t\treturn $this->each();\n\t\t  }\n\t\t}\n\t\telse \n\t\t  $this->toggleDQuote($cur);\n\t  }\n\t  return $next;\n\t}\n\n\tprivate function write($code) {\n\t  //echo \"write:::\".$code.\"\\n\";\n\t  $this->output.=$code;\n\t}\n\n\tprivate function writeInclude($once) {\n\t  $name = \"\";\n\t  while(1) {\n\t\tif (!$this->each()) die(\"parse error\");\n\t\t$val = current($this->code);\n\t\tif (is_array($val)) {\n\t\t  $name.=$val[1];\n\t\t} else {\n\t\t  if ($val==';') break;\n\t\t  $name.=$val;\n\t\t}\n\t  }\n\t  if (PDB_DEBUG == 2) \n\t\t$this->write(\"EVAL($name);\");\n\t  else\n\t\t$this->write(\"eval('?>'.pdb_startInclude($name, $once)); pdb_endInclude();\");\n\t}\n\n\tprivate function writeCall() {\n\t  while(1) {\n\t\tif (!$this->each()) die(\"parse error\");\n\t\t$val = current($this->code);\n\t\tif (is_array($val)) {\n\t\t  $this->write($val[1]);\n\t\t} else {\n\t\t  $this->write($val);\n\t\t  if ($val=='{') break;\n\t\t}\n\t  }\n\t  $scriptName = addslashes($this->scriptName);\n\t  $this->write(\"\\$__pdb_CurrentFrame=pdb_startCall(\\\"$scriptName\\\", {$this->currentLine});\");\n\t}\n\n\tprivate function writeStep($pLevel) {\n\t  $token = current($this->code);\n\t  if ($this->inPhp && !$pLevel && !$this->inDQuote && $this->beginStatement && !$this->isWhitespace($token) && ($this->line != $this->currentLine)) {\n\t\t$line = $this->line = $this->currentLine;\n\t\t$scriptName = addslashes($this->scriptName);\n\t\tif (PDB_DEBUG == 2)\n\t\t  $this->write(\";STEP($line);\");\n\t\telse\n\t\t  $this->write(\";pdb_step(\\\"$scriptName\\\", $line, pdb_getDefinedVars(get_defined_vars(), (isset(\\$this) ? \\$this : NULL)));\");\n\t  }\n\t}\n\n\tprivate function writeNext() {\n\t  $this->next();\n\t  $token = current($this->code);\n\t  if (is_array($token)) $token = $token[1];\n\t  $this->write($token);\n\t}\n\n\tprivate function nextIs($chr) {\n\t  $i = 0;\n\t  while(each($this->code)) {\n\t\t$cur = current($this->code);\n\t\t$i++;\n\t\tif (is_array($cur)) {\n\t\t  switch ($cur[0]) {\n\t\t  case T_COMMENT:\n\t\t  case T_DOC_COMMENT:\n\t\t  case T_WHITESPACE:\n\t\t\tbreak;\t/* skip */\n\t\t  default: \n\t\t\twhile($i--) prev($this->code);\n\t\t\treturn false;\t/* not found */\n\t\t  }\n\t\t} else {\n\t\t  while($i--) prev($this->code);\n\t\t  return $cur == $chr;\t/* found */\n\t\t}\n\t  }\n\t  while($i--) prev($this->code);\n\t  return false;\t/* not found */\n\t}\n\n\tprivate function nextTokenIs($ar) {\n\t  $i = 0;\n\t  while(each($this->code)) {\n\t\t$cur = current($this->code);\n\t\t$i++;\n\t\tif (is_array($cur)) {\n\t\t  switch ($cur[0]) {\n\t\t  case T_COMMENT:\n\t\t  case T_DOC_COMMENT:\n\t\t  case T_WHITESPACE:\n\t\t\tbreak;\t/* skip */\n\t\t  default: \n\t\t\twhile($i--) prev($this->code);\n\t\t\treturn (in_array($cur[0], $ar));\n\t\t  }\n\t\t} else {\n\t\t  break; /* not found */\n\t\t}\n\t  }\n\t  while($i--) prev($this->code);\n\t  return false;\t/* not found */\n\t}\n\n\tprivate function isWhitespace($token) {\n\t  $isWhitespace = false;\n\t  switch($token[0]) {\n\t  case T_COMMENT:\n\t  case T_DOC_COMMENT:\n\t  case T_WHITESPACE:\n\t\t$isWhitespace = true;\n\t\tbreak;\n\t  }\n\t  return $isWhitespace;\n\t}\n\tprivate function next() {\n\t  if (!$this->each()) trigger_error(\"parse error\", E_USER_ERROR);\n\t}\n\n\tprivate function parseBlock () {\n\t  $this->parse(self::BLOCK);\n\t}\n\tprivate function parseFunction () {\n\t  $this->parse(self::FUNCTION_BLOCK);\n\t}\n\tprivate function parseStatement () {\n\t  $this->parse(self::STATEMENT);\n\t}\n\tprivate function parseExpression () {\n\t  $this->parse(self::EXPRESSION);\n\t}\n\n\tprivate function parse ($type) {\n\t  pdb_Logger::debug(\"parse:::$type\");\n\n\t  $this->beginStatement = true;\n\t  $pLevel = 0;\n\n\t  do {\n\t\t$token = current($this->code);\n\t\tif (!is_array($token)) {\n\t\t  pdb_Logger::debug(\":::\".$token);\n\t\t  if (!$pLevel && $type==self::FUNCTION_BLOCK && $token=='}') $this->writeStep($pLevel);\n\t\t  $this->write($token);\n\t\t  if ($this->inPhp && !$this->inDQuote) {\n\t\t\t$this->beginStatement = false; \n\t\t\tswitch($token) {\n\t\t\tcase '(': \n\t\t\t  $pLevel++;\n\t\t\t  break;\n\t\t\tcase ')':\n\t\t\t  if (!--$pLevel && $type==self::EXPRESSION) return;\n\t\t\t  break;\n\t\t\tcase '{': \n\t\t\t  $this->next();\n\t\t\t  $this->parseBlock(); \n\t\t\t  break;\n\t\t\tcase '}': \n\t\t\t  if (!$pLevel) return;\n\t\t\t  break;\n\t\t\tcase ';':\n\t\t\t  if (!$pLevel) {\n\t\t\t\tif ($type==self::STATEMENT) return;\n\t\t\t\t$this->beginStatement = true; \n\t\t\t  }\n\t\t\t  break;\n\t\t\t}\n\t\t  }\n\t\t} else {\n\t\t  pdb_Logger::debug(\":::\".$token[1].\":(\".token_name($token[0]).')');\n\n\t\t  if ($this->inDQuote) {\n\t\t\t$this->write($token[1]);\n\t\t\tcontinue;\n\t\t  }\n\n\t\t  switch($token[0]) {\n\n\t\t  case T_OPEN_TAG: \n\t\t  case T_START_HEREDOC:\n\t\t  case T_OPEN_TAG_WITH_ECHO: \n\t\t\t$this->beginStatement = $this->inPhp = true;\n\t\t\t$this->write($token[1]);\n\t\t\tbreak;\n\n\t\t  case T_END_HEREDOC:\n\t\t  case T_CLOSE_TAG: \n\t\t\t$this->writeStep($pLevel);\n\n\t\t\t$this->write($token[1]);\n\t\t\t$this->beginStatement = $this->inPhp = false; \n\t\t\tbreak;\n\n\t\t  case T_FUNCTION:\n\t\t\t$this->write($token[1]);\n\t\t\t$this->writeCall();\n\t\t\t$this->next();\n\t\t\t$this->parseFunction();\n\t\t\t$this->beginStatement = true;\n\t\t\tbreak;\n\n\t\t  case T_ELSE:\n\t\t\t$this->write($token[1]);\n\t\t\tif ($this->nextIs('{')) {\n\t\t\t  $this->writeNext();\n\t\t\t  $this->next();\n\n\t\t\t  $this->parseBlock();\n\t\t\t} else {\n\t\t\t  $this->next();\n\n\t\t\t  /* create an artificial block */\n\t\t\t  $this->write('{');\n\t\t\t  $this->beginStatement = true;\n\t\t\t  $this->writeStep($pLevel);\n\t\t\t  $this->parseStatement();\n\t\t\t  $this->write('}');\n\n\t\t\t}\n\t\t\tif ($type==self::STATEMENT) return;\n\n\t\t\t$this->beginStatement = true;\n\t\t\tbreak;\n\n\t\t  case T_DO:\n\t\t\t$this->writeStep($pLevel);\n\t\t\t$this->write($token[1]);\n\t\t\tif ($this->nextIs('{')) {\n\t\t\t  $this->writeNext();\n\t\t\t  $this->next();\n\n\t\t\t  $this->parseBlock();\n\t\t\t  $this->next();\n\n\t\t\t} else {\n\t\t\t  $this->next();\n\n\t\t\t  /* create an artificial block */\n\t\t\t  $this->write('{');\n\t\t\t  $this->beginStatement = true;\n\t\t\t  $this->writeStep($pLevel);\n\t\t\t  $this->parseStatement();\n\t\t\t  $this->next();\n\t\t\t  $this->write('}');\n\t\t\t}\n\t\t\t$token = current($this->code);\n\t\t\t$this->write($token[1]);\n\n\t\t\tif ($token[0]!=T_WHILE) trigger_error(\"parse error\", E_USER_ERROR);\n\t\t\t$this->next();\n\t\t\t$this->parseExpression();\n\n\t\t\tif ($type==self::STATEMENT) return;\n\n\t\t\t$this->beginStatement = true;\n\t\t\tbreak;\n\n\t\t  case T_CATCH:\n\t\t  case T_IF:\n\t\t  case T_ELSEIF:\n\t\t  case T_FOR:\n\t\t  case T_FOREACH:\n\t\t  case T_WHILE:\n\t\t\t$this->writeStep($pLevel);\n\n\t\t\t$this->write($token[1]);\n\t\t\t$this->next();\n\n\t\t\t$this->parseExpression();\n\n\t\t\tif ($this->nextIs('{')) {\n\t\t\t  $this->writeNext();\n\t\t\t  $this->next();\n\n\t\t\t  $this->parseBlock();\n\n\n\t\t\t} else {\n\t\t\t  $this->next();\n\t\t\t  /* create an artificial block */\n\t\t\t  $this->write('{');\n\t\t\t  $this->beginStatement = true;\n\t\t\t  $this->writeStep($pLevel);\n\t\t\t  $this->parseStatement();\n\t\t\t  $this->write('}');\n\t\t\t}\n\n\t\t\tif ($this->nextTokenIs(array(T_ELSE, T_ELSEIF, T_CATCH))) {\n\t\t\t  $this->beginStatement = false;\n\t\t\t} else {\n\t\t\t  if ($type==self::STATEMENT) return;\n\t\t\t  $this->beginStatement = true;\n\t\t\t}\n\t\t\tbreak;\n\n\t\t  case T_REQUIRE_ONCE:\n\t\t  case T_INCLUDE_ONCE: \n\t\t  case T_INCLUDE: \n\t\t  case T_REQUIRE: \n\t\t\t$this->writeStep($pLevel);\n\t\t\t$this->writeInclude((($token[0]==T_REQUIRE_ONCE) || ($token[0]==T_INCLUDE_ONCE)) ? 1 : 0);\n\n\t\t\tif ($type==self::STATEMENT) return;\n\n\t\t\t$this->beginStatement = true;\n\t\t\tbreak;\n\n\t\t  case T_CLASS:\n\t\t\t$this->write($token[1]);\n\t\t\t$this->writeNext();\n\t\t\tif ($this->nextIs('{')) {\n\t\t\t  $this->writeNext();\n\t\t\t  $this->next();\n\t\t\t  $this->parseBlock(); \n\t\t\t  $this->beginStatement = true;\n\t\t\t} else {\n\t\t\t  $this->writeNext();\n\t\t\t  $this->beginStatement = false;\n\t\t\t}\n\t\t\tbreak;\n\n\t\t  case T_CASE:\n\t\t  case T_DEFAULT:\n\t\t  case T_PUBLIC:\n\t\t  case T_PRIVATE:\n\t\t  case T_PROTECTED:\n\t\t  case T_STATIC:\n\t\t  case T_CONST:\n\t\t  case T_GLOBAL:\n\t\t  case T_ABSTRACT:\n\t\t\t$this->write($token[1]);\n\t\t\t$this->beginStatement = false;\n\t\t\tbreak;\n\n\t\t  default:\n\t\t\t$this->writeStep($pLevel);\n\t\t\t$this->write($token[1]);\n\t\t\t$this->beginStatement = false;\n\t\t\tbreak;\n\t\n\t\t  }\n\t\t}\n\t  } while($this->each());\n\t}\n\n\t/**\n\t * parse the given PHP script\n\t * @return the parsed PHP script\n\t * @access private\n\t */\n\tpublic function parseScript() {\n\t  do {\n\t\t$this->parseBlock();\n\t  } while($this->each());\n\n\t  return $this->output;\n\t}\n  }\n}\n\n/**\n * @access private\n */\nclass pdb_Logger {\n  const FATAL = 1;\n  const INFO = 2;\n  const VERBOSE = 3;\n  const DEBUG = 4;\n\n  private static $logLevel = 0;\n  private static $logFileName;\n\n  private static function println($msg, $level) {\n\tif (!self::$logLevel) self::$logLevel=PDB_DEBUG?self::DEBUG:self::INFO;\n\tif ($level <= self::$logLevel) {\n\t  static $file = null;\n\t  if(!isset(self::$logFileName)) {\n\t\tself::$logFileName = $_SERVER['HOME'].DIRECTORY_SEPARATOR.\"pdb_PHPDebugger.inc.log\";\n\t  }\n\t  if (!$file) $file = fopen(self::$logFileName, \"ab\") or die(\"fopen\");\n\t  fwrite($file, time().\": \");\n\t  fwrite($file, $msg.\"\\n\");\n\t  fflush($file);\n\t}\n  }\n\n  public static function logFatal($msg) {\n\tself::println($msg, self::FATAL);\n  }\n  public static function logInfo($msg) {\n\tself::println($msg, self::INFO);\n  }\n  public static function logMessage($msg) {\n\tself::println($msg, self::VERBOSE);\n  }\n  public static function logDebug($msg) {\n\tself::println($msg, self::DEBUG);\n  }\n  public static function debug($msg) {\n\tself::logDebug($msg);\n  }\n  public static function log($msg) {\n\tself::logMessage($msg);\n  }\n  public static function setLogLevel($level) {\n\tself::$logLevel=$level;\n  }\n  public static function setLogFileName($name) {\n\tself::$logFileName = $name;\n  }\n}\n\n/**\n * @access private\n */\nclass pdb_Environment {\n  public $filename, $stepNext;\n  public $vars, $line, $firstLine;\n  public $parent;\n\n  public function __construct($parent, $filename, $stepNext, $firstLine) {\n\t$this->parent = $parent;\n    $this->filename = $filename;\n    $this->stepNext = $stepNext;\n\t$this->firstLine = $firstLine;\n    $this->line = -1;\n  }\n\n  public function update ($line, &$vars) {\n    $this->line = $line;\n    $this->vars = &$vars;\n  }\n  public function __toString() {\n\treturn \"pdb_Environment: {$this->filename}, {$this->firstLine} - {$this->line}\";\n  }\n}\n\n/**\n * @access private\n */\nabstract class pdb_Message {\n  public $session;\n\n  public abstract function getType();\n\n  public function __construct($session) {\n    $this->session = $session;\n  }\n\n  public function serialize() {\n    $this->session->out->writeShort($this->getType());\n  }\n\n  private static $messages = array();\n  public static function register($message) {\n    pdb_Message::$messages[$message->getType()] = $message;\n  }\n  public function getMessageById($id) {\n    $message = pdb_Message::$messages[$id];\n    return $message;\n  }\n  public function getMessage() {\n    $id = $this->session->in->readShort();\n    $message = $this->getMessageById($id);\n    if (!$message) trigger_error(\"invalid message: $id\", E_USER_ERROR);\n    $message->deserialize();\n    return $message;\n  }\n\n  protected function handleContinueProcessFile($message) {\n\t$code = $this->session->parseCode($this->currentFrame->filename, file_get_contents($this->currentFrame->filename));\n\tif (PDB_DEBUG) pdb_Logger::debug( \"parse file:::\" . $code .\"\\n\");\n\tif (!PDB_DEBUG) ob_start();\n\tself::doEval ($code);\n\t$output = $this->getMessageById(pdb_OutputNotification::TYPE);\n\tif(!PDB_DEBUG) $output->setOutput(ob_get_contents());\n\tif(!PDB_DEBUG) ob_end_clean();\n\t$output->serialize();\n\t$this->status = 42; //FIXME\n\t$this->getMessageById(pdb_DebugScriptEndedNotification::TYPE)->serialize();\n    return true;\n  }\n  private static function doEval($__pdb_Code) {\n    return  eval (\"?>\".$__pdb_Code);\n  }\n  protected function handleStep($message) {\n    return false;\n  }\n  protected function handleGo($message) {\n    foreach ($this->session->allFrames as $frame) {\n      $frame->stepNext = false;\n    }\n    return true; // exit\n  }\n  public function handleRequests () {\n\t$this->ignoreInterrupt = false;\n\n    $this->serialize();\n    while(1) {\n      $message = $this->getMessage();\n      switch ($message->getType()) {\n      case pdb_SetProtocolRequest::TYPE:\n\t\t$message->ack();\n\t\tbreak;\n      case pdb_StartRequest::TYPE:\n\t\t$message->ack();\n\t\t$this->getMessageById(pdb_StartProcessFileNotification::TYPE)->serialize();\n\t\tbreak;\n      case pdb_ContinueProcessFileNotification::TYPE:\n\t\tif ($this->handleContinueProcessFile($message)) return pdb_ContinueProcessFileNotification::TYPE;\n\t\tbreak;\n      case pdb_AddBreakpointRequest::TYPE:\n\t\t$message->ack();\n\t\tbreak;\n      case pdb_RemoveBreakpointRequest::TYPE:\n\t\t$message->ack();\n\t\tbreak;\n      case pdb_RemoveAllBreakpointsRequest::TYPE:\n\t\t$message->ack();\n\t\tbreak;\n      case pdb_GetCallStackRequest::TYPE:\n\t\t$message->ack();\n\t\tbreak;\n      case pdb_GetCWDRequest::TYPE:\n\t\t$message->ack();\n\t\tbreak;\n      case pdb_GetVariableValueRequest::TYPE:\n\t\t$message->ack();\n\t\tbreak;\n      case pdb_AddFilesRequest::TYPE:\n\t\t$message->ack();\n\t\tbreak;\n      case pdb_FileContentExtendedRequest::TYPE:\n\t\t$message->ack();\n\t\tbreak;\n      case pdb_MsgEvalRequest::TYPE:\n\t\t$message->ack();\n\t\tbreak;\n      case pdb_GoRequest::TYPE:\n\t\t$message->ack();\n\t\tif ($this->handleGo($message)) return pdb_GoRequest::TYPE;\n\t\tbreak;\n      case pdb_StepOverRequest::TYPE:\n\t\t$message->ack();\n\t\tif ($this->handleStep($message)) return pdb_StepOverRequest::TYPE;\n\t\tbreak;\n      case pdb_StepIntoRequest::TYPE:\n\t\t$message->ack();\n\t\tif ($this->handleStep($message)) return pdb_StepIntoRequest::TYPE;\n\t\tbreak;\n      case pdb_StepOutRequest::TYPE:\n\t\t$message->ack();\n\t\tif ($this->handleStep($message)) return pdb_StepOutRequest::TYPE;\n\t\tbreak;\n      case pdb_End::TYPE:\n\t\t$this->session->end();\n      default: trigger_error(\"protocol error: $message\", E_USER_ERROR);\n      }\n    }\n  }\n}\n/**\n * @access private\n */\nabstract class pdb_MessageRequest extends pdb_Message {\n  public abstract function ack();\n}\n\n/**\n * @access private\n */\nclass pdb_Serializer {\n  private $serial;\n  private $depth;\n\n  private function doSerialize ($o, $depth) {\n    $serial = &$this->serial;\n\n    switch(gettype($o)) {\n    case 'object':\n      $serial.=\"O:\";\n      $serial.=strlen(get_class($o));\n      $serial.=\":\\\"\";\n      $serial.=get_class($o);\n      $serial.=\"\\\":\";\n      $serial.=count((array)$o);\n\n\t  if ($depth <= $this->depth) {\n\t\t$serial.=\":{\";\n\t\tforeach((array)$o as $k=>$v) {\n\t\t  $serial.=serialize($k);\n\t\t  $this->doSerialize($v, $depth+1);\n\t\t}\n\t\t$serial.=\"}\";\n\t  } else {\n\t\t$serial .= \";\";\n\t  }\n      break;\n\n    case 'array':\n      $serial.=\"a:\";\n      $serial.=count($o);\n\n\t  if ($depth <= $this->depth) {\n\t\t$serial.=\":{\";\n\t\tforeach($o as $k=>$v) {\n\t\t  $serial.=serialize($k);\n\t\t  $this->doSerialize($v, $depth+1);\n\t\t}\n\t\t$serial.=\"}\";\n\t  } else {\n\t\t$serial.=\";\";\n\t  }\n      break;\n    default:\n      $serial.=serialize($o);\n      break;\n    }\n  }\n\n  public function serialize ($obj, $depth) {\n    $this->serial = \"\";\n\t$this->depth = $depth;\n\n    $this->doSerialize ($obj, 1);\n\n    return $this->serial;\n  }\n}\n\n/**\n * @access private\n */\nclass pdb_DebugSessionStart extends pdb_Message {\n  const TYPE = 2005;\n\n  public $status;\n  public $end;\n\n  private $breakFirstLine;\n  private $enable;\n  public $uri;\n  public $query;\n  public $options;\n  \n  public $in, $out;\n  private $outputNotification;\n\n  public $lines;\n  public $breakpoints;\n\n  public $currentTopLevelFrame, $currentFrame;\n  public $allFrames; // should be a weak map so that frames could be gc'ed\n\n  public $ignoreInterrupt; \n\n  public $serializer;\n\n  public $includedScripts;\n\n  public function getType() {\n    return self::TYPE;\n  }\n  public function __construct($options) {\n    parent::__construct($this);\n\t$this->end = true;\n\tif (isset($_SERVER[\"SCRIPT_FILENAME\"]) && isset($_SERVER[\"QUERY_STRING\"])&&!extension_loaded(\"Zend Debugger\")) {\n\t  $filename = $uri = $_SERVER[\"SCRIPT_FILENAME\"];\n\t  $queryStr = $_SERVER[\"QUERY_STRING\"];\n\t} else { // PHPDebugger disabled\n\t  global $pdb_script;\n\t  $this->enable = false;\n\t  if (isset($pdb_script) && $pdb_script!=\"@\") {\n\t  \trequire_once($pdb_script);\n\t  }\n\t  return;\n\t}\n\n\t$params = explode('&', $queryStr);\n\t$args = array();\n\tfor ($i=0; $i<count($params); $i++) {\n\t\t$arg=explode( '=', urldecode($params[$i]));\n\t\t$args[$arg[0]] = $arg[1];\n\t}\n\t$this->enable = $args[\"start_debug\"];\n\t$this->breakFirstLine = isset($args[\"debug_stop\"]) ? $args[\"debug_stop\"] : 0;\n    $this->uri = $uri;\n    $this->query = $queryStr;\n    $this->options = $options;\n    $this->breakpoints = $this->lines = array();\n\n\t$this->serializer = new pdb_Serializer();\n\n\t$this->currentTopLevelFrame = $this->currentFrame = new pdb_Environment(null, $filename, false, 1);\n\t$this->allFrames[] = $this->currentFrame;\n\t$this->ignoreInterrupt = false;\n\t$this->includedScripts = array();\n\n    $errno = 0; $errstr = \"\";\n    $io = null;\n    foreach(explode(\",\", $args[\"debug_host\"]) as $host) {\n        if ($io = fsockopen($host, $args['debug_port'], $errno, $errstr, 5)) {\n            break;\n        }\n    }\n    if ($io==null) {\n        trigger_error(\"fsockopen\", E_USER_ERROR);\n    }\n\t$this->end = false;\n\n    $this->in =new pdb_In($io, $this);\n    $this->out=new pdb_Out($io, $this);\n  }\n  public function end() {\n\t$this->end = true;\n\tif (PDB_DEBUG) pdb_Logger::debug( \"end() called\");\n\texit(0);\n  }\n  /**\n   * @access private\n   */\n  public function flushOutput() {\n\tif (!isset($this->outputNotification))\n\t  $this->outputNotification = $this->getMessageById(pdb_OutputNotification::TYPE);\n\n\t$this->outputNotification->setOutput(ob_get_contents());\n\tif (!PDB_DEBUG) ob_clean();\n\t$this->outputNotification->serialize();\n  }\n\n  /**\n   * @access private\n   */\n  public function resolveIncludePath($scriptName) {\n\tif (file_exists($scriptName)) return realpath($scriptName);\n\t$paths = explode(PATH_SEPARATOR, get_include_path());\n\t$name = $scriptName;\n\tforeach ($paths as $path) {\n\t  $scriptName = realpath(\"${path}${name}\");\n\t  if ($scriptName) return $scriptName;\n\t}\n\ttrigger_error(\"file $scriptName not found\", E_USER_ERROR);\n  }\n\n  public function serialize() {\n    $out = $this->session->out;\n    parent::serialize();\n    $out->writeInt(2004102501);\n    $out->writeString($this->currentFrame->filename);\n    $out->writeString($this->uri);\n    $out->writeString($this->query);\n    $out->writeString($this->options);\n    $out->flush();\n    if (PDB_DEBUG) pdb_Logger::debug( \"$this\");\n  }\n  public function handleRequests () {\n\tif ($this->enable) {\n\t  set_error_handler(\"pdb_error_handler\");\n\t  register_shutdown_function(\"pdb_shutdown\");\n\n\t  parent::handleRequests(); \n\t  if (PDB_DEBUG) pdb_Logger::debug( \"exit({$this->status})\");\n\t  exit ($this->status); }\n  }\n  public function hasBreakpoint($scriptName, $line) {\n\tif ($this->breakFirstLine) {$this->breakFirstLine = false; return true;}\n\n    if ($this->currentFrame->stepNext) return true;\n\n    foreach ($this->breakpoints as $breakpoint) {\n      if($breakpoint->type==1) {\n\t\tif ($breakpoint->file==$scriptName&&$breakpoint->line==$line) return true;\n      }\n    }\n\n    return false;\n  }\n  function parseCode($filename, $contents) {\n\t$parser = new pdb_Parser($filename, $contents);\n\treturn $parser->parseScript();\n  }\n\n  public function __toString() {\n    return \"pdb_DebugSessionStart: {$this->currentFrame->filename}\";\n  }\n}\n\n\n/**\n * @access private\n */\nclass pdb_HeaderOutputNotification extends pdb_Message {\n  const TYPE = 2008;\n  private $out;\n\n  public function setOutput($out) {\n    $this->out = $out;\n  }\n  protected function getAsciiOutput() {\n    return $this->out;\n  }\n  protected function getEncodedOutput () {\n    return $this->out; //FIXME\n  }\n  protected function getOutput() {\n    return $this->getAsciiOutput();\n  }\n  public function getType() {\n    return self::TYPE;\n  }\n\n  public function serialize() {\n    $out = $this->session->out;\n    parent::serialize();\n    $out->writeString($this->getOutput());\n    $out->flush();\n    if (PDB_DEBUG) pdb_Logger::debug( \"$this\");\n  }\n  public function __toString () {\n    return \"pdb_HeaderOutputNotification: \".$this->getOutput();\n  }\n}\n\n/**\n * @access private\n */\nclass pdb_OutputNotification extends pdb_HeaderOutputNotification {\n  const TYPE = 2004;\n\n  public function getType() {\n    return self::TYPE;\n  }\n  protected function getOutput() {\n    return $this->getEncodedOutput();\n  }\n  public function __toString () {\n    return \"pdb_OutputNotification: \".$this->getAsciiOutput();\n  }\n}\n\n/**\n * @access private\n */\nclass pdb_ErrorNotification extends pdb_Message {\n  const TYPE = 2006;\n  private $type, $filename, $lineno, $error;\n\n  public function getType() {\n    return self::TYPE;\n  }\n  public function setError($type, $filename, $lineno, $error) {\n\t$this->type = $type;\n\t$this->filename = $filename;\n\t$this->lineno = $lineno;\n\t$this->error = $error;\n  }\n\n  public function serialize() {\n    $out = $this->session->out;\n    parent::serialize();\n    $out->writeInt($this->type);\n\t$out->writeString($this->filename);\n\t$out->writeInt($this->lineno);\n\t$out->writeString($this->error);\n    $out->flush();\n    if (PDB_DEBUG) pdb_Logger::debug( \"$this\");\n  }\n  public function __toString () {\n    return \"pdb_ErrorNotification: {$this->error} at {$this->filename} line {$this->lineno}\";\n  }\n}\n\n/**\n * @access private\n */\nclass pdb_DebugScriptEndedNotification extends pdb_Message {\n  const TYPE = 2002;\n\n  public function getType() {\n    return self::TYPE;\n  }\n\n  public function serialize() {\n    $out = $this->session->out;\n    parent::serialize();\n    $out->writeShort($this->session->status);\n    $out->flush();\n    if (PDB_DEBUG) pdb_Logger::debug( \"$this\");\n  }\n  public function __toString () {\n    return \"pdb_DebugScriptEndedNotification: {$this->session->status}\";\n  }\n}\n\n\n/**\n * @access private\n */\nclass pdb_ReadyNotification extends pdb_Message {\n  const TYPE = 2003;\n  \n  public function getType() {\n    return self::TYPE;\n  }\n\n  protected function handleStep($message) {\n    return true;\n  }\n\n  public function serialize() {\n    $out = $this->session->out;\n    parent::serialize();\n    $out->writeString($this->session->currentFrame->filename);\n    $out->writeInt($this->session->currentFrame->line);\n    $out->writeInt(0);\n    $out->flush();\n    if (PDB_DEBUG) pdb_Logger::debug( \"$this\");\n  }\n  public function __toString () {\n    return \"pdb_ReadyNotification: {$this->session->currentFrame->filename}, {$this->session->currentFrame->line}\";\n  }\n}\n\n/**\n * @access private\n */\nclass pdb_SetProtocolRequest extends pdb_MessageRequest {\n  const TYPE = 10000;\n  public $id;\n  public $protocolId;\n  \n  public function getType() {\n    return self::TYPE;\n  }\n  public function deserialize() {\n    $in = $this->session->in;\n    $this->id = $in->readInt();\n    $this->protocolId = $in->readInt();\n    if (PDB_DEBUG) pdb_Logger::debug( \"$this\");\n  }\n  public function ack() {\n    $res = new pdb_SetProtocolResponse($this);\n    $res->serialize();\n  }\n  public function __toString () {\n    return \"pdb_SetProtocolRequest: \". $this->protocolId;\n  }\n}\n\n/**\n * @access private\n */\nclass pdb_SetProtocolResponse extends pdb_Message {\n  const TYPE = 11000;\n  private $req;\n  \n  public function __construct ($req) {\n    parent::__construct($req->session);\n    $this->req = $req;\n  }\n\n  public function getType() {\n    return self::TYPE;\n  }\n  public function serialize() {\n    $out = $this->session->out;\n    parent::serialize();\n    $out->writeInt($this->req->id);\n\n    // use fixed id instead of $out->writeInt($this->req->protocolId);\n\t$out->writeInt(2012121702);\n\n    $out->flush();\n    if (PDB_DEBUG) pdb_Logger::debug( \"$this\");\n  }\n  public function __toString () {\n    return \"pdb_SetProtocolResponse: \";\n  }\n}\n\n/**\n * @access private\n */\nclass pdb_StartRequest extends pdb_MessageRequest {\n  const TYPE = 1;\n  public $id;\n  public $protocolId;\n  \n  public function getType() {\n    return self::TYPE;\n  }\n  public function deserialize() {\n    $in = $this->session->in;\n    $this->id = $in->readInt();\n    if (PDB_DEBUG) pdb_Logger::debug( \"$this\");\n  }\n\n  public function ack() {\n    $res = new pdb_StartResponse($this);\n    $res->serialize();\n  }\n  public function __toString () {\n    return \"pdb_StartRequest: \";\n  }\n}\n\n/**\n * @access private\n */\nclass pdb_AddFilesRequest extends pdb_MessageRequest {\n  const TYPE = 38;\n  public $id;\n  public $pathSize;\n  public $paths;\n\n  public function getType() {\n    return self::TYPE;\n  }\n  public function deserialize() {\n    $in = $this->session->in;\n    $this->id = $in->readInt();\n    $this->pathSize = $in->readInt();\n    $this->paths = array();\n    for($i=0; $i<$this->pathSize; $i++) {\n       $this->paths[] = $in->readString();\n    }\n    if (PDB_DEBUG) pdb_Logger::debug( \"$this\");\n  }\n\n  public function ack() {\n    $res = new pdb_AddFilesResponse($this);\n    $res->serialize();\n  }\n  public function __toString () {\n    return \"pdb_AddFilesRequest: \";\n  }\n}\n/**\n * @access private\n */\nclass pdb_FileContentExtendedRequest extends pdb_MessageRequest {\n  const TYPE = 10002;\n  public $id;\n  public $size;\n  public $checksum;\n\n  public function getType() {\n    return self::TYPE;\n  }\n  public function deserialize() {\n    $in = $this->session->in;\n    $this->id = $in->readInt();\n    $this->size = $in->readInt();\n    $this->checksum = $in->readInt();\n\n    if (PDB_DEBUG) pdb_Logger::debug( \"$this\");\n  }\n\n  public function ack() {\n    $res = new pdb_FileContentExtendedResponse($this);\n    $res->serialize();\n  }\n  public function __toString () {\n    return \"pdb_FileContentExtendedRequest: \";\n  }\n}\n\n/**\n * @access private\n */\nclass pdb_AddFilesResponse extends pdb_Message {\n  const TYPE = 1038;\n  private $req;\n  \n  public function __construct ($req) {\n    parent::__construct($req->session);\n    $this->req = $req;\n  }\n\n  public function getType() {\n    return self::TYPE;\n  }\n  public function serialize() {\n    $out = $this->session->out;\n    parent::serialize();\n    $out->writeInt($this->req->id);\n    $out->writeInt(0);\n    $out->flush();\n    if (PDB_DEBUG) pdb_Logger::debug( \"$this\");\n  }\n  public function __toString () {\n    return \"pdb_AddFilesResponse: \";\n  }\n}\n\n/**\n * @access private\n */\nclass pdb_FileContentExtendedResponse extends pdb_Message {\n  const TYPE = 11001;\n  private $req;\n  \n  public function __construct ($req) {\n    parent::__construct($req->session);\n    $this->req = $req;\n  }\n\n  public function getType() {\n    return self::TYPE;\n  }\n  public function serialize() {\n    $out = $this->session->out;\n    parent::serialize();\n    $out->writeInt($this->req->id);\n    $out->writeInt(0); // fixme: status\n    $out->writeInt(0); // fixme: string: filecontent\n    $out->flush();\n    if (PDB_DEBUG) pdb_Logger::debug( \"$this\");\n  }\n  public function __toString () {\n    return \"pdb_FileContentExtendedResponse: \";\n  }\n}\n\n/**\n * @access private\n */\nclass pdb_StartResponse extends pdb_Message {\n  const TYPE = 1001;\n  private $req;\n  \n  public function __construct ($req) {\n    parent::__construct($req->session);\n    $this->req = $req;\n  }\n\n  public function getType() {\n    return self::TYPE;\n  }\n  public function serialize() {\n    $out = $this->session->out;\n    parent::serialize();\n    $out->writeInt($this->req->id);\n    $out->writeInt(0);\n    $out->flush();\n    if (PDB_DEBUG) pdb_Logger::debug( \"$this\");\n  }\n  public function __toString () {\n    return \"pdb_StartResponse: \";\n  }\n}\n/**\n * @access private\n */\nclass pdb_StartProcessFileNotification extends pdb_Message {\n  const TYPE = 2009;\n  public function __construct ($session) {\n    parent::__construct($session);\n  }\n  protected function handleContinueProcessFile($message) {\n    return true; // next\n  }\n  public function getType() {\n    return self::TYPE;\n  }\n  public function serialize() {\n    $out = $this->session->out;\n    parent::serialize();\n    $out->writeString($this->session->currentFrame->filename);\n    $out->flush();\n    if (PDB_DEBUG) pdb_Logger::debug( \"$this\");\n  }\n  public function __toString () {\n    return \"pdb_StartProcessFileNotification: {$this->session->currentFrame->filename}\";\n  }\n}\n\n/**\n * @access private\n */\nclass pdb_ContinueProcessFileNotification extends pdb_Message {\n  const TYPE = 2010;\n  public function getType() {\n    return self::TYPE;\n  }\n  public function deserialize() {\n    if (PDB_DEBUG) pdb_Logger::debug( \"$this\");\n  }\n  public function __toString () {\n    return \"pdb_ContinueProcessFileNotification: \";\n  }\n}\n\n/**\n * @access private\n */\nclass pdb_Breakpoint {\n  public $type, $lifeTime, $file, $line, $condition;\n  private $id;\n\n  public function __construct($type, $lifeTime, $file, $line, $condition, $id) {\n    $this->type = $type;\n    $this->lifeTime = $lifeTime;\n    $this->file = $file;\n    $this->line = $line;\n    $this->condition = $condition;\n    $this->id = $id;\n  }\n  public function __toString () {\n    return \"pdb_Breakpoint: \";\n  }\n}\n/**\n * @access private\n */\nclass pdb_AddBreakpointResponse extends pdb_Message {\n  const TYPE = 1021;\n  private $req;\n  private $id;\n\n  private static function getId() {\n    static $id = 0;\n    return ++$id;\n  }\n\n  public function __construct($req) {\n    parent::__construct($req->session);\n    $this->req = $req;\n    $this->id = self::getId();\n    $this->session->breakpoints[$this->id] = new pdb_Breakpoint($req->type, $req->lifeTime, $req->file, $req->line, $req->condition, $this->id);\n  }\n\n  public function getType() {\n    return self::TYPE;\n  }\n  public function serialize() {\n    $out = $this->session->out;\n    parent::serialize();\n    $out->writeInt($this->req->id);\n    $out->writeInt(0);\n    $out->writeInt($this->id);\n    $out->flush();\n    if (PDB_DEBUG) pdb_Logger::debug( \"$this\");\n  }\n  public function __toString () {\n    return \"pdb_AddBreakpointResponse: {$this->id}\";\n  }\n}\n\n/**\n * @access private\n */\nclass pdb_RemoveBreakpointResponse extends pdb_Message {\n  const TYPE = 1022;\n  private $req;\n  private $id;\n  private $failure;\n\n  public function __construct($req) {\n    parent::__construct($req->session);\n    $this->req = $req;\n\n\t$this->remove();\n  }\n\n  protected function remove() {\n\tif (isset($this->session->breakpoints[$this->req->bpId])) {\n\t  unset($this->session->breakpoints[$this->req->bpId]);\n\t  $this->failure = 0;\n\t} else {\n\t  $this->failure = -1;\n\t}\n  }\n\n  public function getType() {\n    return self::TYPE;\n  }\n  public function serialize() {\n    $out = $this->session->out;\n    parent::serialize();\n    $out->writeInt($this->req->id);\n    $out->writeInt($this->failure);\n    $out->flush();\n    if (PDB_DEBUG) pdb_Logger::debug( \"$this\");\n  }\n  public function __toString () {\n    return \"pdb_RemoveBreakpointResponse: {$this->id}\";\n  }\n}\n/**\n * @access private\n */\nclass pdb_RemoveAllBreakpointsResponse extends pdb_RemoveBreakpointResponse {\n  const TYPE = 1023;\n  public function __construct($req) {\n    parent::__construct($req);\n  }\n\n  protected function remove() {\n\t$keys = array_keys($this->session->breakpoints);\n\tforeach($keys as $key)\n\t  unset($this->session->breakpoints[$key]);\n\t\n\t$this->failure = 0;\n  }\n\n  public function getType() {\n    return self::TYPE;\n  }\n\n  public function __toString () {\n    return \"pdb_RemoveAllBreakpoinstResponse: {$this->id}\";\n  }\n}\n\n/**\n * @access private\n */\nclass pdb_AddBreakpointRequest extends pdb_MessageRequest {\n  const TYPE = 21;\n  public $id;\n  public $type;\n  public $lifeTime;\n\n  public $file;\n  public $line;\n\n  public $condition;\n\n  public function getType() {\n    return self::TYPE;\n  }\n  public function deserialize() {\n    $in = $this->session->in;\n    $this->id = $in->readInt();\n    $this->type = $in->readShort();\n    $this->lifeType = $in->readShort();\n    switch($this->type) {\n    case 1: \n      $this->file = $in->readString();\n      $this->line = $in->readInt();\n      break;\n    case 2:\n      $this->condition = $in->readString();\n      break;\n    default: \n      trigger_error(\"invalid breakpoint\", E_USER_ERROR);\n    }\n    if (PDB_DEBUG) pdb_Logger::debug( \"$this\");\n  }\n  public function ack() {\n    $res = new pdb_AddBreakpointResponse ($this);\n    $res->serialize();\n  }\n  public function __toString () {\n    if ($this->type == 1) \n      return \"pdb_AddBreakpointRequest: {$this->file}, {$this->line}\";\n    else\n      return \"pdb_AddBreakpointRequest: {$this->condition}\";\n  }\n}\n/**\n * @access private\n */\nclass pdb_RemoveAllBreakpointsRequest extends pdb_MessageRequest {\n  const TYPE = 23;\n  public $id;\n\n  public function getType() {\n    return self::TYPE;\n  }\n  public function deserialize() {\n    $in = $this->session->in;\n    $this->id = $in->readInt();\n    if (PDB_DEBUG) pdb_Logger::debug( \"$this\");\n  }\n  public function ack() {\n    $res = new pdb_RemoveAllBreakpointsResponse ($this);\n    $res->serialize();\n  }\n  public function __toString () {\n\treturn \"pdb_RemoveAllBreakpointsRequest \";\n  }\n}\n/**\n * @access private\n */\nclass pdb_RemoveBreakpointRequest extends pdb_RemoveAllBreakpointsRequest {\n  const TYPE = 22;\n  public $bpId;\n\n  public function getType() {\n    return self::TYPE;\n  }\n\n  public function deserialize() {\n\tparent::deserialize();\n    $in = $this->session->in;\n    $this->bpId = $in->readInt();\n    if (PDB_DEBUG) pdb_Logger::debug( \"$this\");\n  }\n  public function ack() {\n    $res = new pdb_RemoveBreakpointResponse ($this);\n    $res->serialize();\n  }\n  public function __toString () {\n\treturn \"pdb_RemoveBreakpointRequest: {$this->bpId}\";\n  }\n}\n\n/**\n * @access private\n */\nclass pdb_GetCallStackResponse extends pdb_Message {\n  const TYPE = 1034;\n  private $req;\n\n  public function __construct($req) {\n    parent::__construct($req->session);\n    $this->req = $req;\n  }\n\n  public function getType() {\n    return self::TYPE;\n  }\n  public function serialize() {\n    $out = $this->session->out;\n    parent::serialize();\n    $out->writeInt($this->req->id);\n\n\tfor($frame=$this->session->currentFrame; $frame; $frame=$frame->parent)\n\t  $environments[] = $frame;\n\n\t$environments = array_reverse($environments);\n    $n = count($environments);\n\n    $out->writeInt($n);\n    for ($i=0; $i<$n; $i++) {\n\t  $env = $environments[$i];\n      $out->writeString($env->filename);\n      $out->writeInt($env->line);\n      $out->writeInt(0);\n      $out->writeString($env->filename);\n      $out->writeInt($env->firstLine);\n      $out->writeInt(0);\n      $out->writeInt(0); //fixme: params\n    }\n\n\t$out->flush();\n    if (PDB_DEBUG) pdb_Logger::debug( \"$this\");\n  }\n  public function __toString () {\n    return \"pdb_GetCallStackResponse: \";\n  }\n}\n/**\n * @access private\n */\nclass pdb_GetCallStackRequest extends pdb_MessageRequest {\n  const TYPE = 34;\n  public $id;\n\t\n  public function getType() {\n    return self::TYPE;\n  }\n  public function deserialize() {\n    $in = $this->session->in;\n    $this->id = $in->readInt();\n    if (PDB_DEBUG) pdb_Logger::debug( \"$this\");\n  }\n  public function ack() {\n    $res = new pdb_GetCallStackResponse ($this);\n    $res->serialize();\n  }\n  public function __toString () {\n    return \"pdb_GetCallStackRequest: \";\n  }\n}\n\n\n/**\n * @access private\n */\nclass pdb_GetCWDResponse extends pdb_Message {\n  const TYPE = 1036;\n  private $req;\n\n  public function __construct ($req) {\n    parent::__construct($req->session);\n    $this->req = $req;\n  }\n\n  public function getType() {\n    return self::TYPE;\n  }\n  public function serialize() {\n    $out = $this->session->out;\n    parent::serialize();\n    $out->writeInt($this->req->id);\n    $out->writeInt(0);\n    $out->writeString(getcwd());    \n    $out->flush();\n    if (PDB_DEBUG) pdb_Logger::debug( \"$this\");\n  }\n  public function __toString () {\n    return \"pdb_GetCWDResponse: \";\n  }\n}\n\n/**\n * @access private\n */\nclass pdb_GetCWDRequest extends pdb_MessageRequest {\n  const TYPE = 36;\n  public $id;\n\n  public function getType() {\n    return self::TYPE;\n  }\n  public function deserialize() {\n    $in = $this->session->in;\n    $this->id = $in->readInt();\n    if (PDB_DEBUG) pdb_Logger::debug( \"$this\");\n  }\n  public function ack() {\n    $res = new pdb_GetCWDResponse($this);\n    $res->serialize();\n  }\n  public function __toString () {\n    return \"pdb_GetCWDRequest: \";\n  }\n}\n\n/**\n * @access private\n */\nclass pdb_MsgEvalResponse extends pdb_Message {\n  const TYPE = 1031;\n  private $req;\n\n  public function __construct ($req) {\n    parent::__construct($req->session);\n    $this->req = $req;\n  }\n\n  public function getType() {\n    return self::TYPE;\n  }\n\n  public function serialize() {\n    $out = $this->session->out;\n    parent::serialize();\n    $out->writeInt($this->req->id);\n    if (PDB_DEBUG) pdb_Logger::debug( \"evalcode:::\".$this->req->code.\"\\n\");\n\t$error = 0;\n    $code = $this->req->code;\n    $res = eval(\"return $code ?>\");\n \t$out->writeInt($error);\n    $out->writeString($res);\n\n\tif (PDB_DEBUG) pdb_Logger::debug(\"pdb_MsgEvalResponse: \".print_r($res, true));\n    $out->flush();\n  }\n  public function __toString () {\n    return \"pdb_MsgEvalResponse: \";\n  }\n}\n/**\n * @access private\n */\nclass pdb_GetVariableValueResponse extends pdb_Message {\n  const TYPE = 1032;\n  private $req;\n\n  public function __construct ($req) {\n    parent::__construct($req->session);\n    $this->req = $req;\n  }\n\n  public function getType() {\n    return self::TYPE;\n  }\n\n  public function serialize() {\n    $out = $this->session->out;\n    parent::serialize();\n    $out->writeInt($this->req->id);\n    if (PDB_DEBUG) pdb_Logger::debug( \"evalcode:::\".$this->req->code.\"\\n\");\n\t$error = 0;\n    if ($this->req->code[0]=='$') {\n\n\t  $this->session->end = true;\n\t  $key = substr($this->req->code, 1);\n\t  if (isset($this->session->currentFrame->vars[$key])) {\n\t\t$var = $this->session->currentFrame->vars[$key];\n\t\t$paths = $this->req->paths;\n\t\tforeach ($paths as $path) {\n\t\t  if (is_object($var)) {\n\t\t\t$var = $var->$path;\n\t\t  } else {\n\t\t\t$var = $var[$path];\n\t\t  }\n\t\t}\n\t  } else {\n\t\t$var = \"${key} not found!\";\n\t\t$error = -1;\n\t  }\n\t  $ser = $this->session->serializer->serialize($var, $this->req->depth);\n\t  $this->session->end = false;\n\n\t  $out->writeInt($error);\n      $out->writeString($ser);\n\t  if (PDB_DEBUG) pdb_Logger::debug(\"pdb_GetVariableValueResponse: \".print_r($var, true).\": ${ser}, error: ${error}\");\n    } else {\n\t  if (PDB_DEBUG) pdb_Logger::debug(print_r($this->session->currentFrame->vars, true));\n\n\t  $this->session->end = true;\n\t  $vars = $this->session->currentFrame->vars;\n\t  $ser = $this->session->serializer->serialize($vars, $this->req->depth);\n\t  $this->session->end = false;\n\n\t  $out->writeInt($error);\n\t  $out->writeString($ser);\n\t  if (PDB_DEBUG) pdb_Logger::debug(\"pdb_GetVariableValueResponse: \".print_r($vars, true).\": ${ser}, error: ${error}\");\n\t}\n    $out->flush();\n  }\n  public function __toString () {\n    return \"pdb_GetVariableValueResponse: \";\n  }\n}\n\n/**\n * @access private\n */\nclass pdb_MsgEvalRequest extends pdb_MessageRequest {\n  const TYPE = 31;\n  public $id;\n  public $code;\n\n  public function getType() {\n    return self::TYPE;\n  }\n  public function deserialize() {\n    $in = $this->session->in;\n    $this->id = $in->readInt();\n    $this->code = $in->readString();\n\n    if (PDB_DEBUG) pdb_Logger::debug( \"$this\");\n  }\n  public function ack() {\n    $res = new pdb_MsgEvalResponse($this);\n    $res->serialize();\n  }\n  public function __toString () {\n    return \"pdb_MsgEvalRequest: {$this->code}\";\n  }\n}\n\n/**\n * @access private\n */\nclass pdb_GetVariableValueRequest extends pdb_MessageRequest {\n  const TYPE = 32;\n  public $id;\n  public $code;\n  public $depth;\n  public $paths;\n\n  public function getType() {\n    return self::TYPE;\n  }\n  public function deserialize() {\n    $in = $this->session->in;\n    $this->id = $in->readInt();\n    $this->code = $in->readString();\n    $this->depth = $in->readInt();\n\n    $this->paths = array();\n    $length = $in->readInt();\n    while($length--) {\n      $this->paths[] = $in->readString();\n    }\n    if (PDB_DEBUG) pdb_Logger::debug( \"$this\");\n  }\n  public function ack() {\n    $res = new pdb_GetVariableValueResponse($this);\n    $res->serialize();\n  }\n  public function __toString () {\n    return \"pdb_GetVariableValueRequest: {$this->code}, {$this->depth}, paths::\".print_r($this->paths, true);\n  }\n}\n\n/**\n * @access private\n */\nclass pdb_StepOverResponse extends pdb_Message {\n  const TYPE = 1012;\n  private $req;\n\n  public function __construct($req) {\n    parent::__construct($req->session);\n    $this->req = $req;\n  }\n\n  public function getType() {\n    return self::TYPE;\n  }\n  public function serialize() {\n    $out = $this->req->session->out;\n    parent::serialize();\n    $out->writeInt($this->req->id);\n    $out->writeInt(0);\n    $out->flush();\n    if (PDB_DEBUG) pdb_Logger::debug( \"$this\");\n  }\n  public function __toString () {\n    return \"pdb_StepOverResponse: \";\n  }\n}\n\n/**\n * @access private\n */\nclass pdb_StepOverRequest extends pdb_MessageRequest {\n  const TYPE = 12;\n  public $id;\n  \n  public function getType() {\n    return self::TYPE;\n  }\n  public function deserialize() {\n    $in = $this->session->in;\n    $this->id = $in->readInt();\n    if (PDB_DEBUG) pdb_Logger::debug( \"$this\");\n  }\n  public function ack() {\n    $res = new pdb_StepOverResponse($this);\n    $res->serialize();\n  }\n  public function __toString () {\n    return \"pdb_StepOverRequest: \";\n  }\n}\n\n/**\n * @access private\n */\nclass pdb_StepIntoResponse extends pdb_StepOverResponse {\n  const TYPE = 1011;\n  public function getType() {\n    return self::TYPE;\n  }\n  public function __toString () {\n    return \"pdb_StepIntoResponse: \";\n  }\n}\n\n/**\n * @access private\n */\nclass pdb_StepIntoRequest extends pdb_StepOverRequest {\n  const TYPE = 11;\n  public function getType() {\n    return self::TYPE;\n  }\n  public function ack() {\n    $res = new pdb_StepIntoResponse($this);\n    $res->serialize();\n  }\n  public function __toString () {\n    return \"pdb_StepIntoRequest: \";\n  }\n}\n\n/**\n * @access private\n */\nclass pdb_StepOutResponse extends pdb_StepOverResponse {\n  const TYPE = 1013;\n  public function getType() {\n    return self::TYPE;\n  }\n  public function __toString () {\n    return \"pdb_StepOutResponse: \";\n  }\n}\n\n/**\n * @access private\n */\nclass pdb_StepOutRequest extends pdb_StepOverRequest {\n  const TYPE = 13;\n  public function getType() {\n    return self::TYPE;\n  }\n  public function ack() {\n    $res = new pdb_StepOutResponse($this);\n    $res->serialize();\n  }\n  public function __toString () {\n    return \"pdb_OutIntoRequest: \";\n  }\n}\n\n/**\n * @access private\n */\nclass pdb_GoResponse extends pdb_Message {\n  const TYPE = 1014;\n  private $req;\n\n  public function __construct ($req) {\n    parent::__construct($req->session);\n    $this->req = $req;\n  }\n\n  public function getType() {\n    return self::TYPE;\n  }\n  public function serialize() {\n    $out = $this->session->out;\n    parent::serialize();\n    $out->writeInt($this->req->id);\n    $out->writeInt(0);\n    $out->flush();\n    if (PDB_DEBUG) pdb_Logger::debug( \"$this\");\n  }\n  public function __toString () {\n    return \"pdb_GoResponse: \";\n  }\n}\n\n/**\n * @access private\n */\nclass pdb_GoRequest extends pdb_MessageRequest {\n  const TYPE = 14;\n  public $id;\n \n  public function getType() {\n    return self::TYPE;\n  }\n  public function deserialize() {\n    $in = $this->session->in;\n    $this->id = $in->readInt();\n    if (PDB_DEBUG) pdb_Logger::debug( \"$this\");\n  }\n  public function ack() {\n    $res = new pdb_GoResponse($this);\n    $res->serialize();\n  }\n  public function __toString () {\n    return \"pdb_GoRequest: \";\n  }\n}\n/**\n * @access private\n */\nclass pdb_End extends pdb_Message {\n  const TYPE = 3;\n  public $id;\n \n  public function getType() {\n    return self::TYPE;\n  }\n  public function deserialize() {\n    if (PDB_DEBUG) pdb_Logger::debug( \"$this\");\n  }\n  public function __toString () {\n    return \"pdb_End: \";\n  }\n}\n\n/**\n * @access private\n */\nclass pdb_In {\n  private $in;\n  private $len;\n  private $session;\n\n  public function __construct($in, $session) {\n    $this->in = $in;\n    $this->len = 0;\n\t$this->session = $session;\n  }\n  private function readBytes($n) {\n    $str = \"\";\n    while ($n) {\n      $s = fread($this->in, $n);\n\t  if (feof($this->in)) $this->session->end();\n\n      $n -= strlen($s);\n\n      $str.=$s;\n    }\n    return $str;\n  }\n  public function read() {\n    if(!$this->len) {\n      $str = $this->readBytes(4);\n      $lenDesc = unpack(\"N\", $str);\n      $this->len = array_pop($lenDesc);\n    }\n  }\n  public function readShort() {\n    $this->read();\n\n    $this->len-=2;\n    $str = $this->readBytes(2);\n    $lenDesc = unpack(\"n\", $str);\n    return array_pop($lenDesc);\n  }\n  public function readInt() {\n    $this->read();\n\n    $this->len-=4;\n    $str = $this->readBytes(4);\n    $lenDesc = unpack(\"N\", $str);\n    return array_pop($lenDesc);\n  }\n  public function readString() {\n    $this->read();\n\n    $length = $this->readInt();\n    $this->len-=$length;\n    return $this->readBytes($length);\n  }\n  public function __toString () {\n    return \"pdb_In: \";\n  }\n}\n/**\n * @access private\n */\nclass pdb_Out {\n  private $out;\n  private $buf;\n  private $session;\n  \n  public function __construct($out, $session) {\n    $this->out = $out;\n    $this->buf = \"\";\n\t$this->session = $session;\n  }\n\n  public function writeShort($val) {\n    $this->buf.=pack(\"n\", $val);\n  }\n  public function writeInt($val) {\n    $this->buf.=pack(\"N\", $val);\n  }\n  public function writeString($str) {\n    $length = strlen($str);\n    $this->writeInt($length);\n    $this->buf.=$str;\n  }\n  public function writeUTFString($str) {\n    $this->writeString(urlencode($str));\n  }\n  public function flush() {\n    $length = strlen($this->buf);\n    $this->buf = pack(\"N\", $length).$this->buf;\n    fwrite($this->out, $this->buf);\n\tif (feof($this->out)) $this->session->end();\n    $this->buf = \"\";\n  }\n  public function __toString () {\n    return \"pdb_Out: \";\n  }\n}\n$pdb_dbg = new pdb_DebugSessionStart(\"&debug_fastfile=1\");\npdb_Message::register(new pdb_SetProtocolRequest($pdb_dbg));\npdb_Message::register(new pdb_StartRequest($pdb_dbg));\npdb_Message::register(new pdb_AddFilesRequest($pdb_dbg));\npdb_Message::register(new pdb_FileContentExtendedRequest($pdb_dbg));\npdb_Message::register(new pdb_ContinueProcessFileNotification($pdb_dbg));\npdb_Message::register(new pdb_AddBreakpointRequest($pdb_dbg));\npdb_Message::register(new pdb_RemoveBreakpointRequest($pdb_dbg));\npdb_Message::register(new pdb_RemoveAllBreakpointsRequest($pdb_dbg));\npdb_Message::register(new pdb_GetCallStackRequest($pdb_dbg));\npdb_Message::register(new pdb_GetCWDRequest($pdb_dbg));\npdb_Message::register(new pdb_GetVariableValueRequest($pdb_dbg));\npdb_Message::register(new pdb_MsgEvalRequest($pdb_dbg));\npdb_Message::register(new pdb_StepOverRequest($pdb_dbg));\npdb_Message::register(new pdb_StepIntoRequest($pdb_dbg));\npdb_Message::register(new pdb_StepOutRequest($pdb_dbg));\npdb_Message::register(new pdb_GoRequest($pdb_dbg));\npdb_Message::register(new pdb_End($pdb_dbg));\n\npdb_Message::register(new pdb_StartProcessFileNotification($pdb_dbg));\npdb_Message::register(new pdb_ReadyNotification($pdb_dbg));\npdb_Message::register(new pdb_DebugScriptEndedNotification($pdb_dbg));\npdb_Message::register(new pdb_HeaderOutputNotification($pdb_dbg));\npdb_Message::register(new pdb_OutputNotification($pdb_dbg));\npdb_Message::register(new pdb_ErrorNotification($pdb_dbg));\n\n/**\n * @access private\n */\nfunction pdb_getDefinedVars($vars1, $vars2) {\n  //if(isset($vars2)) $vars1['pbd_This'] = $vars2;\n\n  unset($vars1['__pdb_Code']);\t     // see pdb_Message::doEval()\n\n  return $vars1;   \n}\n/**\n * @access private\n */\nfunction pdb_startCall($scriptName, $line) {\n  global $pdb_dbg;\n\n  $stepNext = $pdb_dbg->currentFrame->stepNext == pdb_StepIntoRequest::TYPE ? pdb_StepIntoRequest::TYPE : false;\n\n  pdb_Logger::debug(\"startCall::$scriptName, $stepNext\");\n\n  $env = new pdb_Environment($pdb_dbg->currentFrame, $scriptName, $stepNext, $line);\n  $pdb_dbg->allFrames[] = $env;\n\n  return $env;\n}\n\n/**\n * @access private\n */\nfunction pdb_startInclude($scriptName, $once) {\n  global $pdb_dbg;\n\n  $scriptName = $pdb_dbg->resolveIncludePath($scriptName);\n\n  // include only from a top-level environment\n  // initial line# and vars may be wrong due to a side-effect in step\n  $pdb_dbg->session->currentFrame = $pdb_dbg->session->currentTopLevelFrame;\n\n  $stepNext = $pdb_dbg->currentFrame->stepNext == pdb_StepIntoRequest::TYPE ? pdb_StepIntoRequest::TYPE : false;\n  $pdb_dbg->currentFrame = new pdb_Environment($pdb_dbg->currentFrame, $scriptName, $stepNext, 1);\n  $pdb_dbg->allFrames[] = $pdb_dbg->currentFrame;\n\n  /* BEGIN: StartProcessFileNotification */\n  $pdb_dbg->getMessageById(pdb_StartProcessFileNotification::TYPE)->handleRequests();\n  /* ...  set breakpoints ... */\n  /* END: ContinueProcessFileNotification */\n\n  if ($once && isset($pdb_dbg->includedScripts[$scriptName]))\n\t$code = \"<?php ?>\";\n  else\n\t$code = $pdb_dbg->parseCode(realpath($scriptName), file_get_contents($scriptName));\n\n  $pdb_dbg->currentTopLevelFrame = $pdb_dbg->currentFrame;\n\n  if (PDB_DEBUG) pdb_Logger::debug(\"include:::$code\");\n\n  if ($once) $pdb_dbg->includedScripts[$scriptName] = true;\n  return $code; // eval -> pdb_step/MSG_READY or pdb_endInclude/MSG_READY OR FINISH\n}\n/**\n * @access private\n */\nfunction pdb_endInclude() {\n  global $pdb_dbg;\n\n  $pdb_dbg->currentFrame = $pdb_dbg->currentTopLevelFrame = $pdb_dbg->currentTopLevelFrame->parent;\n}\n\n\n/**\n * @access private\n */\nfunction pdb_step($filename, $line, $vars) {\n  global $pdb_dbg;\n  if ($pdb_dbg->ignoreInterrupt) return;\n\n  $pdb_dbg->ignoreInterrupt = true;\n\n  // pull the current frame from the stack or the top-level environment\n  $pdb_dbg->currentFrame = (isset($vars['__pdb_CurrentFrame'])) ? $vars['__pdb_CurrentFrame'] : $pdb_dbg->currentTopLevelFrame;\n  unset($vars['__pdb_CurrentFrame']);\n\n  $pdb_dbg->currentFrame->update($line, $vars);\n\n  if ($pdb_dbg->hasBreakpoint($filename, $line)) {\n\t$pdb_dbg->flushOutput();\n\t$stepNext = $pdb_dbg->getMessageById(pdb_ReadyNotification::TYPE)->handleRequests();\n\tpdb_Logger::logDebug(\"continue\");\n\t/* clear all dynamic breakpoints */\n\tforeach ($pdb_dbg->allFrames as $currentFrame)\n\t  $currentFrame->stepNext = false;\n\n\t/* set new dynamic breakpoint */\n\tif ($stepNext != pdb_GoRequest::TYPE) {\n\t  $currentFrame = $pdb_dbg->currentFrame;\n\n\t  /* break in current frame or frame below */\n\t  if ($stepNext != pdb_StepOutRequest::TYPE)\n\t\t$currentFrame->stepNext = $stepNext;\n\n\t  /* or break in any parent */\n\t  while ($currentFrame = $currentFrame->parent) {\n\t\t$currentFrame->stepNext = $stepNext;\n\t  }\n\t}\n  }\n  $pdb_dbg->ignoreInterrupt = false;\n}\n\n/**\n * @access private\n */\nfunction pdb_error_handler($errno, $errstr, $errfile, $errline) {\n  global $pdb_dbg;\n  if (PDB_DEBUG) pdb_Logger::debug(\"PHP error $errno: $errstr in $errfile line $errline\");\n  if ($pdb_dbg->end) return false;\n\n  $msg = $pdb_dbg->getMessageById(pdb_ErrorNotification::TYPE);\n  $msg->setError($errno, $errfile, $errline, $errstr);\n  $msg->serialize();\n  return true;\n}\n\n/**\n * @access private\n */\nfunction pdb_shutdown() {\n  global $pdb_dbg;\n  if (PDB_DEBUG) pdb_Logger::debug(\"PHP error: \".print_r(error_get_last(), true));\n  if ($pdb_dbg->end) return;\n\n  $error = error_get_last();\n  if ($error) {\n\t$msg = $pdb_dbg->getMessageById(pdb_ErrorNotification::TYPE);\n\t$msg->setError($error['type'], $error['file'], $error['line'], $error['message']);\n\t$msg->serialize();\n  }\n}\n\n\nfunction pdb_getDebugHeader($name,$array) {\n  if (array_key_exists($name,$array)) return $array[$name];\n  $name=\"HTTP_$name\";\n  if (array_key_exists($name,$array)) return $array[$name];\n  return null;\n}\n\n\nif (!isset($java_include_only) && isset($pdb_script) && $pdb_script!=\"@\") { // not called from JavaProxy.php and pdb_script is set\n\tchdir (dirname ($pdb_script));\n\t$pdb_dbg->handleRequests();\n}\n\n?>\n";
    public static final byte[] bytes = "<?php /*-*- mode: php; tab-width:4 -*-*/\n\n  /**\n   * PHPDebugger.inc -- A PHP debugger for Eclipse for PHP Developers\n   *\n   * Copyright (C) 2009,2010 Jost Boekemeier.\n   *\n   * This file is part of the PHP/Java Bridge.\n   * \n   * The PHP/Java Bridge (\"the library\") is free software; you can\n   * redistribute it and/or modify it under the terms of the GNU General\n   * Public License as published by the Free Software Foundation; either\n   * version 2, or (at your option) any later version.\n   * \n   * The library is distributed in the hope that it will be useful, but\n   * WITHOUT ANY WARRANTY; without even the implied warranty of\n   * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU\n   * General Public License for more details.\n   * \n   * You should have received a copy of the GNU General Public License\n   * along with the PHP/Java Bridge; see the file COPYING.  If not, write to the\n   * Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA\n   * 02111-1307 USA.\n   * \n   * Linking this file statically or dynamically with other modules is\n   * making a combined work based on this library.  Thus, the terms and\n   * conditions of the GNU General Public License cover the whole\n   * combination.\n   * \n   * As a special exception, the copyright holders of this library give you\n   * permission to link this library with independent modules to produce an\n   * executable, regardless of the license terms of these independent\n   * modules, and to copy and distribute the resulting executable under\n   * terms of your choice, provided that you also meet, for each linked\n   * independent module, the terms and conditions of the license of that\n   * module.  An independent module is a module which is not derived from\n   * or based on this library.  If you modify this library, you may extend\n   * this exception to your version of the library, but you are not\n   * obligated to do so.  If you do not wish to do so, delete this\n   * exception statement from your version. \n   *\n   * Installation:\n   *\n   * Install \"Eclipse for PHP Developers\" version >= 3.5.2\n   * \n   * - Open Window -> Preferences -> Servers and set Default Web Server to: http://localhost:8080\n   * - Deploy JavaBridgeTemplate.war\n   * - Create a new Project using .../apache-tomcat-7.0.75/webapps/JavaBridgeTemplate as directory\n   * - Open index.php and start debugger: Default Web Server with Zend Debugger (other options default)\n   * - Click debug \n   *\n   * To debug standalone applications, remove zend_extension=ZendDebugger.so from your php.ini and set:\n   * \n   *<code>\n   * ;; activate the PHPDebugger in the php.ini\n   * auto_prepend_file=PHPDebugger.php\n   *</code>\n   *\n   * - Debug your PHP scripts as usual. \n   *\n   *\n   * @category   java\n   * @package    pdb\n   * @author     Jost Boekemeier\n   * @license    GPL+Classpath exception\n   * @version    7.0\n   * @link       http://php-java-bridge.sf.net/phpdebugger\n   */\n\n\n/** @access private */\ndefine (\"PDB_DEBUG\", 0);\nset_time_limit (0);\nif(!function_exists(\"token_get_all\")) {\n\tdl(\"tokenizer.so\");\n}\n\nif ($pdb_script_orig = $pdb_script = pdb_getDebugHeader(\"X_JAVABRIDGE_INCLUDE\", $_SERVER)) {\n\tif ($pdb_script!=\"@\") {\n\t\tif (($_SERVER['REMOTE_ADDR']=='127.0.0.1') || (($pdb_script = realpath($pdb_script)) && (!strncmp($_SERVER['DOCUMENT_ROOT'], $pdb_script, strlen($_SERVER['DOCUMENT_ROOT']))))) {\n\t\t\t$_SERVER['SCRIPT_FILENAME'] = $pdb_script; // set to the original script filename\n\t\t} else {\n\t\t\ttrigger_error(\"illegal access: \".$pdb_script_orig, E_USER_ERROR);\n\t\t\tunset($pdb_script);\n\t\t}\n\t}\n}\n\n\n\nif (!class_exists(\"pdb_Parser\")) {\n  /**\n   * The PHP parser\n   * @access private\n   */\n  class pdb_Parser {\n\tconst BLOCK = 1;\n\tconst STATEMENT = 2;\n\tconst EXPRESSION = 3;\n\tconst FUNCTION_BLOCK = 4; // BLOCK w/ STEP() as last statement\n\n\tprivate $scriptName, $content;\n\tprivate $code;\n\tprivate $output;\n\tprivate $line, $currentLine;\n\tprivate $beginStatement, $inPhp, $inDQuote;\n \n\t/**\n\t * Create a new PHP parser\n\t * @param string the script name\n\t * @param string the script content\n\t * @access private\n\t */\n\tpublic function __construct($scriptName, $content) {\n\t  $this->scriptName = $scriptName;\n\t  $this->content = $content;\n\t  $this->code = token_get_all($content);\n\t  $this->output = \"\";\n\t  $this->line = $this->currentLine = 0;\n\t  $this->beginStatement = $this->inPhp = $this->inDQuote = false;\n\t}\n\n\tprivate function toggleDQuote($chr) {\n\t  if ($chr == '\"') $this->inDQuote = !$this->inDQuote;\n\t}\n\n\tprivate function each() {\n\t  $next = each ($this->code);\n\t  if ($next) {\n\t\t$cur = current($this->code);\n\t\tif (is_array($cur)) {\n\t\t  $this->currentLine = $cur[2] + ($cur[1][0] == \"\\n\" ? substr_count($cur[1], \"\\n\") : 0);\n\t\t  if ($this->isWhitespace($cur)) {\n\t\t\t$this->write($cur[1]);\n\t\t\treturn $this->each();\n\t\t  }\n\t\t}\n\t\telse \n\t\t  $this->toggleDQuote($cur);\n\t  }\n\t  return $next;\n\t}\n\n\tprivate function write($code) {\n\t  //echo \"write:::\".$code.\"\\n\";\n\t  $this->output.=$code;\n\t}\n\n\tprivate function writeInclude($once) {\n\t  $name = \"\";\n\t  while(1) {\n\t\tif (!$this->each()) die(\"parse error\");\n\t\t$val = current($this->code);\n\t\tif (is_array($val)) {\n\t\t  $name.=$val[1];\n\t\t} else {\n\t\t  if ($val==';') break;\n\t\t  $name.=$val;\n\t\t}\n\t  }\n\t  if (PDB_DEBUG == 2) \n\t\t$this->write(\"EVAL($name);\");\n\t  else\n\t\t$this->write(\"eval('?>'.pdb_startInclude($name, $once)); pdb_endInclude();\");\n\t}\n\n\tprivate function writeCall() {\n\t  while(1) {\n\t\tif (!$this->each()) die(\"parse error\");\n\t\t$val = current($this->code);\n\t\tif (is_array($val)) {\n\t\t  $this->write($val[1]);\n\t\t} else {\n\t\t  $this->write($val);\n\t\t  if ($val=='{') break;\n\t\t}\n\t  }\n\t  $scriptName = addslashes($this->scriptName);\n\t  $this->write(\"\\$__pdb_CurrentFrame=pdb_startCall(\\\"$scriptName\\\", {$this->currentLine});\");\n\t}\n\n\tprivate function writeStep($pLevel) {\n\t  $token = current($this->code);\n\t  if ($this->inPhp && !$pLevel && !$this->inDQuote && $this->beginStatement && !$this->isWhitespace($token) && ($this->line != $this->currentLine)) {\n\t\t$line = $this->line = $this->currentLine;\n\t\t$scriptName = addslashes($this->scriptName);\n\t\tif (PDB_DEBUG == 2)\n\t\t  $this->write(\";STEP($line);\");\n\t\telse\n\t\t  $this->write(\";pdb_step(\\\"$scriptName\\\", $line, pdb_getDefinedVars(get_defined_vars(), (isset(\\$this) ? \\$this : NULL)));\");\n\t  }\n\t}\n\n\tprivate function writeNext() {\n\t  $this->next();\n\t  $token = current($this->code);\n\t  if (is_array($token)) $token = $token[1];\n\t  $this->write($token);\n\t}\n\n\tprivate function nextIs($chr) {\n\t  $i = 0;\n\t  while(each($this->code)) {\n\t\t$cur = current($this->code);\n\t\t$i++;\n\t\tif (is_array($cur)) {\n\t\t  switch ($cur[0]) {\n\t\t  case T_COMMENT:\n\t\t  case T_DOC_COMMENT:\n\t\t  case T_WHITESPACE:\n\t\t\tbreak;\t/* skip */\n\t\t  default: \n\t\t\twhile($i--) prev($this->code);\n\t\t\treturn false;\t/* not found */\n\t\t  }\n\t\t} else {\n\t\t  while($i--) prev($this->code);\n\t\t  return $cur == $chr;\t/* found */\n\t\t}\n\t  }\n\t  while($i--) prev($this->code);\n\t  return false;\t/* not found */\n\t}\n\n\tprivate function nextTokenIs($ar) {\n\t  $i = 0;\n\t  while(each($this->code)) {\n\t\t$cur = current($this->code);\n\t\t$i++;\n\t\tif (is_array($cur)) {\n\t\t  switch ($cur[0]) {\n\t\t  case T_COMMENT:\n\t\t  case T_DOC_COMMENT:\n\t\t  case T_WHITESPACE:\n\t\t\tbreak;\t/* skip */\n\t\t  default: \n\t\t\twhile($i--) prev($this->code);\n\t\t\treturn (in_array($cur[0], $ar));\n\t\t  }\n\t\t} else {\n\t\t  break; /* not found */\n\t\t}\n\t  }\n\t  while($i--) prev($this->code);\n\t  return false;\t/* not found */\n\t}\n\n\tprivate function isWhitespace($token) {\n\t  $isWhitespace = false;\n\t  switch($token[0]) {\n\t  case T_COMMENT:\n\t  case T_DOC_COMMENT:\n\t  case T_WHITESPACE:\n\t\t$isWhitespace = true;\n\t\tbreak;\n\t  }\n\t  return $isWhitespace;\n\t}\n\tprivate function next() {\n\t  if (!$this->each()) trigger_error(\"parse error\", E_USER_ERROR);\n\t}\n\n\tprivate function parseBlock () {\n\t  $this->parse(self::BLOCK);\n\t}\n\tprivate function parseFunction () {\n\t  $this->parse(self::FUNCTION_BLOCK);\n\t}\n\tprivate function parseStatement () {\n\t  $this->parse(self::STATEMENT);\n\t}\n\tprivate function parseExpression () {\n\t  $this->parse(self::EXPRESSION);\n\t}\n\n\tprivate function parse ($type) {\n\t  pdb_Logger::debug(\"parse:::$type\");\n\n\t  $this->beginStatement = true;\n\t  $pLevel = 0;\n\n\t  do {\n\t\t$token = current($this->code);\n\t\tif (!is_array($token)) {\n\t\t  pdb_Logger::debug(\":::\".$token);\n\t\t  if (!$pLevel && $type==self::FUNCTION_BLOCK && $token=='}') $this->writeStep($pLevel);\n\t\t  $this->write($token);\n\t\t  if ($this->inPhp && !$this->inDQuote) {\n\t\t\t$this->beginStatement = false; \n\t\t\tswitch($token) {\n\t\t\tcase '(': \n\t\t\t  $pLevel++;\n\t\t\t  break;\n\t\t\tcase ')':\n\t\t\t  if (!--$pLevel && $type==self::EXPRESSION) return;\n\t\t\t  break;\n\t\t\tcase '{': \n\t\t\t  $this->next();\n\t\t\t  $this->parseBlock(); \n\t\t\t  break;\n\t\t\tcase '}': \n\t\t\t  if (!$pLevel) return;\n\t\t\t  break;\n\t\t\tcase ';':\n\t\t\t  if (!$pLevel) {\n\t\t\t\tif ($type==self::STATEMENT) return;\n\t\t\t\t$this->beginStatement = true; \n\t\t\t  }\n\t\t\t  break;\n\t\t\t}\n\t\t  }\n\t\t} else {\n\t\t  pdb_Logger::debug(\":::\".$token[1].\":(\".token_name($token[0]).')');\n\n\t\t  if ($this->inDQuote) {\n\t\t\t$this->write($token[1]);\n\t\t\tcontinue;\n\t\t  }\n\n\t\t  switch($token[0]) {\n\n\t\t  case T_OPEN_TAG: \n\t\t  case T_START_HEREDOC:\n\t\t  case T_OPEN_TAG_WITH_ECHO: \n\t\t\t$this->beginStatement = $this->inPhp = true;\n\t\t\t$this->write($token[1]);\n\t\t\tbreak;\n\n\t\t  case T_END_HEREDOC:\n\t\t  case T_CLOSE_TAG: \n\t\t\t$this->writeStep($pLevel);\n\n\t\t\t$this->write($token[1]);\n\t\t\t$this->beginStatement = $this->inPhp = false; \n\t\t\tbreak;\n\n\t\t  case T_FUNCTION:\n\t\t\t$this->write($token[1]);\n\t\t\t$this->writeCall();\n\t\t\t$this->next();\n\t\t\t$this->parseFunction();\n\t\t\t$this->beginStatement = true;\n\t\t\tbreak;\n\n\t\t  case T_ELSE:\n\t\t\t$this->write($token[1]);\n\t\t\tif ($this->nextIs('{')) {\n\t\t\t  $this->writeNext();\n\t\t\t  $this->next();\n\n\t\t\t  $this->parseBlock();\n\t\t\t} else {\n\t\t\t  $this->next();\n\n\t\t\t  /* create an artificial block */\n\t\t\t  $this->write('{');\n\t\t\t  $this->beginStatement = true;\n\t\t\t  $this->writeStep($pLevel);\n\t\t\t  $this->parseStatement();\n\t\t\t  $this->write('}');\n\n\t\t\t}\n\t\t\tif ($type==self::STATEMENT) return;\n\n\t\t\t$this->beginStatement = true;\n\t\t\tbreak;\n\n\t\t  case T_DO:\n\t\t\t$this->writeStep($pLevel);\n\t\t\t$this->write($token[1]);\n\t\t\tif ($this->nextIs('{')) {\n\t\t\t  $this->writeNext();\n\t\t\t  $this->next();\n\n\t\t\t  $this->parseBlock();\n\t\t\t  $this->next();\n\n\t\t\t} else {\n\t\t\t  $this->next();\n\n\t\t\t  /* create an artificial block */\n\t\t\t  $this->write('{');\n\t\t\t  $this->beginStatement = true;\n\t\t\t  $this->writeStep($pLevel);\n\t\t\t  $this->parseStatement();\n\t\t\t  $this->next();\n\t\t\t  $this->write('}');\n\t\t\t}\n\t\t\t$token = current($this->code);\n\t\t\t$this->write($token[1]);\n\n\t\t\tif ($token[0]!=T_WHILE) trigger_error(\"parse error\", E_USER_ERROR);\n\t\t\t$this->next();\n\t\t\t$this->parseExpression();\n\n\t\t\tif ($type==self::STATEMENT) return;\n\n\t\t\t$this->beginStatement = true;\n\t\t\tbreak;\n\n\t\t  case T_CATCH:\n\t\t  case T_IF:\n\t\t  case T_ELSEIF:\n\t\t  case T_FOR:\n\t\t  case T_FOREACH:\n\t\t  case T_WHILE:\n\t\t\t$this->writeStep($pLevel);\n\n\t\t\t$this->write($token[1]);\n\t\t\t$this->next();\n\n\t\t\t$this->parseExpression();\n\n\t\t\tif ($this->nextIs('{')) {\n\t\t\t  $this->writeNext();\n\t\t\t  $this->next();\n\n\t\t\t  $this->parseBlock();\n\n\n\t\t\t} else {\n\t\t\t  $this->next();\n\t\t\t  /* create an artificial block */\n\t\t\t  $this->write('{');\n\t\t\t  $this->beginStatement = true;\n\t\t\t  $this->writeStep($pLevel);\n\t\t\t  $this->parseStatement();\n\t\t\t  $this->write('}');\n\t\t\t}\n\n\t\t\tif ($this->nextTokenIs(array(T_ELSE, T_ELSEIF, T_CATCH))) {\n\t\t\t  $this->beginStatement = false;\n\t\t\t} else {\n\t\t\t  if ($type==self::STATEMENT) return;\n\t\t\t  $this->beginStatement = true;\n\t\t\t}\n\t\t\tbreak;\n\n\t\t  case T_REQUIRE_ONCE:\n\t\t  case T_INCLUDE_ONCE: \n\t\t  case T_INCLUDE: \n\t\t  case T_REQUIRE: \n\t\t\t$this->writeStep($pLevel);\n\t\t\t$this->writeInclude((($token[0]==T_REQUIRE_ONCE) || ($token[0]==T_INCLUDE_ONCE)) ? 1 : 0);\n\n\t\t\tif ($type==self::STATEMENT) return;\n\n\t\t\t$this->beginStatement = true;\n\t\t\tbreak;\n\n\t\t  case T_CLASS:\n\t\t\t$this->write($token[1]);\n\t\t\t$this->writeNext();\n\t\t\tif ($this->nextIs('{')) {\n\t\t\t  $this->writeNext();\n\t\t\t  $this->next();\n\t\t\t  $this->parseBlock(); \n\t\t\t  $this->beginStatement = true;\n\t\t\t} else {\n\t\t\t  $this->writeNext();\n\t\t\t  $this->beginStatement = false;\n\t\t\t}\n\t\t\tbreak;\n\n\t\t  case T_CASE:\n\t\t  case T_DEFAULT:\n\t\t  case T_PUBLIC:\n\t\t  case T_PRIVATE:\n\t\t  case T_PROTECTED:\n\t\t  case T_STATIC:\n\t\t  case T_CONST:\n\t\t  case T_GLOBAL:\n\t\t  case T_ABSTRACT:\n\t\t\t$this->write($token[1]);\n\t\t\t$this->beginStatement = false;\n\t\t\tbreak;\n\n\t\t  default:\n\t\t\t$this->writeStep($pLevel);\n\t\t\t$this->write($token[1]);\n\t\t\t$this->beginStatement = false;\n\t\t\tbreak;\n\t\n\t\t  }\n\t\t}\n\t  } while($this->each());\n\t}\n\n\t/**\n\t * parse the given PHP script\n\t * @return the parsed PHP script\n\t * @access private\n\t */\n\tpublic function parseScript() {\n\t  do {\n\t\t$this->parseBlock();\n\t  } while($this->each());\n\n\t  return $this->output;\n\t}\n  }\n}\n\n/**\n * @access private\n */\nclass pdb_Logger {\n  const FATAL = 1;\n  const INFO = 2;\n  const VERBOSE = 3;\n  const DEBUG = 4;\n\n  private static $logLevel = 0;\n  private static $logFileName;\n\n  private static function println($msg, $level) {\n\tif (!self::$logLevel) self::$logLevel=PDB_DEBUG?self::DEBUG:self::INFO;\n\tif ($level <= self::$logLevel) {\n\t  static $file = null;\n\t  if(!isset(self::$logFileName)) {\n\t\tself::$logFileName = $_SERVER['HOME'].DIRECTORY_SEPARATOR.\"pdb_PHPDebugger.inc.log\";\n\t  }\n\t  if (!$file) $file = fopen(self::$logFileName, \"ab\") or die(\"fopen\");\n\t  fwrite($file, time().\": \");\n\t  fwrite($file, $msg.\"\\n\");\n\t  fflush($file);\n\t}\n  }\n\n  public static function logFatal($msg) {\n\tself::println($msg, self::FATAL);\n  }\n  public static function logInfo($msg) {\n\tself::println($msg, self::INFO);\n  }\n  public static function logMessage($msg) {\n\tself::println($msg, self::VERBOSE);\n  }\n  public static function logDebug($msg) {\n\tself::println($msg, self::DEBUG);\n  }\n  public static function debug($msg) {\n\tself::logDebug($msg);\n  }\n  public static function log($msg) {\n\tself::logMessage($msg);\n  }\n  public static function setLogLevel($level) {\n\tself::$logLevel=$level;\n  }\n  public static function setLogFileName($name) {\n\tself::$logFileName = $name;\n  }\n}\n\n/**\n * @access private\n */\nclass pdb_Environment {\n  public $filename, $stepNext;\n  public $vars, $line, $firstLine;\n  public $parent;\n\n  public function __construct($parent, $filename, $stepNext, $firstLine) {\n\t$this->parent = $parent;\n    $this->filename = $filename;\n    $this->stepNext = $stepNext;\n\t$this->firstLine = $firstLine;\n    $this->line = -1;\n  }\n\n  public function update ($line, &$vars) {\n    $this->line = $line;\n    $this->vars = &$vars;\n  }\n  public function __toString() {\n\treturn \"pdb_Environment: {$this->filename}, {$this->firstLine} - {$this->line}\";\n  }\n}\n\n/**\n * @access private\n */\nabstract class pdb_Message {\n  public $session;\n\n  public abstract function getType();\n\n  public function __construct($session) {\n    $this->session = $session;\n  }\n\n  public function serialize() {\n    $this->session->out->writeShort($this->getType());\n  }\n\n  private static $messages = array();\n  public static function register($message) {\n    pdb_Message::$messages[$message->getType()] = $message;\n  }\n  public function getMessageById($id) {\n    $message = pdb_Message::$messages[$id];\n    return $message;\n  }\n  public function getMessage() {\n    $id = $this->session->in->readShort();\n    $message = $this->getMessageById($id);\n    if (!$message) trigger_error(\"invalid message: $id\", E_USER_ERROR);\n    $message->deserialize();\n    return $message;\n  }\n\n  protected function handleContinueProcessFile($message) {\n\t$code = $this->session->parseCode($this->currentFrame->filename, file_get_contents($this->currentFrame->filename));\n\tif (PDB_DEBUG) pdb_Logger::debug( \"parse file:::\" . $code .\"\\n\");\n\tif (!PDB_DEBUG) ob_start();\n\tself::doEval ($code);\n\t$output = $this->getMessageById(pdb_OutputNotification::TYPE);\n\tif(!PDB_DEBUG) $output->setOutput(ob_get_contents());\n\tif(!PDB_DEBUG) ob_end_clean();\n\t$output->serialize();\n\t$this->status = 42; //FIXME\n\t$this->getMessageById(pdb_DebugScriptEndedNotification::TYPE)->serialize();\n    return true;\n  }\n  private static function doEval($__pdb_Code) {\n    return  eval (\"?>\".$__pdb_Code);\n  }\n  protected function handleStep($message) {\n    return false;\n  }\n  protected function handleGo($message) {\n    foreach ($this->session->allFrames as $frame) {\n      $frame->stepNext = false;\n    }\n    return true; // exit\n  }\n  public function handleRequests () {\n\t$this->ignoreInterrupt = false;\n\n    $this->serialize();\n    while(1) {\n      $message = $this->getMessage();\n      switch ($message->getType()) {\n      case pdb_SetProtocolRequest::TYPE:\n\t\t$message->ack();\n\t\tbreak;\n      case pdb_StartRequest::TYPE:\n\t\t$message->ack();\n\t\t$this->getMessageById(pdb_StartProcessFileNotification::TYPE)->serialize();\n\t\tbreak;\n      case pdb_ContinueProcessFileNotification::TYPE:\n\t\tif ($this->handleContinueProcessFile($message)) return pdb_ContinueProcessFileNotification::TYPE;\n\t\tbreak;\n      case pdb_AddBreakpointRequest::TYPE:\n\t\t$message->ack();\n\t\tbreak;\n      case pdb_RemoveBreakpointRequest::TYPE:\n\t\t$message->ack();\n\t\tbreak;\n      case pdb_RemoveAllBreakpointsRequest::TYPE:\n\t\t$message->ack();\n\t\tbreak;\n      case pdb_GetCallStackRequest::TYPE:\n\t\t$message->ack();\n\t\tbreak;\n      case pdb_GetCWDRequest::TYPE:\n\t\t$message->ack();\n\t\tbreak;\n      case pdb_GetVariableValueRequest::TYPE:\n\t\t$message->ack();\n\t\tbreak;\n      case pdb_AddFilesRequest::TYPE:\n\t\t$message->ack();\n\t\tbreak;\n      case pdb_FileContentExtendedRequest::TYPE:\n\t\t$message->ack();\n\t\tbreak;\n      case pdb_MsgEvalRequest::TYPE:\n\t\t$message->ack();\n\t\tbreak;\n      case pdb_GoRequest::TYPE:\n\t\t$message->ack();\n\t\tif ($this->handleGo($message)) return pdb_GoRequest::TYPE;\n\t\tbreak;\n      case pdb_StepOverRequest::TYPE:\n\t\t$message->ack();\n\t\tif ($this->handleStep($message)) return pdb_StepOverRequest::TYPE;\n\t\tbreak;\n      case pdb_StepIntoRequest::TYPE:\n\t\t$message->ack();\n\t\tif ($this->handleStep($message)) return pdb_StepIntoRequest::TYPE;\n\t\tbreak;\n      case pdb_StepOutRequest::TYPE:\n\t\t$message->ack();\n\t\tif ($this->handleStep($message)) return pdb_StepOutRequest::TYPE;\n\t\tbreak;\n      case pdb_End::TYPE:\n\t\t$this->session->end();\n      default: trigger_error(\"protocol error: $message\", E_USER_ERROR);\n      }\n    }\n  }\n}\n/**\n * @access private\n */\nabstract class pdb_MessageRequest extends pdb_Message {\n  public abstract function ack();\n}\n\n/**\n * @access private\n */\nclass pdb_Serializer {\n  private $serial;\n  private $depth;\n\n  private function doSerialize ($o, $depth) {\n    $serial = &$this->serial;\n\n    switch(gettype($o)) {\n    case 'object':\n      $serial.=\"O:\";\n      $serial.=strlen(get_class($o));\n      $serial.=\":\\\"\";\n      $serial.=get_class($o);\n      $serial.=\"\\\":\";\n      $serial.=count((array)$o);\n\n\t  if ($depth <= $this->depth) {\n\t\t$serial.=\":{\";\n\t\tforeach((array)$o as $k=>$v) {\n\t\t  $serial.=serialize($k);\n\t\t  $this->doSerialize($v, $depth+1);\n\t\t}\n\t\t$serial.=\"}\";\n\t  } else {\n\t\t$serial .= \";\";\n\t  }\n      break;\n\n    case 'array':\n      $serial.=\"a:\";\n      $serial.=count($o);\n\n\t  if ($depth <= $this->depth) {\n\t\t$serial.=\":{\";\n\t\tforeach($o as $k=>$v) {\n\t\t  $serial.=serialize($k);\n\t\t  $this->doSerialize($v, $depth+1);\n\t\t}\n\t\t$serial.=\"}\";\n\t  } else {\n\t\t$serial.=\";\";\n\t  }\n      break;\n    default:\n      $serial.=serialize($o);\n      break;\n    }\n  }\n\n  public function serialize ($obj, $depth) {\n    $this->serial = \"\";\n\t$this->depth = $depth;\n\n    $this->doSerialize ($obj, 1);\n\n    return $this->serial;\n  }\n}\n\n/**\n * @access private\n */\nclass pdb_DebugSessionStart extends pdb_Message {\n  const TYPE = 2005;\n\n  public $status;\n  public $end;\n\n  private $breakFirstLine;\n  private $enable;\n  public $uri;\n  public $query;\n  public $options;\n  \n  public $in, $out;\n  private $outputNotification;\n\n  public $lines;\n  public $breakpoints;\n\n  public $currentTopLevelFrame, $currentFrame;\n  public $allFrames; // should be a weak map so that frames could be gc'ed\n\n  public $ignoreInterrupt; \n\n  public $serializer;\n\n  public $includedScripts;\n\n  public function getType() {\n    return self::TYPE;\n  }\n  public function __construct($options) {\n    parent::__construct($this);\n\t$this->end = true;\n\tif (isset($_SERVER[\"SCRIPT_FILENAME\"]) && isset($_SERVER[\"QUERY_STRING\"])&&!extension_loaded(\"Zend Debugger\")) {\n\t  $filename = $uri = $_SERVER[\"SCRIPT_FILENAME\"];\n\t  $queryStr = $_SERVER[\"QUERY_STRING\"];\n\t} else { // PHPDebugger disabled\n\t  global $pdb_script;\n\t  $this->enable = false;\n\t  if (isset($pdb_script) && $pdb_script!=\"@\") {\n\t  \trequire_once($pdb_script);\n\t  }\n\t  return;\n\t}\n\n\t$params = explode('&', $queryStr);\n\t$args = array();\n\tfor ($i=0; $i<count($params); $i++) {\n\t\t$arg=explode( '=', urldecode($params[$i]));\n\t\t$args[$arg[0]] = $arg[1];\n\t}\n\t$this->enable = $args[\"start_debug\"];\n\t$this->breakFirstLine = isset($args[\"debug_stop\"]) ? $args[\"debug_stop\"] : 0;\n    $this->uri = $uri;\n    $this->query = $queryStr;\n    $this->options = $options;\n    $this->breakpoints = $this->lines = array();\n\n\t$this->serializer = new pdb_Serializer();\n\n\t$this->currentTopLevelFrame = $this->currentFrame = new pdb_Environment(null, $filename, false, 1);\n\t$this->allFrames[] = $this->currentFrame;\n\t$this->ignoreInterrupt = false;\n\t$this->includedScripts = array();\n\n    $errno = 0; $errstr = \"\";\n    $io = null;\n    foreach(explode(\",\", $args[\"debug_host\"]) as $host) {\n        if ($io = fsockopen($host, $args['debug_port'], $errno, $errstr, 5)) {\n            break;\n        }\n    }\n    if ($io==null) {\n        trigger_error(\"fsockopen\", E_USER_ERROR);\n    }\n\t$this->end = false;\n\n    $this->in =new pdb_In($io, $this);\n    $this->out=new pdb_Out($io, $this);\n  }\n  public function end() {\n\t$this->end = true;\n\tif (PDB_DEBUG) pdb_Logger::debug( \"end() called\");\n\texit(0);\n  }\n  /**\n   * @access private\n   */\n  public function flushOutput() {\n\tif (!isset($this->outputNotification))\n\t  $this->outputNotification = $this->getMessageById(pdb_OutputNotification::TYPE);\n\n\t$this->outputNotification->setOutput(ob_get_contents());\n\tif (!PDB_DEBUG) ob_clean();\n\t$this->outputNotification->serialize();\n  }\n\n  /**\n   * @access private\n   */\n  public function resolveIncludePath($scriptName) {\n\tif (file_exists($scriptName)) return realpath($scriptName);\n\t$paths = explode(PATH_SEPARATOR, get_include_path());\n\t$name = $scriptName;\n\tforeach ($paths as $path) {\n\t  $scriptName = realpath(\"${path}${name}\");\n\t  if ($scriptName) return $scriptName;\n\t}\n\ttrigger_error(\"file $scriptName not found\", E_USER_ERROR);\n  }\n\n  public function serialize() {\n    $out = $this->session->out;\n    parent::serialize();\n    $out->writeInt(2004102501);\n    $out->writeString($this->currentFrame->filename);\n    $out->writeString($this->uri);\n    $out->writeString($this->query);\n    $out->writeString($this->options);\n    $out->flush();\n    if (PDB_DEBUG) pdb_Logger::debug( \"$this\");\n  }\n  public function handleRequests () {\n\tif ($this->enable) {\n\t  set_error_handler(\"pdb_error_handler\");\n\t  register_shutdown_function(\"pdb_shutdown\");\n\n\t  parent::handleRequests(); \n\t  if (PDB_DEBUG) pdb_Logger::debug( \"exit({$this->status})\");\n\t  exit ($this->status); }\n  }\n  public function hasBreakpoint($scriptName, $line) {\n\tif ($this->breakFirstLine) {$this->breakFirstLine = false; return true;}\n\n    if ($this->currentFrame->stepNext) return true;\n\n    foreach ($this->breakpoints as $breakpoint) {\n      if($breakpoint->type==1) {\n\t\tif ($breakpoint->file==$scriptName&&$breakpoint->line==$line) return true;\n      }\n    }\n\n    return false;\n  }\n  function parseCode($filename, $contents) {\n\t$parser = new pdb_Parser($filename, $contents);\n\treturn $parser->parseScript();\n  }\n\n  public function __toString() {\n    return \"pdb_DebugSessionStart: {$this->currentFrame->filename}\";\n  }\n}\n\n\n/**\n * @access private\n */\nclass pdb_HeaderOutputNotification extends pdb_Message {\n  const TYPE = 2008;\n  private $out;\n\n  public function setOutput($out) {\n    $this->out = $out;\n  }\n  protected function getAsciiOutput() {\n    return $this->out;\n  }\n  protected function getEncodedOutput () {\n    return $this->out; //FIXME\n  }\n  protected function getOutput() {\n    return $this->getAsciiOutput();\n  }\n  public function getType() {\n    return self::TYPE;\n  }\n\n  public function serialize() {\n    $out = $this->session->out;\n    parent::serialize();\n    $out->writeString($this->getOutput());\n    $out->flush();\n    if (PDB_DEBUG) pdb_Logger::debug( \"$this\");\n  }\n  public function __toString () {\n    return \"pdb_HeaderOutputNotification: \".$this->getOutput();\n  }\n}\n\n/**\n * @access private\n */\nclass pdb_OutputNotification extends pdb_HeaderOutputNotification {\n  const TYPE = 2004;\n\n  public function getType() {\n    return self::TYPE;\n  }\n  protected function getOutput() {\n    return $this->getEncodedOutput();\n  }\n  public function __toString () {\n    return \"pdb_OutputNotification: \".$this->getAsciiOutput();\n  }\n}\n\n/**\n * @access private\n */\nclass pdb_ErrorNotification extends pdb_Message {\n  const TYPE = 2006;\n  private $type, $filename, $lineno, $error;\n\n  public function getType() {\n    return self::TYPE;\n  }\n  public function setError($type, $filename, $lineno, $error) {\n\t$this->type = $type;\n\t$this->filename = $filename;\n\t$this->lineno = $lineno;\n\t$this->error = $error;\n  }\n\n  public function serialize() {\n    $out = $this->session->out;\n    parent::serialize();\n    $out->writeInt($this->type);\n\t$out->writeString($this->filename);\n\t$out->writeInt($this->lineno);\n\t$out->writeString($this->error);\n    $out->flush();\n    if (PDB_DEBUG) pdb_Logger::debug( \"$this\");\n  }\n  public function __toString () {\n    return \"pdb_ErrorNotification: {$this->error} at {$this->filename} line {$this->lineno}\";\n  }\n}\n\n/**\n * @access private\n */\nclass pdb_DebugScriptEndedNotification extends pdb_Message {\n  const TYPE = 2002;\n\n  public function getType() {\n    return self::TYPE;\n  }\n\n  public function serialize() {\n    $out = $this->session->out;\n    parent::serialize();\n    $out->writeShort($this->session->status);\n    $out->flush();\n    if (PDB_DEBUG) pdb_Logger::debug( \"$this\");\n  }\n  public function __toString () {\n    return \"pdb_DebugScriptEndedNotification: {$this->session->status}\";\n  }\n}\n\n\n/**\n * @access private\n */\nclass pdb_ReadyNotification extends pdb_Message {\n  const TYPE = 2003;\n  \n  public function getType() {\n    return self::TYPE;\n  }\n\n  protected function handleStep($message) {\n    return true;\n  }\n\n  public function serialize() {\n    $out = $this->session->out;\n    parent::serialize();\n    $out->writeString($this->session->currentFrame->filename);\n    $out->writeInt($this->session->currentFrame->line);\n    $out->writeInt(0);\n    $out->flush();\n    if (PDB_DEBUG) pdb_Logger::debug( \"$this\");\n  }\n  public function __toString () {\n    return \"pdb_ReadyNotification: {$this->session->currentFrame->filename}, {$this->session->currentFrame->line}\";\n  }\n}\n\n/**\n * @access private\n */\nclass pdb_SetProtocolRequest extends pdb_MessageRequest {\n  const TYPE = 10000;\n  public $id;\n  public $protocolId;\n  \n  public function getType() {\n    return self::TYPE;\n  }\n  public function deserialize() {\n    $in = $this->session->in;\n    $this->id = $in->readInt();\n    $this->protocolId = $in->readInt();\n    if (PDB_DEBUG) pdb_Logger::debug( \"$this\");\n  }\n  public function ack() {\n    $res = new pdb_SetProtocolResponse($this);\n    $res->serialize();\n  }\n  public function __toString () {\n    return \"pdb_SetProtocolRequest: \". $this->protocolId;\n  }\n}\n\n/**\n * @access private\n */\nclass pdb_SetProtocolResponse extends pdb_Message {\n  const TYPE = 11000;\n  private $req;\n  \n  public function __construct ($req) {\n    parent::__construct($req->session);\n    $this->req = $req;\n  }\n\n  public function getType() {\n    return self::TYPE;\n  }\n  public function serialize() {\n    $out = $this->session->out;\n    parent::serialize();\n    $out->writeInt($this->req->id);\n\n    // use fixed id instead of $out->writeInt($this->req->protocolId);\n\t$out->writeInt(2012121702);\n\n    $out->flush();\n    if (PDB_DEBUG) pdb_Logger::debug( \"$this\");\n  }\n  public function __toString () {\n    return \"pdb_SetProtocolResponse: \";\n  }\n}\n\n/**\n * @access private\n */\nclass pdb_StartRequest extends pdb_MessageRequest {\n  const TYPE = 1;\n  public $id;\n  public $protocolId;\n  \n  public function getType() {\n    return self::TYPE;\n  }\n  public function deserialize() {\n    $in = $this->session->in;\n    $this->id = $in->readInt();\n    if (PDB_DEBUG) pdb_Logger::debug( \"$this\");\n  }\n\n  public function ack() {\n    $res = new pdb_StartResponse($this);\n    $res->serialize();\n  }\n  public function __toString () {\n    return \"pdb_StartRequest: \";\n  }\n}\n\n/**\n * @access private\n */\nclass pdb_AddFilesRequest extends pdb_MessageRequest {\n  const TYPE = 38;\n  public $id;\n  public $pathSize;\n  public $paths;\n\n  public function getType() {\n    return self::TYPE;\n  }\n  public function deserialize() {\n    $in = $this->session->in;\n    $this->id = $in->readInt();\n    $this->pathSize = $in->readInt();\n    $this->paths = array();\n    for($i=0; $i<$this->pathSize; $i++) {\n       $this->paths[] = $in->readString();\n    }\n    if (PDB_DEBUG) pdb_Logger::debug( \"$this\");\n  }\n\n  public function ack() {\n    $res = new pdb_AddFilesResponse($this);\n    $res->serialize();\n  }\n  public function __toString () {\n    return \"pdb_AddFilesRequest: \";\n  }\n}\n/**\n * @access private\n */\nclass pdb_FileContentExtendedRequest extends pdb_MessageRequest {\n  const TYPE = 10002;\n  public $id;\n  public $size;\n  public $checksum;\n\n  public function getType() {\n    return self::TYPE;\n  }\n  public function deserialize() {\n    $in = $this->session->in;\n    $this->id = $in->readInt();\n    $this->size = $in->readInt();\n    $this->checksum = $in->readInt();\n\n    if (PDB_DEBUG) pdb_Logger::debug( \"$this\");\n  }\n\n  public function ack() {\n    $res = new pdb_FileContentExtendedResponse($this);\n    $res->serialize();\n  }\n  public function __toString () {\n    return \"pdb_FileContentExtendedRequest: \";\n  }\n}\n\n/**\n * @access private\n */\nclass pdb_AddFilesResponse extends pdb_Message {\n  const TYPE = 1038;\n  private $req;\n  \n  public function __construct ($req) {\n    parent::__construct($req->session);\n    $this->req = $req;\n  }\n\n  public function getType() {\n    return self::TYPE;\n  }\n  public function serialize() {\n    $out = $this->session->out;\n    parent::serialize();\n    $out->writeInt($this->req->id);\n    $out->writeInt(0);\n    $out->flush();\n    if (PDB_DEBUG) pdb_Logger::debug( \"$this\");\n  }\n  public function __toString () {\n    return \"pdb_AddFilesResponse: \";\n  }\n}\n\n/**\n * @access private\n */\nclass pdb_FileContentExtendedResponse extends pdb_Message {\n  const TYPE = 11001;\n  private $req;\n  \n  public function __construct ($req) {\n    parent::__construct($req->session);\n    $this->req = $req;\n  }\n\n  public function getType() {\n    return self::TYPE;\n  }\n  public function serialize() {\n    $out = $this->session->out;\n    parent::serialize();\n    $out->writeInt($this->req->id);\n    $out->writeInt(0); // fixme: status\n    $out->writeInt(0); // fixme: string: filecontent\n    $out->flush();\n    if (PDB_DEBUG) pdb_Logger::debug( \"$this\");\n  }\n  public function __toString () {\n    return \"pdb_FileContentExtendedResponse: \";\n  }\n}\n\n/**\n * @access private\n */\nclass pdb_StartResponse extends pdb_Message {\n  const TYPE = 1001;\n  private $req;\n  \n  public function __construct ($req) {\n    parent::__construct($req->session);\n    $this->req = $req;\n  }\n\n  public function getType() {\n    return self::TYPE;\n  }\n  public function serialize() {\n    $out = $this->session->out;\n    parent::serialize();\n    $out->writeInt($this->req->id);\n    $out->writeInt(0);\n    $out->flush();\n    if (PDB_DEBUG) pdb_Logger::debug( \"$this\");\n  }\n  public function __toString () {\n    return \"pdb_StartResponse: \";\n  }\n}\n/**\n * @access private\n */\nclass pdb_StartProcessFileNotification extends pdb_Message {\n  const TYPE = 2009;\n  public function __construct ($session) {\n    parent::__construct($session);\n  }\n  protected function handleContinueProcessFile($message) {\n    return true; // next\n  }\n  public function getType() {\n    return self::TYPE;\n  }\n  public function serialize() {\n    $out = $this->session->out;\n    parent::serialize();\n    $out->writeString($this->session->currentFrame->filename);\n    $out->flush();\n    if (PDB_DEBUG) pdb_Logger::debug( \"$this\");\n  }\n  public function __toString () {\n    return \"pdb_StartProcessFileNotification: {$this->session->currentFrame->filename}\";\n  }\n}\n\n/**\n * @access private\n */\nclass pdb_ContinueProcessFileNotification extends pdb_Message {\n  const TYPE = 2010;\n  public function getType() {\n    return self::TYPE;\n  }\n  public function deserialize() {\n    if (PDB_DEBUG) pdb_Logger::debug( \"$this\");\n  }\n  public function __toString () {\n    return \"pdb_ContinueProcessFileNotification: \";\n  }\n}\n\n/**\n * @access private\n */\nclass pdb_Breakpoint {\n  public $type, $lifeTime, $file, $line, $condition;\n  private $id;\n\n  public function __construct($type, $lifeTime, $file, $line, $condition, $id) {\n    $this->type = $type;\n    $this->lifeTime = $lifeTime;\n    $this->file = $file;\n    $this->line = $line;\n    $this->condition = $condition;\n    $this->id = $id;\n  }\n  public function __toString () {\n    return \"pdb_Breakpoint: \";\n  }\n}\n/**\n * @access private\n */\nclass pdb_AddBreakpointResponse extends pdb_Message {\n  const TYPE = 1021;\n  private $req;\n  private $id;\n\n  private static function getId() {\n    static $id = 0;\n    return ++$id;\n  }\n\n  public function __construct($req) {\n    parent::__construct($req->session);\n    $this->req = $req;\n    $this->id = self::getId();\n    $this->session->breakpoints[$this->id] = new pdb_Breakpoint($req->type, $req->lifeTime, $req->file, $req->line, $req->condition, $this->id);\n  }\n\n  public function getType() {\n    return self::TYPE;\n  }\n  public function serialize() {\n    $out = $this->session->out;\n    parent::serialize();\n    $out->writeInt($this->req->id);\n    $out->writeInt(0);\n    $out->writeInt($this->id);\n    $out->flush();\n    if (PDB_DEBUG) pdb_Logger::debug( \"$this\");\n  }\n  public function __toString () {\n    return \"pdb_AddBreakpointResponse: {$this->id}\";\n  }\n}\n\n/**\n * @access private\n */\nclass pdb_RemoveBreakpointResponse extends pdb_Message {\n  const TYPE = 1022;\n  private $req;\n  private $id;\n  private $failure;\n\n  public function __construct($req) {\n    parent::__construct($req->session);\n    $this->req = $req;\n\n\t$this->remove();\n  }\n\n  protected function remove() {\n\tif (isset($this->session->breakpoints[$this->req->bpId])) {\n\t  unset($this->session->breakpoints[$this->req->bpId]);\n\t  $this->failure = 0;\n\t} else {\n\t  $this->failure = -1;\n\t}\n  }\n\n  public function getType() {\n    return self::TYPE;\n  }\n  public function serialize() {\n    $out = $this->session->out;\n    parent::serialize();\n    $out->writeInt($this->req->id);\n    $out->writeInt($this->failure);\n    $out->flush();\n    if (PDB_DEBUG) pdb_Logger::debug( \"$this\");\n  }\n  public function __toString () {\n    return \"pdb_RemoveBreakpointResponse: {$this->id}\";\n  }\n}\n/**\n * @access private\n */\nclass pdb_RemoveAllBreakpointsResponse extends pdb_RemoveBreakpointResponse {\n  const TYPE = 1023;\n  public function __construct($req) {\n    parent::__construct($req);\n  }\n\n  protected function remove() {\n\t$keys = array_keys($this->session->breakpoints);\n\tforeach($keys as $key)\n\t  unset($this->session->breakpoints[$key]);\n\t\n\t$this->failure = 0;\n  }\n\n  public function getType() {\n    return self::TYPE;\n  }\n\n  public function __toString () {\n    return \"pdb_RemoveAllBreakpoinstResponse: {$this->id}\";\n  }\n}\n\n/**\n * @access private\n */\nclass pdb_AddBreakpointRequest extends pdb_MessageRequest {\n  const TYPE = 21;\n  public $id;\n  public $type;\n  public $lifeTime;\n\n  public $file;\n  public $line;\n\n  public $condition;\n\n  public function getType() {\n    return self::TYPE;\n  }\n  public function deserialize() {\n    $in = $this->session->in;\n    $this->id = $in->readInt();\n    $this->type = $in->readShort();\n    $this->lifeType = $in->readShort();\n    switch($this->type) {\n    case 1: \n      $this->file = $in->readString();\n      $this->line = $in->readInt();\n      break;\n    case 2:\n      $this->condition = $in->readString();\n      break;\n    default: \n      trigger_error(\"invalid breakpoint\", E_USER_ERROR);\n    }\n    if (PDB_DEBUG) pdb_Logger::debug( \"$this\");\n  }\n  public function ack() {\n    $res = new pdb_AddBreakpointResponse ($this);\n    $res->serialize();\n  }\n  public function __toString () {\n    if ($this->type == 1) \n      return \"pdb_AddBreakpointRequest: {$this->file}, {$this->line}\";\n    else\n      return \"pdb_AddBreakpointRequest: {$this->condition}\";\n  }\n}\n/**\n * @access private\n */\nclass pdb_RemoveAllBreakpointsRequest extends pdb_MessageRequest {\n  const TYPE = 23;\n  public $id;\n\n  public function getType() {\n    return self::TYPE;\n  }\n  public function deserialize() {\n    $in = $this->session->in;\n    $this->id = $in->readInt();\n    if (PDB_DEBUG) pdb_Logger::debug( \"$this\");\n  }\n  public function ack() {\n    $res = new pdb_RemoveAllBreakpointsResponse ($this);\n    $res->serialize();\n  }\n  public function __toString () {\n\treturn \"pdb_RemoveAllBreakpointsRequest \";\n  }\n}\n/**\n * @access private\n */\nclass pdb_RemoveBreakpointRequest extends pdb_RemoveAllBreakpointsRequest {\n  const TYPE = 22;\n  public $bpId;\n\n  public function getType() {\n    return self::TYPE;\n  }\n\n  public function deserialize() {\n\tparent::deserialize();\n    $in = $this->session->in;\n    $this->bpId = $in->readInt();\n    if (PDB_DEBUG) pdb_Logger::debug( \"$this\");\n  }\n  public function ack() {\n    $res = new pdb_RemoveBreakpointResponse ($this);\n    $res->serialize();\n  }\n  public function __toString () {\n\treturn \"pdb_RemoveBreakpointRequest: {$this->bpId}\";\n  }\n}\n\n/**\n * @access private\n */\nclass pdb_GetCallStackResponse extends pdb_Message {\n  const TYPE = 1034;\n  private $req;\n\n  public function __construct($req) {\n    parent::__construct($req->session);\n    $this->req = $req;\n  }\n\n  public function getType() {\n    return self::TYPE;\n  }\n  public function serialize() {\n    $out = $this->session->out;\n    parent::serialize();\n    $out->writeInt($this->req->id);\n\n\tfor($frame=$this->session->currentFrame; $frame; $frame=$frame->parent)\n\t  $environments[] = $frame;\n\n\t$environments = array_reverse($environments);\n    $n = count($environments);\n\n    $out->writeInt($n);\n    for ($i=0; $i<$n; $i++) {\n\t  $env = $environments[$i];\n      $out->writeString($env->filename);\n      $out->writeInt($env->line);\n      $out->writeInt(0);\n      $out->writeString($env->filename);\n      $out->writeInt($env->firstLine);\n      $out->writeInt(0);\n      $out->writeInt(0); //fixme: params\n    }\n\n\t$out->flush();\n    if (PDB_DEBUG) pdb_Logger::debug( \"$this\");\n  }\n  public function __toString () {\n    return \"pdb_GetCallStackResponse: \";\n  }\n}\n/**\n * @access private\n */\nclass pdb_GetCallStackRequest extends pdb_MessageRequest {\n  const TYPE = 34;\n  public $id;\n\t\n  public function getType() {\n    return self::TYPE;\n  }\n  public function deserialize() {\n    $in = $this->session->in;\n    $this->id = $in->readInt();\n    if (PDB_DEBUG) pdb_Logger::debug( \"$this\");\n  }\n  public function ack() {\n    $res = new pdb_GetCallStackResponse ($this);\n    $res->serialize();\n  }\n  public function __toString () {\n    return \"pdb_GetCallStackRequest: \";\n  }\n}\n\n\n/**\n * @access private\n */\nclass pdb_GetCWDResponse extends pdb_Message {\n  const TYPE = 1036;\n  private $req;\n\n  public function __construct ($req) {\n    parent::__construct($req->session);\n    $this->req = $req;\n  }\n\n  public function getType() {\n    return self::TYPE;\n  }\n  public function serialize() {\n    $out = $this->session->out;\n    parent::serialize();\n    $out->writeInt($this->req->id);\n    $out->writeInt(0);\n    $out->writeString(getcwd());    \n    $out->flush();\n    if (PDB_DEBUG) pdb_Logger::debug( \"$this\");\n  }\n  public function __toString () {\n    return \"pdb_GetCWDResponse: \";\n  }\n}\n\n/**\n * @access private\n */\nclass pdb_GetCWDRequest extends pdb_MessageRequest {\n  const TYPE = 36;\n  public $id;\n\n  public function getType() {\n    return self::TYPE;\n  }\n  public function deserialize() {\n    $in = $this->session->in;\n    $this->id = $in->readInt();\n    if (PDB_DEBUG) pdb_Logger::debug( \"$this\");\n  }\n  public function ack() {\n    $res = new pdb_GetCWDResponse($this);\n    $res->serialize();\n  }\n  public function __toString () {\n    return \"pdb_GetCWDRequest: \";\n  }\n}\n\n/**\n * @access private\n */\nclass pdb_MsgEvalResponse extends pdb_Message {\n  const TYPE = 1031;\n  private $req;\n\n  public function __construct ($req) {\n    parent::__construct($req->session);\n    $this->req = $req;\n  }\n\n  public function getType() {\n    return self::TYPE;\n  }\n\n  public function serialize() {\n    $out = $this->session->out;\n    parent::serialize();\n    $out->writeInt($this->req->id);\n    if (PDB_DEBUG) pdb_Logger::debug( \"evalcode:::\".$this->req->code.\"\\n\");\n\t$error = 0;\n    $code = $this->req->code;\n    $res = eval(\"return $code ?>\");\n \t$out->writeInt($error);\n    $out->writeString($res);\n\n\tif (PDB_DEBUG) pdb_Logger::debug(\"pdb_MsgEvalResponse: \".print_r($res, true));\n    $out->flush();\n  }\n  public function __toString () {\n    return \"pdb_MsgEvalResponse: \";\n  }\n}\n/**\n * @access private\n */\nclass pdb_GetVariableValueResponse extends pdb_Message {\n  const TYPE = 1032;\n  private $req;\n\n  public function __construct ($req) {\n    parent::__construct($req->session);\n    $this->req = $req;\n  }\n\n  public function getType() {\n    return self::TYPE;\n  }\n\n  public function serialize() {\n    $out = $this->session->out;\n    parent::serialize();\n    $out->writeInt($this->req->id);\n    if (PDB_DEBUG) pdb_Logger::debug( \"evalcode:::\".$this->req->code.\"\\n\");\n\t$error = 0;\n    if ($this->req->code[0]=='$') {\n\n\t  $this->session->end = true;\n\t  $key = substr($this->req->code, 1);\n\t  if (isset($this->session->currentFrame->vars[$key])) {\n\t\t$var = $this->session->currentFrame->vars[$key];\n\t\t$paths = $this->req->paths;\n\t\tforeach ($paths as $path) {\n\t\t  if (is_object($var)) {\n\t\t\t$var = $var->$path;\n\t\t  } else {\n\t\t\t$var = $var[$path];\n\t\t  }\n\t\t}\n\t  } else {\n\t\t$var = \"${key} not found!\";\n\t\t$error = -1;\n\t  }\n\t  $ser = $this->session->serializer->serialize($var, $this->req->depth);\n\t  $this->session->end = false;\n\n\t  $out->writeInt($error);\n      $out->writeString($ser);\n\t  if (PDB_DEBUG) pdb_Logger::debug(\"pdb_GetVariableValueResponse: \".print_r($var, true).\": ${ser}, error: ${error}\");\n    } else {\n\t  if (PDB_DEBUG) pdb_Logger::debug(print_r($this->session->currentFrame->vars, true));\n\n\t  $this->session->end = true;\n\t  $vars = $this->session->currentFrame->vars;\n\t  $ser = $this->session->serializer->serialize($vars, $this->req->depth);\n\t  $this->session->end = false;\n\n\t  $out->writeInt($error);\n\t  $out->writeString($ser);\n\t  if (PDB_DEBUG) pdb_Logger::debug(\"pdb_GetVariableValueResponse: \".print_r($vars, true).\": ${ser}, error: ${error}\");\n\t}\n    $out->flush();\n  }\n  public function __toString () {\n    return \"pdb_GetVariableValueResponse: \";\n  }\n}\n\n/**\n * @access private\n */\nclass pdb_MsgEvalRequest extends pdb_MessageRequest {\n  const TYPE = 31;\n  public $id;\n  public $code;\n\n  public function getType() {\n    return self::TYPE;\n  }\n  public function deserialize() {\n    $in = $this->session->in;\n    $this->id = $in->readInt();\n    $this->code = $in->readString();\n\n    if (PDB_DEBUG) pdb_Logger::debug( \"$this\");\n  }\n  public function ack() {\n    $res = new pdb_MsgEvalResponse($this);\n    $res->serialize();\n  }\n  public function __toString () {\n    return \"pdb_MsgEvalRequest: {$this->code}\";\n  }\n}\n\n/**\n * @access private\n */\nclass pdb_GetVariableValueRequest extends pdb_MessageRequest {\n  const TYPE = 32;\n  public $id;\n  public $code;\n  public $depth;\n  public $paths;\n\n  public function getType() {\n    return self::TYPE;\n  }\n  public function deserialize() {\n    $in = $this->session->in;\n    $this->id = $in->readInt();\n    $this->code = $in->readString();\n    $this->depth = $in->readInt();\n\n    $this->paths = array();\n    $length = $in->readInt();\n    while($length--) {\n      $this->paths[] = $in->readString();\n    }\n    if (PDB_DEBUG) pdb_Logger::debug( \"$this\");\n  }\n  public function ack() {\n    $res = new pdb_GetVariableValueResponse($this);\n    $res->serialize();\n  }\n  public function __toString () {\n    return \"pdb_GetVariableValueRequest: {$this->code}, {$this->depth}, paths::\".print_r($this->paths, true);\n  }\n}\n\n/**\n * @access private\n */\nclass pdb_StepOverResponse extends pdb_Message {\n  const TYPE = 1012;\n  private $req;\n\n  public function __construct($req) {\n    parent::__construct($req->session);\n    $this->req = $req;\n  }\n\n  public function getType() {\n    return self::TYPE;\n  }\n  public function serialize() {\n    $out = $this->req->session->out;\n    parent::serialize();\n    $out->writeInt($this->req->id);\n    $out->writeInt(0);\n    $out->flush();\n    if (PDB_DEBUG) pdb_Logger::debug( \"$this\");\n  }\n  public function __toString () {\n    return \"pdb_StepOverResponse: \";\n  }\n}\n\n/**\n * @access private\n */\nclass pdb_StepOverRequest extends pdb_MessageRequest {\n  const TYPE = 12;\n  public $id;\n  \n  public function getType() {\n    return self::TYPE;\n  }\n  public function deserialize() {\n    $in = $this->session->in;\n    $this->id = $in->readInt();\n    if (PDB_DEBUG) pdb_Logger::debug( \"$this\");\n  }\n  public function ack() {\n    $res = new pdb_StepOverResponse($this);\n    $res->serialize();\n  }\n  public function __toString () {\n    return \"pdb_StepOverRequest: \";\n  }\n}\n\n/**\n * @access private\n */\nclass pdb_StepIntoResponse extends pdb_StepOverResponse {\n  const TYPE = 1011;\n  public function getType() {\n    return self::TYPE;\n  }\n  public function __toString () {\n    return \"pdb_StepIntoResponse: \";\n  }\n}\n\n/**\n * @access private\n */\nclass pdb_StepIntoRequest extends pdb_StepOverRequest {\n  const TYPE = 11;\n  public function getType() {\n    return self::TYPE;\n  }\n  public function ack() {\n    $res = new pdb_StepIntoResponse($this);\n    $res->serialize();\n  }\n  public function __toString () {\n    return \"pdb_StepIntoRequest: \";\n  }\n}\n\n/**\n * @access private\n */\nclass pdb_StepOutResponse extends pdb_StepOverResponse {\n  const TYPE = 1013;\n  public function getType() {\n    return self::TYPE;\n  }\n  public function __toString () {\n    return \"pdb_StepOutResponse: \";\n  }\n}\n\n/**\n * @access private\n */\nclass pdb_StepOutRequest extends pdb_StepOverRequest {\n  const TYPE = 13;\n  public function getType() {\n    return self::TYPE;\n  }\n  public function ack() {\n    $res = new pdb_StepOutResponse($this);\n    $res->serialize();\n  }\n  public function __toString () {\n    return \"pdb_OutIntoRequest: \";\n  }\n}\n\n/**\n * @access private\n */\nclass pdb_GoResponse extends pdb_Message {\n  const TYPE = 1014;\n  private $req;\n\n  public function __construct ($req) {\n    parent::__construct($req->session);\n    $this->req = $req;\n  }\n\n  public function getType() {\n    return self::TYPE;\n  }\n  public function serialize() {\n    $out = $this->session->out;\n    parent::serialize();\n    $out->writeInt($this->req->id);\n    $out->writeInt(0);\n    $out->flush();\n    if (PDB_DEBUG) pdb_Logger::debug( \"$this\");\n  }\n  public function __toString () {\n    return \"pdb_GoResponse: \";\n  }\n}\n\n/**\n * @access private\n */\nclass pdb_GoRequest extends pdb_MessageRequest {\n  const TYPE = 14;\n  public $id;\n \n  public function getType() {\n    return self::TYPE;\n  }\n  public function deserialize() {\n    $in = $this->session->in;\n    $this->id = $in->readInt();\n    if (PDB_DEBUG) pdb_Logger::debug( \"$this\");\n  }\n  public function ack() {\n    $res = new pdb_GoResponse($this);\n    $res->serialize();\n  }\n  public function __toString () {\n    return \"pdb_GoRequest: \";\n  }\n}\n/**\n * @access private\n */\nclass pdb_End extends pdb_Message {\n  const TYPE = 3;\n  public $id;\n \n  public function getType() {\n    return self::TYPE;\n  }\n  public function deserialize() {\n    if (PDB_DEBUG) pdb_Logger::debug( \"$this\");\n  }\n  public function __toString () {\n    return \"pdb_End: \";\n  }\n}\n\n/**\n * @access private\n */\nclass pdb_In {\n  private $in;\n  private $len;\n  private $session;\n\n  public function __construct($in, $session) {\n    $this->in = $in;\n    $this->len = 0;\n\t$this->session = $session;\n  }\n  private function readBytes($n) {\n    $str = \"\";\n    while ($n) {\n      $s = fread($this->in, $n);\n\t  if (feof($this->in)) $this->session->end();\n\n      $n -= strlen($s);\n\n      $str.=$s;\n    }\n    return $str;\n  }\n  public function read() {\n    if(!$this->len) {\n      $str = $this->readBytes(4);\n      $lenDesc = unpack(\"N\", $str);\n      $this->len = array_pop($lenDesc);\n    }\n  }\n  public function readShort() {\n    $this->read();\n\n    $this->len-=2;\n    $str = $this->readBytes(2);\n    $lenDesc = unpack(\"n\", $str);\n    return array_pop($lenDesc);\n  }\n  public function readInt() {\n    $this->read();\n\n    $this->len-=4;\n    $str = $this->readBytes(4);\n    $lenDesc = unpack(\"N\", $str);\n    return array_pop($lenDesc);\n  }\n  public function readString() {\n    $this->read();\n\n    $length = $this->readInt();\n    $this->len-=$length;\n    return $this->readBytes($length);\n  }\n  public function __toString () {\n    return \"pdb_In: \";\n  }\n}\n/**\n * @access private\n */\nclass pdb_Out {\n  private $out;\n  private $buf;\n  private $session;\n  \n  public function __construct($out, $session) {\n    $this->out = $out;\n    $this->buf = \"\";\n\t$this->session = $session;\n  }\n\n  public function writeShort($val) {\n    $this->buf.=pack(\"n\", $val);\n  }\n  public function writeInt($val) {\n    $this->buf.=pack(\"N\", $val);\n  }\n  public function writeString($str) {\n    $length = strlen($str);\n    $this->writeInt($length);\n    $this->buf.=$str;\n  }\n  public function writeUTFString($str) {\n    $this->writeString(urlencode($str));\n  }\n  public function flush() {\n    $length = strlen($this->buf);\n    $this->buf = pack(\"N\", $length).$this->buf;\n    fwrite($this->out, $this->buf);\n\tif (feof($this->out)) $this->session->end();\n    $this->buf = \"\";\n  }\n  public function __toString () {\n    return \"pdb_Out: \";\n  }\n}\n$pdb_dbg = new pdb_DebugSessionStart(\"&debug_fastfile=1\");\npdb_Message::register(new pdb_SetProtocolRequest($pdb_dbg));\npdb_Message::register(new pdb_StartRequest($pdb_dbg));\npdb_Message::register(new pdb_AddFilesRequest($pdb_dbg));\npdb_Message::register(new pdb_FileContentExtendedRequest($pdb_dbg));\npdb_Message::register(new pdb_ContinueProcessFileNotification($pdb_dbg));\npdb_Message::register(new pdb_AddBreakpointRequest($pdb_dbg));\npdb_Message::register(new pdb_RemoveBreakpointRequest($pdb_dbg));\npdb_Message::register(new pdb_RemoveAllBreakpointsRequest($pdb_dbg));\npdb_Message::register(new pdb_GetCallStackRequest($pdb_dbg));\npdb_Message::register(new pdb_GetCWDRequest($pdb_dbg));\npdb_Message::register(new pdb_GetVariableValueRequest($pdb_dbg));\npdb_Message::register(new pdb_MsgEvalRequest($pdb_dbg));\npdb_Message::register(new pdb_StepOverRequest($pdb_dbg));\npdb_Message::register(new pdb_StepIntoRequest($pdb_dbg));\npdb_Message::register(new pdb_StepOutRequest($pdb_dbg));\npdb_Message::register(new pdb_GoRequest($pdb_dbg));\npdb_Message::register(new pdb_End($pdb_dbg));\n\npdb_Message::register(new pdb_StartProcessFileNotification($pdb_dbg));\npdb_Message::register(new pdb_ReadyNotification($pdb_dbg));\npdb_Message::register(new pdb_DebugScriptEndedNotification($pdb_dbg));\npdb_Message::register(new pdb_HeaderOutputNotification($pdb_dbg));\npdb_Message::register(new pdb_OutputNotification($pdb_dbg));\npdb_Message::register(new pdb_ErrorNotification($pdb_dbg));\n\n/**\n * @access private\n */\nfunction pdb_getDefinedVars($vars1, $vars2) {\n  //if(isset($vars2)) $vars1['pbd_This'] = $vars2;\n\n  unset($vars1['__pdb_Code']);\t     // see pdb_Message::doEval()\n\n  return $vars1;   \n}\n/**\n * @access private\n */\nfunction pdb_startCall($scriptName, $line) {\n  global $pdb_dbg;\n\n  $stepNext = $pdb_dbg->currentFrame->stepNext == pdb_StepIntoRequest::TYPE ? pdb_StepIntoRequest::TYPE : false;\n\n  pdb_Logger::debug(\"startCall::$scriptName, $stepNext\");\n\n  $env = new pdb_Environment($pdb_dbg->currentFrame, $scriptName, $stepNext, $line);\n  $pdb_dbg->allFrames[] = $env;\n\n  return $env;\n}\n\n/**\n * @access private\n */\nfunction pdb_startInclude($scriptName, $once) {\n  global $pdb_dbg;\n\n  $scriptName = $pdb_dbg->resolveIncludePath($scriptName);\n\n  // include only from a top-level environment\n  // initial line# and vars may be wrong due to a side-effect in step\n  $pdb_dbg->session->currentFrame = $pdb_dbg->session->currentTopLevelFrame;\n\n  $stepNext = $pdb_dbg->currentFrame->stepNext == pdb_StepIntoRequest::TYPE ? pdb_StepIntoRequest::TYPE : false;\n  $pdb_dbg->currentFrame = new pdb_Environment($pdb_dbg->currentFrame, $scriptName, $stepNext, 1);\n  $pdb_dbg->allFrames[] = $pdb_dbg->currentFrame;\n\n  /* BEGIN: StartProcessFileNotification */\n  $pdb_dbg->getMessageById(pdb_StartProcessFileNotification::TYPE)->handleRequests();\n  /* ...  set breakpoints ... */\n  /* END: ContinueProcessFileNotification */\n\n  if ($once && isset($pdb_dbg->includedScripts[$scriptName]))\n\t$code = \"<?php ?>\";\n  else\n\t$code = $pdb_dbg->parseCode(realpath($scriptName), file_get_contents($scriptName));\n\n  $pdb_dbg->currentTopLevelFrame = $pdb_dbg->currentFrame;\n\n  if (PDB_DEBUG) pdb_Logger::debug(\"include:::$code\");\n\n  if ($once) $pdb_dbg->includedScripts[$scriptName] = true;\n  return $code; // eval -> pdb_step/MSG_READY or pdb_endInclude/MSG_READY OR FINISH\n}\n/**\n * @access private\n */\nfunction pdb_endInclude() {\n  global $pdb_dbg;\n\n  $pdb_dbg->currentFrame = $pdb_dbg->currentTopLevelFrame = $pdb_dbg->currentTopLevelFrame->parent;\n}\n\n\n/**\n * @access private\n */\nfunction pdb_step($filename, $line, $vars) {\n  global $pdb_dbg;\n  if ($pdb_dbg->ignoreInterrupt) return;\n\n  $pdb_dbg->ignoreInterrupt = true;\n\n  // pull the current frame from the stack or the top-level environment\n  $pdb_dbg->currentFrame = (isset($vars['__pdb_CurrentFrame'])) ? $vars['__pdb_CurrentFrame'] : $pdb_dbg->currentTopLevelFrame;\n  unset($vars['__pdb_CurrentFrame']);\n\n  $pdb_dbg->currentFrame->update($line, $vars);\n\n  if ($pdb_dbg->hasBreakpoint($filename, $line)) {\n\t$pdb_dbg->flushOutput();\n\t$stepNext = $pdb_dbg->getMessageById(pdb_ReadyNotification::TYPE)->handleRequests();\n\tpdb_Logger::logDebug(\"continue\");\n\t/* clear all dynamic breakpoints */\n\tforeach ($pdb_dbg->allFrames as $currentFrame)\n\t  $currentFrame->stepNext = false;\n\n\t/* set new dynamic breakpoint */\n\tif ($stepNext != pdb_GoRequest::TYPE) {\n\t  $currentFrame = $pdb_dbg->currentFrame;\n\n\t  /* break in current frame or frame below */\n\t  if ($stepNext != pdb_StepOutRequest::TYPE)\n\t\t$currentFrame->stepNext = $stepNext;\n\n\t  /* or break in any parent */\n\t  while ($currentFrame = $currentFrame->parent) {\n\t\t$currentFrame->stepNext = $stepNext;\n\t  }\n\t}\n  }\n  $pdb_dbg->ignoreInterrupt = false;\n}\n\n/**\n * @access private\n */\nfunction pdb_error_handler($errno, $errstr, $errfile, $errline) {\n  global $pdb_dbg;\n  if (PDB_DEBUG) pdb_Logger::debug(\"PHP error $errno: $errstr in $errfile line $errline\");\n  if ($pdb_dbg->end) return false;\n\n  $msg = $pdb_dbg->getMessageById(pdb_ErrorNotification::TYPE);\n  $msg->setError($errno, $errfile, $errline, $errstr);\n  $msg->serialize();\n  return true;\n}\n\n/**\n * @access private\n */\nfunction pdb_shutdown() {\n  global $pdb_dbg;\n  if (PDB_DEBUG) pdb_Logger::debug(\"PHP error: \".print_r(error_get_last(), true));\n  if ($pdb_dbg->end) return;\n\n  $error = error_get_last();\n  if ($error) {\n\t$msg = $pdb_dbg->getMessageById(pdb_ErrorNotification::TYPE);\n\t$msg->setError($error['type'], $error['file'], $error['line'], $error['message']);\n\t$msg->serialize();\n  }\n}\n\n\nfunction pdb_getDebugHeader($name,$array) {\n  if (array_key_exists($name,$array)) return $array[$name];\n  $name=\"HTTP_$name\";\n  if (array_key_exists($name,$array)) return $array[$name];\n  return null;\n}\n\n\nif (!isset($java_include_only) && isset($pdb_script) && $pdb_script!=\"@\") { // not called from JavaProxy.php and pdb_script is set\n\tchdir (dirname ($pdb_script));\n\t$pdb_dbg->handleRequests();\n}\n\n?>\n".getBytes();
}

