/*
 * Decompiled with CFR 0.152.
 */
package php.java.bridge.http;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import php.java.bridge.IManaged;
import php.java.bridge.Util;
import php.java.bridge.http.IContext;
import php.java.bridge.parser.Invocable;
import php.java.bridge.util.Logger;
import php.java.bridge.util.NotImplementedException;
import php.java.bridge.util.Thread;

public class Context
implements IManaged,
Invocable,
IContext {
    private Map globalScope;
    private Map engineScope;
    private static boolean registeredHook = false;
    private static LinkedList closeables = new LinkedList();
    private static Object lockObject = new Object();
    private int exitCode;

    protected Context() {
    }

    @Override
    public Object getAttribute(String name) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (this.getEngineScope().get(name) != null) {
            return this.getEngineScope().get(name);
        }
        if (this.getGlobalScope().get(name) != null) {
            return this.getGlobalScope().get(name);
        }
        return null;
    }

    @Override
    public Object getAttribute(String name, int scope) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        switch (scope) {
            case 100: {
                return this.getEngineScope().get(name);
            }
            case 200: {
                return this.getGlobalScope().get(name);
            }
        }
        throw new IllegalArgumentException("invalid scope");
    }

    @Override
    public int getAttributesScope(String name) {
        if (this.getEngineScope().containsKey(name)) {
            return 100;
        }
        if (this.getGlobalScope().containsKey(name)) {
            return 200;
        }
        return -1;
    }

    @Override
    public Writer getWriter() throws IOException {
        return new PrintWriter(System.out, true);
    }

    @Override
    public Object removeAttribute(String name, int scope) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        switch (scope) {
            case 100: {
                return this.getEngineScope().remove(name);
            }
            case 200: {
                return this.getGlobalScope().remove(name);
            }
        }
        throw new IllegalArgumentException("invalid scope");
    }

    @Override
    public void setAttribute(String name, Object value, int scope) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        switch (scope) {
            case 100: {
                this.getEngineScope().put(name, value);
                break;
            }
            case 200: {
                this.getGlobalScope().put(name, value);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid scope");
            }
        }
    }

    @Override
    public Object getHttpServletRequest() {
        throw new IllegalStateException("PHP not running in a servlet environment");
    }

    @Override
    public Object getServletContext() {
        throw new IllegalStateException("PHP not running in a servlet environment");
    }

    @Override
    public Object getHttpServletResponse() {
        throw new IllegalStateException("PHP not running in a servlet environment");
    }

    @Override
    public Object getServlet() {
        throw new IllegalStateException("PHP not running in a servlet environment");
    }

    @Override
    public Object getServletConfig() {
        throw new IllegalStateException("PHP not running in a servlet environment");
    }

    @Override
    public boolean call(Object kont) {
        return false;
    }

    protected void setGlobalScope(Map globalScope) {
        this.globalScope = globalScope;
    }

    protected Map getGlobalScope() {
        if (this.globalScope == null) {
            this.globalScope = new HashMap();
        }
        return this.globalScope;
    }

    protected void setEngineScope(Map engineScope) {
        this.engineScope = engineScope;
    }

    protected Map getEngineScope() {
        if (this.engineScope == null) {
            this.engineScope = new HashMap();
        }
        return this.engineScope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void handleManaged(Object closeable) {
        LinkedList linkedList = closeables;
        synchronized (linkedList) {
            if (!registeredHook) {
                registeredHook = true;
                try {
                    Runtime.getRuntime().addShutdownHook(new Thread(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            if (closeables == null) {
                                return;
                            }
                            LinkedList linkedList = closeables;
                            synchronized (linkedList) {
                                Iterator ii = closeables.iterator();
                                while (ii.hasNext()) {
                                    Object c = ii.next();
                                    try {
                                        Method close = c.getClass().getMethod("close", Util.ZERO_PARAM);
                                        close.invoke(c, Util.ZERO_ARG);
                                    }
                                    catch (Exception e) {
                                        Logger.printStackTrace(e);
                                    }
                                    ii.remove();
                                }
                            }
                        }
                    });
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
            closeables.add(closeable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getManageable(Object callable) throws Exception {
        Object object = lockObject;
        synchronized (object) {
            Method call = callable.getClass().getMethod("call", Util.ZERO_PARAM);
            return call.invoke(callable, Util.ZERO_ARG);
        }
    }

    @Override
    public Object init(Object callable) throws Exception {
        return Context.getManageable(callable);
    }

    @Override
    public void onShutdown(Object closeable) {
        Context.handleManaged(closeable);
    }

    public static String getRealPathInternal(String path) {
        try {
            return new File(path).getCanonicalPath();
        }
        catch (IOException e) {
            return new File(path).getAbsolutePath();
        }
    }

    @Override
    public String getRealPath(String path) {
        return Context.getRealPathInternal(path);
    }

    @Override
    public Object get(String key) {
        return this.getEngineScope().get(key);
    }

    @Override
    public void put(String key, Object val) {
        this.getEngineScope().put(key, val);
    }

    @Override
    public void remove(String key) {
        this.getEngineScope().remove(key);
    }

    @Override
    public void putAll(Map map) {
        this.getEngineScope().putAll(map);
    }

    @Override
    public Map getAll() {
        return Collections.unmodifiableMap(this.getEngineScope());
    }

    @Override
    public String getSocketName() {
        throw new NotImplementedException("Use the JSR 223 API or a servlet environment instead");
    }

    @Override
    public String getRedirectString() {
        throw new NotImplementedException();
    }

    @Override
    public String getRedirectString(String webPath) {
        throw new NotImplementedException();
    }

    @Override
    public String getRedirectURL(String webPath) {
        return "http://127.0.0.1:" + this.getSocketName() + webPath;
    }

    @Override
    public void setExitCode(int exitCode) {
        this.exitCode = exitCode;
    }

    @Override
    public int getExitCode() {
        return this.exitCode;
    }
}

