/*
 * Decompiled with CFR 0.152.
 */
package php.java.bridge.http;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import php.java.bridge.JavaBridge;
import php.java.bridge.JavaBridgeFactory;
import php.java.bridge.Util;
import php.java.bridge.classloader.SimpleJavaBridgeClassLoader;
import php.java.bridge.classloader.StandaloneJavaBridgeClassLoader;
import php.java.bridge.http.IContext;
import php.java.bridge.http.ISession;
import php.java.bridge.http.Session;
import php.java.bridge.util.Logger;
import php.java.bridge.util.Thread;

public class SessionFactory
extends JavaBridgeFactory {
    public static final long TIMER_DURATION = 36000000L;
    private static final SessionTimer timer = SessionFactory.getSessionTimer();

    private static SessionTimer getSessionTimer() {
        try {
            return new SessionTimer();
        }
        catch (Throwable e) {
            Logger.printStackTrace(e);
            return null;
        }
    }

    @Override
    public SimpleJavaBridgeClassLoader getJavaBridgeClassLoader() {
        if (this.javaBridgeClassLoader != null) {
            return this.javaBridgeClassLoader;
        }
        this.javaBridgeClassLoader = new StandaloneJavaBridgeClassLoader(this.getClassLoader());
        return this.javaBridgeClassLoader;
    }

    private ClassLoader getClassLoader() {
        return Util.getContextClassLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ISession session(String name, short clientIsNew, int timeout) {
        HashMap hashMap = JavaBridge.getSessionHash();
        synchronized (hashMap) {
            Session ref = null;
            if (!JavaBridge.getSessionHash().containsKey(name)) {
                ref = new Session(name);
                JavaBridge.getSessionHash().put(name, ref);
            } else {
                ref = (Session)JavaBridge.getSessionHash().get(name);
                if (clientIsNew == 1) {
                    ref.destroy();
                    ref = new Session(name);
                    JavaBridge.getSessionHash().put(name, ref);
                } else {
                    ref.isNew = false;
                }
            }
            ref.setTimeout(timeout);
            return ref;
        }
    }

    @Override
    public ISession getSession(String name, short clientIsNew, int timeout) {
        name = name == null ? "PHPSESSION" : "@" + name;
        return this.session(name, clientIsNew, timeout);
    }

    @Override
    public IContext getContext() {
        return null;
    }

    protected static final SessionTimer getTimer() {
        return timer;
    }

    public static final void destroyTimer() {
        SessionFactory.getTimer().interrupt();
    }

    @Override
    public void flushBuffer() throws IOException {
        this.bridge.out.flush();
    }

    @Override
    public void invalidate() {
    }

    protected static class SessionTimer
    implements Runnable {
        private List jobs = Collections.synchronizedList(new LinkedList());
        private java.lang.Thread thread = new Thread(this, "JavaBridgeSessionTimer");

        public SessionTimer() {
            this.thread.start();
        }

        public void addJob(Runnable r) {
            this.jobs.add(r);
        }

        public void interrupt() {
            if (Logger.getLogLevel() > 5) {
                System.out.println("lifecycle: sending session timer interrupt " + System.identityHashCode(SessionFactory.class));
            }
            this.thread.interrupt();
        }

        @Override
        public void run() {
            block5: {
                try {
                    while (!java.lang.Thread.interrupted()) {
                        java.lang.Thread.sleep(36000000L);
                        Session.expire();
                        for (Runnable job : this.jobs) {
                            job.run();
                        }
                    }
                }
                catch (InterruptedException e) {
                    if (Logger.getLogLevel() <= 5) break block5;
                    System.out.println("lifecycle: session timer got interrupt" + System.identityHashCode(SessionFactory.class));
                }
            }
            if (Logger.getLogLevel() > 5) {
                System.out.println("lifecycle: session timer terminating" + System.identityHashCode(SessionFactory.class));
            }
        }
    }
}

