/*
 * Decompiled with CFR 0.152.
 */
package php.java.bridge.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import php.java.bridge.JavaBridge;
import php.java.bridge.http.AbstractChannel;
import php.java.bridge.http.AbstractChannelName;
import php.java.bridge.http.ContextFactory;
import php.java.bridge.http.ContextRunner;
import php.java.bridge.http.IContextServer;
import php.java.bridge.http.ISocketFactory;
import php.java.bridge.util.AppThreadPool;
import php.java.bridge.util.Logger;
import php.java.bridge.util.Thread;

public final class SocketContextServer
implements Runnable,
IContextServer {
    private AppThreadPool threadPool;
    private ISocketFactory serverSocket = null;
    protected List sockets = Collections.synchronizedList(new ArrayList());
    private String contextName;
    public static final boolean SOCKET_SERVER_AVAIL = SocketContextServer.checkTestTunnel("php.java.bridge.no_socket_server");

    public SocketContextServer(AppThreadPool threadPool, boolean promiscuous, String contextName) {
        this.threadPool = threadPool;
        this.contextName = contextName;
        try {
            this.serverSocket = JavaBridge.bind(promiscuous ? "INET:0" : "INET_LOCAL:0");
            SecurityManager sec = System.getSecurityManager();
            if (sec != null) {
                sec.checkAccept("127.0.0.1", Integer.parseInt(this.serverSocket.getSocketName()));
            }
            Thread t = new Thread(this, "JavaBridgeSocketContextServer(" + this.serverSocket.getSocketName() + ")");
            t.start();
        }
        catch (Throwable t) {
            Logger.warn("Local communication channel not available.");
            Logger.printStackTrace(t);
            if (this.serverSocket != null) {
                try {
                    this.serverSocket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.serverSocket = null;
        }
    }

    private boolean accept() {
        InputStream in = null;
        OutputStream out = null;
        Socket socket = null;
        Channel channel = null;
        try {
            try {
                socket = this.serverSocket.accept();
            }
            catch (IOException ex) {
                return false;
            }
            in = socket.getInputStream();
            out = socket.getOutputStream();
            channel = new Channel(this.getChannelName(), in, out, socket);
            ContextRunner runner = new ContextRunner(channel);
            if (this.threadPool != null) {
                this.threadPool.start(runner);
            } else {
                Thread t = new Thread(runner, "JavaBridgeContextRunner(" + this.contextName + ")");
                t.start();
            }
        }
        catch (SecurityException t) {
            if (channel != null) {
                channel.shutdown();
            }
            ContextFactory.destroyAll();
            Logger.printStackTrace(t);
            return false;
        }
        catch (Throwable t) {
            if (channel != null) {
                channel.shutdown();
            }
            Logger.printStackTrace(t);
        }
        return true;
    }

    @Override
    public void run() {
        while (this.serverSocket != null) {
            if (this.accept()) continue;
            this.destroy();
        }
        if (Logger.getLogLevel() > 4) {
            System.err.println("SocketContextServer stopped, the local channel is not available anymore.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeAllSockets() {
        List list = this.sockets;
        synchronized (list) {
            Iterator ii = this.sockets.iterator();
            while (ii.hasNext()) {
                Socket sock = (Socket)ii.next();
                ii.remove();
                try {
                    sock.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public void destroy() {
        this.closeAllSockets();
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (IOException e) {
                Logger.printStackTrace(e);
            }
            this.serverSocket = null;
        }
    }

    private static boolean checkTestTunnel(String property) {
        try {
            return !"true".equals(System.getProperty(property));
        }
        catch (SecurityException e) {
            return false;
        }
        catch (Throwable t) {
            return true;
        }
    }

    @Override
    public boolean isAvailable() {
        return SOCKET_SERVER_AVAIL && this.serverSocket != null;
    }

    public String getChannelName() {
        return this.serverSocket.getSocketName();
    }

    @Override
    public boolean start(AbstractChannelName channelName) {
        return this.isAvailable();
    }

    protected class Channel
    extends AbstractChannel {
        protected Socket sock;
        protected InputStream in;
        protected OutputStream out;
        protected String name;

        public Channel(String name, InputStream in, OutputStream out, Socket sock) {
            this.name = name;
            this.in = in;
            this.out = out;
            this.sock = sock;
            SocketContextServer.this.sockets.add(sock);
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public InputStream getInputStream() {
            return this.in;
        }

        @Override
        public OutputStream getOuptutStream() {
            return this.out;
        }

        public Socket getSocket() {
            return this.sock;
        }

        @Override
        public void shutdown() {
            if (this.in != null) {
                try {
                    this.in.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.out != null) {
                try {
                    this.out.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (SocketContextServer.this.sockets.remove(this.sock)) {
                try {
                    this.sock.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }
}

